/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.extseed.impl.webseed;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.extseed.ExternalSeedReader;
import com.biglybt.plugin.extseed.ExternalSeedReaderFactory;
import com.biglybt.plugin.extseed.impl.webseed.ExternalSeedReaderWebSeed;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalSeedReaderFactoryWebSeed
implements ExternalSeedReaderFactory {
    @Override
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent());
    }

    @Override
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Torrent torrent) {
        return this.getSeedReaders(plugin, torrent.getName(), torrent);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent) {
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            Object obj = torrent.getAdditionalProperty("httpseeds");
            if (obj != null) {
                config.put("httpseeds", obj);
            }
            return this.getSeedReaders(plugin, name, torrent, config);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ExternalSeedReader[0];
        }
    }

    @Override
    public ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, Download download, Map config) {
        return this.getSeedReaders(plugin, download.getName(), download.getTorrent(), config);
    }

    private ExternalSeedReader[] getSeedReaders(ExternalSeedPlugin plugin, String name, Torrent torrent, Map config) {
        block8: {
            try {
                Object obj = config.get("httpseeds");
                if (obj instanceof byte[]) {
                    ArrayList l = new ArrayList();
                    l.add(obj);
                    obj = l;
                }
                if (!(obj instanceof List)) break block8;
                List urls = (List)obj;
                ArrayList<ExternalSeedReaderWebSeed> readers = new ArrayList<ExternalSeedReaderWebSeed>();
                Object _params = config.get("httpseeds-params");
                Map params = _params instanceof Map ? (Map)_params : new HashMap();
                Collections.shuffle(urls);
                int i = 0;
                while (i < urls.size()) {
                    if (readers.size() > 10) break;
                    try {
                        String url_str = new String((byte[])urls.get(i));
                        url_str = url_str.replaceAll(" ", "%20");
                        URL url = new URL(url_str);
                        String protocol = url.getProtocol().toLowerCase();
                        if (protocol.equals("http")) {
                            readers.add(new ExternalSeedReaderWebSeed(plugin, torrent, url, params));
                        } else {
                            plugin.log(String.valueOf(name) + ": WS unsupported protocol: " + url);
                        }
                    }
                    catch (Throwable e) {
                        Object o = urls.get(i);
                        String str = o instanceof byte[] ? new String((byte[])o) : String.valueOf(o);
                        Debug.out("WS seed invalid: " + str, e);
                    }
                    ++i;
                }
                ExternalSeedReader[] res = new ExternalSeedReader[readers.size()];
                readers.toArray(res);
                return res;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new ExternalSeedReader[0];
    }
}

