/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.extseed.impl;

import com.biglybt.pif.peers.PeerReadRequest;
import com.biglybt.plugin.extseed.ExternalSeedException;
import com.biglybt.plugin.extseed.impl.ExternalSeedReaderImpl;
import com.biglybt.plugin.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.util.List;

public class ExternalSeedReaderRequest
implements ExternalSeedHTTPDownloaderListener {
    private ExternalSeedReaderImpl reader;
    private List<PeerReadRequest> requests;
    private int start_piece_number;
    private int start_piece_offset;
    private int length;
    private int current_request_index = 0;
    private PeerReadRequest current_request;
    private byte[] current_buffer;
    private int current_position;

    protected ExternalSeedReaderRequest(ExternalSeedReaderImpl _reader, List<PeerReadRequest> _requests) {
        this.reader = _reader;
        this.requests = _requests;
        int i = 0;
        while (i < this.requests.size()) {
            PeerReadRequest req = this.requests.get(i);
            if (i == 0) {
                this.start_piece_number = req.getPieceNumber();
                this.start_piece_offset = req.getOffset();
            }
            this.length += req.getLength();
            ++i;
        }
    }

    public int getStartPieceNumber() {
        return this.start_piece_number;
    }

    public int getStartPieceOffset() {
        return this.start_piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBuffer() throws ExternalSeedException {
        if (this.current_request_index >= this.requests.size()) {
            throw new ExternalSeedException("Insufficient buffers to satisfy request");
        }
        this.current_request = this.requests.get(this.current_request_index++);
        this.current_buffer = new byte[this.current_request.getLength()];
        this.current_position = 0;
        return this.current_buffer;
    }

    @Override
    public boolean isCancelled() {
        int i = 0;
        while (i < this.requests.size()) {
            PeerReadRequest req = this.requests.get(i);
            if (req.isCancelled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void done() {
        this.reader.informComplete(this.current_request, this.current_buffer);
    }

    protected void cancel() {
        int i = 0;
        while (i < this.requests.size()) {
            PeerReadRequest req = this.requests.get(i);
            if (!req.isCancelled()) {
                req.cancel();
            }
            ++i;
        }
    }

    public void failed() {
        int i = this.current_request_index;
        while (i < this.requests.size()) {
            PeerReadRequest request2 = this.requests.get(i);
            this.reader.informFailed(request2);
            ++i;
        }
    }

    @Override
    public void setBufferPosition(int pos) {
        this.current_position = pos;
    }

    @Override
    public int getBufferPosition() {
        return this.current_position;
    }

    @Override
    public int getBufferLength() {
        return this.current_buffer.length;
    }

    public int[] getCurrentMessageProgress() {
        PeerReadRequest req = this.current_request;
        if (req == null) {
            return null;
        }
        return new int[]{req.getLength(), this.current_position, req.getPieceNumber()};
    }

    @Override
    public int getPermittedBytes() throws ExternalSeedException {
        PeerReadRequest req = this.current_request;
        if (req == null) {
            req = this.requests.get(0);
        }
        if (req.isCancelled()) {
            throw new ExternalSeedException("Request cancelled");
        }
        return this.reader.getPermittedBytes();
    }

    @Override
    public int getPermittedTime() {
        return 0;
    }

    @Override
    public void reportBytesRead(int num) {
        this.reader.reportBytesRead(num);
    }
}

