/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.platform.macosx;

import com.biglybt.core.html.HTMLUtils;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import com.biglybt.pifimpl.update.sf.SFPluginDetails;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsLoaderFactory;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.plugin.I2PHelpers;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PlatformManagerUpdateChecker
implements Plugin,
UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String UPDATE_NAME = "Platform-specific support";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String version = "1.0";
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.getPlatformType() == 3) {
            if (platform.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                try {
                    version = platform.getVersion();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", version);
    }

    @Override
    public String getName() {
        return UPDATE_NAME;
    }

    @Override
    public int getMaximumCheckTime() {
        return 30;
    }

    @Override
    public void checkForUpdate(final UpdateChecker checker) {
        try {
            try {
                String sf_cvs_version;
                String sf_plugin_version;
                SFPluginDetails sf_details = SFPluginDetailsLoaderFactory.getSingleton().getPluginDetails(this.plugin_interface.getPluginID());
                String current_version = this.plugin_interface.getPluginVersion();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update check starts: current = " + current_version));
                }
                boolean current_az_is_cvs = Constants.isCVSVersion();
                String sf_comp_version = sf_plugin_version = sf_details.getVersion();
                if (current_az_is_cvs && (sf_cvs_version = sf_details.getCVSVersion()).length() > 0) {
                    sf_plugin_version = sf_cvs_version;
                    sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                }
                String target_version = null;
                if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "PlatformManager:OSX no valid version to check against (" + sf_comp_version + ")"));
                    }
                } else if (Constants.compareVersions(current_version, sf_comp_version) < 0) {
                    target_version = sf_comp_version;
                }
                checker.reportProgress("OSX: current = " + current_version + ", latest = " + sf_comp_version);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update required = " + (target_version != null)));
                }
                if (target_version != null) {
                    String sf_cvs_version2;
                    String target_download = sf_details.getDownloadURL();
                    if (current_az_is_cvs && (sf_cvs_version2 = sf_details.getCVSVersion()).length() > 0) {
                        target_download = sf_details.getCVSDownloadURL();
                    }
                    ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                    ResourceDownloader direct_rdl = rdf.create(new URL(target_download));
                    String torrent_download = "http://version.biglybt.com/biglybt-files/plugins/";
                    int slash_pos = target_download.lastIndexOf("/");
                    torrent_download = slash_pos == -1 ? String.valueOf(torrent_download) + target_download : String.valueOf(torrent_download) + target_download.substring(slash_pos + 1);
                    torrent_download = String.valueOf(torrent_download) + ".torrent";
                    if (I2PHelpers.isI2PInstalled()) {
                        torrent_download = String.valueOf(torrent_download) + "?i2p=1";
                    }
                    ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                    torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                    ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl});
                    rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                    ArrayList update_desc = new ArrayList();
                    List desc_lines = HTMLUtils.convertHTMLToText("", sf_details.getDescription());
                    update_desc.addAll(desc_lines);
                    List comment_lines = HTMLUtils.convertHTMLToText("    ", sf_details.getComment());
                    update_desc.addAll(comment_lines);
                    String[] update_d = new String[update_desc.size()];
                    update_desc.toArray(update_d);
                    final Update update = checker.addUpdate(UPDATE_NAME, update_d, current_version, target_version, alternate_rdl, 2);
                    update.setDescriptionURL(sf_details.getInfoURL());
                    alternate_rdl.addListener(new ResourceDownloaderAdapter(){

                        @Override
                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            PlatformManagerUpdateChecker.this.installUpdate(checker, update, downloader, data);
                            return true;
                        }

                        @Override
                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            Debug.out(String.valueOf(downloader.getName()) + " failed", e);
                            update.complete(false);
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                checker.reportProgress("Failed to load plugin details for the platform manager: " + Debug.getNestedExceptionMessage(e));
                checker.setFailed(new Exception("Failed to load plugin details for the platform manager", e));
                checker.completed();
            }
        }
        finally {
            checker.completed();
        }
    }

    protected void installUpdate(UpdateChecker checker, Update update, ResourceDownloader rd, InputStream data) {
        block17: {
            ZipInputStream zip = null;
            try {
                try {
                    data = update.verifyData(data, true);
                    rd.reportActivity("Data verified successfully");
                    UpdateInstaller installer = checker.createInstaller();
                    zip = new ZipInputStream(data);
                    ZipEntry entry = null;
                    while ((entry = zip.getNextEntry()) != null) {
                        String target_dir;
                        String name = entry.getName();
                        String string = target_dir = Constants.isArm ? "osx_arm/" : "osx/";
                        if (!name.toLowerCase().startsWith(target_dir) || (name = name.substring(target_dir.length())).length() <= 0) continue;
                        rd.reportActivity("Adding update action for '" + name + "'");
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "PlatformManager:OSX adding action for '" + name + "'"));
                        }
                        String resource_name = name.replaceAll("/", "-");
                        installer.addResource(resource_name, zip, false);
                        String appDir = installer.getInstallDir();
                        String dotBiglyBT = ".biglybt/";
                        if (name.startsWith(dotBiglyBT)) {
                            String target;
                            if (appDir.endsWith(".biglybt")) {
                                name = name.substring(dotBiglyBT.length());
                                target = String.valueOf(appDir) + File.separator + name;
                                installer.addMoveAction(resource_name, target);
                                if (!name.endsWith(".jnilib") && !name.endsWith("JavaApplicationStub")) continue;
                                installer.addChangeRightsAction("755", target);
                                continue;
                            }
                            name = name.substring(name.lastIndexOf("/") + 1);
                            target = String.valueOf(appDir) + File.separator + name;
                            installer.addMoveAction(resource_name, target);
                            if (!name.endsWith(".jnilib") && !name.endsWith("JavaApplicationStub")) continue;
                            installer.addChangeRightsAction("755", target);
                            continue;
                        }
                        String contentsResourceJava = "Contents/Resources/Java/";
                        if (name.startsWith(contentsResourceJava)) {
                            name = name.substring(contentsResourceJava.length());
                        }
                        String target = String.valueOf(appDir) + File.separator + name;
                        installer.addMoveAction(resource_name, target);
                        if (!name.endsWith(".jnilib") && !name.endsWith("JavaApplicationStub")) continue;
                        installer.addChangeRightsAction("755", target);
                    }
                    update.complete(true);
                }
                catch (Throwable e) {
                    update.complete(false);
                    rd.reportActivity("Update install failed:" + e.getMessage());
                    if (zip == null) break block17;
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected List splitMultiLine(String indent, String text) {
        int p1;
        int pos = 0;
        String lc_text = text.toLowerCase();
        ArrayList<String> lines = new ArrayList<String>();
        do {
            String line;
            if ((p1 = lc_text.indexOf("<br>", pos)) == -1) {
                line = text.substring(pos);
            } else {
                line = text.substring(pos, p1);
                pos = p1 + 4;
            }
            lines.add(String.valueOf(indent) + line);
        } while (p1 != -1);
        return lines;
    }
}

