/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.xml.simpleparser;

import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.UncloseableInputStream;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import com.biglybt.pifimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentNodeImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.Entities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLParserDocumentImpl
implements SimpleXMLParserDocument {
    private static DocumentBuilderFactory dbf_singleton;
    private URL source_url;
    private Document document;
    private SimpleXMLParserDocumentNodeImpl root_node;

    public SimpleXMLParserDocumentImpl(File file) throws SimpleXMLParserDocumentException {
        try {
            this.create(FileUtil.newFileInputStream(file));
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocumentImpl(String data) throws SimpleXMLParserDocumentException {
        this.create(new ByteArrayInputStream(data.getBytes(Constants.DEFAULT_ENCODING_CHARSET)));
    }

    public SimpleXMLParserDocumentImpl(URL _source_url, InputStream _input_stream) throws SimpleXMLParserDocumentException {
        this.source_url = _source_url;
        this.create(_input_stream);
    }

    protected static synchronized DocumentBuilderFactory getDBF() {
        if (dbf_singleton == null) {
            dbf_singleton = DocumentBuilderFactory.newInstance();
            dbf_singleton.setNamespaceAware(true);
            dbf_singleton.setValidating(false);
            dbf_singleton.setIgnoringComments(true);
            dbf_singleton.setIgnoringElementContentWhitespace(true);
            dbf_singleton.setCoalescing(true);
            dbf_singleton.setExpandEntityReferences(true);
        }
        return dbf_singleton;
    }

    /*
     * Unable to fully structure code
     */
    private void create(InputStream _input_stream) throws SimpleXMLParserDocumentException {
        if (!_input_stream.markSupported()) {
            _input_stream = new BufferedInputStream(_input_stream);
        }
        _input_stream.mark(102400);
        uc_is = new UncloseableInputStream(_input_stream);
        error = null;
        try {
            try {
                this.createSupport(uc_is);
            }
            catch (SimpleXMLParserDocumentException e) {
                msg = Debug.getNestedExceptionMessage(e);
                if ((!msg.contains("entity") || !msg.contains("was referenced")) && !msg.contains("entity reference")) ** GOTO lbl20
                try {
                    _input_stream.reset();
                    this.createSupport(new EntityFudger(_input_stream));
                }
                catch (Throwable f) {
                    if (f instanceof SimpleXMLParserDocumentException) {
                        error = (SimpleXMLParserDocumentException)f;
                    }
lbl20:
                    // 4 sources

                    if (error == null) {
                        error = e;
                    }
                    throw error;
                }
                if (Constants.isCVSVersion() && error != null) {
                    try {
                        _input_stream.reset();
                        stuff = FileUtil.readInputStreamAsStringWithTruncation(_input_stream, 2014);
                        Debug.out("RSS parsing failed for '" + stuff + "': " + Debug.getExceptionMessage(error));
                    }
                    catch (Throwable stuff) {
                        // empty catch block
                    }
                }
                try {
                    _input_stream.close();
                }
                catch (Throwable stuff) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            if (Constants.isCVSVersion() && error != null) {
                try {
                    _input_stream.reset();
                    stuff = FileUtil.readInputStreamAsStringWithTruncation(_input_stream, 2014);
                    Debug.out("RSS parsing failed for '" + stuff + "': " + Debug.getExceptionMessage(error));
                }
                catch (Throwable var8_13) {}
            }
            try {
                _input_stream.close();
            }
            catch (Throwable var8_14) {}
        }
    }

    private void createSupport(InputStream input_stream) throws SimpleXMLParserDocumentException {
        try {
            DocumentBuilderFactory dbf = SimpleXMLParserDocumentImpl.getDBF();
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            MyErrorHandler error_handler = new MyErrorHandler(new PrintWriter((Writer)errorWriter, true));
            db.setErrorHandler(error_handler);
            db.setEntityResolver(new EntityResolver(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    try {
                        String net;
                        URL url = new URL(systemId);
                        String protocol = url.getProtocol();
                        if (!protocol.toLowerCase().startsWith("http")) {
                            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                        }
                        if (SimpleXMLParserDocumentImpl.this.source_url != null && (net = AENetworkClassifier.categoriseAddress(SimpleXMLParserDocumentImpl.this.source_url.getHost())) != "Public" && AENetworkClassifier.categoriseAddress(url.getHost()) != net) {
                            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                        }
                        String host = url.getHost();
                        InetAddress.getByName(host);
                        InputStream is = null;
                        try {
                            try {
                                int len;
                                int len2;
                                URLConnection con = url.openConnection();
                                con.setConnectTimeout(15000);
                                con.setReadTimeout(15000);
                                is = con.getInputStream();
                                byte[] buffer = new byte[32];
                                int pos = 0;
                                while (pos < buffer.length && (len2 = is.read(buffer, pos, buffer.length - pos)) > 0) {
                                    pos += len2;
                                }
                                String str = new String(buffer, "UTF-8").trim().toLowerCase(Locale.US);
                                if (str.contains("<?xml")) return null;
                                buffer = new byte[32000];
                                pos = 0;
                                while (pos < buffer.length && (len = is.read(buffer, pos, buffer.length - pos)) > 0) {
                                    pos += len;
                                }
                                str = String.valueOf(str) + new String(buffer, "UTF-8").trim().toLowerCase(Locale.US);
                                if (!str.contains("<html")) return null;
                                if (!str.contains("<head")) return null;
                                throw new Exception("Bad DTD");
                            }
                            catch (Throwable e) {
                                InputSource inputSource = new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                                if (is == null) return inputSource;
                                try {
                                    is.close();
                                    return inputSource;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                return inputSource;
                            }
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                    catch (UnknownHostException e) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            });
            this.document = db.parse(input_stream);
            SimpleXMLParserDocumentNodeImpl[] root_nodes = this.parseNode(this.document, false);
            int root_node_count = 0;
            int i = 0;
            while (i < root_nodes.length) {
                SimpleXMLParserDocumentNodeImpl node = root_nodes[i];
                if (node.getNode().getNodeType() != 7) {
                    this.root_node = node;
                    ++root_node_count;
                }
                ++i;
            }
            if (root_node_count != 1) {
                throw new SimpleXMLParserDocumentException("invalid document - " + root_nodes.length + " root elements");
            }
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    @Override
    public String getName() {
        return this.root_node.getName();
    }

    @Override
    public String getFullName() {
        return this.root_node.getFullName();
    }

    @Override
    public String getNameSpaceURI() {
        return this.root_node.getNameSpaceURI();
    }

    @Override
    public String getValue() {
        return this.root_node.getValue();
    }

    @Override
    public SimpleXMLParserDocumentNode[] getChildren() {
        return this.root_node.getChildren();
    }

    @Override
    public SimpleXMLParserDocumentNode getChild(String name) {
        return this.root_node.getChild(name);
    }

    @Override
    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        return this.root_node.getAttributes();
    }

    @Override
    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        return this.root_node.getAttribute(name);
    }

    @Override
    public void print() {
        PrintWriter pw = new PrintWriter(System.out);
        this.print(pw);
        pw.flush();
    }

    @Override
    public void print(PrintWriter pw) {
        this.root_node.print(pw, "");
    }

    protected SimpleXMLParserDocumentNodeImpl[] parseNode(Node node, boolean skip_this_node) {
        short type = node.getNodeType();
        if (!(type != 1 && type != 7 || skip_this_node)) {
            return new SimpleXMLParserDocumentNodeImpl[]{new SimpleXMLParserDocumentNodeImpl(this, node)};
        }
        Vector<SimpleXMLParserDocumentNodeImpl> v = new Vector<SimpleXMLParserDocumentNodeImpl>();
        Node child = node.getFirstChild();
        while (child != null) {
            SimpleXMLParserDocumentNodeImpl[] kids = this.parseNode(child, false);
            int i = 0;
            while (i < kids.length) {
                v.addElement(kids[i]);
                ++i;
            }
            child = child.getNextSibling();
        }
        Object[] res = new SimpleXMLParserDocumentNodeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    private static class EntityFudger
    extends InputStream {
        private InputStream is;
        char[] buffer = new char[16];
        int buffer_pos = 0;
        char[] insertion = new char[16];
        int insertion_pos = 0;
        int insertion_len = 0;

        public EntityFudger(InputStream _is) {
            this.is = _is;
        }

        @Override
        public int read() throws IOException {
            int b;
            if (this.insertion_len > 0) {
                int result = this.insertion[this.insertion_pos++] & 0xFF;
                if (this.insertion_pos == this.insertion_len) {
                    this.insertion_pos = 0;
                    this.insertion_len = 0;
                }
                return result;
            }
            while (true) {
                if ((b = this.is.read()) < 0) {
                    if (this.buffer_pos == 0) {
                        return b;
                    }
                    if (this.buffer_pos == 1) {
                        this.buffer_pos = 0;
                        return this.buffer[0] & 0xFF;
                    }
                    System.arraycopy(this.buffer, 1, this.insertion, 0, this.buffer_pos - 1);
                    this.insertion_len = this.buffer_pos - 1;
                    this.insertion_pos = 0;
                    this.buffer_pos = 0;
                    return this.buffer[0] & 0xFF;
                }
                if (this.buffer_pos == 0) {
                    if (b == 38) {
                        this.buffer[this.buffer_pos++] = (char)b;
                        continue;
                    }
                    return b;
                }
                if (this.buffer_pos == this.buffer.length - 1) {
                    this.buffer[this.buffer_pos++] = (char)b;
                    System.arraycopy(this.buffer, 0, this.insertion, 0, this.buffer_pos);
                    this.buffer_pos = 0;
                    this.insertion_pos = 0;
                    this.insertion_len = this.buffer_pos;
                    return this.insertion[this.insertion_pos++];
                }
                if (b == 59) {
                    int num;
                    this.buffer[this.buffer_pos++] = (char)b;
                    String ref = new String(this.buffer, 1, this.buffer_pos - 2).toLowerCase(Locale.US);
                    String replacement = ref.equals("amp") || ref.equals("lt") || ref.equals("gt") || ref.equals("quot") || ref.equals("apos") || ref.startsWith("#") ? new String(this.buffer, 0, this.buffer_pos) : ((num = Entities.HTML40.entityValue(ref)) != -1 ? "&#" + num + ";" : new String(this.buffer, 0, this.buffer_pos));
                    char[] chars = replacement.toCharArray();
                    System.arraycopy(chars, 0, this.insertion, 0, chars.length);
                    this.buffer_pos = 0;
                    this.insertion_pos = 0;
                    this.insertion_len = chars.length;
                    return this.insertion[this.insertion_pos++];
                }
                this.buffer[this.buffer_pos++] = (char)b;
                char c = (char)b;
                if (!Character.isLetterOrDigit(c)) break;
            }
            if (this.buffer_pos == 2 && this.buffer[0] == '&') {
                char[] chars = "&amp;".toCharArray();
                System.arraycopy(chars, 0, this.insertion, 0, chars.length);
                this.buffer_pos = 0;
                this.insertion_pos = 0;
                this.insertion_len = chars.length;
                this.insertion[this.insertion_len++] = (char)b;
                return this.insertion[this.insertion_pos++];
            }
            System.arraycopy(this.buffer, 0, this.insertion, 0, this.buffer_pos);
            this.buffer_pos = 0;
            this.insertion_pos = 0;
            this.insertion_len = this.buffer_pos;
            return this.insertion[this.insertion_pos++];
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public long skip(long n) throws IOException {
            int rem;
            if (this.insertion_len > 0) {
                rem = this.insertion_len - this.insertion_pos;
                System.arraycopy(this.insertion, this.insertion_pos, this.buffer, 0, rem);
                this.insertion_pos = 0;
                this.insertion_len = 0;
                this.buffer_pos = rem;
            }
            if (n <= (long)this.buffer_pos) {
                rem = this.buffer_pos - (int)n;
                System.arraycopy(this.buffer, (int)n, this.insertion, 0, rem);
                this.insertion_pos = 0;
                this.insertion_len = rem;
                return n;
            }
            int to_skip = this.buffer_pos;
            this.buffer_pos = 0;
            return this.is.skip(n - (long)to_skip) + (long)to_skip;
        }

        @Override
        public int available() throws IOException {
            return this.buffer_pos + this.is.available();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler(PrintWriter out) {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

