/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.security;

import com.biglybt.core.Core;
import com.biglybt.core.security.SECertificateListener;
import com.biglybt.core.security.SEPasswordListener;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.utils.security.CertificateListener;
import com.biglybt.pif.utils.security.PasswordListener;
import com.biglybt.pif.utils.security.SEPublicKey;
import com.biglybt.pif.utils.security.SEPublicKeyLocator;
import com.biglybt.pif.utils.security.SESecurityManager;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionImpl;
import com.biglybt.pifimpl.local.utils.security.SEPublicKeyImpl;
import com.biglybt.pifimpl.local.utils.security.SESTSConnectionImpl;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class SESecurityManagerImpl
implements SESecurityManager {
    private Core core;
    private Map password_listeners = new HashMap();
    private Map certificate_listeners = new HashMap();

    public SESecurityManagerImpl(Core _core) {
        this.core = _core;
    }

    @Override
    public byte[] calculateSHA1(byte[] data_in) {
        if (data_in == null) {
            data_in = new byte[]{};
        }
        SHA1Hasher hasher = new SHA1Hasher();
        return hasher.calculateHash(data_in);
    }

    @Override
    public void runWithAuthenticator(Authenticator authenticator, Runnable target) {
        try {
            Authenticator.setDefault(authenticator);
            target.run();
        }
        finally {
            com.biglybt.core.security.SESecurityManager.installAuthenticator();
        }
    }

    @Override
    public void addPasswordListener(final PasswordListener listener) {
        SEPasswordListener sepl = new SEPasswordListener(){

            @Override
            public PasswordAuthentication getAuthentication(String realm, URL tracker) {
                return listener.getAuthentication(realm, tracker);
            }

            @Override
            public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
                listener.setAuthenticationOutcome(realm, tracker, success);
            }

            @Override
            public void clearPasswords() {
            }
        };
        this.password_listeners.put(listener, sepl);
        com.biglybt.core.security.SESecurityManager.addPasswordListener(sepl);
    }

    @Override
    public void removePasswordListener(PasswordListener listener) {
        SEPasswordListener sepl = (SEPasswordListener)this.password_listeners.get(listener);
        if (sepl != null) {
            com.biglybt.core.security.SESecurityManager.removePasswordListener(sepl);
        }
    }

    @Override
    public void addCertificateListener(final CertificateListener listener) {
        SECertificateListener sepl = new SECertificateListener(){

            @Override
            public boolean trustCertificate(String resource, X509Certificate cert) {
                return listener.trustCertificate(resource, cert);
            }
        };
        this.certificate_listeners.put(listener, sepl);
        com.biglybt.core.security.SESecurityManager.addCertificateListener(sepl);
    }

    @Override
    public void removeCertificateListener(CertificateListener listener) {
        SECertificateListener sepl = (SECertificateListener)this.certificate_listeners.get(listener);
        if (sepl != null) {
            com.biglybt.core.security.SESecurityManager.removeCertificateListener(sepl);
        }
    }

    @Override
    public SSLSocketFactory installServerCertificate(URL url) {
        return com.biglybt.core.security.SESecurityManager.installServerCertificates(url);
    }

    @Override
    public KeyStore getKeyStore() throws Exception {
        return com.biglybt.core.security.SESecurityManager.getKeyStore();
    }

    @Override
    public KeyStore getTrustStore() throws Exception {
        return com.biglybt.core.security.SESecurityManager.getTrustStore();
    }

    @Override
    public Certificate createSelfSignedCertificate(String alias, String cert_dn, int strength) throws Exception {
        return com.biglybt.core.security.SESecurityManager.createSelfSignedCertificate(alias, cert_dn, strength);
    }

    @Override
    public byte[] getIdentity() {
        return this.core.getCryptoManager().getSecureID();
    }

    @Override
    public SEPublicKey getPublicKey(int key_type, String reason_resource) throws Exception {
        byte[] encoded = this.core.getCryptoManager().getECCHandler().getPublicKey(reason_resource);
        return new SEPublicKeyImpl(key_type, 1, encoded);
    }

    @Override
    public SEPublicKey getPublicKey(int key_type, int instance, String reason_resource) throws Exception {
        byte[] encoded = this.core.getCryptoManager().getECCHandler(instance).getPublicKey(reason_resource);
        return new SEPublicKeyImpl(key_type, instance, encoded);
    }

    @Override
    public GenericMessageConnection getSTSConnection(GenericMessageConnection connection, SEPublicKey my_public_key, SEPublicKeyLocator key_locator, String reason_resource, int block_crypto) throws Exception {
        return new SESTSConnectionImpl(this.core, (GenericMessageConnectionImpl)connection, my_public_key, key_locator, reason_resource, block_crypto);
    }
}

