/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.security;

import com.biglybt.core.Core;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.security.CryptoManagerException;
import com.biglybt.core.security.CryptoSTSEngine;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.messaging.MessageException;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.messaging.generic.GenericMessageConnectionListener;
import com.biglybt.pif.messaging.generic.GenericMessageEndpoint;
import com.biglybt.pif.messaging.generic.GenericMessageStartpoint;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pif.utils.security.SEPublicKey;
import com.biglybt.pif.utils.security.SEPublicKeyLocator;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import com.biglybt.pifimpl.local.utils.security.SEPublicKeyImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SESTSConnectionImpl
implements GenericMessageConnection {
    private static final int CRYPTO_SETUP_TIMEOUT = 60000;
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte[] AES_IV1 = new byte[]{21, -32, 107, 126, -104, 89, -28, -89, 52, 102, -83, 72, 53, -30, -48, 36};
    private static final byte[] AES_IV2 = new byte[]{-60, -17, 6, 60, -104, 35, -24, -76, 38, 88, -82, -71, 44, 36, -74, 17};
    private final int AES_KEY_SIZE_BYTES = AES_IV1.length;
    private static List<SESTSConnectionImpl> connections = new ArrayList<SESTSConnectionImpl>();
    private static AsyncDispatcher dispatcher;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 500;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private Core core;
    private GenericMessageConnectionImpl connection;
    private SEPublicKey my_public_key;
    private SEPublicKeyLocator key_locator;
    private String reason;
    private int block_crypto;
    private long create_time;
    private CryptoSTSEngine sts_engine;
    private CopyOnWriteList<GenericMessageConnectionListener> listeners = new CopyOnWriteList();
    private boolean sent_keys;
    private boolean sent_auth;
    private PooledByteBuffer pending_message;
    private AESemaphore crypto_complete = new AESemaphore("SESTSConnection:send");
    private Cipher outgoing_cipher;
    private Cipher incoming_cipher;
    private volatile boolean failed;

    static {
        SimpleTimer.addPeriodicEvent("SESTSConnectionTimer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                ArrayList<SESTSConnectionImpl> to_close = new ArrayList<SESTSConnectionImpl>();
                List list = connections;
                synchronized (list) {
                    int i = 0;
                    while (i < connections.size()) {
                        SESTSConnectionImpl connection = (SESTSConnectionImpl)connections.get(i);
                        if (!connection.crypto_complete.isReleasedForever()) {
                            long now = SystemTime.getCurrentTime();
                            if (connection.create_time > now) {
                                connection.create_time = now;
                            } else {
                                int time_allowed = connection.getConnectMethodCount() * 60000;
                                if (now - connection.create_time > (long)time_allowed) {
                                    to_close.add(connection);
                                }
                            }
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < to_close.size()) {
                    ((SESTSConnectionImpl)to_close.get(i)).reportFailed(new Exception("Timeout during crypto setup"));
                    ++i;
                }
            }
        });
        dispatcher = new AsyncDispatcher("SESTSAsync");
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(500);
        generate_bloom_create_time = SystemTime.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SESTSConnectionImpl(Core _core, GenericMessageConnectionImpl _connection, SEPublicKey _my_public_key, SEPublicKeyLocator _key_locator, String _reason, int _block_crypto) throws Exception {
        this.core = _core;
        this.connection = _connection;
        this.my_public_key = _my_public_key;
        this.key_locator = _key_locator;
        this.reason = _reason;
        this.block_crypto = _block_crypto;
        this.create_time = SystemTime.getCurrentTime();
        List<SESTSConnectionImpl> list = connections;
        synchronized (list) {
            connections.add(this);
        }
        if (this.connection.isIncoming()) {
            SESTSConnectionImpl.rateLimit(this.connection.getEndpoint().getNotionalAddress());
        }
        this.sts_engine = this.core.getCryptoManager().getECCHandler(this.my_public_key.getInstance()).getSTSEngine(this.reason);
        this.connection.addListener(new GenericMessageConnectionListener(){

            @Override
            public void connected(GenericMessageConnection connection) {
                SESTSConnectionImpl.this.reportConnected();
            }

            @Override
            public void receive(GenericMessageConnection connection, PooledByteBuffer message) throws MessageException {
                SESTSConnectionImpl.this.receive(message);
            }

            @Override
            public void failed(GenericMessageConnection connection, Throwable error) throws MessageException {
                SESTSConnectionImpl.this.reportFailed(error);
            }
        });
    }

    @Override
    public GenericMessageStartpoint getStartpoint() {
        return this.connection.getStartpoint();
    }

    @Override
    public Connection getConnection() {
        return this.connection.getConnection();
    }

    protected int getConnectMethodCount() {
        return this.connection.getConnectMethodCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void rateLimit(InetSocketAddress originator) throws Exception {
        Class<SESTSConnectionImpl> clazz = SESTSConnectionImpl.class;
        synchronized (SESTSConnectionImpl.class) {
            int hit_count = generate_bloom.add(AddressUtils.getAddressBytes(originator));
            long now = SystemTime.getCurrentTime();
            if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 500);
                generate_bloom_create_time = now;
                Logger.log(new LogEvent(LOGID, "STS bloom: size increased to " + generate_bloom.getSize()));
            } else if (now < generate_bloom_create_time || now - generate_bloom_create_time > 30000L) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                generate_bloom_create_time = now;
            }
            if (hit_count >= 15) {
                Logger.log(new LogEvent(LOGID, "STS bloom: too many recent connection attempts from " + originator));
                Debug.out("STS: too many recent connection attempts from " + originator);
                throw new IOException("Too many recent connection attempts (sts)");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.connection.getEndpoint();
    }

    @Override
    public int getMaximumMessageSize() {
        int max = this.connection.getMaximumMessageSize();
        if (this.outgoing_cipher != null) {
            max -= this.outgoing_cipher.getBlockSize();
        }
        return max;
    }

    @Override
    public String getType() {
        String con_type = this.connection.getType();
        if (con_type.length() == 0) {
            return "";
        }
        return "AES " + con_type;
    }

    @Override
    public int getTransportType() {
        return this.connection.getTransportType();
    }

    @Override
    public void addInboundRateLimiter(RateLimiter limiter) {
        this.connection.addInboundRateLimiter(limiter);
    }

    @Override
    public void removeInboundRateLimiter(RateLimiter limiter) {
        this.connection.removeInboundRateLimiter(limiter);
    }

    @Override
    public void addOutboundRateLimiter(RateLimiter limiter) {
        this.connection.addOutboundRateLimiter(limiter);
    }

    @Override
    public void removeOutboundRateLimiter(RateLimiter limiter) {
        this.connection.removeOutboundRateLimiter(limiter);
    }

    @Override
    public void connect(GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) throws MessageException {
        if (this.connection.isIncoming()) {
            this.connection.connect(ph);
        } else {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(32768);
                this.sts_engine.getKeys(buffer);
                buffer.flip();
                this.sent_keys = true;
                this.connection.connect(buffer, ph);
            }
            catch (CryptoManagerException e) {
                throw new MessageException("Failed to get initial keys", e);
            }
        }
    }

    protected void setFailed() {
        this.failed = true;
        try {
            this.cryptoComplete();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(PooledByteBuffer message) throws MessageException {
        try {
            boolean forward = false;
            boolean crypto_completed = false;
            ByteBuffer out_buffer = null;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.crypto_complete.isReleasedForever()) {
                    forward = true;
                } else {
                    ByteBuffer in_buffer = ByteBuffer.wrap(message.toByteArray());
                    message.returnToPool();
                    if (!this.sent_keys) {
                        out_buffer = ByteBuffer.allocate(65536);
                        this.sts_engine.getKeys(out_buffer);
                        this.sent_keys = true;
                        this.sts_engine.putKeys(in_buffer);
                        this.sts_engine.getAuth(out_buffer);
                        this.sent_auth = true;
                    } else if (!this.sent_auth) {
                        out_buffer = ByteBuffer.allocate(65536);
                        this.sts_engine.putKeys(in_buffer);
                        this.sts_engine.getAuth(out_buffer);
                        this.sent_auth = true;
                        this.sts_engine.putAuth(in_buffer);
                        byte[] rem_key = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), this.my_public_key.getInstance(), rem_key))) {
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        if (this.pending_message != null) {
                            byte[] pending_bytes = this.pending_message.toByteArray();
                            int pending_size = pending_bytes.length;
                            if (this.outgoing_cipher != null && (pending_size = (pending_size + this.AES_KEY_SIZE_BYTES - 1) / this.AES_KEY_SIZE_BYTES * this.AES_KEY_SIZE_BYTES) == 0) {
                                pending_size = this.AES_KEY_SIZE_BYTES;
                            }
                            if (out_buffer.remaining() >= pending_size) {
                                if (this.outgoing_cipher != null) {
                                    out_buffer.put(this.outgoing_cipher.doFinal(pending_bytes));
                                } else {
                                    out_buffer.put(pending_bytes);
                                }
                                this.pending_message = null;
                            }
                        }
                        crypto_completed = true;
                    } else {
                        this.sts_engine.putAuth(in_buffer);
                        byte[] rem_key = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), this.my_public_key.getInstance(), rem_key))) {
                            this.connection.closing();
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        crypto_completed = true;
                        if (in_buffer.hasRemaining()) {
                            message = new PooledByteBufferImpl(new DirectByteBuffer(in_buffer.slice()));
                            forward = true;
                        }
                    }
                }
            }
            if (out_buffer != null) {
                out_buffer.flip();
                this.connection.send(new PooledByteBufferImpl(new DirectByteBuffer(out_buffer)));
            }
            if (crypto_completed) {
                this.cryptoComplete();
            }
            if (forward) {
                this.receiveContent(message);
            }
        }
        catch (Throwable e) {
            this.reportFailed(e);
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            throw new MessageException("Receive failed", e);
        }
    }

    protected void setupBlockCrypto() throws MessageException {
        if (!this.failed) {
            if (this.block_crypto == 1) {
                return;
            }
            try {
                byte[] shared_secret = this.sts_engine.getSharedSecret();
                SecretKeySpec secret_key_spec1 = new SecretKeySpec(shared_secret, 0, 16, "AES");
                SecretKeySpec secret_key_spec2 = new SecretKeySpec(shared_secret, 8, 16, "AES");
                IvParameterSpec param_spec1 = new IvParameterSpec(AES_IV1);
                IvParameterSpec param_spec2 = new IvParameterSpec(AES_IV2);
                Cipher cipher1 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                Cipher cipher2 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                if (this.connection.isIncoming()) {
                    cipher1.init(1, (Key)secret_key_spec1, param_spec1);
                    cipher2.init(2, (Key)secret_key_spec2, param_spec2);
                    this.incoming_cipher = cipher2;
                    this.outgoing_cipher = cipher1;
                } else {
                    cipher1.init(2, (Key)secret_key_spec1, param_spec1);
                    cipher2.init(1, (Key)secret_key_spec2, param_spec2);
                    this.incoming_cipher = cipher1;
                    this.outgoing_cipher = cipher2;
                }
            }
            catch (Throwable e) {
                throw new MessageException("Failed to setup block encryption", e);
            }
        }
    }

    protected void cryptoComplete() throws MessageException {
        this.crypto_complete.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(PooledByteBuffer message) throws MessageException {
        if (this.failed) {
            throw new MessageException("Connection failed");
        }
        try {
            if (this.crypto_complete.isReleasedForever()) {
                this.sendContent(message);
            } else {
                SESTSConnectionImpl sESTSConnectionImpl = this;
                synchronized (sESTSConnectionImpl) {
                    if (this.pending_message == null) {
                        this.pending_message = message;
                    }
                }
            }
            this.crypto_complete.reserve();
            boolean send_it = false;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.pending_message == message) {
                    this.pending_message = null;
                    send_it = true;
                }
            }
            if (send_it) {
                this.sendContent(message);
            }
        }
        catch (Throwable e) {
            this.setFailed();
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            throw new MessageException("Send failed", e);
        }
    }

    protected void sendContent(PooledByteBuffer message) throws MessageException {
        block6: {
            if (this.outgoing_cipher != null) {
                try {
                    byte[] plain = message.toByteArray();
                    byte[] enc = this.outgoing_cipher.doFinal(plain);
                    PooledByteBufferImpl temp = new PooledByteBufferImpl(enc);
                    try {
                        this.connection.send(temp);
                        message.returnToPool();
                        break block6;
                    }
                    catch (Throwable e) {
                        temp.returnToPool();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throw new MessageException("Failed to encrypt data", e);
                }
            }
            if (this.block_crypto != 1) {
                this.connection.close();
                throw new MessageException("Crypto isn't setup");
            }
            this.connection.send(message);
        }
    }

    protected void receiveContent(PooledByteBuffer message) throws MessageException {
        boolean buffer_handled = false;
        try {
            if (this.incoming_cipher != null) {
                try {
                    byte[] enc = message.toByteArray();
                    byte[] plain = this.incoming_cipher.doFinal(enc);
                    PooledByteBufferImpl temp = new PooledByteBufferImpl(plain);
                    message.returnToPool();
                    buffer_handled = true;
                    message = temp;
                }
                catch (Throwable e) {
                    throw new MessageException("Failed to decrypt data", e);
                }
            } else if (this.block_crypto != 1) {
                throw new MessageException("Crypto isn't setup");
            }
            List<GenericMessageConnectionListener> listeners_ref = this.listeners.getList();
            MessageException last_error = null;
            int i = 0;
            while (i < listeners_ref.size()) {
                PooledByteBuffer message_to_deliver = i == 0 ? message : new PooledByteBufferImpl(message.toByteArray());
                try {
                    listeners_ref.get(i).receive(this, message_to_deliver);
                    if (message_to_deliver == message) {
                        buffer_handled = true;
                    }
                }
                catch (Throwable e) {
                    message_to_deliver.returnToPool();
                    if (message_to_deliver == message) {
                        buffer_handled = true;
                    }
                    last_error = e instanceof MessageException ? (MessageException)e : new MessageException("Failed to process message", e);
                }
                ++i;
            }
            if (last_error != null) {
                throw last_error;
            }
        }
        finally {
            if (!buffer_handled) {
                message.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MessageException {
        List<SESTSConnectionImpl> list = connections;
        synchronized (list) {
            connections.remove(this);
        }
        this.connection.close();
    }

    protected void reportConnected() {
        dispatcher.dispatch(AERunnable.create(() -> {
            List<GenericMessageConnectionListener> listeners_ref = this.listeners.getList();
            int i = 0;
            while (i < listeners_ref.size()) {
                try {
                    listeners_ref.get(i).connected(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }));
    }

    protected void reportFailed(Throwable error) {
        this.setFailed();
        dispatcher.dispatch(AERunnable.create(() -> {
            try {
                List<GenericMessageConnectionListener> listeners_ref = this.listeners.getList();
                int i = 0;
                while (i < listeners_ref.size()) {
                    try {
                        listeners_ref.get(i).failed(this, error);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            finally {
                try {
                    this.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }));
    }

    @Override
    public void addListener(GenericMessageConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GenericMessageConnectionListener listener) {
        this.listeners.remove(listener);
    }
}

