/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils.resourcedownloader;

import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.security.SEPasswordListener;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.clientid.ClientIDGenerator;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderCancelledException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import com.biglybt.pifimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    private URL original_url;
    private boolean auth_supplied;
    private String user_name;
    private String password;
    private InputStream input_stream;
    private boolean cancel_download = false;
    private boolean download_initiated;
    private long size = -2L;
    private boolean force_no_proxy = false;
    private Proxy force_proxy;
    private boolean auto_plugin_proxy;
    private Map<String, Object> auto_plugin_proxy_options;
    private final byte[] post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        this(_parent, _url, null, _auth_supplied, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, byte[] _data, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.post_data = _data;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected void setForceNoProxy(boolean force_no_proxy) {
        this.force_no_proxy = force_no_proxy;
    }

    protected void setForceProxy(Proxy proxy) {
        this.force_proxy = proxy;
    }

    protected void setAutoPluginProxy(Map<String, Object> options) {
        this.auto_plugin_proxy = true;
        this.auto_plugin_proxy_options = options;
    }

    protected URL getURL() {
        return this.original_url;
    }

    @Override
    public String getName() {
        return this.original_url.toString();
    }

    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
                this.setProperties(c);
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
    }

    @Override
    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String protocol = this.original_url.getProtocol().toLowerCase();
            if (protocol.equals("magnet")) return -1L;
            if (protocol.equals("maggot")) return -1L;
            if (protocol.equals("dht")) return -1L;
            if (protocol.equals("vuze")) return -1L;
            if (protocol.equals("biglybt")) return -1L;
            if (protocol.equals("azplug")) return -1L;
            if (protocol.equals("ftp")) {
                return -1L;
            }
            if (protocol.equals("file")) {
                return FileUtil.newFile(this.original_url.toURI()).length();
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                AEProxyFactory.PluginProxy plugin_proxy;
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                URL initial_url = url = AddressUtils.adjustURL(url);
                boolean ok = false;
                if (this.auto_plugin_proxy || this.isAnonymous()) {
                    plugin_proxy = AEProxyFactory.getPluginProxy("downloading resource", url, this.auto_plugin_proxy_options);
                    if (plugin_proxy == null) {
                        throw new ResourceDownloaderException(this, "No plugin proxy available");
                    }
                    url = plugin_proxy.getURL();
                    this.force_proxy = plugin_proxy.getProxy();
                } else {
                    plugin_proxy = null;
                }
                try {
                    if (this.force_no_proxy) {
                        AEProxySelectorFactory.getSelector().startNoProxy();
                    }
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    boolean dh_hack = false;
                    boolean internal_error_hack = false;
                    SSLSocketFactory ssl_socket_factory = null;
                    int connect_loop = 0;
                    {
                        while (true) {
                            block53: {
                                HttpURLConnection con;
                                block52: {
                                    if (connect_loop >= 2) {
                                        throw new ResourceDownloaderException(this, "Should never get here");
                                    }
                                    if (url.getProtocol().equalsIgnoreCase("https")) {
                                        HttpsURLConnection ssl_con = (HttpsURLConnection)this.openConnection(this.force_proxy, url);
                                        if (ssl_socket_factory != null) {
                                            ssl_con.setSSLSocketFactory(ssl_socket_factory);
                                        }
                                        if (!internal_error_hack) {
                                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                                @Override
                                                public boolean verify(String host, SSLSession session) {
                                                    return true;
                                                }
                                            });
                                        }
                                        if (plugin_proxy != null) {
                                            TrustManagerFactory tmf = SESecurityManager.getTrustManagerFactory();
                                            final ArrayList<X509TrustManager> default_tms = new ArrayList<X509TrustManager>();
                                            if (tmf != null) {
                                                TrustManager[] trustManagerArray = tmf.getTrustManagers();
                                                int n = trustManagerArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    TrustManager tm = trustManagerArray[n2];
                                                    if (tm instanceof X509TrustManager) {
                                                        default_tms.add((X509TrustManager)tm);
                                                    }
                                                    ++n2;
                                                }
                                            }
                                            TrustManager[] tms_delegate = SESecurityManager.getAllTrustingTrustManager(new X509TrustManager(){

                                                @Override
                                                public X509Certificate[] getAcceptedIssuers() {
                                                    ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
                                                    for (X509TrustManager tm : default_tms) {
                                                        result.addAll(Arrays.asList(tm.getAcceptedIssuers()));
                                                    }
                                                    return result.toArray(new X509Certificate[result.size()]);
                                                }

                                                @Override
                                                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                                    for (X509TrustManager tm : default_tms) {
                                                        tm.checkClientTrusted(chain, authType);
                                                    }
                                                }

                                                @Override
                                                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                                    for (X509TrustManager tm : default_tms) {
                                                        tm.checkServerTrusted(chain, authType);
                                                    }
                                                }
                                            });
                                            SSLContext sc = SSLContext.getInstance("SSL");
                                            sc.init(null, tms_delegate, RandomUtils.SECURE_RANDOM);
                                            SSLSocketFactory factory = sc.getSocketFactory();
                                            ssl_con.setSSLSocketFactory(factory);
                                        }
                                        if (dh_hack) {
                                            UrlUtils.DHHackIt(ssl_con);
                                        }
                                        if (internal_error_hack && plugin_proxy != null) {
                                            String host = plugin_proxy.getURLHostRewrite();
                                            UrlUtils.HTTPSURLConnectionSNIHack(host, ssl_con);
                                        }
                                        con = ssl_con;
                                    } else {
                                        con = (HttpURLConnection)this.openConnection(this.force_proxy, url);
                                    }
                                    con.setInstanceFollowRedirects(plugin_proxy == null);
                                    if (plugin_proxy != null) {
                                        con.setRequestProperty("HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (initial_url.getPort() == -1 ? "" : ":" + initial_url.getPort()));
                                    }
                                    con.setRequestMethod("HEAD");
                                    ClientIDGenerator cidg = ClientIDManagerImpl.getSingleton().getGenerator();
                                    if (cidg != null) {
                                        Properties props = new Properties();
                                        cidg.generateHTTPProperties(null, props);
                                        String ua = props.getProperty("User-Agent");
                                        con.setRequestProperty("User-Agent", ua);
                                    }
                                    this.setRequestProperties(con, false);
                                    try {
                                        con.connect();
                                    }
                                    catch (AEProxyFactory.UnknownHostException e) {
                                        throw new UnknownHostException(e.getMessage());
                                    }
                                    int response = con.getResponseCode();
                                    this.setProperty("URL_HTTP_Response", new Long(response));
                                    if (response == 202 || response == 200) break block52;
                                    if (response == 302) return -1L;
                                    if (response == 301) {
                                        return -1L;
                                    }
                                    URL dest = url;
                                    if (plugin_proxy == null) throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay(dest) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                                    try {
                                        dest = new URL(plugin_proxy.getTarget());
                                        throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay(dest) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay(dest) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                                }
                                this.getRequestProperties(con);
                                ok = true;
                                long l = UrlUtils.getContentLength(con);
                                return l;
                                catch (SSLException e) {}
                                String msg = Debug.getNestedExceptionMessage(e);
                                if (connect_loop >= 3) throw e;
                                boolean try_again = false;
                                if (msg.contains("DH keypair")) {
                                    if (!dh_hack) {
                                        dh_hack = true;
                                        try_again = true;
                                    }
                                } else if ((msg.contains("internal_error") || msg.contains("handshake_failure")) && !internal_error_hack) {
                                    internal_error_hack = true;
                                    try_again = true;
                                }
                                URL cert_url = url;
                                if (plugin_proxy != null) {
                                    try {
                                        cert_url = new URL(plugin_proxy.getTarget());
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if ((ssl_socket_factory = SESecurityManager.installServerCertificates(cert_url)) != null) {
                                    try_again = true;
                                }
                                if (!try_again) throw e;
                                break block53;
                                catch (IOException e) {
                                    if (connect_loop != 0) throw e;
                                    URL retry_url = UrlUtils.getIPV4Fallback(url);
                                    if (retry_url == null) throw e;
                                    url = retry_url;
                                }
                            }
                            ++connect_loop;
                        }
                    }
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, null);
                    }
                    if (this.force_no_proxy) {
                        AEProxySelectorFactory.getSelector().endNoProxy();
                    }
                    if (plugin_proxy != null) {
                        plugin_proxy.setOK(ok);
                        this.force_proxy = null;
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
                throw rde;
            }
            Debug.out(e);
            rde = new ResourceDownloaderException(this, "Unexpected error", e);
            throw rde;
        }
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        c.setProperties(this);
        c.setForceNoProxy(this.force_no_proxy);
        if (this.force_proxy != null) {
            c.setForceProxy(this.force_proxy);
        }
        if (this.auto_plugin_proxy) {
            c.setAutoPluginProxy(this.auto_plugin_proxy_options);
        }
        return c;
    }

    @Override
    public void asyncDownload() {
        final Object parent_tls = TorrentUtils.getTLS();
        AEThread2 t = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            @Override
            public void run() {
                Object child_tls = TorrentUtils.getTLS();
                TorrentUtils.setTLS(parent_tls);
                try {
                    try {
                        ResourceDownloaderURLImpl.this.download();
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        TorrentUtils.setTLS(child_tls);
                    }
                }
                finally {
                    TorrentUtils.setTLS(child_tls);
                }
            }
        };
        t.start();
    }

    /*
     * Exception decompiling
     */
    @Override
    public InputStream download() throws ResourceDownloaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.informFailed(new ResourceDownloaderCancelledException(this));
    }

    protected void setRequestProperties(URLConnection con, boolean use_compression) {
        Map properties = this.getLCKeyProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith("url_") || !(value instanceof String) || value.equals("skip") || key.equalsIgnoreCase("URL_HTTP_VERB") || (key = key.substring(4)).equals("accept-encoding") && !use_compression) continue;
            String nice_key = "";
            boolean upper = true;
            char[] cArray = key.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (upper) {
                    c = Character.toUpperCase(c);
                    upper = false;
                } else if (c == '-') {
                    upper = true;
                }
                nice_key = String.valueOf(nice_key) + c;
                ++n2;
            }
            con.setRequestProperty(nice_key, (String)value);
        }
    }

    protected void getRequestProperties(URLConnection con) {
        try {
            this.setProperty("ContentType", con.getContentType());
            this.setProperty("URL_URL", con.getURL());
            Map<String, List<String>> headers = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> val = entry.getValue();
                if (key == null) continue;
                this.setProperty("URL_" + key, val);
            }
            this.setPropertiesSet();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    @Override
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    @Override
    public void clearPasswords() {
    }

    private URLConnection openConnection(Proxy proxy, URL url) throws IOException {
        if (this.force_no_proxy) {
            return url.openConnection(Proxy.NO_PROXY);
        }
        if (proxy != null) {
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    protected String trimForDisplay(URL url) {
        String str;
        int pos;
        AEProxyFactory.PluginProxy pp;
        if (this.force_proxy != null && (pp = AEProxyFactory.getPluginProxy(this.force_proxy)) != null) {
            try {
                url = new URL(pp.getTarget());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((pos = (str = url.toString()).indexOf(63)) != -1) {
            str = str.substring(0, pos);
        }
        return str;
    }
}

