/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.utils;

import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.utils.Formatters;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class FormattersImpl
implements Formatters {
    @Override
    public String formatByteCountToKiBEtc(long bytes) {
        return DisplayFormatters.formatByteCountToKiBEtc(bytes);
    }

    @Override
    public String formatByteCountToKiBEtcPerSec(long bytes) {
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(bytes);
    }

    @Override
    public String formatPercentFromThousands(long thousands) {
        return DisplayFormatters.formatPercentFromThousands((int)thousands);
    }

    @Override
    public String formatByteArray(byte[] data, boolean no_spaces) {
        return ByteFormatter.nicePrint(data, no_spaces);
    }

    @Override
    public String encodeBytesToString(byte[] bytes) {
        return ByteFormatter.encodeString(bytes);
    }

    @Override
    public byte[] decodeBytesFromString(String str) {
        return ByteFormatter.decodeString(str);
    }

    @Override
    public String formatDate(long millis) {
        return DisplayFormatters.formatCustomDateTime(millis);
    }

    @Override
    public String formatTimeOnly(long millis) {
        return DisplayFormatters.formatCustomTimeOnly(millis);
    }

    @Override
    public String formatTimeOnly(long millis, boolean with_secs) {
        return DisplayFormatters.formatCustomTimeOnly(millis, with_secs);
    }

    @Override
    public String formatDateOnly(long millis) {
        return DisplayFormatters.formatCustomDateOnly(millis);
    }

    @Override
    public String formatTimeFromSeconds(long seconds) {
        return DisplayFormatters.formatTime(seconds * 1000L);
    }

    @Override
    public String formatETAFromSeconds(long seconds) {
        return TimeFormatter.format(seconds);
    }

    @Override
    public byte[] bEncode(Map map) throws IOException {
        return BEncoder.encode(map);
    }

    @Override
    public Map bDecode(byte[] data) throws IOException {
        return BDecoder.decode(data);
    }

    @Override
    public String base32Encode(byte[] data) {
        return Base32.encode(data);
    }

    @Override
    public byte[] base32Decode(String data) {
        return Base32.decode(data);
    }

    @Override
    public Comparator<String> getAlphanumericComparator(boolean ignore_case) {
        return FormattersImpl.getAlphanumericComparator2(ignore_case);
    }

    public static Comparator<String> getAlphanumericComparator2(final boolean ignore_case) {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int l1 = s1.length();
                int l2 = s2.length();
                int c1_pos = 0;
                int c2_pos = 0;
                while (c1_pos < l1 && c2_pos < l2) {
                    char c1 = s1.charAt(c1_pos++);
                    char c2 = s2.charAt(c2_pos++);
                    if (Character.isDigit(c1) && Character.isDigit(c2)) {
                        int n1_pos = c1_pos - 1;
                        int n2_pos = c2_pos - 1;
                        while (c1_pos < l1) {
                            if (!Character.isDigit(s1.charAt(c1_pos))) break;
                            ++c1_pos;
                        }
                        while (c2_pos < l2) {
                            if (!Character.isDigit(s2.charAt(c2_pos))) break;
                            ++c2_pos;
                        }
                        int n1_length = c1_pos - n1_pos;
                        int n2_length = c2_pos - n2_pos;
                        if (n1_length != n2_length) {
                            return n1_length - n2_length;
                        }
                        int i = 0;
                        while (i < n1_length) {
                            char nc2;
                            char nc1;
                            if ((nc1 = s1.charAt(n1_pos++)) != (nc2 = s2.charAt(n2_pos++))) {
                                return nc1 - nc2;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (ignore_case) {
                        c1 = Character.toLowerCase(c1);
                        c2 = Character.toLowerCase(c2);
                    }
                    if (c1 == c2) continue;
                    return c1 - c2;
                }
                return l1 - l2;
            }
        };
    }
}

