/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.tables;

import com.biglybt.pif.ui.UIRuntimeException;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.ui.UIManagerImpl;
import com.biglybt.pifimpl.local.ui.tables.TableContextMenuItemImpl;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.common.table.impl.TableColumnImpl;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.table.impl.TableContextMenuManager;

public class TableManagerImpl
implements TableManager {
    private UIManagerImpl ui_manager;

    public TableManagerImpl(UIManagerImpl _ui_manager) {
        this.ui_manager = _ui_manager;
    }

    @Override
    public TableColumn createColumn(String tableID, String cellID) {
        return new TableColumnImpl(tableID, cellID);
    }

    @Override
    public void registerColumn(Class forDataSourceType, String cellID, TableColumnCreationListener listener) {
        String[] tables;
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.registerColumn(forDataSourceType, cellID, listener);
        String[] stringArray = tables = tcManager.getTableIDs();
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String tid = stringArray[n2];
            TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(tid);
            tsed.tableStructureChanged(true, forDataSourceType);
            ++n2;
        }
    }

    @Override
    public void unregisterColumn(Class forDataSourceType, String cellID) {
        String[] tables;
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.unregisterColumn(forDataSourceType, cellID);
        String[] stringArray = tables = tcManager.getTableIDs();
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String tid = stringArray[n2];
            TableColumnCore col = tcManager.getTableColumnCore(tid, cellID);
            if (col != null) {
                col.remove();
            }
            ++n2;
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        if (!(tableColumn instanceof TableColumnImpl)) {
            throw new UIRuntimeException("TableManager.addColumn(..) can only add columns created by createColumn(..)");
        }
        TableColumnManager.getInstance().addColumns(new TableColumnCore[]{(TableColumnCore)tableColumn});
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(tableColumn.getTableID());
        tsed.tableStructureChanged(true, tableColumn.getForDataSourceType());
    }

    @Override
    public TableContextMenuItem addContextMenuItem(TableContextMenuItem parent, String resourceKey) {
        if (!(parent instanceof TableContextMenuItemImpl)) {
            throw new UIRuntimeException("parent must have been created by addContextMenuItem");
        }
        if (parent.getStyle() != 5) {
            throw new UIRuntimeException("parent menu item must have the menu style associated");
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl((TableContextMenuItemImpl)parent, resourceKey);
        return item;
    }

    @Override
    public TableContextMenuItem addContextMenuItem(String tableID, String resourceKey) {
        TableContextMenuItemImpl item = new TableContextMenuItemImpl(this.ui_manager.getPluginInterface(), tableID, resourceKey);
        TableContextMenuManager.getInstance().addContextMenuItem(item);
        return item;
    }
}

