/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.model;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.logging.LoggerChannelListener;
import com.biglybt.pif.ui.components.UIButton;
import com.biglybt.pif.ui.components.UIProgressBar;
import com.biglybt.pif.ui.components.UITextArea;
import com.biglybt.pif.ui.components.UITextField;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pifimpl.local.ui.UIManagerImpl;
import com.biglybt.pifimpl.local.ui.components.UIButtonImpl;
import com.biglybt.pifimpl.local.ui.components.UIProgressBarImpl;
import com.biglybt.pifimpl.local.ui.components.UITextAreaImpl;
import com.biglybt.pifimpl.local.ui.components.UITextFieldImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicPluginViewModelImpl
implements BasicPluginViewModel,
DataSourceResolver.ExportableDataSource {
    private UIManagerImpl ui_manager;
    private String name;
    private UITextField status;
    private UITextField activity;
    private UITextArea log;
    private UIProgressBar progress;
    private String sConfigSectionID;
    private List<UIButton> buttons = new ArrayList<UIButton>();
    private Map<Integer, Object> properties;

    public BasicPluginViewModelImpl(UIManagerImpl _ui_manager, String _name) {
        this.ui_manager = _ui_manager;
        this.name = _name;
        this.status = new UITextFieldImpl();
        this.activity = new UITextFieldImpl();
        this.log = new UITextAreaImpl();
        this.progress = new UIProgressBarImpl();
    }

    @Override
    public DataSourceResolver.ExportedDataSource exportDataSource() {
        return UIManagerImpl.exportDataSource(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UITextField getStatus() {
        return this.status;
    }

    @Override
    public UITextField getActivity() {
        return this.activity;
    }

    @Override
    public UIButton addButton() {
        UIButtonImpl res = new UIButtonImpl();
        this.buttons.add(res);
        return res;
    }

    @Override
    public List<UIButton> getButtons() {
        return this.buttons;
    }

    @Override
    public PluginInterface getPluginInterface() {
        return this.ui_manager.getPluginInterface();
    }

    @Override
    public UITextArea getLogArea() {
        return this.log;
    }

    @Override
    public UIProgressBar getProgress() {
        return this.progress;
    }

    @Override
    public void setConfigSectionID(String id) {
        this.sConfigSectionID = id;
    }

    @Override
    public String getConfigSectionID() {
        return this.sConfigSectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(int property, Object value) {
        BasicPluginViewModelImpl basicPluginViewModelImpl = this;
        synchronized (basicPluginViewModelImpl) {
            if (this.properties == null) {
                this.properties = new HashMap<Integer, Object>();
            }
            this.properties.put(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(int property) {
        BasicPluginViewModelImpl basicPluginViewModelImpl = this;
        synchronized (basicPluginViewModelImpl) {
            block4: {
                if (this.properties != null) break block4;
                return null;
            }
            return this.properties.get(property);
        }
    }

    @Override
    public void destroy() {
        this.ui_manager.destroy(this);
    }

    @Override
    public void attachLoggerChannel(LoggerChannel channel2) {
        channel2.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(String message, Throwable t) {
                this.messageLogged(3, message, t);
            }

            @Override
            public void messageLogged(int logtype, String message) {
                this.messageLogged(logtype, message, null);
            }

            public void messageLogged(int logtype, String message, Throwable t) {
                String log_type_s = null;
                switch (logtype) {
                    case 2: {
                        log_type_s = "warning";
                        break;
                    }
                    case 3: {
                        log_type_s = "error";
                    }
                }
                if (log_type_s != null) {
                    String prefix = MessageText.getString("AlertMessageBox." + log_type_s);
                    BasicPluginViewModelImpl.this.log.appendText("[" + prefix.toUpperCase() + "] ");
                }
                BasicPluginViewModelImpl.this.log.appendText(String.valueOf(message) + "\n");
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    BasicPluginViewModelImpl.this.log.appendText(String.valueOf(sw.toString()) + "\n");
                }
            }
        });
    }
}

