/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.pif.ui.config.PasswordParameter;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import java.security.MessageDigest;

public class PasswordParameterImpl
extends ParameterImpl
implements PasswordParameter {
    protected int encoding_type;
    private int widthInCharacters;

    public PasswordParameterImpl(String key, String labelKey, int _encoding_type) {
        super(key, labelKey);
        this.encoding_type = _encoding_type;
    }

    @Override
    public void setValue(String plain_password) {
        byte[] encoded = plain_password == null || plain_password.length() == 0 ? new byte[]{} : this.encode(plain_password);
        COConfigurationManager.setParameter(this.getConfigKeyName(), encoded);
    }

    public int getEncodingType() {
        return this.encoding_type;
    }

    @Override
    public byte[] getValue() {
        return COConfigurationManager.getByteParameter(this.getConfigKeyName());
    }

    protected byte[] encode(String str) {
        try {
            return this.encode(this.encoding_type == 3 ? str.getBytes("UTF-8") : str.getBytes());
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public byte[] encode(byte[] bytes) {
        if (this.encoding_type == 2) {
            SHA1Hasher hasher = new SHA1Hasher();
            return hasher.calculateHash(bytes);
        }
        if (this.encoding_type == 3) {
            try {
                return MessageDigest.getInstance("md5").digest(bytes);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return bytes;
    }

    @Override
    public void setWidthInCharacters(int widthInCharacters) {
        this.widthInCharacters = widthInCharacters;
    }

    @Override
    public int getWidthInCharacters() {
        return this.widthInCharacters;
    }

    @Override
    public Object getValueObject() {
        return this.getValue();
    }
}

