/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui.components;

import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.pif.ui.components.UIComponent;
import com.biglybt.pif.ui.components.UIPropertyChangeEvent;
import com.biglybt.pif.ui.components.UIPropertyChangeListener;
import java.util.Properties;

public class UIComponentImpl
implements UIComponent {
    private Properties properties = new Properties();
    private CopyOnWriteList<UIPropertyChangeListener> property_listeners = new CopyOnWriteList();
    private CopyOnWriteList<UIComponent.RefreshListener> refresh_listeners = new CopyOnWriteList();

    protected UIComponentImpl() {
        this.properties.put("enabled", Boolean.TRUE);
        this.properties.put("visible", Boolean.TRUE);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    @Override
    public boolean getEnabled() {
        return (Boolean)this.getProperty("enabled");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setProperty("visible", visible);
    }

    @Override
    public boolean getVisible() {
        return (Boolean)this.getProperty("visible");
    }

    @Override
    public void setProperty(final String property_type, final Object property_value) {
        final Boolean old_value = property_type == "selected" ? Boolean.valueOf(false) : this.properties.get(property_type);
        this.properties.put(property_type, property_value);
        UIPropertyChangeEvent ev = new UIPropertyChangeEvent(){

            @Override
            public UIComponent getSource() {
                return UIComponentImpl.this;
            }

            @Override
            public String getPropertyType() {
                return property_type;
            }

            @Override
            public Object getNewPropertyValue() {
                return property_value;
            }

            @Override
            public Object getOldPropertyValue() {
                return old_value;
            }
        };
        for (UIPropertyChangeListener listener : this.property_listeners) {
            listener.propertyChanged(ev);
        }
    }

    @Override
    public Object getProperty(String property_type) {
        return this.properties.get(property_type);
    }

    @Override
    public void addPropertyChangeListener(UIPropertyChangeListener l) {
        this.property_listeners.add(l);
    }

    @Override
    public void removePropertyChangeListener(UIPropertyChangeListener l) {
        this.property_listeners.remove(l);
    }

    @Override
    public void refresh() {
        for (UIComponent.RefreshListener l : this.refresh_listeners) {
            l.refresh();
        }
    }

    @Override
    public void addRefreshListener(UIComponent.RefreshListener l) {
        this.refresh_listeners.add(l);
    }

    @Override
    public void removeRefreshListener(UIComponent.RefreshListener l) {
        this.refresh_listeners.remove(l);
    }
}

