/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ui;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.ui.UIDataSourceListener;
import com.biglybt.pif.ui.UIException;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIInstanceFactory;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerEvent;
import com.biglybt.pif.ui.UIManagerEventListener;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.UIManagerListener2;
import com.biglybt.pif.ui.UIMessage;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.pif.ui.model.PluginConfigModel;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.ui.UIManagerEventAdapter;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionRepository;
import com.biglybt.pifimpl.local.ui.menus.MenuManagerImpl;
import com.biglybt.pifimpl.local.ui.model.BasicPluginConfigModelImpl;
import com.biglybt.pifimpl.local.ui.model.BasicPluginViewModelImpl;
import com.biglybt.pifimpl.local.ui.tables.TableManagerImpl;
import com.biglybt.ui.IUIIntializer;
import com.biglybt.ui.common.UIInstanceBase;
import com.biglybt.ui.common.table.impl.TableContextMenuManager;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.config.BasicPluginConfigImpl;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIManagerImpl
implements UIManager {
    protected static final AEMonitor class_mon = new AEMonitor("UIManager:class");
    protected static boolean initialisation_complete;
    protected static CopyOnWriteList<Object[]> ui_listeners;
    protected static CopyOnWriteList<UIManagerEventListener> ui_event_listeners;
    protected static List<UIInstanceFactory> ui_factories;
    protected static List<UIManagerEventAdapter> ui_event_history;
    private static Map<BasicPluginConfigModel, BasicPluginConfigImpl> config_view_map;
    private static Map<String, BasicPluginViewModel> view_model_map;
    private static UIMDSImporter ds_importer;
    protected PluginInterface pi;
    protected TableManager table_manager;
    protected MenuManager menu_manager;
    private static ArrayList<UIDataSourceListener> listDSListeners;

    static {
        ui_listeners = new CopyOnWriteList();
        ui_event_listeners = new CopyOnWriteList();
        ui_factories = new ArrayList<UIInstanceFactory>();
        ui_event_history = new ArrayList<UIManagerEventAdapter>();
        config_view_map = new HashMap<BasicPluginConfigModel, BasicPluginConfigImpl>();
        view_model_map = new HashMap<String, BasicPluginViewModel>();
        ds_importer = new UIMDSImporter();
    }

    public static DataSourceResolver.ExportedDataSource exportDataSource(final BasicPluginViewModel model) {
        return new DataSourceResolver.ExportedDataSource(){

            @Override
            public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                return UIMDSImporter.class;
            }

            @Override
            public Map<String, Object> getExport() {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("model_key", UIManagerImpl.getBasicPluginViewModelKey(model));
                return m;
            }
        };
    }

    public UIManagerImpl(PluginInterface _pi) {
        this.pi = _pi;
        this.table_manager = new TableManagerImpl(this);
        this.menu_manager = new MenuManagerImpl(this);
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    @Override
    public BasicPluginViewModel createBasicPluginViewModel(String name) {
        BasicPluginViewModelImpl model = new BasicPluginViewModelImpl(this, name);
        view_model_map.put(UIManagerImpl.getBasicPluginViewModelKey(model), model);
        UIManagerImpl.fireEvent(this.pi, 4, model);
        return model;
    }

    public void destroy(BasicPluginViewModel model) {
        view_model_map.remove(UIManagerImpl.getBasicPluginViewModelKey(model), model);
        UIManagerImpl.fireEvent(this.pi, 7, model);
    }

    public static String getBasicPluginViewModelKey(BasicPluginViewModel model) {
        return String.valueOf(model.getPluginInterface().getPluginID()) + "/" + model.getName();
    }

    public static BasicPluginViewModel getBasicPluginViewModel(String key) {
        return view_model_map.get(key);
    }

    @Override
    public BasicPluginConfigModel createBasicPluginConfigModel(String section_name) {
        return this.createBasicPluginConfigModel("plugins", section_name);
    }

    @Override
    public BasicPluginConfigModel createBasicPluginConfigModel(String parent_section, String section_name) {
        BasicPluginConfigModelImpl model = new BasicPluginConfigModelImpl(this, parent_section, section_name);
        try {
            class_mon.enter();
            BasicPluginConfigImpl view = new BasicPluginConfigImpl(new WeakReference<BasicPluginConfigModel>(model));
            config_view_map.put(model, view);
            ConfigSectionRepository.getInstance().addConfigSection(view, model.getPluginInterface());
        }
        finally {
            class_mon.exit();
        }
        return model;
    }

    public void destroy(BasicPluginConfigModel model) {
        try {
            class_mon.enter();
            BasicPluginConfigImpl view = config_view_map.get(model);
            if (view != null) {
                ConfigSectionRepository.getInstance().removeConfigSection(view);
            }
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public PluginConfigModel[] getPluginConfigModels() {
        try {
            class_mon.enter();
            PluginConfigModel[] pluginConfigModelArray = config_view_map.keySet().toArray(new PluginConfigModel[0]);
            return pluginConfigModelArray;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void copyToClipBoard(String data) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(this.pi, 6, data);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    @Override
    public void openURL(URL url) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(this.pi, 9, url);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    @Override
    public TableManager getTableManager() {
        return this.table_manager;
    }

    @Override
    public MenuManager getMenuManager() {
        return this.menu_manager;
    }

    public static void initialisationComplete() {
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            @Override
            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                UIManagerImpl.triggerDataSourceListeners(SelectedContentManager.convertSelectedContentToObject(null));
            }
        });
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            initialisation_complete = true;
            int j = 0;
            while (j < ui_factories.size()) {
                UIInstanceFactory factory = ui_factories.get(j);
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    if (fired.contains(factory)) continue;
                    fired.add(factory);
                    to_fire.add(new Object[]{entry[0], factory.getInstance((PluginInterface)entry[1])});
                }
                ++j;
            }
        }
        finally {
            class_mon.exit();
        }
        for (Object[] entry : to_fire) {
            try {
                ((UIManagerListener)entry[0]).UIAttached((UIInstance)entry[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (Object[] entry : to_fire) {
            try {
                if (!(entry[0] instanceof UIManagerListener2)) continue;
                ((UIManagerListener2)entry[0]).UIAttachedComplete((UIInstance)entry[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void attachUI(UIInstanceFactory factory) throws UIException {
        this.attachUI(factory, null);
    }

    public void attachUI(UIInstanceFactory factory, IUIIntializer init) {
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            ui_factories.add(factory);
            if (initialisation_complete) {
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    fired.add(factory);
                    to_fire.add(new Object[]{entry[0], entry[1], factory.getInstance((PluginInterface)entry[1])});
                }
            }
        }
        finally {
            class_mon.exit();
        }
        for (Object[] entry : to_fire) {
            PluginInterface pi = (PluginInterface)entry[1];
            String name = pi.getPluginName();
            if (init != null) {
                init.reportCurrentTask(MessageText.getString("splash.plugin.UIinit", new String[]{name}));
                init.increaseProgress();
            }
            try {
                ((UIManagerListener)entry[0]).UIAttached((UIInstance)entry[2]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (Object[] entry : to_fire) {
            try {
                if (!(entry[0] instanceof UIManagerListener2)) continue;
                ((UIManagerListener2)entry[0]).UIAttachedComplete((UIInstance)entry[2]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void detachUI(UIInstanceFactory factory) throws UIException {
        factory.detach();
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            ui_factories.remove(factory);
            if (initialisation_complete) {
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    fired.remove(factory);
                    to_fire.add(new Object[]{entry[0], factory.getInstance((PluginInterface)entry[1])});
                }
            }
        }
        finally {
            class_mon.exit();
        }
        for (Object[] entry : to_fire) {
            try {
                ((UIManagerListener)entry[0]).UIDetached((UIInstance)entry[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        MenuItemManager.getInstance().removeMenuItemsForDetach(factory.getUIType());
        TableContextMenuManager.getInstance().removeMenuItemsForDetach(factory.getUIType());
        factory.dispose();
    }

    @Override
    public void addUIListener(UIManagerListener listener) {
        ArrayList<UIInstance> to_fire = new ArrayList<UIInstance>();
        try {
            class_mon.enter();
            ArrayList fired = new ArrayList();
            ui_listeners.add(new Object[]{listener, this.pi, fired});
            if (initialisation_complete) {
                int i = 0;
                while (i < ui_factories.size()) {
                    UIInstanceFactory factory = ui_factories.get(i);
                    to_fire.add(factory.getInstance(this.pi));
                    ++i;
                }
            }
        }
        finally {
            class_mon.exit();
        }
        for (UIInstance instance : to_fire) {
            try {
                listener.UIAttached(instance);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (listener instanceof UIManagerListener2) {
            for (UIInstance instance : to_fire) {
                try {
                    ((UIManagerListener2)listener).UIAttachedComplete(instance);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void removeUIListener(UIManagerListener listener) {
        try {
            class_mon.enter();
            Iterator<Object[]> it = ui_listeners.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[0] != listener) continue;
                it.remove();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addUIEventListener(UIManagerEventListener listener) {
        ArrayList<UIManagerEventAdapter> ui_event_history_copy;
        try {
            class_mon.enter();
            ui_event_listeners.add(listener);
            ui_event_history_copy = new ArrayList<UIManagerEventAdapter>(ui_event_history);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < ui_event_history_copy.size()) {
            try {
                listener.eventOccurred((UIManagerEvent)ui_event_history_copy.get(i));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void removeUIEventListener(UIManagerEventListener listener) {
        try {
            class_mon.enter();
            ui_event_listeners.remove(listener);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public boolean hasUIInstances() {
        return !ui_factories.isEmpty();
    }

    @Override
    public UIInstance[] getUIInstances() {
        try {
            class_mon.enter();
            ArrayList<UIInstance> result = new ArrayList<UIInstance>(ui_factories.size());
            int i = 0;
            while (i < ui_factories.size()) {
                UIInstanceFactory instance = ui_factories.get(i);
                result.add(instance.getInstance(this.pi));
                ++i;
            }
            UIInstance[] uIInstanceArray = result.toArray(new UIInstance[result.size()]);
            return uIInstanceArray;
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean fireEvent(PluginInterface pi, int type, Object data) {
        return UIManagerImpl.fireEvent(new UIManagerEventAdapter(pi, type, data));
    }

    public static boolean fireEvent(UIManagerEventAdapter event2) {
        boolean delivered = false;
        Iterator<UIManagerEventListener> event_it = ui_event_listeners.iterator();
        while (event_it.hasNext()) {
            try {
                if (!event_it.next().eventOccurred(event2)) continue;
                delivered = true;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        int type = event2.getType();
        if (type == 4) {
            delivered = true;
            try {
                class_mon.enter();
                ui_event_history.add(event2);
            }
            finally {
                class_mon.exit();
            }
        }
        if (type == 7) {
            delivered = true;
            try {
                class_mon.enter();
                Iterator<UIManagerEventAdapter> history_it = ui_event_history.iterator();
                while (history_it.hasNext()) {
                    UIManagerEvent e = history_it.next();
                    int e_type = e.getType();
                    if (e_type != 4 || e.getData() != event2.getData()) continue;
                    history_it.remove();
                    break;
                }
            }
            finally {
                class_mon.exit();
            }
        }
        return delivered;
    }

    @Override
    public void showTextMessage(String title_resource, String message_resource, String contents) {
        UIManagerImpl.fireEvent(this.pi, 1, new String[]{title_resource, message_resource, contents});
    }

    @Override
    public long showMessageBox(String title_resource, String message_resource, long message_map) {
        return this.showMessageBox(title_resource, message_resource, message_map, new Object[0]);
    }

    @Override
    public long showMessageBox(String title_resource, String message_resource, long message_map, Object[] params) {
        Object[] all_params = new Object[3 + params.length];
        all_params[0] = title_resource;
        all_params[1] = message_resource;
        all_params[2] = new Long(message_map);
        System.arraycopy(params, 0, all_params, 3, params.length);
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(this.pi, 21, all_params);
        if (!UIManagerImpl.fireEvent(event2)) {
            return 0L;
        }
        return (Long)event2.getResult();
    }

    @Override
    public long showMessageBox(String title_resource, String message_resource, long message_map, Map<String, Object> params) {
        Object[] all_params = new Object[]{title_resource, message_resource, new Long(message_map), params};
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(this.pi, 21, all_params);
        if (!UIManagerImpl.fireEvent(event2)) {
            return 0L;
        }
        return (Long)event2.getResult();
    }

    @Override
    public void openTorrent(Torrent torrent) {
        UIManagerImpl.fireEvent(this.pi, 22, torrent);
    }

    @Override
    public void openFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 24, file);
    }

    @Override
    public void showFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 23, file);
    }

    @Override
    public boolean showConfigSection(String sectionID) {
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(this.pi, 13, sectionID);
        if (!UIManagerImpl.fireEvent(event2)) {
            return false;
        }
        if (event2.getResult() instanceof Boolean) {
            return false;
        }
        return (Boolean)event2.getResult();
    }

    @Override
    public UIInputReceiver getInputReceiver() {
        UIInstance[] instances = this.getUIInstances();
        UIInputReceiver r = null;
        int i = 0;
        while (i < instances.length) {
            r = instances[i].getInputReceiver();
            if (r != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    @Override
    public UIMessage createMessage() {
        UIInstance[] instances = this.getUIInstances();
        UIMessage r = null;
        int i = 0;
        while (i < instances.length) {
            r = instances[i].createMessage();
            if (r != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    @Override
    public BasicPluginViewModel createLoggingViewModel(LoggerChannel channel2, boolean use_plugin_name) {
        String log_view_name = use_plugin_name ? this.pi.getPluginName() : channel2.getName();
        BasicPluginViewModel model = this.createBasicPluginViewModel(log_view_name);
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.getStatus().setVisible(false);
        model.attachLoggerChannel(channel2);
        return model;
    }

    @Override
    public void setEverythingHidden(boolean hidden) {
        UIManagerImpl.fireEvent(this.pi, 27, hidden);
    }

    @Override
    public void toggleEverythingHidden() {
        UIManagerImpl.fireEvent(this.pi, 28, null);
    }

    public static void unload(PluginInterface pi) {
        try {
            class_mon.enter();
            Iterator<Object[]> it = ui_listeners.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (pi != (PluginInterface)entry[1]) continue;
                it.remove();
            }
            Iterator<UIManagerEventAdapter> ev_it = ui_event_history.iterator();
            while (ev_it.hasNext()) {
                UIManagerEventAdapter event2 = ev_it.next();
                if (event2.getPluginInterface() != pi) continue;
                ev_it.remove();
            }
            for (UIInstanceFactory uif : ui_factories) {
                UIInstance instance = uif.getInstance(pi);
                if (!(instance instanceof UIInstanceBase)) continue;
                UIInstanceBase instanceBase = (UIInstanceBase)instance;
                try {
                    instanceBase.unload(pi);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addDataSourceListener(UIDataSourceListener l, boolean triggerNow) {
        class_mon.enter();
        try {
            if (listDSListeners == null) {
                listDSListeners = new ArrayList();
            }
            listDSListeners.add(l);
        }
        finally {
            class_mon.exit();
        }
        if (triggerNow) {
            try {
                l.dataSourceChanged(SelectedContentManager.convertSelectedContentToObject(null));
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    @Override
    public void removeDataSourceListener(UIDataSourceListener l) {
        class_mon.enter();
        try {
            if (listDSListeners == null) {
                return;
            }
            listDSListeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public Object getDataSource() {
        return SelectedContentManager.convertSelectedContentToObject(null);
    }

    private static void triggerDataSourceListeners(Object ds) {
        UIDataSourceListener[] listeners;
        class_mon.enter();
        try {
            if (listDSListeners == null) {
                return;
            }
            listeners = listDSListeners.toArray(new UIDataSourceListener[0]);
        }
        finally {
            class_mon.exit();
        }
        UIDataSourceListener[] uIDataSourceListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            UIDataSourceListener l = uIDataSourceListenerArray[n2];
            try {
                l.dataSourceChanged(ds);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            ++n2;
        }
    }

    public static class UIMDSImporter
    implements DataSourceResolver.DataSourceImporter {
        private UIMDSImporter() {
            DataSourceResolver.registerExporter(this);
        }

        @Override
        public Object importDataSource(Map<String, Object> map) {
            String key = (String)map.get("model_key");
            if (key != null) {
                Object ds = view_model_map.get(key);
                if (ds == null) {
                    Debug.out("No model for datasource key " + key);
                }
                return ds;
            }
            return null;
        }
    }
}

