/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.tracker;

import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostAuthenticationListener;
import com.biglybt.core.tracker.host.TRHostFactory;
import com.biglybt.core.tracker.host.TRHostListener2;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.TrackerException;
import com.biglybt.pif.tracker.TrackerListener;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.tracker.web.TrackerAuthenticationAdapter;
import com.biglybt.pif.tracker.web.TrackerAuthenticationListener;
import com.biglybt.pif.tracker.web.TrackerWebContext;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.tracker.TrackerTorrentImpl;
import com.biglybt.pifimpl.local.tracker.TrackerWCHelper;
import com.biglybt.pifimpl.local.tracker.TrackerWebContextImpl;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrackerImpl
extends TrackerWCHelper
implements Tracker,
TRHostListener2,
TRHostAuthenticationListener {
    private static TrackerImpl singleton;
    private static AEMonitor class_mon;
    private List listeners = new ArrayList();
    private TRHost host;
    private List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    static {
        class_mon = new AEMonitor("Tracker");
    }

    public static Tracker getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TrackerImpl(TRHostFactory.getSingleton());
            }
            TrackerImpl trackerImpl = singleton;
            return trackerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TrackerImpl(TRHost _host) {
        this.setTracker(this);
        this.host = _host;
        this.host.addListener2(this);
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public void setEnableKeepAlive(boolean enable) {
        Debug.out("Keep alive setting ignored for tracker");
    }

    @Override
    public URL[] getURLs() {
        URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
        URL[] res = new URL[url_sets.length];
        int i = 0;
        while (i < res.length) {
            res[i] = url_sets[i][0];
            ++i;
        }
        return res;
    }

    @Override
    public InetAddress getBindIP() {
        return this.host.getBindIP();
    }

    @Override
    public TrackerTorrent host(Torrent _torrent, boolean _persistent) throws TrackerException {
        return this.host(_torrent, _persistent, false);
    }

    @Override
    public TrackerTorrent host(Torrent _torrent, boolean _persistent, boolean _passive) throws TrackerException {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return new TrackerTorrentImpl(this.host.hostTorrent(torrent.getTorrent(), _persistent, _passive));
        }
        catch (Throwable e) {
            throw new TrackerException("Tracker: host operation fails", e);
        }
    }

    @Override
    public TrackerTorrent publish(Torrent _torrent) throws TrackerException {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return new TrackerTorrentImpl(this.host.publishTorrent(torrent.getTorrent()));
        }
        catch (Throwable e) {
            throw new TrackerException("Tracker: publish operation fails", e);
        }
    }

    @Override
    public TrackerTorrent[] getTorrents() {
        TRHostTorrent[] hts = this.host.getTorrents();
        TrackerTorrent[] res = new TrackerTorrent[hts.length];
        int i = 0;
        while (i < hts.length) {
            res[i] = new TrackerTorrentImpl(hts[i]);
            ++i;
        }
        return res;
    }

    @Override
    public TrackerTorrent getTorrent(Torrent torrent) {
        TRHostTorrent ht = this.host.getHostTorrent(((TorrentImpl)torrent).getTorrent());
        if (ht == null) {
            return null;
        }
        return new TrackerTorrentImpl(ht);
    }

    @Override
    public TrackerWebContext createWebContext(int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, null, port, protocol, null, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, null, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, bind_ip, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip, Map<String, Object> properties) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, bind_ip, properties);
    }

    public void torrentAdded(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                ((TrackerListener)this.listeners.get(i)).torrentAdded(new TrackerTorrentImpl(t));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void torrentChanged(TRHostTorrent t) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((TrackerListener)this.listeners.get(i)).torrentChanged(new TrackerTorrentImpl(t));
            ++i;
        }
    }

    public void torrentRemoved(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                ((TrackerListener)this.listeners.get(i)).torrentRemoved(new TrackerTorrentImpl(t));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
            TrackerTorrent[] torrents = this.getTorrents();
            int i = 0;
            while (i < torrents.length) {
                listener.torrentAdded(torrents[i]);
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean authenticate(String headers, URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                TrackerAuthenticationListener listener = this.auth_listeners.get(i);
                boolean res = listener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)listener).authenticate(headers, resource, user, password) : listener.authenticate(resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = this.auth_listeners.get(i).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.host.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.host.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.host.removeAuthenticationListener(this);
        this.listeners.clear();
        this.host.close();
    }
}

