/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.sharing;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.sharing.ShareResourceDeletionVetoException;
import com.biglybt.pif.sharing.ShareResourceDirContents;
import com.biglybt.pif.sharing.ShareResourceListener;
import com.biglybt.pif.sharing.ShareResourceWillBeDeletedListener;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.sharing.ShareManagerImpl;
import com.biglybt.pifimpl.local.sharing.ShareResourceImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShareResourceDirContentsImpl
extends ShareResourceImpl
implements ShareResourceDirContents {
    private final File root;
    private final boolean recursive;
    private final Map<String, String> properties;
    private final byte[] personal_key;
    protected ShareResource[] children = new ShareResource[0];

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, boolean _personal, Map<String, String> _properties, boolean _async_check) throws ShareException {
        super(_manager, 3);
        this.root = _dir;
        this.recursive = _recursive;
        HashMap hashMap = this.properties = _properties == null ? new HashMap() : _properties;
        if (!this.root.exists()) {
            throw new ShareException("Dir '" + this.root.getName() + "' not found");
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        Object object = this.personal_key = (Object)(_personal ? RandomUtils.nextSecureHash() : null);
        if (_async_check) {
            new AEThread2("SM:asyncCheck", true){

                @Override
                public void run() {
                    try {
                        ShareResourceDirContentsImpl.this.checkConsistency();
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to update consistency", e);
                    }
                }
            }.start();
        } else {
            this.checkConsistency();
        }
    }

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, Map _map) throws ShareException {
        super(_manager, 3, _map);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            Debug.out("Dir '" + this.root.getName() + "' not found");
        } else if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        this.personal_key = (byte[])_map.get("per_key");
        this.properties = BDecoder.decodeStrings((Map)_map.get("props"));
    }

    @Override
    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        int i = 0;
        while (i < this.children.length) {
            if (!this.children[i].canBeDeleted()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void checkConsistency() throws ShareException {
        List kids = this.checkConsistency(this.root);
        if (kids != null) {
            this.children = new ShareResource[kids.size()];
            kids.toArray(this.children);
        } else {
            this.children = new ShareResource[0];
        }
    }

    protected List checkConsistency(File dir) throws ShareException {
        ArrayList<ShareResource> kids = new ArrayList<ShareResource>();
        File[] files = dir.listFiles();
        if (files == null || !dir.exists()) {
            if (!this.isPersistent()) {
                if (dir == this.root) {
                    return null;
                }
                this.manager.delete(this, true);
            }
        } else {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String file_name = file.getName();
                if (!file_name.equals(".") && !file_name.equals("..")) {
                    ShareResource res;
                    if (file.isDirectory()) {
                        if (this.recursive) {
                            List child = this.checkConsistency(file);
                            kids.add(new shareNode(this, file, child));
                        } else {
                            try {
                                res = this.manager.getDir(file);
                                if (res == null) {
                                    res = this.manager.addDir(this, file, this.personal_key != null, this.properties);
                                }
                                kids.add(res);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    } else {
                        try {
                            res = this.manager.getFile(file);
                            if (res == null) {
                                res = this.manager.addFile(this, file, this.personal_key != null, this.properties);
                            }
                            kids.add(res);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < kids.size()) {
                Object o = kids.get(i);
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                } else {
                    ((shareNode)o).setParent(this);
                }
                ++i;
            }
        }
        return kids;
    }

    @Override
    protected void deleteInternal() {
        super.deleteInternal();
        int i = 0;
        while (i < this.children.length) {
            try {
                if (this.children[i] instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)this.children[i]).delete(true);
                } else {
                    ((shareNode)this.children[i]).delete(true);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("recursive", new Long(this.recursive ? 1 : 0));
        map.put("file", this.root.toString().getBytes(Constants.DEFAULT_ENCODING_CHARSET));
        if (this.personal_key != null) {
            map.put("per_key", this.personal_key);
        }
        if (this.properties != null) {
            map.put("props", this.properties);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map) throws ShareException {
        File root = FileUtil.newFile(new String((byte[])map.get("file"), Constants.DEFAULT_ENCODING_CHARSET), new String[0]);
        boolean recursive = (Long)map.get("recursive") == 1L;
        ShareResourceDirContentsImpl res = new ShareResourceDirContentsImpl(manager, root, recursive, map);
        return res;
    }

    @Override
    public String getName() {
        return this.root.toString();
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public ShareResource[] getChildren() {
        return this.children;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> props, boolean internal) {
        this.properties.putAll(props);
        ShareResource[] shareResourceArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ShareResource sr = shareResourceArray[n2];
            sr.setProperties(props, internal);
            ++n2;
        }
        this.manager.configDirty();
    }

    protected class shareNode
    implements ShareResourceDirContents {
        protected ShareResourceDirContents node_parent;
        protected File node;
        protected ShareResource[] node_children;

        protected shareNode(ShareResourceDirContents _parent, File _node, List kids) {
            this.node_parent = _parent;
            this.node = _node;
            this.node_children = new ShareResource[kids.size()];
            kids.toArray(this.node_children);
            int i = 0;
            while (i < this.node_children.length) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                } else {
                    ((shareNode)o).setParent(this);
                }
                ++i;
            }
        }

        @Override
        public ShareResourceDirContents getParent() {
            return this.node_parent;
        }

        protected void setParent(ShareResourceDirContents _parent) {
            this.node_parent = _parent;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public String getName() {
            return this.node.toString();
        }

        @Override
        public void setAttribute(TorrentAttribute attribute, String value) {
            int i = 0;
            while (i < this.node_children.length) {
                this.node_children[i].setAttribute(attribute, value);
                ++i;
            }
        }

        @Override
        public String getAttribute(TorrentAttribute attribute) {
            return null;
        }

        @Override
        public TorrentAttribute[] getAttributes() {
            return new TorrentAttribute[0];
        }

        @Override
        public void delete() throws ShareResourceDeletionVetoException {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }

        @Override
        public void delete(boolean force) throws ShareException, ShareResourceDeletionVetoException {
            int i = 0;
            while (i < this.node_children.length) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).delete(force);
                } else {
                    ((shareNode)o).delete(force);
                }
                ++i;
            }
        }

        @Override
        public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
            int i = 0;
            while (i < this.node_children.length) {
                this.node_children[i].canBeDeleted();
                ++i;
            }
            return true;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public File getRoot() {
            return this.node;
        }

        @Override
        public boolean isRecursive() {
            return ShareResourceDirContentsImpl.this.recursive;
        }

        @Override
        public ShareResource[] getChildren() {
            return this.node_children;
        }

        @Override
        public Map<String, String> getProperties() {
            return null;
        }

        @Override
        public void setProperties(Map<String, String> props, boolean internal) {
            int i = 0;
            while (i < this.node_children.length) {
                this.node_children[i].setProperties(props, internal);
                ++i;
            }
        }

        @Override
        public boolean isPersistent() {
            return false;
        }

        @Override
        public void addChangeListener(ShareResourceListener l) {
        }

        @Override
        public void removeChangeListener(ShareResourceListener l) {
        }

        @Override
        public void addDeletionListener(ShareResourceWillBeDeletedListener l) {
        }

        @Override
        public void removeDeletionListener(ShareResourceWillBeDeletedListener l) {
        }
    }
}

