/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.messaging;

import com.biglybt.core.nat.NATTraversalObserver;
import com.biglybt.core.nat.NATTraverser;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.messaging.MessageException;
import com.biglybt.pif.messaging.generic.GenericMessageConnection;
import com.biglybt.pif.messaging.generic.GenericMessageConnectionListener;
import com.biglybt.pif.messaging.generic.GenericMessageEndpoint;
import com.biglybt.pif.messaging.generic.GenericMessageStartpoint;
import com.biglybt.pif.network.Connection;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.messaging.GenericMessage;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionAdapter;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionDirect;
import com.biglybt.pifimpl.local.messaging.GenericMessageConnectionIndirect;
import com.biglybt.pifimpl.local.messaging.GenericMessageEndpointImpl;
import com.biglybt.pifimpl.local.messaging.MessageManagerImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericMessageConnectionImpl
implements GenericMessageConnection {
    private static final boolean TRACE = false;
    private static final boolean TEST_TUNNEL = false;
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpointImpl endpoint;
    private int stream_crypto;
    byte[][] shared_secrets;
    private boolean incoming;
    private volatile GenericMessageConnectionAdapter delegate;
    private volatile boolean closing;
    private volatile boolean closed;
    private volatile boolean connecting;
    private List listeners = new ArrayList();
    private int connect_method_count;
    private List inbound_rls;
    private List outbound_rls;

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, GenericMessageConnectionAdapter _delegate) {
        this.message_manager = _message_manager;
        this.delegate = _delegate;
        this.incoming = true;
        this.connect_method_count = 1;
        this.delegate.setOwner(this);
    }

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, String _msg_id, String _msg_desc, GenericMessageEndpointImpl _endpoint, int _stream_crypto, byte[][] _shared_secrets) {
        this.message_manager = _message_manager;
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.stream_crypto = _stream_crypto;
        this.shared_secrets = _shared_secrets;
        this.connect_method_count = this.endpoint.getConnectionEndpoint().getProtocols().length;
        this.incoming = false;
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint == null ? this.delegate.getEndpoint() : this.endpoint;
    }

    @Override
    public GenericMessageStartpoint getStartpoint() {
        if (this.delegate != null) {
            return this.delegate.getStartpoint();
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        if (this.delegate != null) {
            return this.delegate.getConnection();
        }
        return null;
    }

    @Override
    public int getMaximumMessageSize() {
        return this.delegate == null ? 32768 : this.delegate.getMaximumMessageSize();
    }

    @Override
    public String getType() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.getType();
    }

    @Override
    public int getTransportType() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getTransportType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addInboundRateLimiter(limiter);
            } else {
                if (this.inbound_rls == null) {
                    this.inbound_rls = new ArrayList();
                }
                this.inbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeInboundRateLimiter(limiter);
            } else if (this.inbound_rls != null) {
                this.inbound_rls.remove(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addOutboundRateLimiter(limiter);
            } else {
                if (this.outbound_rls == null) {
                    this.outbound_rls = new ArrayList();
                }
                this.outbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeOutboundRateLimiter(limiter);
            } else if (this.outbound_rls != null) {
                this.outbound_rls.remove(limiter);
            }
        }
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public int getConnectMethodCount() {
        return this.connect_method_count;
    }

    @Override
    public void connect(GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) throws MessageException {
        this.connect(null, ph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDelegate(GenericMessageConnectionAdapter _delegate) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            int i;
            this.delegate = _delegate;
            if (this.inbound_rls != null) {
                i = 0;
                while (i < this.inbound_rls.size()) {
                    this.delegate.addInboundRateLimiter((RateLimiter)this.inbound_rls.get(i));
                    ++i;
                }
                this.inbound_rls = null;
            }
            if (this.outbound_rls != null) {
                i = 0;
                while (i < this.outbound_rls.size()) {
                    this.delegate.addOutboundRateLimiter((RateLimiter)this.outbound_rls.get(i));
                    ++i;
                }
                this.outbound_rls = null;
            }
        }
    }

    public void connect(ByteBuffer initial_data, GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) throws MessageException {
        if (this.incoming) {
            throw new MessageException("Already connected");
        }
        if (this.connecting) {
            throw new MessageException("Connect already performed");
        }
        this.connecting = true;
        if (this.closed) {
            throw new MessageException("Connection has been closed");
        }
        InetSocketAddress tcp_ep = this.endpoint.getTCP();
        if (tcp_ep != null) {
            this.connectTCP(initial_data, tcp_ep, ph);
        } else {
            InetSocketAddress udp_ep = this.endpoint.getUDP();
            if (udp_ep != null) {
                this.connectUDP(initial_data, udp_ep, false, ph);
            } else {
                throw new MessageException("No protocols availabld");
            }
        }
    }

    protected void connectTCP(final ByteBuffer initial_data, InetSocketAddress tcp_ep, final GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) {
        GenericMessageEndpointImpl gen_tcp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_tcp.addTCP(tcp_ep);
        int crypto = MessageManagerImpl.adjustCrypto(gen_tcp, this.stream_crypto);
        final GenericMessageConnectionDirect tcp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_tcp, crypto, this.shared_secrets);
        tcp_delegate.setOwner(this);
        tcp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
            private boolean connected;

            @Override
            public void connectSuccess() {
                this.connected = true;
                GenericMessageConnectionImpl.this.setDelegate(tcp_delegate);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                InetSocketAddress udp_ep = GenericMessageConnectionImpl.this.endpoint.getUDP();
                if (udp_ep != null && !this.connected) {
                    initial_data.rewind();
                    GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, false, ph);
                } else {
                    GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                }
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                if (ph != null) {
                    return ph.getConnectionProperty(property_name);
                }
                return null;
            }
        });
    }

    protected void connectUDP(final ByteBuffer initial_data, final InetSocketAddress udp_ep, boolean nat_traversal, final GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) {
        final GenericMessageEndpointImpl gen_udp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_udp.addUDP(udp_ep);
        final GenericMessageConnectionDirect udp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_udp, this.stream_crypto, this.shared_secrets);
        udp_delegate.setOwner(this);
        if (nat_traversal) {
            NATTraverser nat_traverser = this.message_manager.getNATTraverser();
            HashMap request2 = new HashMap();
            nat_traverser.attemptTraversal(this.message_manager, udp_ep, request2, false, new NATTraversalObserver(){

                @Override
                public void succeeded(final InetSocketAddress rendezvous, final InetSocketAddress target, Map reply) {
                    if (GenericMessageConnectionImpl.this.closed) {
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl genericMessageConnectionImpl = GenericMessageConnectionImpl.this;
                        genericMessageConnectionImpl.connect_method_count = genericMessageConnectionImpl.connect_method_count + 1;
                        udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
                            private boolean connected;

                            @Override
                            public void connectSuccess() {
                                this.connected = true;
                                GenericMessageConnectionImpl.this.setDelegate(udp_delegate);
                                if (GenericMessageConnectionImpl.this.closed) {
                                    try {
                                        GenericMessageConnectionImpl.this.delegate.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                                } else {
                                    GenericMessageConnectionImpl.this.reportConnected();
                                }
                            }

                            @Override
                            public void connectFailure(Throwable failure_msg) {
                                if (this.connected) {
                                    GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                                } else {
                                    initial_data.rewind();
                                    GenericMessageConnectionImpl.this.connectTunnel(initial_data, gen_udp, rendezvous, target, ph);
                                }
                            }

                            @Override
                            public Object getConnectionProperty(String property_name) {
                                if (ph != null) {
                                    return ph.getConnectionProperty(property_name);
                                }
                                return null;
                            }
                        });
                    }
                }

                @Override
                public void failed(int failure_type) {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed - NAT traversal failed (" + NATTraversalObserver.FT_STRINGS[failure_type] + ")"));
                }

                @Override
                public void failed(Throwable cause) {
                    GenericMessageConnectionImpl.this.reportFailed(cause);
                }

                @Override
                public void disabled() {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed as DDB is disabled"));
                }
            });
        } else {
            udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
                private boolean connected;

                @Override
                public void connectSuccess() {
                    this.connected = true;
                    GenericMessageConnectionImpl.this.setDelegate(udp_delegate);
                    if (GenericMessageConnectionImpl.this.closed) {
                        try {
                            GenericMessageConnectionImpl.this.delegate.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.reportConnected();
                    }
                }

                @Override
                public void connectFailure(Throwable failure_msg) {
                    if (this.connected) {
                        GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                    } else {
                        initial_data.rewind();
                        GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, true, ph);
                    }
                }

                @Override
                public Object getConnectionProperty(String property_name) {
                    if (ph != null) {
                        return ph.getConnectionProperty(property_name);
                    }
                    return null;
                }
            });
        }
    }

    protected void connectTunnel(ByteBuffer initial_data, GenericMessageEndpoint ep, InetSocketAddress rendezvous, InetSocketAddress target, final GenericMessageConnection.GenericMessageConnectionPropertyHandler ph) {
        final GenericMessageConnectionIndirect tunnel_delegate = new GenericMessageConnectionIndirect(this.message_manager, this.msg_id, this.msg_desc, ep, rendezvous, target);
        tunnel_delegate.setOwner(this);
        tunnel_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){

            @Override
            public void connectSuccess() {
                GenericMessageConnectionImpl.this.setDelegate(tunnel_delegate);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                GenericMessageConnectionImpl.this.reportFailed(failure_msg);
            }

            @Override
            public Object getConnectionProperty(String property_name) {
                if (ph != null) {
                    return ph.getConnectionProperty(property_name);
                }
                return null;
            }
        });
    }

    protected void accepted() {
        this.delegate.accepted();
    }

    @Override
    public void send(PooledByteBuffer message) throws MessageException {
        int size = ((PooledByteBufferImpl)message).getBuffer().remaining((byte)1);
        if (size > this.getMaximumMessageSize()) {
            throw new MessageException("Message is too large: supplied is " + size + ", maximum is " + this.getMaximumMessageSize());
        }
        this.delegate.send(message);
    }

    protected void receive(GenericMessage message) {
        boolean handled = false;
        int i = 0;
        while (i < this.listeners.size()) {
            block4: {
                PooledByteBufferImpl buffer = new PooledByteBufferImpl(message.getPayload());
                try {
                    ((GenericMessageConnectionListener)this.listeners.get(i)).receive(this, buffer);
                    handled = true;
                }
                catch (Throwable f) {
                    buffer.returnToPool();
                    if (f instanceof MessageException) break block4;
                    Debug.printStackTrace(f);
                }
            }
            ++i;
        }
        if (handled || !this.closed) {
            // empty if block
        }
    }

    public void closing() {
        this.closing = true;
    }

    @Override
    public void close() throws MessageException {
        this.closed = true;
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected void reportConnected() {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).connected(this);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    protected void reportFailed(Throwable e) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).failed(this, e);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            ++i;
        }
    }

    @Override
    public void addListener(GenericMessageConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GenericMessageConnectionListener listener) {
        this.listeners.remove(listener);
    }
}

