/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.installer;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.core.vuzefile.VuzeFileProcessor;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.installer.FilePluginInstaller;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.PluginInstallerListener;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.update.UpdatableComponent;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateInstaller;
import com.biglybt.pif.update.UpdateListener;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pifimpl.local.FailedPlugin;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.installer.FilePluginInstallerImpl;
import com.biglybt.pifimpl.local.installer.InstallablePluginImpl;
import com.biglybt.pifimpl.local.installer.StandardPluginImpl;
import com.biglybt.pifimpl.local.update.UpdateCheckInstanceImpl;
import com.biglybt.pifimpl.local.update.UpdateManagerImpl;
import com.biglybt.pifimpl.update.PluginUpdatePlugin;
import com.biglybt.pifimpl.update.sf.SFPluginDetails;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsException;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsLoader;
import com.biglybt.pifimpl.update.sf.SFPluginDetailsLoaderFactory;
import com.biglybt.ui.common.RememberedDecisionsManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class PluginInstallerImpl
implements PluginInstaller {
    protected static PluginInstallerImpl singleton;
    private PluginManager manager;
    private CopyOnWriteList<PluginInstallerListener> listeners = new CopyOnWriteList();
    private AsyncDispatcher add_file_install_dispatcher;

    public static synchronized PluginInstallerImpl getSingleton(PluginManager _manager) {
        if (singleton == null) {
            singleton = new PluginInstallerImpl(_manager);
        }
        return singleton;
    }

    protected PluginInstallerImpl(PluginManager _manager) {
        this.manager = _manager;
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] files, int expected_types) {
                int i = 0;
                while (i < files.length) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    int j = 0;
                    while (j < comps.length) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() == 8) {
                            try {
                                Map content = comp2.getContent();
                                String id = new String((byte[])content.get("id"), "UTF-8");
                                String version = new String((byte[])content.get("version"), "UTF-8");
                                String suffix = (Long)content.get("is_jar") == 1L ? "jar" : "zip";
                                byte[] plugin_file = (byte[])content.get("file");
                                File temp_dir = AETemporaryFileHandler.createTempDir();
                                File temp_file = FileUtil.newFile(temp_dir, String.valueOf(id) + "_" + version + "." + suffix);
                                FileUtil.copyFile((InputStream)new ByteArrayInputStream(plugin_file), temp_file);
                                FilePluginInstaller installer = PluginInstallerImpl.this.installFromFile(temp_file);
                                PluginInstallerImpl.this.addFileInstallOperation(installer);
                                comp2.setProcessed();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileInstallOperation(final FilePluginInstaller installer) {
        PluginInstallerImpl pluginInstallerImpl = this;
        synchronized (pluginInstallerImpl) {
            if (this.add_file_install_dispatcher == null) {
                this.add_file_install_dispatcher = new AsyncDispatcher();
            }
            this.add_file_install_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        final AESemaphore done_sem = new AESemaphore("PluginInstall:fio");
                        final UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                        new AEThread2("PluginInstall:fio", true){

                            @Override
                            public void run() {
                                if (installer.isAlreadyInstalled()) {
                                    String details = MessageText.getString("fileplugininstall.duplicate.desc", new String[]{installer.getName(), installer.getVersion()});
                                    ui_manager.showMessageBox("fileplugininstall.duplicate.title", "!" + details + "!", 1L);
                                    done_sem.release();
                                } else {
                                    String details = MessageText.getString("fileplugininstall.install.desc", new String[]{installer.getName(), installer.getVersion()});
                                    String rememberID = "plugin.install.shared";
                                    RememberedDecisionsManager.setRemembered(rememberID, -1);
                                    HashMap<String, Object> mapOptions = new HashMap<String, Object>();
                                    mapOptions.put("remember-id", rememberID);
                                    mapOptions.put("remember-by-def", false);
                                    mapOptions.put("remember-res", "Install for all users");
                                    long res = ui_manager.showMessageBox("fileplugininstall.install.title", "!" + details + "!", 12L, mapOptions);
                                    if (res == 4L) {
                                        boolean shared = RememberedDecisionsManager.getRememberedDecision(rememberID) >= 0;
                                        try {
                                            PluginInstallerImpl.this.install(new InstallablePlugin[]{installer}, shared, true, null, new PluginInstallationListener(){

                                                @Override
                                                public void completed() {
                                                    done_sem.release();
                                                }

                                                @Override
                                                public void cancelled() {
                                                    done_sem.release();
                                                }

                                                @Override
                                                public void failed(PluginException e) {
                                                    done_sem.release();
                                                    Debug.out("Installation failed", e);
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            done_sem.release();
                                        }
                                    } else if (res == 8L) {
                                        done_sem.release();
                                    } else {
                                        Debug.out("Message box not handled");
                                        done_sem.release();
                                    }
                                }
                            }
                        }.start();
                        while (!done_sem.reserve(60000L)) {
                            if (PluginInstallerImpl.this.add_file_install_dispatcher.getQueueSize() <= 0) continue;
                            Debug.out("File plugin install operation queued pending completion of previous");
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
    }

    protected PluginManager getPluginManager() {
        return this.manager;
    }

    @Override
    public StandardPlugin[] getStandardPlugins() throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            ArrayList<StandardPluginImpl> res = new ArrayList<StandardPluginImpl>();
            int i = 0;
            while (i < details.length) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                String version = "";
                if (Constants.isCVSVersion()) {
                    version = detail.getCVSVersion();
                }
                if (version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) {
                    version = detail.getVersion();
                } else {
                    String non_cvs_version = detail.getVersion();
                    if (version.equals(String.valueOf(non_cvs_version) + "_CVS")) {
                        version = non_cvs_version;
                    }
                }
                if (!name.startsWith("azplatform") && !name.equals("azupdater") && version != null && version.length() != 0 && Character.isDigit(version.charAt(0)) && !detail.getCategory().equalsIgnoreCase("hidden")) {
                    res.add(new StandardPluginImpl(this, details[i], version));
                }
                ++i;
            }
            StandardPlugin[] res_a = new StandardPlugin[res.size()];
            res.toArray(res_a);
            return res_a;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    @Override
    public StandardPlugin getStandardPlugin(String id) throws PluginException {
        try {
            SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] details = loader.getPluginDetails();
            int i = 0;
            while (i < details.length) {
                SFPluginDetails detail = details[i];
                String name = detail.getId();
                if (name.equalsIgnoreCase(id)) {
                    String version = "";
                    if (Constants.isCVSVersion()) {
                        version = detail.getCVSVersion();
                    }
                    if (version == null || version.length() == 0 || !Character.isDigit(version.charAt(0))) {
                        version = detail.getVersion();
                    } else {
                        String non_cvs_version = detail.getVersion();
                        if (version.equals(String.valueOf(non_cvs_version) + "_CVS")) {
                            version = non_cvs_version;
                        }
                    }
                    if (!name.startsWith("azplatform") && !name.equals("azupdater") && version != null && version.length() != 0 && Character.isDigit(version.charAt(0))) {
                        return new StandardPluginImpl(this, details[i], version);
                    }
                }
                ++i;
            }
            return null;
        }
        catch (SFPluginDetailsException e) {
            throw new PluginException("Failed to load standard plugin details", e);
        }
    }

    private File extractFromVuzeFile(File file) throws PluginException {
        VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(file);
        VuzeFileComponent[] comps = vf.getComponents();
        int j = 0;
        while (j < comps.length) {
            VuzeFileComponent comp2 = comps[j];
            if (comp2.getType() == 8) {
                try {
                    Map content = comp2.getContent();
                    String id = new String((byte[])content.get("id"), "UTF-8");
                    String version = new String((byte[])content.get("version"), "UTF-8");
                    String suffix = (Long)content.get("is_jar") == 1L ? "jar" : "zip";
                    byte[] plugin_file = (byte[])content.get("file");
                    File temp_dir = AETemporaryFileHandler.createTempDir();
                    File temp_file = FileUtil.newFile(temp_dir, String.valueOf(id) + "_" + version + "." + suffix);
                    FileUtil.copyFile((InputStream)new ByteArrayInputStream(plugin_file), temp_file);
                    return temp_file;
                }
                catch (Throwable e) {
                    throw new PluginException("Not a valid Vuze file", e);
                }
            }
            ++j;
        }
        return file;
    }

    @Override
    public FilePluginInstaller installFromFile(File file) throws PluginException {
        if (VuzeFileHandler.isAcceptedVuzeFileName(file)) {
            file = this.extractFromVuzeFile(file);
        }
        return new FilePluginInstallerImpl(this, file);
    }

    public void install(InstallablePlugin installable_plugin, boolean shared) throws PluginException {
        this.install(new InstallablePlugin[]{installable_plugin}, shared);
    }

    @Override
    public void install(InstallablePlugin[] plugins, boolean shared) throws PluginException {
        this.install(plugins, shared, false, null, null);
    }

    @Override
    public UpdateCheckInstance install(InstallablePlugin[] plugins, boolean shared, Map<Integer, Object> properties, PluginInstallationListener listener) throws PluginException {
        return this.install(plugins, shared, false, properties, listener);
    }

    protected UpdateCheckInstance install(InstallablePlugin[] plugins, boolean shared, boolean low_noise, Map<Integer, Object> properties, final PluginInstallationListener listener) throws PluginException {
        PluginInterface pup_pi = this.manager.getPluginInterfaceByClass(PluginUpdatePlugin.class);
        if (pup_pi == null) {
            throw new PluginException("Installation aborted, plugin-update plugin unavailable");
        }
        if (!pup_pi.getPluginState().isOperational()) {
            throw new PluginException("Installation aborted, plugin-update plugin not operational");
        }
        PluginUpdatePlugin pup = (PluginUpdatePlugin)pup_pi.getPlugin();
        UpdateManagerImpl uman = (UpdateManagerImpl)this.manager.getDefaultPluginInterface().getUpdateManager();
        UpdateCheckInstanceImpl inst = uman.createEmptyUpdateCheckInstance(1, "update.instance.install", low_noise);
        if (properties != null) {
            for (Map.Entry<Integer, Object> entry : properties.entrySet()) {
                inst.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (listener != null) {
            inst.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                    listener.cancelled();
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                    final Update[] updates = instance.getUpdates();
                    if (updates.length == 0) {
                        listener.failed(new PluginException("No updates were added during check process"));
                    } else {
                        int i = 0;
                        while (i < updates.length) {
                            updates[i].addListener(new UpdateListener(){
                                private boolean cancelled;

                                @Override
                                public void cancelled(Update update) {
                                    this.cancelled = true;
                                    this.check();
                                }

                                @Override
                                public void complete(Update update) {
                                    this.check();
                                }

                                protected void check() {
                                    Update failed_update = null;
                                    Update[] updateArray = updates;
                                    int n = updates.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Update update = updateArray[n2];
                                        if (!update.isCancelled() && !update.isComplete()) {
                                            return;
                                        }
                                        if (!update.wasSuccessful()) {
                                            failed_update = update;
                                        }
                                        ++n2;
                                    }
                                    if (this.cancelled) {
                                        listener.cancelled();
                                    } else if (failed_update == null) {
                                        PluginInitializer.waitForPluginEvents();
                                        listener.completed();
                                    } else {
                                        listener.failed(new PluginException("Install of " + failed_update.getName() + " failed"));
                                    }
                                }
                            });
                            ++i;
                        }
                    }
                }
            });
        }
        try {
            int i = 0;
            while (i < plugins.length) {
                InstallablePlugin plugin = plugins[i];
                final String plugin_id = plugin.getId();
                PluginInterface existing_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id, false);
                Plugin existing_plugin = null;
                if (existing_plugin_interface != null) {
                    existing_plugin = existing_plugin_interface.getPlugin();
                    String old_version = existing_plugin_interface.getPluginVersion();
                    if (old_version != null) {
                        int res = Constants.compareVersions(plugin.getVersion(), old_version);
                        if (res < 0) {
                            throw new PluginException("A higher version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                        if (res == 0) {
                            throw new PluginException("Version (" + old_version + ") of Plugin '" + plugin_id + "' is already installed");
                        }
                    }
                }
                File target_dir = shared ? FileUtil.getApplicationFile("plugins") : FileUtil.getUserFile("plugins");
                target_dir = FileUtil.newFile(target_dir, plugin_id);
                target_dir.mkdir();
                if (existing_plugin == null) {
                    FailedPlugin dummy_plugin = new FailedPlugin(plugin_id, target_dir.toString());
                    PluginManager.registerPlugin(dummy_plugin, plugin_id);
                    final PluginInterface dummy_plugin_interface = this.manager.getPluginInterfaceByID(plugin_id, false);
                    ((InstallablePluginImpl)plugin).addUpdate(inst, pup, dummy_plugin, dummy_plugin_interface);
                    inst.addListener(new UpdateCheckInstanceListener(){

                        @Override
                        public void cancelled(UpdateCheckInstance instance) {
                            try {
                                dummy_plugin_interface.getPluginState().unload();
                            }
                            catch (Throwable e) {
                                Debug.out("Failed to unload plugin", e);
                            }
                        }

                        @Override
                        public void complete(UpdateCheckInstance instance) {
                            PluginInterface pi = PluginInstallerImpl.this.manager.getPluginInterfaceByID(plugin_id, false);
                            if (pi != null && pi.getPlugin() instanceof FailedPlugin) {
                                try {
                                    pi.getPluginState().unload();
                                }
                                catch (Throwable e) {
                                    Debug.out("Failed to unload plugin", e);
                                }
                            }
                        }
                    });
                } else {
                    ((InstallablePluginImpl)plugin).addUpdate(inst, pup, existing_plugin, existing_plugin_interface);
                }
                ++i;
            }
            inst.start();
            return inst;
        }
        catch (Throwable e) {
            inst.cancel();
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Failed to create installer", e);
        }
    }

    public void uninstall(InstallablePlugin standard_plugin) throws PluginException {
        PluginInterface pi = standard_plugin.getAlreadyInstalledPlugin();
        if (pi == null) {
            throw new PluginException(" Plugin '" + standard_plugin.getId() + "' is not installed");
        }
        pi.getPluginState().uninstall();
    }

    @Override
    public void uninstall(PluginInterface pi) throws PluginException {
        this.uninstall(new PluginInterface[]{pi});
    }

    @Override
    public void uninstall(PluginInterface[] pis) throws PluginException {
        this.uninstall(pis, null);
    }

    @Override
    public void uninstall(PluginInterface[] pis, PluginInstallationListener listener_maybe_null) throws PluginException {
        this.uninstall(pis, listener_maybe_null, new HashMap<Integer, Object>());
    }

    @Override
    public UpdateCheckInstance uninstall(PluginInterface[] pis, final PluginInstallationListener listener_maybe_null, final Map<Integer, Object> properties) throws PluginException {
        properties.put(5, false);
        int i = 0;
        while (i < pis.length) {
            PluginInterface pi = pis[i];
            if (pi.getPluginState().isMandatory()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is mandatory, can't uninstall");
            }
            if (pi.getPluginState().isBuiltIn()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is built-in, can't uninstall");
            }
            String plugin_dir = pi.getPluginDirectoryName();
            if (plugin_dir == null || !FileUtil.newFile(plugin_dir, new String[0]).exists()) {
                throw new PluginException("Plugin '" + pi.getPluginID() + "' is not loaded from the file system, can't uninstall");
            }
            ++i;
        }
        try {
            UpdateManager uman = this.manager.getDefaultPluginInterface().getUpdateManager();
            UpdateCheckInstance inst = uman.createEmptyUpdateCheckInstance(3, "update.instance.uninstall");
            final int[] rds_added = new int[1];
            final AESemaphore rd_waiter_sem = new AESemaphore("uninst:rd:wait");
            int i2 = 0;
            while (i2 < pis.length) {
                final PluginInterface pi = pis[i2];
                final String plugin_dir = pi.getPluginDirectoryName();
                inst.addUpdatableComponent(new UpdatableComponent(){

                    @Override
                    public String getName() {
                        return pi.getPluginName();
                    }

                    @Override
                    public int getMaximumCheckTime() {
                        return 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void checkForUpdate(final UpdateChecker checker) {
                        try {
                            ResourceDownloader rd = PluginInstallerImpl.this.manager.getDefaultPluginInterface().getUtilities().getResourceDownloaderFactory().create(FileUtil.newFile(plugin_dir, new String[0]));
                            String update_name = "";
                            PluginInterface[] ifs = PluginInstallerImpl.this.manager.getPluginInterfaces();
                            Arrays.sort(ifs, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                                }
                            });
                            int i = 0;
                            while (i < ifs.length) {
                                if (ifs[i].getPluginID().equals(pi.getPluginID())) {
                                    update_name = String.valueOf(update_name) + (update_name.length() == 0 ? "" : ",") + ifs[i].getPluginName();
                                }
                                ++i;
                            }
                            boolean unloadable = pi.getPluginState().isUnloadable();
                            if (!unloadable) {
                                properties.put(5, true);
                            }
                            final Update update = checker.addUpdate(update_name, new String[]{"Uninstall: " + plugin_dir}, pi.getPluginVersion(), pi.getPluginVersion(), rd, unloadable ? 1 : 2);
                            int[] nArray = rds_added;
                            synchronized (rds_added) {
                                rds_added[0] = rds_added[0] + 1;
                                // ** MonitorExit[var7_7] (shouldn't be in output)
                                rd.addListener(new ResourceDownloaderAdapter(){

                                    @Override
                                    public boolean completed(ResourceDownloader downloader, InputStream data) {
                                        try {
                                            try {
                                                if (pi.getPluginState().isUnloadable()) {
                                                    pi.getPluginState().unload();
                                                    if (!FileUtil.recursiveDelete(FileUtil.newFile(plugin_dir, new String[0]))) {
                                                        update.setRestartRequired(2);
                                                        properties.put(5, true);
                                                        checker.reportProgress("Failed to remove plugin, restart will be required");
                                                    }
                                                }
                                                UpdateInstaller installer = checker.createInstaller();
                                                installer.addRemoveAction(FileUtil.newFile(plugin_dir, new String[0]).getCanonicalPath());
                                                update.complete(true);
                                                try {
                                                    PluginInitializer.fireEvent(12, pi.getPluginID());
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                            catch (Throwable e) {
                                                update.complete(false);
                                                Debug.printStackTrace(e);
                                                Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                            }
                                            return true;
                                        }
                                        finally {
                                            rd_waiter_sem.release();
                                        }
                                    }

                                    @Override
                                    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                                        try {
                                            update.complete(false);
                                            if (!downloader.isCancelled()) {
                                                Logger.log(new LogAlert(true, "Plugin uninstall failed", e));
                                            }
                                        }
                                        finally {
                                            rd_waiter_sem.release();
                                        }
                                    }
                                });
                            }
                        }
                        finally {
                            checker.completed();
                        }
                        {
                            return;
                        }
                    }
                }, false);
                ++i2;
            }
            if (listener_maybe_null != null) {
                inst.addListener(new UpdateCheckInstanceListener(){

                    @Override
                    public void cancelled(UpdateCheckInstance instance) {
                        listener_maybe_null.cancelled();
                    }

                    @Override
                    public void complete(UpdateCheckInstance instance) {
                        new AEThread2("Uninstall:async"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                int[] nArray = rds_added;
                                synchronized (rds_added) {
                                    int wait_count = rds_added[0];
                                    // ** MonitorExit[var2_1] (shouldn't be in output)
                                    int i = 0;
                                    while (i < wait_count) {
                                        rd_waiter_sem.reserve();
                                        ++i;
                                    }
                                    listener_maybe_null.completed();
                                    return;
                                }
                            }
                        }.start();
                    }
                });
            }
            inst.start();
            return inst;
        }
        catch (Throwable e) {
            PluginException pe = e instanceof PluginException ? (PluginException)e : new PluginException("Uninstall failed", e);
            if (listener_maybe_null != null) {
                listener_maybe_null.failed(pe);
            }
            throw pe;
        }
    }

    protected PluginInterface getAlreadyInstalledPlugin(String id) {
        return this.getPluginManager().getPluginInterfaceByID(id, false);
    }

    @Override
    public void requestInstall(String reason, InstallablePlugin plugin) throws PluginException {
        PluginException lastException = null;
        for (PluginInstallerListener listener : this.listeners) {
            try {
                if (!listener.installRequest(reason, plugin)) continue;
                return;
            }
            catch (PluginException pe) {
                lastException = pe;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new PluginException("No listeners registered to perform installation of '" + plugin.getName() + "' (" + reason + ")");
    }

    @Override
    public void addListener(PluginInstallerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PluginInstallerListener l) {
        this.listeners.remove(l);
    }
}

