/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.installer;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pifimpl.local.installer.PluginInstallerImpl;
import com.biglybt.pifimpl.update.PluginUpdatePlugin;
import java.util.Map;

public abstract class InstallablePluginImpl
implements InstallablePlugin {
    private PluginInstallerImpl installer;

    protected InstallablePluginImpl(PluginInstallerImpl _installer) {
        this.installer = _installer;
    }

    @Override
    public boolean isAlreadyInstalled() {
        PluginInterface pi = this.getAlreadyInstalledPlugin();
        if (pi == null) {
            return false;
        }
        String version = this.getVersion();
        if (version == null || version.length() == 0) {
            return false;
        }
        String existing_version = pi.getPluginVersion();
        if (existing_version == null) {
            return true;
        }
        return Constants.compareVersions(existing_version, version) >= 0;
    }

    @Override
    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    @Override
    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    @Override
    public void install(boolean shared, boolean low_noise, boolean wait_until_done) throws PluginException {
        this.install(shared, low_noise, wait_until_done, null);
    }

    @Override
    public void install(boolean shared, boolean low_noise, final boolean wait_until_done, Map<Integer, Object> properties) throws PluginException {
        final AESemaphore sem = new AESemaphore("FPI");
        final PluginException[] error = new PluginException[1];
        this.installer.install(new InstallablePlugin[]{this}, shared, low_noise, properties, new PluginInstallationListener(){
            public boolean cancelled;

            @Override
            public void completed() {
                sem.release();
            }

            @Override
            public void cancelled() {
                this.cancelled = true;
                error[0] = new PluginException("Install cancelled");
                sem.release();
            }

            @Override
            public void failed(PluginException e) {
                error[0] = e;
                sem.release();
                if (!wait_until_done && !this.cancelled) {
                    Debug.out("Install failed", e);
                }
            }
        });
        if (wait_until_done) {
            sem.reserve();
            if (error[0] != null) {
                throw error[0];
            }
        }
    }

    @Override
    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    @Override
    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public abstract void addUpdate(UpdateCheckInstance var1, PluginUpdatePlugin var2, Plugin var3, PluginInterface var4);
}

