/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.download;

import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerActivationListener;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.DownloadManagerTrackerListener;
import com.biglybt.core.download.impl.DownloadManagerMoveHandler;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerDownloadRemovalVetoException;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.TrackerPeerSourceAdapter;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.CopyOnWriteMap;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadActivationEvent;
import com.biglybt.pif.download.DownloadActivationListener;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAnnounceResultPeer;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadCompletionListener;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.download.DownloadWillBeRemovedListener;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.tag.Tag;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.ddb.DDBaseImpl;
import com.biglybt.pifimpl.local.disk.DiskManagerFileInfoImpl;
import com.biglybt.pifimpl.local.download.DownloadAnnounceResultImpl;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.pifimpl.local.download.DownloadScrapeResultImpl;
import com.biglybt.pifimpl.local.download.DownloadStatsImpl;
import com.biglybt.pifimpl.local.peers.PeerManagerImpl;
import com.biglybt.pifimpl.local.torrent.TorrentImpl;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DownloadImpl
extends LogRelation
implements Download,
DownloadManagerListener,
DownloadManagerTrackerListener,
DownloadManagerActivationListener,
DownloadManagerStateAttributeListener {
    private final DownloadManagerImpl manager;
    private final DownloadManager download_manager;
    private final DownloadStatsImpl download_stats;
    private int latest_state = 7;
    private boolean latest_forcedStart;
    private final DownloadAnnounceResultImpl last_announce_result = new DownloadAnnounceResultImpl(this, null);
    private final DownloadScrapeResultImpl last_scrape_result = new DownloadScrapeResultImpl(this, null);
    private final AggregateScrapeResult aggregate_scrape;
    private TorrentImpl torrent = null;
    private List listeners = new ArrayList();
    private AEMonitor listeners_mon = new AEMonitor("Download:L");
    private List tracker_listeners = new ArrayList();
    private AEMonitor tracker_listeners_mon = new AEMonitor("Download:TL");
    private List removal_listeners = new ArrayList();
    private AEMonitor removal_listeners_mon = new AEMonitor("Download:RL");
    private Map peer_listeners = new HashMap();
    private AEMonitor peer_listeners_mon = new AEMonitor("Download:PL");
    private CopyOnWriteList completion_listeners = new CopyOnWriteList();
    private CopyOnWriteMap read_attribute_listeners_map_cow = new CopyOnWriteMap();
    private CopyOnWriteMap write_attribute_listeners_map_cow = new CopyOnWriteMap();
    private CopyOnWriteList activation_listeners = new CopyOnWriteList();
    private DownloadActivationEvent activation_state;
    private Map<String, int[]> announce_response_map;
    private volatile long last_asr_calc = -1L;

    protected DownloadImpl(DownloadManagerImpl _manager, DownloadManager _dm) {
        this.manager = _manager;
        this.download_manager = _dm;
        this.download_stats = new DownloadStatsImpl(this.download_manager);
        this.aggregate_scrape = new AggregateScrapeResult(this, this.download_manager);
        this.activation_state = new DownloadActivationEvent(){

            @Override
            public Download getDownload() {
                return DownloadImpl.this;
            }

            @Override
            public int getActivationCount() {
                return DownloadImpl.this.download_manager.getActivationCount();
            }
        };
        this.download_manager.addListener(this);
        this.latest_forcedStart = this.download_manager.isForceStart();
    }

    public DownloadManager getDownload() {
        return this.download_manager;
    }

    @Override
    public int getState() {
        return this.convertState(this.download_manager.getState());
    }

    @Override
    public int getSubState() {
        int state = this.getState();
        if (state == 6) {
            int substate = this.download_manager.getSubState();
            if (substate == 75) {
                return 9;
            }
            if (substate == 70) {
                return 7;
            }
            if (substate == 100) {
                return 8;
            }
        }
        return state;
    }

    protected int convertState(int dm_state) {
        int our_state;
        switch (dm_state) {
            case 0: {
                our_state = 1;
                break;
            }
            case 5: 
            case 10: 
            case 20: 
            case 30: {
                our_state = 2;
                break;
            }
            case 40: {
                our_state = 3;
                break;
            }
            case 50: 
            case 55: {
                our_state = 4;
                break;
            }
            case 60: {
                our_state = 5;
                break;
            }
            case 65: {
                our_state = 6;
                break;
            }
            case 70: {
                our_state = 7;
                break;
            }
            case 75: {
                our_state = 9;
                break;
            }
            case 100: {
                our_state = 8;
                break;
            }
            default: {
                our_state = 8;
            }
        }
        return our_state;
    }

    @Override
    public String getErrorStateDetails() {
        return this.download_manager.getErrorDetails();
    }

    @Override
    public long getFlags() {
        return this.download_manager.getDownloadState().getFlags();
    }

    @Override
    public boolean getFlag(long flag) {
        return this.download_manager.getDownloadState().getFlag(flag);
    }

    @Override
    public void setFlag(long flag, boolean set) {
        this.download_manager.getDownloadState().setFlag(flag, set);
    }

    @Override
    public Torrent getTorrent() {
        if (this.torrent != null) {
            return this.torrent;
        }
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        this.torrent = new TorrentImpl(torrent);
        return this.torrent;
    }

    @Override
    public void initialize() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 0) {
            throw new DownloadException("Download::initialize: download not waiting (state=" + state + ")");
        }
        this.download_manager.initialize();
    }

    @Override
    public void start() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 40) {
            throw new DownloadException("Download::start: download not ready (state=" + state + ")");
        }
        this.download_manager.startDownload();
    }

    @Override
    public void restart() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 70 && state != 75) {
            throw new DownloadException("Download::restart: download already running (state=" + state + ")");
        }
        this.download_manager.setStateWaiting();
    }

    @Override
    public void stop() throws DownloadException {
        if (this.download_manager.getState() == 70) {
            throw new DownloadException("Download::stop: download already stopped");
        }
        this.download_manager.stopIt(70, false, false);
    }

    @Override
    public void setStopReason(String reason) {
        this.setUserData(UD_KEY_STOP_REASON, reason);
    }

    @Override
    public String getStopReason() {
        return (String)this.getUserData(UD_KEY_STOP_REASON);
    }

    @Override
    public void stopAndQueue() throws DownloadException {
        if (this.download_manager.getState() == 75) {
            throw new DownloadException("Download::stopAndQueue: download already queued");
        }
        this.download_manager.stopIt(75, false, false);
    }

    @Override
    public void recheckData() throws DownloadException {
        if (!this.download_manager.canForceRecheck()) {
            throw new DownloadException("Download::recheckData: download must be stopped, queued or in error state");
        }
        this.download_manager.forceRecheck();
    }

    @Override
    public boolean isStartStopLocked() {
        return this.download_manager.getState() == 70;
    }

    @Override
    public boolean isForceStart() {
        return this.download_manager.isForceStart();
    }

    @Override
    public void setForceStart(boolean forceStart) {
        this.download_manager.setForceStart(forceStart);
    }

    @Override
    public boolean isPaused() {
        return this.download_manager.isPaused();
    }

    @Override
    public void pause() {
        this.download_manager.pause(false);
    }

    @Override
    public void resume() {
        this.download_manager.resume();
    }

    @Override
    public int getPosition() {
        return this.download_manager.getPosition();
    }

    @Override
    public long getCreationTime() {
        return this.download_manager.getCreationTime();
    }

    @Override
    public void setPosition(int newPosition) {
        this.download_manager.setPosition(newPosition);
    }

    @Override
    public void moveUp() {
        this.download_manager.getGlobalManager().moveUp(this.download_manager);
    }

    @Override
    public void moveDown() {
        this.download_manager.getGlobalManager().moveDown(this.download_manager);
    }

    @Override
    public void moveTo(int pos) {
        this.download_manager.getGlobalManager().moveTo(this.download_manager, pos);
    }

    @Override
    public String getName() {
        return this.download_manager.getDisplayName();
    }

    @Override
    public String getTorrentFileName() {
        return this.download_manager.getTorrentFileName();
    }

    @Override
    public String getCategoryName() {
        Category category = this.download_manager.getDownloadState().getCategory();
        if (category == null) {
            category = CategoryManager.getCategory(2);
        }
        if (category == null) {
            return null;
        }
        return category.getName();
    }

    @Override
    public List<Tag> getTags() {
        return new ArrayList<Tag>(TagManagerFactory.getTagManager().getTagsForTaggable(this.download_manager));
    }

    @Override
    public String getAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getAttribute(name);
        }
        return null;
    }

    @Override
    public String[] getListAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getListAttribute(name);
        }
        return null;
    }

    @Override
    public void setListAttribute(TorrentAttribute attribute, String[] value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setListAttribute(name, value);
        }
    }

    @Override
    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setMapAttribute(name, BEncoder.cloneMap(value));
        }
    }

    @Override
    public Map getMapAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getMapAttribute(name);
        }
        return null;
    }

    @Override
    public void setAttribute(TorrentAttribute attribute, String value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setAttribute(name, value);
        }
    }

    @Override
    public boolean hasAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name == null) {
            return false;
        }
        return this.download_manager.getDownloadState().hasAttribute(name);
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name == null) {
            return false;
        }
        return this.download_manager.getDownloadState().getBooleanAttribute(name);
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute attribute, boolean value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setBooleanAttribute(name, value);
        }
    }

    @Override
    public int getIntAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name == null) {
            return 0;
        }
        return this.download_manager.getDownloadState().getIntAttribute(name);
    }

    @Override
    public void setIntAttribute(TorrentAttribute attribute, int value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setIntAttribute(name, value);
        }
    }

    @Override
    public long getLongAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name == null) {
            return 0L;
        }
        return this.download_manager.getDownloadState().getLongAttribute(name);
    }

    @Override
    public void setLongAttribute(TorrentAttribute attribute, long value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setLongAttribute(name, value);
        }
    }

    protected String convertAttribute(TorrentAttribute attribute) {
        if (attribute.getName() == "Category") {
            return "category";
        }
        if (attribute.getName() == "Networks") {
            return "networks";
        }
        if (attribute.getName() == "TrackerClientExtensions") {
            return "trackerclientextensions";
        }
        if (attribute.getName() == "PeerSources") {
            return "peersources";
        }
        if (attribute.getName() == "DisplayName") {
            return "displayname";
        }
        if (attribute.getName() == "UserComment") {
            return "comment";
        }
        if (attribute.getName() == "RelativePath") {
            return "relativepath";
        }
        if (attribute.getName() == "ShareProperties") {
            return null;
        }
        if (attribute.getName().startsWith("Plugin.")) {
            return attribute.getName();
        }
        Debug.out("Can't convert attribute '" + attribute.getName() + "'");
        return null;
    }

    protected TorrentAttribute convertAttribute(String name) {
        if (name.equals("category")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Category");
        }
        if (name.equals("networks")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Networks");
        }
        if (name.equals("peersources")) {
            return TorrentManagerImpl.getSingleton().getAttribute("PeerSources");
        }
        if (name.equals("trackerclientextensions")) {
            return TorrentManagerImpl.getSingleton().getAttribute("TrackerClientExtensions");
        }
        if (name.equals("displayname")) {
            return TorrentManagerImpl.getSingleton().getAttribute("DisplayName");
        }
        if (name.equals("comment")) {
            return TorrentManagerImpl.getSingleton().getAttribute("UserComment");
        }
        if (name.equals("relativepath")) {
            return TorrentManagerImpl.getSingleton().getAttribute("RelativePath");
        }
        if (name.startsWith("Plugin.")) {
            return TorrentManagerImpl.getSingleton().getAttribute(name);
        }
        return null;
    }

    @Override
    public void setCategory(String sName) {
        Category category = CategoryManager.getCategory(sName);
        if (category == null) {
            category = CategoryManager.createCategory(sName);
        }
        this.download_manager.getDownloadState().setCategory(category);
    }

    @Override
    public boolean isPersistent() {
        return this.download_manager.isPersistent();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        this.remove(false, false);
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state != 70 && dl_state != 100 && dl_state != 75) {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
        this.stopAndRemove(delete_torrent, delete_data);
    }

    @Override
    public void stopAndRemove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        GlobalManager gm = this.download_manager.getGlobalManager();
        try {
            gm.removeDownloadManager(this.download_manager, delete_torrent, delete_data);
        }
        catch (GlobalManagerDownloadRemovalVetoException e) {
            throw new DownloadRemovalVetoException(e.getMessage());
        }
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state == 70 || dl_state == 100 || dl_state == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.canDownloadManagerBeRemoved(this.download_manager, false, false);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                throw new DownloadRemovalVetoException(e.getMessage(), e.isSilent());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
        return true;
    }

    @Override
    public DownloadStats getStats() {
        return this.download_stats;
    }

    @Override
    public boolean isComplete() {
        return this.download_manager.isDownloadComplete(false);
    }

    @Override
    public boolean isComplete(boolean bIncludeDND) {
        return this.download_manager.isDownloadComplete(bIncludeDND);
    }

    @Override
    public boolean isChecking() {
        return this.download_stats.getCheckingDoneInThousandNotation() != -1;
    }

    @Override
    public boolean isMoving() {
        com.biglybt.core.disk.DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null) {
            return dm.getMoveProgress() != null;
        }
        return false;
    }

    protected void isRemovable() throws DownloadRemovalVetoException {
        int i = 0;
        while (i < this.removal_listeners.size()) {
            try {
                ((DownloadWillBeRemovedListener)this.removal_listeners.get(i)).downloadWillBeRemoved(this);
            }
            catch (DownloadRemovalVetoException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void destroy() {
        this.download_manager.removeListener(this);
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        int prev_state = this.latest_state;
        this.latest_state = this.convertState(state);
        boolean curr_forcedStart = this.isForceStart();
        List listeners_to_use = this.listeners;
        if (prev_state != this.latest_state || this.latest_forcedStart != curr_forcedStart) {
            this.latest_forcedStart = curr_forcedStart;
            int i = 0;
            while (i < listeners_to_use.size()) {
                try {
                    long startTime = SystemTime.getCurrentTime();
                    DownloadListener listener = (DownloadListener)listeners_to_use.get(i);
                    listener.stateChanged(this, prev_state, this.latest_state);
                    long diff = SystemTime.getCurrentTime() - startTime;
                    if (diff > 1000L) {
                        System.out.println("Plugin should move long processes (" + diff + "ms) off of Download's stateChanged listener trigger. " + listener);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
        if (this.completion_listeners.isEmpty()) {
            return;
        }
        for (DownloadCompletionListener dcl : this.completion_listeners) {
            long startTime = SystemTime.getCurrentTime();
            try {
                dcl.onCompletion(this);
            }
            catch (Throwable t) {
                Debug.printStackTrace(t);
            }
            long diff = SystemTime.getCurrentTime() - startTime;
            if (diff <= 1000L) continue;
            System.out.println("Plugin should move long processes (" + diff + "ms) off of Download's onCompletion listener trigger. " + dcl);
        }
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, com.biglybt.core.disk.DiskManagerFileInfo file) {
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                long startTime = SystemTime.getCurrentTime();
                DownloadListener listener = (DownloadListener)this.listeners.get(i);
                listener.positionChanged(this, oldPosition, newPosition);
                long diff = SystemTime.getCurrentTime() - startTime;
                if (diff > 1000L) {
                    System.out.println("Plugin should move long processes (" + diff + "ms) off of Download's positionChanged listener trigger. " + listener);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void addListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadListener> new_listeners = new ArrayList<DownloadListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void removeListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener listener, TorrentAttribute attr, int event_type) {
        String attribute = this.convertAttribute(attr);
        if (attribute == null) {
            return;
        }
        CopyOnWriteMap attr_map = this.getAttributeMapForType(event_type);
        CopyOnWriteList<DownloadAttributeListener> listener_list = (CopyOnWriteList<DownloadAttributeListener>)attr_map.get(attribute);
        boolean add_self = false;
        if (listener_list == null) {
            listener_list = new CopyOnWriteList<DownloadAttributeListener>();
            attr_map.put(attribute, listener_list);
        }
        add_self = listener_list.isEmpty();
        listener_list.add(listener);
        if (add_self) {
            this.download_manager.getDownloadState().addListener(this, attribute, event_type);
        }
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener listener, TorrentAttribute attr, int event_type) {
        String attribute = this.convertAttribute(attr);
        if (attribute == null) {
            return;
        }
        CopyOnWriteMap attr_map = this.getAttributeMapForType(event_type);
        CopyOnWriteList listener_list = (CopyOnWriteList)attr_map.get(attribute);
        boolean remove_self = false;
        if (listener_list != null) {
            listener_list.remove(listener);
            remove_self = listener_list.isEmpty();
        }
        if (remove_self) {
            this.download_manager.getDownloadState().removeListener(this, attribute, event_type);
        }
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        TRTrackerAnnouncer tc = this.download_manager.getTrackerClient();
        if (tc != null) {
            this.last_announce_result.setContent(tc.getLastResponse());
        }
        return this.last_announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        TRTrackerScraperResponse response = this.download_manager.getTrackerScrapeResponse();
        if (response != null && (response.getStatus() == 1 || response.getStatus() == 2)) {
            this.last_scrape_result.setContent(response);
        }
        return this.last_scrape_result;
    }

    @Override
    public DownloadScrapeResult getAggregatedScrapeResult(boolean allow_caching) {
        this.updateAggregatedScrapeResult(allow_caching);
        int new_seeds = this.aggregate_scrape.getSeedCount();
        int new_leechers = this.aggregate_scrape.getNonSeedCount();
        if (new_seeds >= 0 || new_leechers >= 0) {
            String[] bits;
            String cache = this.download_manager.getDownloadState().getAttribute("agsc");
            boolean do_update = true;
            long mins = SystemTime.getCurrentTime() / 60000L;
            int old_seeds = -2;
            int old_leechers = -2;
            if (cache != null && (bits = cache.split(",")).length == 3) {
                long updated_mins = 0L;
                try {
                    updated_mins = Long.parseLong(bits[0]);
                    old_seeds = Integer.parseInt(bits[1]);
                    old_leechers = Integer.parseInt(bits[2]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (mins - updated_mins < 15L) {
                    do_update = false;
                } else {
                    int dl_state = this.download_manager.getState();
                    if (dl_state != 50 && dl_state != 60 && mins - updated_mins < 180L) {
                        do_update = false;
                    }
                }
            }
            if (new_seeds != old_seeds || new_leechers != old_leechers) {
                String str = String.valueOf(mins) + "," + new_seeds + "," + new_leechers;
                this.download_manager.getDownloadState().setAttribute("agsc", str, do_update);
            }
        }
        return this.aggregate_scrape;
    }

    private void updateAggregatedScrapeResult(boolean allow_caching) {
        long now = SystemTime.getMonotonousTime();
        if (allow_caching && now - this.last_asr_calc < 10000L) {
            return;
        }
        this.updateAggregatedScrapeResult();
        this.last_asr_calc = now;
    }

    private void updateAggregatedScrapeResult() {
        List<TRTrackerScraperResponse> responses = this.download_manager.getGoodTrackerScrapeResponses();
        int best_peers = -1;
        int best_seeds = -1;
        int best_time = -1;
        TRTrackerScraperResponse best_resp = null;
        if (responses != null) {
            for (TRTrackerScraperResponse response : responses) {
                int peers = response.getPeers();
                int seeds = response.getSeeds();
                if (peers <= best_peers && (peers != best_peers || seeds <= best_seeds)) continue;
                best_peers = peers;
                best_seeds = seeds;
                best_resp = response;
            }
        }
        if (best_peers == -1) {
            try {
                TrackerPeerSource our_dht = null;
                List<TrackerPeerSource> peer_sources = this.download_manager.getTrackerPeerSources();
                for (TrackerPeerSource ps : peer_sources) {
                    if (ps.getType() != 3) continue;
                    our_dht = ps;
                    break;
                }
                this.peer_listeners_mon.enter();
                if (this.announce_response_map != null) {
                    int total_seeds = 0;
                    int total_peers = 0;
                    int latest_time = 0;
                    int num = 0;
                    if (our_dht != null && our_dht.getStatus() == 5) {
                        total_seeds = our_dht.getSeedCount();
                        total_peers = our_dht.getLeecherCount();
                        latest_time = our_dht.getLastUpdate();
                        num = 1;
                    }
                    for (int[] entry : this.announce_response_map.values()) {
                        ++num;
                        int seeds = entry[0];
                        int peers = entry[1];
                        int time = entry[3];
                        total_seeds += seeds;
                        total_peers += peers;
                        if (time <= latest_time) continue;
                        latest_time = time;
                    }
                    if (total_peers >= 0) {
                        best_peers = Math.max(1, total_peers / num);
                        best_seeds = total_seeds / num;
                        if (total_seeds > 0 && best_seeds == 0) {
                            best_seeds = 1;
                        }
                        best_time = latest_time;
                        best_resp = null;
                    }
                }
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        if (best_peers >= 0) {
            this.aggregate_scrape.update(best_resp, best_seeds, best_peers, best_time);
        }
    }

    @Override
    public void scrapeResult(TRTrackerScraperResponse response) {
        if (response.getStatus() != 1 && response.getStatus() != 2) {
            return;
        }
        this.last_scrape_result.setContent(response);
        int i = 0;
        while (i < this.tracker_listeners.size()) {
            try {
                ((DownloadTrackerListener)this.tracker_listeners.get(i)).scrapeResult(this.last_scrape_result);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    void announceTrackerResultsToListener(DownloadTrackerListener l) {
        l.announceResult(this.last_announce_result);
        l.scrapeResult(this.last_scrape_result);
    }

    @Override
    public void announceResult(TRTrackerAnnouncerResponse response) {
        this.last_announce_result.setContent(response);
        List tracker_listeners_ref = this.tracker_listeners;
        int i = 0;
        while (i < tracker_listeners_ref.size()) {
            try {
                ((DownloadTrackerListener)tracker_listeners_ref.get(i)).announceResult(this.last_announce_result);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public TrackerPeerSource[] getTrackerPeerSources() {
        ArrayList<String> names = null;
        try {
            this.peer_listeners_mon.enter();
            if (this.announce_response_map != null) {
                names = new ArrayList<String>(this.announce_response_map.keySet());
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        if (names == null || names.size() == 0) {
            return new TrackerPeerSource[0];
        }
        TrackerPeerSource[] result = new TrackerPeerSourceAdapter[names.size()];
        int i = 0;
        while (i < result.length) {
            final String name = (String)names.get(i);
            result[i] = new TrackerPeerSourceAdapter(){
                private long fixup;
                private int state;
                private String details = "";
                private int seeds = -1;
                private int leechers = -1;
                private int peers = -1;
                private int time = -1;
                private int next_time = -1;

                private void fixup() {
                    long now = SystemTime.getCurrentTime();
                    if (now - this.fixup > 1000L) {
                        int s;
                        this.state = !DownloadImpl.this.download_manager.getDownloadState().isPeerSourceEnabled("Plugin") ? 1 : ((s = DownloadImpl.this.getState()) == 4 || s == 5 ? 5 : 2);
                        try {
                            DownloadImpl.this.peer_listeners_mon.enter();
                            int[] data = (int[])DownloadImpl.this.announce_response_map.get(name);
                            if (data != null) {
                                this.seeds = data[0];
                                this.leechers = data[1];
                                this.peers = data[2];
                                this.details = this.peers == -1 ? (this.seeds >= 0 ? String.valueOf(name) + " " + this.seeds + "/" + this.leechers : name) : (this.seeds >= 0 ? String.valueOf(name) + " " + this.seeds + "/" + this.leechers + "/" + this.peers : name);
                                this.time = data[3];
                                this.next_time = data[4];
                            } else {
                                this.details = name;
                                this.seeds = -1;
                                this.leechers = -1;
                                this.peers = -1;
                                this.time = -1;
                                this.next_time = -1;
                            }
                        }
                        finally {
                            DownloadImpl.this.peer_listeners_mon.exit();
                        }
                        this.fixup = now;
                    }
                }

                @Override
                public int getType() {
                    return 7;
                }

                @Override
                public int getStatus() {
                    this.fixup();
                    return this.state;
                }

                @Override
                public String getName() {
                    this.fixup();
                    return this.details;
                }

                @Override
                public int getSeedCount() {
                    this.fixup();
                    return this.seeds;
                }

                @Override
                public int getLeecherCount() {
                    this.fixup();
                    return this.leechers;
                }

                @Override
                public int getPeers() {
                    this.fixup();
                    return this.peers;
                }

                @Override
                public int getLastUpdate() {
                    return this.time;
                }

                @Override
                public int getSecondsToUpdate() {
                    if (this.next_time == 0) {
                        return -1;
                    }
                    int now_secs = (int)(SystemTime.getCurrentTime() / 1000L);
                    int rem = this.next_time - now_secs;
                    if (rem < 0) {
                        return 0;
                    }
                    return rem;
                }
            };
            ++i;
        }
        return result;
    }

    private String getTrackingName(Object obj) {
        String name = obj.getClass().getName();
        int pos = name.lastIndexOf(46);
        if ((pos = (name = name.substring(pos + 1)).indexOf(36)) != -1) {
            name = name.substring(0, pos);
        }
        if ((pos = name.indexOf("DHTTrackerPlugin")) == 0) {
            name = null;
        } else if (pos > 0) {
            name = name.substring(0, pos);
        } else if (name.equals("DHTAnnounceResult") || name.equals("DHTScrapeResult")) {
            name = "mlDHT";
        }
        return name;
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        String class_name = this.getTrackingName(result);
        boolean new_entry = false;
        if (class_name != null) {
            int seeds = result.getSeedCount();
            int leechers = result.getNonSeedCount();
            DownloadAnnounceResultPeer[] peers = result.getPeers();
            int peer_count = peers == null ? 0 : peers.length;
            try {
                this.peer_listeners_mon.enter();
                if (this.announce_response_map == null) {
                    this.announce_response_map = new HashMap<String, int[]>();
                } else if (this.announce_response_map.size() > 32) {
                    Debug.out("eh?");
                    this.announce_response_map.clear();
                }
                int[] data = this.announce_response_map.get(class_name);
                if (data == null) {
                    data = new int[5];
                    this.announce_response_map.put(class_name, data);
                    new_entry = true;
                }
                data[0] = seeds;
                data[1] = leechers;
                data[2] = peer_count;
                data[3] = (int)(SystemTime.getCurrentTime() / 1000L);
                data[4] = (int)(SystemTime.getCurrentTime() / 1000L + result.getTimeToWait());
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        this.download_manager.setAnnounceResult(result);
        if (new_entry) {
            this.download_manager.informTPSChanged();
        }
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult result) {
        String class_name = this.getTrackingName(result);
        boolean new_entry = false;
        if (class_name != null) {
            int seeds = result.getSeedCount();
            int leechers = result.getNonSeedCount();
            try {
                this.peer_listeners_mon.enter();
                if (this.announce_response_map == null) {
                    this.announce_response_map = new HashMap<String, int[]>();
                } else if (this.announce_response_map.size() > 32) {
                    Debug.out("eh?");
                    this.announce_response_map.clear();
                }
                int[] data = this.announce_response_map.get(class_name);
                if (data == null) {
                    data = new int[5];
                    data[2] = -1;
                    this.announce_response_map.put(class_name, data);
                    new_entry = true;
                }
                data[0] = seeds;
                data[1] = leechers;
                data[3] = result.getScrapeStartTime() <= 0L ? -1 : (int)(SystemTime.getCurrentTime() / 1000L);
                data[4] = (int)(result.getNextScrapeStartTime() / 1000L);
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        this.download_manager.setScrapeResult(result);
        if (new_entry) {
            this.download_manager.informTPSChanged();
        }
    }

    public void torrentChanged() {
        TRTrackerAnnouncer client = this.download_manager.getTrackerClient();
        if (client != null) {
            client.resetTrackerUrl(true);
        }
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l) {
        this.addTrackerListener(l, true);
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadTrackerListener> new_tracker_listeners = new ArrayList<DownloadTrackerListener>(this.tracker_listeners);
            new_tracker_listeners.add(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 1) {
                this.download_manager.addTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
        if (immediateTrigger) {
            this.announceTrackerResultsToListener(l);
        }
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList new_tracker_listeners = new ArrayList(this.tracker_listeners);
            new_tracker_listeners.remove(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 0) {
                this.download_manager.removeTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList<DownloadWillBeRemovedListener> new_removal_listeners = new ArrayList<DownloadWillBeRemovedListener>(this.removal_listeners);
            new_removal_listeners.add(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList new_removal_listeners = new ArrayList(this.removal_listeners);
            new_removal_listeners.remove(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    @Override
    public void addPeerListener(final DownloadPeerListener listener) {
        DownloadManagerPeerListener delegate = new DownloadManagerPeerListener(){

            @Override
            public void peerManagerAdded(PEPeerManager manager) {
                PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
                listener.peerManagerAdded(DownloadImpl.this, pm);
            }

            @Override
            public void peerManagerRemoved(PEPeerManager manager) {
                PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
                listener.peerManagerRemoved(DownloadImpl.this, pm);
            }

            @Override
            public void peerManagerWillBeAdded(PEPeerManager manager) {
            }

            @Override
            public void peerAdded(PEPeer peer) {
            }

            @Override
            public void peerRemoved(PEPeer peer) {
            }
        };
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.put(listener, delegate);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        this.download_manager.addPeerListener(delegate);
    }

    @Override
    public void removePeerListener(DownloadPeerListener listener) {
        DownloadManagerPeerListener delegate;
        try {
            this.peer_listeners_mon.enter();
            delegate = (DownloadManagerPeerListener)this.peer_listeners.remove(listener);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        if (delegate != null) {
            this.download_manager.removePeerListener(delegate);
        }
    }

    @Override
    public boolean activateRequest(final int count) {
        DownloadActivationEvent event2 = new DownloadActivationEvent(){

            @Override
            public Download getDownload() {
                return DownloadImpl.this;
            }

            @Override
            public int getActivationCount() {
                return count;
            }
        };
        Iterator it = this.activation_listeners.iterator();
        while (it.hasNext()) {
            try {
                DownloadActivationListener listener = (DownloadActivationListener)it.next();
                if (!listener.activationRequested(event2)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        return this.activation_state;
    }

    @Override
    public void addActivationListener(DownloadActivationListener l) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.add(l);
            if (this.activation_listeners.size() == 1) {
                this.download_manager.addActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    @Override
    public void removeActivationListener(DownloadActivationListener l) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.remove(l);
            if (this.activation_listeners.size() == 0) {
                this.download_manager.removeActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener l) {
        try {
            this.listeners_mon.enter();
            this.completion_listeners.add(l);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener l) {
        try {
            this.listeners_mon.enter();
            this.completion_listeners.remove(l);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public PeerManager getPeerManager() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return null;
        }
        return PeerManagerImpl.getPeerManager(pm);
    }

    @Override
    public DiskManager getDiskManager() {
        PeerManager pm = this.getPeerManager();
        if (pm != null) {
            return pm.getDiskManager();
        }
        return null;
    }

    @Override
    public int getDiskManagerFileCount() {
        return this.download_manager.getNumFileInfos();
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int index) {
        com.biglybt.core.disk.DiskManagerFileInfo[] info = this.download_manager.getDiskManagerFileInfo();
        if (info == null) {
            return null;
        }
        if (index < 0 || index >= info.length) {
            return null;
        }
        return new DiskManagerFileInfoImpl(this, info[index]);
    }

    @Override
    public DiskManagerFileInfo getPrimaryFile() {
        com.biglybt.core.disk.DiskManagerFileInfo primaryFile = this.download_manager.getDownloadState().getPrimaryFile();
        if (primaryFile == null) {
            return null;
        }
        return new DiskManagerFileInfoImpl(this, primaryFile);
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        com.biglybt.core.disk.DiskManagerFileInfo[] info = this.download_manager.getDiskManagerFileInfo();
        if (info == null) {
            return new DiskManagerFileInfo[0];
        }
        DiskManagerFileInfo[] res = new DiskManagerFileInfo[info.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new DiskManagerFileInfoImpl(this, info[i]);
            ++i;
        }
        return res;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int kb) {
        if (kb == -1) {
            Debug.out("setMaximiumDownloadKBPerSecond got value (-1) ZERO_DOWNLOAD. (-1)does not work through this method, use getDownloadRateLimitBytesPerSecond() instead.");
        }
        this.download_manager.getStats().setDownloadRateLimitBytesPerSecond(kb < 0 ? 0 : kb * 1024);
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        int bps = this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
        return bps <= 0 ? bps : (bps < 1024 ? 1 : bps / 1024);
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getUploadRateLimitBytesPerSecond();
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.download_manager.getStats().setUploadRateLimitBytesPerSecond(max_rate_bps);
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.download_manager.getStats().setDownloadRateLimitBytesPerSecond(max_rate_bps);
    }

    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.download_manager.addRateLimiter(UtilitiesImpl.wrapLimiter(limiter, false), is_upload);
    }

    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.download_manager.removeRateLimiter(UtilitiesImpl.wrapLimiter(limiter, false), is_upload);
    }

    @Override
    public Download.SeedingRank getSeedingRank() {
        return this.download_manager.getSeedingRank();
    }

    @Override
    public void setSeedingRank(Download.SeedingRank rank) {
        this.download_manager.setSeedingRank(rank);
    }

    @Override
    public String getSavePath() {
        return this.download_manager.getSaveLocation().toString();
    }

    @Override
    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        try {
            this.download_manager.moveDataFiles(new_parent_dir);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("move operation failed", e);
        }
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        try {
            this.download_manager.moveDataFiles(new_parent_dir, new_name);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("move / rename operation failed", e);
        }
    }

    @Override
    public void renameDownload(String new_name) throws DownloadException {
        try {
            this.download_manager.renameDownload(new_name);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("rename operation failed", e);
        }
    }

    @Override
    public void moveTorrentFile(File new_parent_dir) throws DownloadException {
        try {
            this.download_manager.moveTorrentFile(new_parent_dir);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("move operation failed", e);
        }
    }

    @Override
    public void requestTrackerAnnounce() {
        this.download_manager.requestTrackerAnnounce(false);
    }

    @Override
    public void requestTrackerAnnounce(boolean immediate) {
        this.download_manager.requestTrackerAnnounce(immediate);
    }

    @Override
    public void requestTrackerScrape(boolean immediate) {
        this.download_manager.requestTrackerScrape(immediate);
    }

    @Override
    public byte[] getDownloadPeerId() {
        TRTrackerAnnouncer announcer = this.download_manager.getTrackerClient();
        if (announcer == null) {
            return null;
        }
        return announcer.getPeerId();
    }

    @Override
    public boolean isMessagingEnabled() {
        return this.download_manager.getExtendedMessagingMode() == 2;
    }

    @Override
    public void setMessagingEnabled(boolean enabled) {
        throw new RuntimeException("setMessagingEnabled is in the process of being removed - if you are seeing this error, let the Azureus developers know that you need this method to stay!");
    }

    @Override
    public boolean isRemoved() {
        return this.download_manager.isDestroyed();
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.download_manager);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager};
    }

    private CopyOnWriteMap getAttributeMapForType(int event_type) {
        return event_type == 2 ? this.read_attribute_listeners_map_cow : this.write_attribute_listeners_map_cow;
    }

    @Override
    public boolean canMoveDataFiles() {
        return this.download_manager.canMoveDataFiles();
    }

    @Override
    public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
        CopyOnWriteMap attr_listener_map = this.getAttributeMapForType(event_type);
        TorrentAttribute attr = this.convertAttribute(attribute);
        if (attr == null) {
            return;
        }
        List listeners = null;
        listeners = ((CopyOnWriteList)attr_listener_map.get(attribute)).getList();
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.size()) {
            DownloadAttributeListener dal = (DownloadAttributeListener)listeners.get(i);
            try {
                dal.attributeEventOccurred(this, attr, event_type);
            }
            catch (Throwable t) {
                Debug.printStackTrace(t);
            }
            ++i;
        }
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        return DownloadManagerMoveHandler.recalculatePath(this.download_manager);
    }

    @Override
    public Object getUserData(Object key) {
        return this.download_manager.getUserData(key);
    }

    @Override
    public void setUserData(Object key, Object data) {
        this.download_manager.setUserData(key, data);
    }

    @Override
    public void startDownload(boolean force) {
        if (force) {
            this.setForceStart(true);
            return;
        }
        this.setForceStart(false);
        int state = this.getState();
        if (state == 70 || state == 75) {
            this.download_manager.setStateWaiting();
        }
    }

    @Override
    public void stopDownload() {
        if (this.download_manager.getState() == 70) {
            return;
        }
        this.download_manager.stopIt(70, false, false);
    }

    @Override
    public boolean isStub() {
        return false;
    }

    @Override
    public boolean canStubbify() {
        return this.manager.canStubbify(this);
    }

    @Override
    public DownloadStub stubbify() throws DownloadException, DownloadRemovalVetoException {
        return this.manager.stubbify(this);
    }

    @Override
    public Download destubbify() throws DownloadException {
        return this;
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases() {
        return DDBaseImpl.getDDBs(this);
    }

    @Override
    public byte[] getTorrentHash() {
        Torrent t = this.getTorrent();
        if (t == null) {
            return null;
        }
        return t.getHash();
    }

    @Override
    public long getTorrentSize() {
        Torrent t = this.getTorrent();
        if (t == null) {
            return 0L;
        }
        return t.getSize();
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        DiskManagerFileInfo[] dm_files = this.getDiskManagerFileInfo();
        DownloadStub.DownloadStubFile[] files = new DownloadStub.DownloadStubFile[dm_files.length];
        int i = 0;
        while (i < files.length) {
            final DiskManagerFileInfo dm_file = dm_files[i];
            files[i] = new DownloadStub.DownloadStubFile(){

                @Override
                public File getFile() {
                    return dm_file.getFile(true);
                }

                @Override
                public long getLength() {
                    if (dm_file.getDownloaded() == dm_file.getLength() && !dm_file.isSkipped()) {
                        return dm_file.getLength();
                    }
                    return -dm_file.getLength();
                }
            };
            ++i;
        }
        return files;
    }

    @Override
    public void changeLocation(SaveLocationChange slc) throws DownloadException {
        boolean has_change;
        boolean bl = has_change = slc.hasDownloadChange() || slc.hasTorrentChange();
        if (!has_change) {
            return;
        }
        has_change = slc.isDifferentDownloadLocation(FileUtil.newFile(this.getSavePath(), new String[0]));
        if (!has_change) {
            has_change = slc.isDifferentTorrentLocation(FileUtil.newFile(this.getTorrentFileName(), new String[0]));
        }
        if (!has_change) {
            return;
        }
        boolean try_to_resume = !this.isPaused();
        try {
            try {
                if (slc.hasDownloadChange()) {
                    this.download_manager.moveDataFiles(slc.download_location, slc.download_name);
                }
                if (slc.hasTorrentChange()) {
                    this.download_manager.moveTorrentFile(slc.torrent_location, slc.torrent_name);
                }
            }
            catch (DownloadManagerException e) {
                throw new DownloadException(e.getMessage(), e);
            }
        }
        finally {
            if (try_to_resume) {
                this.resume();
            }
        }
    }

    private static class AggregateScrapeResult
    implements DownloadScrapeResult {
        private Download dl;
        private TRTrackerScraperResponse response;
        private int seeds;
        private int leechers;
        private int time_secs;

        private AggregateScrapeResult(Download _dl, DownloadManager _dm) {
            this.dl = _dl;
            try {
                DownloadManagerState dm_state = _dm.getDownloadState();
                String ag_cache = dm_state.getAttribute("agsc");
                if (ag_cache != null) {
                    String[] bits = ag_cache.split(",");
                    if (bits.length == 3) {
                        this.time_secs = Integer.parseInt(bits[0]) * 60;
                        this.seeds = Integer.parseInt(bits[1]);
                        this.leechers = Integer.parseInt(bits[2]);
                    }
                } else {
                    long cache = dm_state.getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        this.seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        this.leechers = (int)(cache & 0xFFFFFFL);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void update(TRTrackerScraperResponse _response, int _seeds, int _peers, int _time_secs) {
            this.response = _response;
            this.seeds = _seeds;
            this.leechers = _peers;
            this.time_secs = _time_secs;
        }

        @Override
        public Download getDownload() {
            return this.dl;
        }

        @Override
        public int getResponseType() {
            return 1;
        }

        @Override
        public int getSeedCount() {
            return this.seeds;
        }

        @Override
        public int getNonSeedCount() {
            return this.leechers;
        }

        @Override
        public long getScrapeStartTime() {
            TRTrackerScraperResponse r = this.response;
            if (r != null) {
                return r.getScrapeStartTime();
            }
            if (this.time_secs <= 0) {
                return -1L;
            }
            return (long)this.time_secs * 1000L;
        }

        @Override
        public void setNextScrapeStartTime(long nextScrapeStartTime) {
            Debug.out("Not Supported");
        }

        @Override
        public long getNextScrapeStartTime() {
            TRTrackerScraperResponse r = this.response;
            return r == null ? -1L : r.getScrapeStartTime();
        }

        @Override
        public String getStatus() {
            return "Aggregate Scrape";
        }

        @Override
        public URL getURL() {
            TRTrackerScraperResponse r = this.response;
            return r == null ? null : r.getURL();
        }
    }
}

