/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.disk;

import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRandomReadRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.disk.DiskManagerFileInfoImpl;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiskManagerRandomReadController {
    private static Map<DownloadImpl, DiskManagerRandomReadController> controller_map = new HashMap<DownloadImpl, DiskManagerRandomReadController>();
    private DownloadImpl download;
    private List<DiskManagerRandomReadRequestImpl> requests = new ArrayList<DiskManagerRandomReadRequestImpl>();
    private AsyncDispatcher dispatcher = new AsyncDispatcher("dm_rand_reads");
    private boolean set_force_start;
    private TimerEventPeriodic timer_event;
    private volatile boolean busy;
    private volatile long last_busy_time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskManagerRandomReadRequest createRequest(DownloadImpl download, DiskManagerFileInfoImpl file, long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        if (file_offset < 0L || file_offset >= file.getLength()) {
            throw new DownloadException("invalid file offset " + file_offset + ", file size=" + file.getLength());
        }
        if (length <= 0L || file_offset + length > file.getLength()) {
            throw new DownloadException("invalid read length " + length + ", offset=" + file_offset + ", file size=" + file.getLength());
        }
        Map<DownloadImpl, DiskManagerRandomReadController> map = controller_map;
        synchronized (map) {
            DiskManagerRandomReadController controller = controller_map.get(download);
            if (controller == null) {
                controller = new DiskManagerRandomReadController(download);
                controller_map.put(download, controller);
            }
            return controller.addRequest(file, file_offset, length, reverse_order, listener);
        }
    }

    private DiskManagerRandomReadController(DownloadImpl _download) {
        this.download = _download;
        this.timer_event = SimpleTimer.addPeriodicEvent("dmrr:timer", 5000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                if (DiskManagerRandomReadController.this.busy || SystemTime.getMonotonousTime() - DiskManagerRandomReadController.this.last_busy_time < 5000L) {
                    return;
                }
                Map map = controller_map;
                synchronized (map) {
                    List list = DiskManagerRandomReadController.this.requests;
                    synchronized (list) {
                        if (DiskManagerRandomReadController.this.requests.size() > 0) {
                            return;
                        }
                    }
                    controller_map.remove(DiskManagerRandomReadController.this.download);
                    if (DiskManagerRandomReadController.this.set_force_start) {
                        DiskManagerRandomReadController.this.download.setForceStart(false);
                    }
                }
                DiskManagerRandomReadController.this.timer_event.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskManagerRandomReadRequest addRequest(DiskManagerFileInfoImpl file, long file_offset, long length, boolean reverse_order, DiskManagerListener listener) {
        DiskManagerRandomReadRequestImpl request2 = new DiskManagerRandomReadRequestImpl(file, file_offset, length, reverse_order, listener);
        long file_length = file.getLength();
        if (file_offset >= file_length) {
            Debug.out("Invalid request offset: " + file_offset + ", file length=" + file_length);
            return null;
        }
        if (file_offset + length > file_length) {
            Debug.out("Invalid request length: " + file_offset + "/" + length + ", file length=" + file_length);
            return null;
        }
        List<DiskManagerRandomReadRequestImpl> list = this.requests;
        synchronized (list) {
            this.requests.add(request2);
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    DiskManagerRandomReadController.this.busy = true;
                    DiskManagerRandomReadController.this.executeRequest();
                }
                finally {
                    DiskManagerRandomReadController.this.busy = false;
                    DiskManagerRandomReadController.this.last_busy_time = SystemTime.getMonotonousTime();
                }
            }
        });
        return request2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeRequest() {
        block60: {
            var2_1 = this.requests;
            synchronized (var2_1) {
                if (this.requests.isEmpty()) {
                    return;
                }
                request = this.requests.remove(0);
            }
            if (DiskManagerRandomReadRequestImpl.access$2(request)) {
                return;
            }
            info_listener = null;
            core_file = request.getFile().getCore();
            core_download = core_file.getDownloadManager();
            prev_hint_piece = -1;
            curr_hint_piece = -1;
            try {
                try {
                    if (core_download.getTorrent() == null) {
                        throw new DownloadException("Torrent invalid");
                    }
                    if (core_download.isDestroyed()) {
                        Debug.out("Download has been removed");
                        throw new DownloadException("Download has been removed");
                    }
                    tf = core_file.getTorrentFile();
                    torrent = tf.getTorrent();
                    tfs = torrent.getFiles();
                    core_file_start_byte = 0L;
                    i = 0;
                    while (i < core_file.getIndex()) {
                        core_file_start_byte += tfs[i].getLength();
                        ++i;
                    }
                    download_byte_start = core_file_start_byte + request.getOffset();
                    download_byte_end = download_byte_start + request.getLength();
                    piece_size = (int)tf.getTorrent().getPieceLength();
                    if (core_file.getDownloaded() != core_file.getLength()) {
                        if (core_file.isSkipped()) {
                            core_file.setSkipped(false);
                        }
                        if (!(force_start = this.download.isForceStart())) {
                            this.download.setForceStart(true);
                            this.set_force_start = true;
                            running_sem = new AESemaphore("rs");
                            dl_listener = new DownloadListener(){

                                @Override
                                public void stateChanged(Download download, int old_state, int new_state) {
                                    if (new_state == 4 || new_state == 5) {
                                        running_sem.release();
                                    }
                                }

                                @Override
                                public void positionChanged(Download download, int oldPosition, int newPosition) {
                                }
                            };
                            this.download.addListener(dl_listener);
                            try {
                                if (this.download.getState() != 4 && this.download.getState() != 5 && !running_sem.reserve(10000L)) {
                                    throw new DownloadException("timeout waiting for download to start");
                                }
                            }
                            finally {
                                this.download.removeListener(dl_listener);
                            }
                        }
                    }
                    is_reverse = request.isReverse();
                    wait_sem = new AESemaphore("rr:waiter");
                    info_listener = new DiskManagerFileInfoListener(){

                        @Override
                        public void dataWritten(long offset, long length, Object originator) {
                            wait_sem.release();
                        }

                        @Override
                        public void dataChecked(long offset, long length) {
                        }
                    };
                    start_time = SystemTime.getMonotonousTime();
                    has_started = false;
                    core_file.addListener(info_listener);
                    while (download_byte_start < download_byte_end) {
                        if (DiskManagerRandomReadRequestImpl.access$2(request)) {
                            throw new Exception("request cancelled");
                        }
                        now = SystemTime.getMonotonousTime();
                        piece_start = (int)(download_byte_start / (long)piece_size);
                        piece_start_offset = (int)(download_byte_start % (long)piece_size);
                        piece_end = (int)((download_byte_end - 1L) / (long)piece_size);
                        piece_end_offset = (int)((download_byte_end - 1L) % (long)piece_size) + 1;
                        pieces = null;
                        disk_manager = core_download.getDiskManager();
                        if (disk_manager != null) {
                            pieces = disk_manager.getPieces();
                        }
                        if (pieces != null) ** GOTO lbl81
                        if (core_file.getDownloaded() == core_file.getLength()) {
                            avail_start = download_byte_start;
                            avail_end = download_byte_end;
                        } else {
                            if (now - start_time < 10000L && !has_started) {
                                wait_sem.reserve(250L);
                                continue;
                            }
                            throw new Exception("download stopped");
lbl81:
                            // 1 sources

                            has_started = true;
                            if (is_reverse) {
                                min_done = download_byte_end;
                                i = piece_end;
                                while (i >= piece_start) {
                                    p_start = i == piece_start ? piece_start_offset : 0;
                                    p_end = i == piece_end ? piece_end_offset : piece_size;
                                    piece = pieces[i];
                                    done = piece.getWritten();
                                    if (done == null) {
                                        if (!piece.isDone()) break;
                                        min_done = (long)i * (long)piece_size;
                                    } else {
                                        block_size = piece.getBlockSize(0);
                                        first_block = p_start / block_size;
                                        j = last_block = (p_end - 1) / block_size;
                                        while (j >= first_block) {
                                            if (!done[j]) break;
                                            min_done = (long)i * (long)piece_size + (long)(j * block_size);
                                            --j;
                                        }
                                    }
                                    --i;
                                }
                                avail_start = Math.max(download_byte_start, min_done);
                                avail_end = download_byte_end;
                            } else {
                                max_done = download_byte_start;
                                i = piece_start;
                                while (i <= piece_end) {
                                    p_start = i == piece_start ? piece_start_offset : 0;
                                    p_end = i == piece_end ? piece_end_offset : piece_size;
                                    piece = pieces[i];
                                    done = piece.getWritten();
                                    if (done == null) {
                                        if (!piece.isDone()) break;
                                        max_done = (long)(i + 1) * (long)piece_size;
                                    } else {
                                        block_size = piece.getBlockSize(0);
                                        first_block = p_start / block_size;
                                        last_block = (p_end - 1) / block_size;
                                        j = first_block;
                                        while (j <= last_block) {
                                            if (!done[j]) break;
                                            max_done = (long)i * (long)piece_size + (long)((j + 1) * block_size);
                                            ++j;
                                        }
                                    }
                                    ++i;
                                }
                                avail_start = download_byte_start;
                                avail_end = Math.min(download_byte_end, max_done);
                            }
                        }
                        max_chunk = 131072;
                        if (avail_end > avail_start) {
                            length = avail_end - avail_start;
                            if (length > (long)max_chunk) {
                                if (is_reverse) {
                                    avail_start = avail_end - (long)max_chunk;
                                } else {
                                    avail_end = avail_start + (long)max_chunk;
                                }
                            }
                            read_offset = avail_start - core_file_start_byte;
                            read_length = (int)(avail_end - avail_start);
                            buffer = core_file.read(read_offset, read_length);
                            DiskManagerRandomReadRequestImpl.access$3(request, buffer, read_offset, read_length);
                            if (is_reverse) {
                                download_byte_end = avail_start;
                                continue;
                            }
                            download_byte_start = avail_end;
                            continue;
                        }
                        pm = core_download.getPeerManager();
                        if (pm == null) {
                            if (now - start_time < 10000L && !has_started) {
                                wait_sem.reserve(250L);
                                continue;
                            }
                            throw new Exception("download stopped");
                        }
                        has_started = true;
                        picker = pm.getPiecePicker();
                        picker.setReverseBlockOrder(is_reverse);
                        if (piece_start == piece_end) {
                            hint_piece = piece_start;
                            hint_offset = piece_start_offset;
                            hint_length = piece_end_offset - piece_start_offset;
                        } else if (is_reverse) {
                            hint_piece = piece_end;
                            hint_offset = 0;
                            hint_length = piece_end_offset;
                        } else {
                            hint_piece = piece_start;
                            hint_offset = piece_start_offset;
                            hint_length = piece_size - piece_start_offset;
                        }
                        if (curr_hint_piece == -1 && (existing = picker.getGlobalRequestHint()) != null) {
                            curr_hint_piece = existing[0];
                        }
                        picker.setGlobalRequestHint(hint_piece, hint_offset, hint_length);
                        if (hint_piece != curr_hint_piece) {
                            prev_hint_piece = curr_hint_piece;
                            curr_hint_piece = hint_piece;
                        }
                        if (prev_hint_piece != -1) {
                            this.clearHint(pm, prev_hint_piece);
                        }
                        wait_sem.reserve(250L);
                    }
                }
                catch (Throwable e) {
                    DiskManagerRandomReadRequestImpl.access$4(request, e);
                    pm = core_download.getPeerManager();
                    if (pm != null && (picker = pm.getPiecePicker()) != null) {
                        picker.setReverseBlockOrder(false);
                        picker.setGlobalRequestHint(-1, 0, 0);
                        if (curr_hint_piece != -1) {
                            this.clearHint(pm, curr_hint_piece);
                        }
                    }
                    if (info_listener != null) {
                        core_file.removeListener(info_listener);
                    }
                    break block60;
                }
            }
            catch (Throwable var45_58) {
                pm = core_download.getPeerManager();
                if (pm != null && (picker = pm.getPiecePicker()) != null) {
                    picker.setReverseBlockOrder(false);
                    picker.setGlobalRequestHint(-1, 0, 0);
                    if (curr_hint_piece != -1) {
                        this.clearHint(pm, curr_hint_piece);
                    }
                }
                if (info_listener != null) {
                    core_file.removeListener(info_listener);
                }
                throw var45_58;
            }
            pm = core_download.getPeerManager();
            if (pm != null && (picker = pm.getPiecePicker()) != null) {
                picker.setReverseBlockOrder(false);
                picker.setGlobalRequestHint(-1, 0, 0);
                if (curr_hint_piece != -1) {
                    this.clearHint(pm, curr_hint_piece);
                }
            }
            if (info_listener != null) {
                core_file.removeListener(info_listener);
            }
        }
    }

    private void clearHint(PEPeerManager pm, int hint_piece) {
        PEPiece piece = pm.getPiece(hint_piece);
        if (piece != null && piece.getReservedBy() != null) {
            piece.setReservedBy(null);
        }
        List<PEPeer> peers = pm.getPeers();
        for (PEPeer peer : peers) {
            int[] res = peer.getReservedPieceNumbers();
            if (res == null) continue;
            int[] nArray = res;
            int n = res.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i == hint_piece) {
                    peer.removeReservedPieceNumber(hint_piece);
                }
                ++n2;
            }
        }
    }

    private class DiskManagerRandomReadRequestImpl
    implements DiskManagerRandomReadRequest {
        private DiskManagerFileInfoImpl file;
        private long file_offset;
        private long length;
        private boolean reverse_order;
        private DiskManagerListener listener;
        private volatile boolean cancelled;
        private boolean failed;

        private DiskManagerRandomReadRequestImpl(DiskManagerFileInfoImpl _file, long _file_offset, long _length, boolean _reverse_order, DiskManagerListener _listener) {
            this.file = _file;
            this.file_offset = _file_offset;
            this.length = _length;
            this.reverse_order = _reverse_order;
            this.listener = _listener;
        }

        @Override
        public DiskManagerFileInfoImpl getFile() {
            return this.file;
        }

        @Override
        public long getOffset() {
            return this.file_offset;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public boolean isReverse() {
            return this.reverse_order;
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            List list = DiskManagerRandomReadController.this.requests;
            synchronized (list) {
                DiskManagerRandomReadController.this.requests.remove(this);
                this.cancelled = true;
            }
            this.failed(new Exception("request cancelled"));
        }

        private void dataAvailable(DirectByteBuffer buffer, final long offset, final int length) {
            final PooledByteBufferImpl p_buffer = new PooledByteBufferImpl(buffer);
            this.listener.eventOccurred(new DiskManagerEvent(){

                @Override
                public int getType() {
                    return 1;
                }

                @Override
                public long getOffset() {
                    return offset;
                }

                @Override
                public int getLength() {
                    return length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return p_buffer;
                }

                @Override
                public Throwable getFailure() {
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failed(final Throwable e) {
            Debug.out(e);
            List list = DiskManagerRandomReadController.this.requests;
            synchronized (list) {
                if (this.failed) {
                    return;
                }
                this.failed = true;
            }
            this.listener.eventOccurred(new DiskManagerEvent(){

                @Override
                public int getType() {
                    return 2;
                }

                @Override
                public long getOffset() {
                    return -1L;
                }

                @Override
                public int getLength() {
                    return -1;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return null;
                }

                @Override
                public Throwable getFailure() {
                    return e;
                }
            });
        }

        static /* synthetic */ boolean access$2(DiskManagerRandomReadRequestImpl diskManagerRandomReadRequestImpl) {
            return diskManagerRandomReadRequestImpl.isCancelled();
        }

        static /* synthetic */ void access$3(DiskManagerRandomReadRequestImpl diskManagerRandomReadRequestImpl, DirectByteBuffer directByteBuffer, long l, int n) {
            diskManagerRandomReadRequestImpl.dataAvailable(directByteBuffer, l, n);
        }

        static /* synthetic */ void access$4(DiskManagerRandomReadRequestImpl diskManagerRandomReadRequestImpl, Throwable throwable) {
            diskManagerRandomReadRequestImpl.failed(throwable);
        }
    }
}

