/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pifimpl.local.ddb;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.ddb.DistributedDatabaseContact;
import com.biglybt.pif.ddb.DistributedDatabaseEvent;
import com.biglybt.pif.ddb.DistributedDatabaseException;
import com.biglybt.pif.ddb.DistributedDatabaseKey;
import com.biglybt.pif.ddb.DistributedDatabaseKeyStats;
import com.biglybt.pif.ddb.DistributedDatabaseListener;
import com.biglybt.pif.ddb.DistributedDatabaseProgressListener;
import com.biglybt.pif.ddb.DistributedDatabaseTransferHandler;
import com.biglybt.pif.ddb.DistributedDatabaseTransferType;
import com.biglybt.pif.ddb.DistributedDatabaseValue;
import com.biglybt.pif.download.Download;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.ddb.DDBaseContactImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseHelpers;
import com.biglybt.pifimpl.local.ddb.DDBaseKeyImpl;
import com.biglybt.pifimpl.local.ddb.DDBaseTTTorrent;
import com.biglybt.pifimpl.local.ddb.DDBaseValueImpl;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.plugin.dht.DHTPluginContact;
import com.biglybt.plugin.dht.DHTPluginInterface;
import com.biglybt.plugin.dht.DHTPluginKeyStats;
import com.biglybt.plugin.dht.DHTPluginListener;
import com.biglybt.plugin.dht.DHTPluginOperationListener;
import com.biglybt.plugin.dht.DHTPluginProgressListener;
import com.biglybt.plugin.dht.DHTPluginTransferHandler;
import com.biglybt.plugin.dht.DHTPluginValue;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DDBaseImpl
implements DistributedDatabase {
    private static DDBaseImpl singleton;
    protected static AEMonitor class_mon;
    private Map<HashWrapper, DistributedDatabaseTransferHandler> transfer_map = new HashMap<HashWrapper, DistributedDatabaseTransferHandler>();
    private static boolean prefer_i2p;
    private static Map<DHTPluginInterface, DistributedDatabase> dht_pi_map;
    private final Core core;
    private final DDBaseTTTorrent torrent_transfer;
    private final String network;
    private DHTPluginInterface dht_use_accessor;
    private CopyOnWriteList<DistributedDatabaseListener> listeners = new CopyOnWriteList();

    static {
        class_mon = new AEMonitor("DDBaseImpl:class");
        COConfigurationManager.addAndFireParameterListener("Plugin.DHT.dht.prefer.i2p", new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                prefer_i2p = COConfigurationManager.getBooleanParameter(name, false);
            }
        });
        dht_pi_map = new HashMap<DHTPluginInterface, DistributedDatabase>();
    }

    public static DDBaseImpl getSingleton(Core core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DDBaseImpl(core);
            }
        }
        finally {
            class_mon.exit();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DistributedDatabase> getDDBs(Download download) {
        String[] networks;
        ArrayList<DistributedDatabase> result = new ArrayList<DistributedDatabase>();
        String[] stringArray = networks = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            if (net == "Public") {
                DDBaseImpl ddb = DDBaseImpl.getSingleton(CoreFactory.getSingleton());
                if (ddb.isAvailable()) {
                    result.add(ddb);
                }
            } else {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("download", download);
                DHTPluginInterface dpi = AEProxyFactory.getPluginDHTProxy("ddb", net, options);
                if (dpi != null) {
                    DistributedDatabase ddb;
                    Map<DHTPluginInterface, DistributedDatabase> map = dht_pi_map;
                    synchronized (map) {
                        ddb = dht_pi_map.get(dpi);
                        if (ddb == null) {
                            ddb = new DDBaseImpl(net, dpi);
                            dht_pi_map.put(dpi, ddb);
                        }
                    }
                    if (ddb.isAvailable()) {
                        result.add(ddb);
                    }
                }
            }
            ++n2;
        }
        if (prefer_i2p && result.size() > 1) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (((DistributedDatabase)it.next()).getNetwork() != "Public") continue;
                it.remove();
            }
        }
        return result;
    }

    public static List<DistributedDatabase> getDDBs(String[] networks) {
        return DDBaseImpl.getDDBs(networks, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DistributedDatabase> getDDBs(String[] networks, Map<String, Object> _options) {
        ArrayList<DistributedDatabase> result = new ArrayList<DistributedDatabase>();
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            if (net == "Public") {
                DDBaseImpl ddb = DDBaseImpl.getSingleton(CoreFactory.getSingleton());
                if (ddb.isAvailable()) {
                    result.add(ddb);
                }
            } else {
                DHTPluginInterface dpi;
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("networks", networks);
                if (_options != null) {
                    options.putAll(_options);
                }
                if ((dpi = AEProxyFactory.getPluginDHTProxy("ddb", net, options)) != null) {
                    DistributedDatabase ddb;
                    Map<DHTPluginInterface, DistributedDatabase> map = dht_pi_map;
                    synchronized (map) {
                        ddb = dht_pi_map.get(dpi);
                        if (ddb == null) {
                            ddb = new DDBaseImpl(net, dpi);
                            dht_pi_map.put(dpi, ddb);
                        }
                    }
                    if (ddb.isAvailable()) {
                        result.add(ddb);
                    }
                }
            }
            ++n2;
        }
        if (prefer_i2p && result.size() > 1) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (((DistributedDatabase)it.next()).getNetwork() != "Public") continue;
                it.remove();
            }
        }
        return result;
    }

    protected DDBaseImpl(Core _core) {
        this.core = _core;
        this.torrent_transfer = new DDBaseTTTorrent(this);
        this.network = "Public";
        this.grabDHT();
    }

    protected DDBaseImpl(String _net, DHTPluginInterface _dht) {
        this.network = _net;
        this.dht_use_accessor = _dht;
        this.core = null;
        this.torrent_transfer = new DDBaseTTTorrent(this);
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public DHTPluginInterface getDHTPlugin() {
        return this.dht_use_accessor;
    }

    public DDBaseTTTorrent getTTTorrent() {
        return this.torrent_transfer;
    }

    protected DHTPluginInterface grabDHT() {
        if (this.dht_use_accessor != null) {
            return this.dht_use_accessor;
        }
        try {
            PluginInterface dht_pi;
            class_mon.enter();
            if (this.dht_use_accessor == null && (dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class)) != null) {
                this.dht_use_accessor = (DHTPluginInterface)((Object)dht_pi.getPlugin());
                if (this.dht_use_accessor.isEnabled()) {
                    this.dht_use_accessor.addListener(new DHTPluginListener(){

                        @Override
                        public void localAddressChanged(DHTPluginContact local_contact) {
                            List list = DDBaseImpl.this.listeners.getList();
                            dbEvent ev = new dbEvent(10);
                            for (DistributedDatabaseListener l : list) {
                                try {
                                    l.event(ev);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                    try {
                        this.addTransferHandler(this.torrent_transfer, this.torrent_transfer);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return this.dht_use_accessor;
    }

    @Override
    public boolean isAvailable() {
        DHTPluginInterface dht = this.grabDHT();
        if (dht == null) {
            return false;
        }
        return dht.isEnabled();
    }

    @Override
    public boolean isInitialized() {
        DHTPluginInterface dht = this.grabDHT();
        if (dht == null) {
            return false;
        }
        return !dht.isInitialising();
    }

    @Override
    public boolean isExtendedUseAllowed() {
        DHTPluginInterface dht = this.grabDHT();
        if (dht == null) {
            return false;
        }
        return dht.isExtendedUseAllowed();
    }

    protected boolean isTorrentXferEnabled() {
        PluginInterface dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi == null) {
            return false;
        }
        return ((DHTPlugin)dht_pi.getPlugin()).isTorrentXferEnabled();
    }

    @Override
    public DistributedDatabaseContact getLocalContact() {
        DHTPluginInterface dht = this.grabDHT();
        if (dht == null) {
            return null;
        }
        return new DDBaseContactImpl(this, dht.getLocalAddress());
    }

    protected void throwIfNotAvailable() throws DistributedDatabaseException {
        if (!this.isAvailable()) {
            throw new DistributedDatabaseException("DHT not available");
        }
    }

    protected DHTPluginInterface getDHT() throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return this.grabDHT();
    }

    protected void log(String str) {
        DHTPluginInterface dht = this.grabDHT();
        if (dht != null) {
            dht.log(str);
        }
    }

    @Override
    public DistributedDatabaseKey createKey(Object key) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(key);
    }

    @Override
    public DistributedDatabaseKey createKey(Object key, String description) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseKeyImpl(key, description);
    }

    @Override
    public DistributedDatabaseValue createValue(Object value) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        return new DDBaseValueImpl(new DDBaseContactImpl(this, this.getDHT().getLocalAddress()), value, SystemTime.getCurrentTime(), -1L);
    }

    @Override
    public DistributedDatabaseContact importContact(InetSocketAddress address) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact contact = this.getDHT().importContact(address);
        if (contact == null) {
            throw new DistributedDatabaseException("import of '" + address + "' failed");
        }
        return new DDBaseContactImpl(this, contact);
    }

    @Override
    public DistributedDatabaseContact importContact(InetSocketAddress address, byte version) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact contact = this.getDHT().importContact(address, version);
        if (contact == null) {
            throw new DistributedDatabaseException("import of '" + address + "' failed");
        }
        return new DDBaseContactImpl(this, contact);
    }

    @Override
    public DistributedDatabaseContact importContact(InetSocketAddress address, byte version, int preferred_dht) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact contact = this.getDHT().importContact(address, version, preferred_dht == 2);
        if (contact == null) {
            throw new DistributedDatabaseException("import of '" + address + "' failed");
        }
        return new DDBaseContactImpl(this, contact);
    }

    @Override
    public DistributedDatabaseContact importContact(Map<String, Object> map) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact contact = this.getDHT().importContact(map);
        if (contact == null) {
            throw new DistributedDatabaseException("import of '" + map + "' failed");
        }
        return new DDBaseContactImpl(this, contact);
    }

    @Override
    public void write(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        this.write(listener, key, new DistributedDatabaseValue[]{value});
    }

    @Override
    public void write(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseValue[] values) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        int i = 0;
        while (i < values.length) {
            if (((DDBaseValueImpl)values[i]).getBytes().length > DDBaseValueImpl.MAX_VALUE_SIZE) {
                throw new DistributedDatabaseException("Value size limited to " + DDBaseValueImpl.MAX_VALUE_SIZE + " bytes");
            }
            ++i;
        }
        int extra_flags = 0;
        int key_flags = key.getFlags();
        if ((key_flags & 1) != 0) {
            extra_flags = (byte)(extra_flags | 0x10);
        }
        if ((key_flags & 2) != 0) {
            extra_flags = (byte)(extra_flags | 0x40);
        }
        if (values.length == 0) {
            this.delete(listener, key);
        } else if (values.length == 1) {
            this.getDHT().put(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), ((DDBaseValueImpl)values[0]).getBytes(), (byte)(0 | extra_flags), new listenerMapper(listener, 1, key, 0L, false, false));
        } else {
            byte[] current_key = ((DDBaseKeyImpl)key).getBytes();
            byte[] payload = new byte[512];
            int payload_length = 1;
            int pos = 0;
            while (pos < values.length) {
                DDBaseValueImpl value = (DDBaseValueImpl)values[pos];
                byte[] bytes = value.getBytes();
                int len = bytes.length;
                if (payload_length + len < payload.length - 2) {
                    payload[payload_length++] = (byte)((len & 0xFF00) >> 8);
                    payload[payload_length++] = (byte)(len & 0xFF);
                    System.arraycopy(bytes, 0, payload, payload_length, len);
                    payload_length += len;
                    ++pos;
                    continue;
                }
                payload[0] = 1;
                byte[] copy = new byte[payload_length];
                System.arraycopy(payload, 0, copy, 0, copy.length);
                byte[] f_current_key = current_key;
                this.getDHT().put(f_current_key, key.getDescription(), copy, (byte)(4 | extra_flags), new listenerMapper(listener, 1, key, 0L, false, false));
                payload_length = 1;
                current_key = new SHA1Simple().calculateHash(current_key);
            }
            if (payload_length > 1) {
                payload[0] = 0;
                byte[] copy = new byte[payload_length];
                System.arraycopy(payload, 0, copy, 0, copy.length);
                byte[] f_current_key = current_key;
                this.getDHT().put(f_current_key, key.getDescription(), copy, (byte)(4 | extra_flags), new listenerMapper(listener, 1, key, 0L, false, false));
            }
        }
    }

    @Override
    public void read(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        this.read(listener, key, timeout, 0);
    }

    @Override
    public void read(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout, int options) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        boolean exhaustive = (options & 1) != 0;
        boolean high_priority = (options & 2) != 0;
        this.getDHT().get(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), (byte)0, 256, timeout, exhaustive, high_priority, new listenerMapper(listener, 2, key, timeout, exhaustive, high_priority));
    }

    @Override
    public void readKeyStats(DistributedDatabaseListener listener, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().get(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), (byte)8, 256, timeout, false, false, new listenerMapper(listener, 6, key, timeout, false, false));
    }

    @Override
    public List<DistributedDatabaseValue> getValues(DistributedDatabaseKey key) throws DistributedDatabaseException {
        List<DHTPluginValue> values = this.getDHT().getValues(((DDBaseKeyImpl)key).getBytes());
        ArrayList<DistributedDatabaseValue> result = new ArrayList<DistributedDatabaseValue>(values.size());
        for (DHTPluginValue v : values) {
            DDBaseContactImpl originator = null;
            DDBaseValueImpl value = new DDBaseValueImpl(originator, v.getValue(), v.getCreationTime(), v.getVersion());
            result.add(value);
        }
        return result;
    }

    @Override
    public void delete(DistributedDatabaseListener listener, DistributedDatabaseKey key) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        this.getDHT().remove(((DDBaseKeyImpl)key).getBytes(), key.getDescription(), new listenerMapper(listener, 3, key, 0L, false, false));
    }

    @Override
    public void delete(DistributedDatabaseListener listener, DistributedDatabaseKey key, DistributedDatabaseContact[] targets) throws DistributedDatabaseException {
        this.throwIfNotAvailable();
        DHTPluginContact[] plugin_targets = new DHTPluginContact[targets.length];
        int i = 0;
        while (i < targets.length) {
            plugin_targets[i] = ((DDBaseContactImpl)targets[i]).getContact();
            ++i;
        }
        this.getDHT().remove(plugin_targets, ((DDBaseKeyImpl)key).getBytes(), key.getDescription(), (DHTPluginOperationListener)new listenerMapper(listener, 3, key, 0L, false, false));
    }

    @Override
    public void addTransferHandler(final DistributedDatabaseTransferType type, final DistributedDatabaseTransferHandler handler) throws DistributedDatabaseException {
        String handler_name;
        this.throwIfNotAvailable();
        HashWrapper type_key = DDBaseHelpers.getKey(type);
        if (this.transfer_map.get(type_key) != null) {
            throw new DistributedDatabaseException("Handler for class '" + type.getClass().getName() + "' already defined");
        }
        this.transfer_map.put(type_key, handler);
        if (type == this.torrent_transfer) {
            handler_name = "Torrent Transfer";
        } else {
            String class_name = type.getClass().getName();
            int pos = class_name.indexOf(36);
            if (pos != -1) {
                class_name = class_name.substring(pos + 1);
            } else {
                pos = class_name.lastIndexOf(46);
                if (pos != -1) {
                    class_name = class_name.substring(pos + 1);
                }
            }
            handler_name = "Plugin Defined (" + class_name + ")";
        }
        this.getDHT().registerHandler(type_key.getHash(), new DHTPluginTransferHandler(){

            @Override
            public String getName() {
                return handler_name;
            }

            @Override
            public byte[] handleRead(DHTPluginContact originator, byte[] xfer_key) {
                DDBaseValueImpl res;
                block3: {
                    try {
                        res = (DDBaseValueImpl)handler.read(new DDBaseContactImpl(DDBaseImpl.this, originator), type, new DDBaseKeyImpl(xfer_key));
                        if (res != null) break block3;
                        return null;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        return null;
                    }
                }
                return res.getBytes();
            }

            @Override
            public byte[] handleWrite(DHTPluginContact originator, byte[] xfer_key, byte[] value) {
                DDBaseValueImpl res;
                block3: {
                    try {
                        DDBaseContactImpl contact = new DDBaseContactImpl(DDBaseImpl.this, originator);
                        res = (DDBaseValueImpl)handler.write(contact, type, new DDBaseKeyImpl(xfer_key), new DDBaseValueImpl(contact, value, SystemTime.getCurrentTime(), -1L));
                        if (res != null) break block3;
                        return null;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        return null;
                    }
                }
                return res.getBytes();
            }
        }, null);
    }

    @Override
    public DistributedDatabaseTransferType getStandardTransferType(int standard_type) throws DistributedDatabaseException {
        if (standard_type == 1) {
            return this.torrent_transfer;
        }
        throw new DistributedDatabaseException("unknown type");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        if (type == this.torrent_transfer) {
            return this.torrent_transfer.read(contact, listener, type, key, timeout);
        }
        DHTPluginContact plugin_contact = contact.getContact();
        byte[] data = plugin_contact.read(listener == null ? null : new DHTPluginProgressListener(){

            @Override
            public void reportSize(long size) {
                listener.reportSize(size);
            }

            @Override
            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            @Override
            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type).getHash(), ((DDBaseKeyImpl)key).getBytes(), timeout);
        if (data == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime(), -1L);
    }

    protected void write(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value, long timeout) throws DistributedDatabaseException {
        DHTPluginContact plugin_contact = contact.getContact();
        plugin_contact.write(listener == null ? null : new DHTPluginProgressListener(){

            @Override
            public void reportSize(long size) {
                listener.reportSize(size);
            }

            @Override
            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            @Override
            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type).getHash(), ((DDBaseKeyImpl)key).getBytes(), ((DDBaseValueImpl)value).getBytes(), timeout);
    }

    protected DistributedDatabaseValue call(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseValue value, long timeout) throws DistributedDatabaseException {
        DHTPluginContact plugin_contact = contact.getContact();
        byte[] data = plugin_contact.call(listener == null ? null : new DHTPluginProgressListener(){

            @Override
            public void reportSize(long size) {
                listener.reportSize(size);
            }

            @Override
            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            @Override
            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type).getHash(), ((DDBaseValueImpl)value).getBytes(), timeout);
        if (data == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime(), -1L);
    }

    @Override
    public void addListener(DistributedDatabaseListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(DistributedDatabaseListener l) {
        this.listeners.remove(l);
    }

    protected class dbEvent
    implements DistributedDatabaseEvent {
        private int type;
        private DistributedDatabaseKey key;
        private DistributedDatabaseKeyStats key_stats;
        private DistributedDatabaseValue value;
        private DDBaseContactImpl contact;

        protected dbEvent(int _type) {
            this.type = _type;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key) {
            this.type = _type;
            this.key = _key;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, DHTPluginValue _value) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.value = new DDBaseValueImpl(this.contact, _value.getValue(), _value.getCreationTime(), _value.getVersion());
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, DistributedDatabaseKeyStats _key_stats) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.key_stats = _key_stats;
        }

        protected dbEvent(int _type, DistributedDatabaseKey _key, DHTPluginContact _contact, byte[] _value, long _ct, long _v) {
            this.type = _type;
            this.key = _key;
            this.contact = new DDBaseContactImpl(DDBaseImpl.this, _contact);
            this.value = new DDBaseValueImpl(this.contact, _value, _ct, _v);
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public DistributedDatabaseKey getKey() {
            return this.key;
        }

        @Override
        public DistributedDatabaseKeyStats getKeyStats() {
            return this.key_stats;
        }

        @Override
        public DistributedDatabaseValue getValue() {
            return this.value;
        }

        @Override
        public DistributedDatabaseContact getContact() {
            return this.contact;
        }
    }

    protected class listenerMapper
    implements DHTPluginOperationListener {
        private DistributedDatabaseListener listener;
        private int type;
        private DistributedDatabaseKey key;
        private byte[] key_bytes;
        private long timeout;
        private boolean complete_disabled;
        private boolean exhaustive;
        private boolean high_priority;
        private int continuation_num;

        protected listenerMapper(DistributedDatabaseListener _listener, int _type, DistributedDatabaseKey _key, long _timeout, boolean _exhaustive, boolean _high_priority) {
            this.listener = _listener;
            this.type = _type;
            this.key = _key;
            this.key_bytes = ((DDBaseKeyImpl)this.key).getBytes();
            this.timeout = _timeout;
            this.exhaustive = _exhaustive;
            this.high_priority = _high_priority;
            this.continuation_num = 1;
        }

        private listenerMapper(DistributedDatabaseListener _listener, int _type, DistributedDatabaseKey _key, byte[] _key_bytes, long _timeout, int _continuation_num) {
            this.listener = _listener;
            this.type = _type;
            this.key = _key;
            this.key_bytes = _key_bytes;
            this.timeout = _timeout;
            this.continuation_num = _continuation_num;
        }

        @Override
        public boolean diversified() {
            this.listener.event(new dbEvent(8, this.key));
            return true;
        }

        @Override
        public void starts(byte[] _key) {
            this.listener.event(new dbEvent(7, this.key));
        }

        @Override
        public void valueRead(DHTPluginContact originator, DHTPluginValue _value) {
            if (this.type == 6) {
                if ((_value.getFlags() & 8) == 0) {
                    return;
                }
                try {
                    final DHTPluginKeyStats stats2 = DDBaseImpl.this.getDHT().decodeStats(_value);
                    if (stats2 != null) {
                        DistributedDatabaseKeyStats ddb_stats = new DistributedDatabaseKeyStats(){

                            @Override
                            public int getEntryCount() {
                                return stats2.getEntryCount();
                            }

                            @Override
                            public int getSize() {
                                return stats2.getSize();
                            }

                            @Override
                            public int getReadsPerMinute() {
                                return stats2.getReadsPerMinute();
                            }

                            @Override
                            public byte getDiversification() {
                                return stats2.getDiversification();
                            }
                        };
                        this.listener.event(new dbEvent(this.type, this.key, originator, ddb_stats));
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                byte[] value = _value.getValue();
                if (_value.getFlags() == 4) {
                    int pos = 1;
                    while (pos < value.length) {
                        int len;
                        if ((len = (value[pos++] << 8 & 0xFF00) + (value[pos++] & 0xFF)) > value.length - pos) {
                            Debug.out("Invalid length: len = " + len + ", remaining = " + (value.length - pos));
                            break;
                        }
                        byte[] d = new byte[len];
                        System.arraycopy(value, pos, d, 0, len);
                        this.listener.event(new dbEvent(this.type, this.key, originator, d, _value.getCreationTime(), _value.getVersion()));
                        pos += len;
                    }
                    if (value[0] == 1) {
                        byte[] next_key_bytes = new SHA1Simple().calculateHash(this.key_bytes);
                        this.complete_disabled = true;
                        DDBaseImpl.this.grabDHT().get(next_key_bytes, String.valueOf(this.key.getDescription()) + " [continuation " + this.continuation_num + "]", (byte)0, 256, this.timeout, this.exhaustive, this.high_priority, new listenerMapper(this.listener, 2, this.key, next_key_bytes, this.timeout, this.continuation_num + 1));
                    }
                } else {
                    this.listener.event(new dbEvent(this.type, this.key, originator, _value));
                }
            }
        }

        @Override
        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            this.listener.event(new dbEvent(this.type, this.key, target, value));
        }

        @Override
        public void complete(byte[] timeout_key, boolean timeout_occurred) {
            if (!this.complete_disabled) {
                this.listener.event(new dbEvent(timeout_occurred ? 5 : 4, this.key));
            }
        }
    }
}

