/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.utils;

import com.biglybt.pif.PluginException;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.tag.Tag;
import com.biglybt.pif.tag.TagManager;
import com.biglybt.pif.utils.AggregatedDispatcher;
import com.biglybt.pif.utils.AggregatedList;
import com.biglybt.pif.utils.AggregatedListAcceptor;
import com.biglybt.pif.utils.ByteArrayWrapper;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.Formatters;
import com.biglybt.pif.utils.LocaleUtilities;
import com.biglybt.pif.utils.LocationProvider;
import com.biglybt.pif.utils.LocationProviderListener;
import com.biglybt.pif.utils.Monitor;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pif.utils.PowerManagementListener;
import com.biglybt.pif.utils.ScriptProvider;
import com.biglybt.pif.utils.Semaphore;
import com.biglybt.pif.utils.UTTimer;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderException;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderFactory;
import com.biglybt.pif.utils.resourceuploader.ResourceUploaderFactory;
import com.biglybt.pif.utils.search.SearchException;
import com.biglybt.pif.utils.search.SearchInitiator;
import com.biglybt.pif.utils.search.SearchProvider;
import com.biglybt.pif.utils.security.SESecurityManager;
import com.biglybt.pif.utils.subscriptions.SubscriptionException;
import com.biglybt.pif.utils.subscriptions.SubscriptionManager;
import com.biglybt.pif.utils.xml.rss.RSSFeed;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface Utilities {
    public String getUserDir();

    public String getProgramDir();

    public boolean isCVSVersion();

    public boolean isWindows();

    public boolean isLinux();

    public boolean isSolaris();

    public boolean isOSX();

    public boolean isUnix();

    public boolean isFreeBSD();

    public InputStream getImageAsStream(String var1);

    public Semaphore getSemaphore();

    public Monitor getMonitor();

    public ByteBuffer allocateDirectByteBuffer(int var1);

    public void freeDirectByteBuffer(ByteBuffer var1);

    public PooledByteBuffer allocatePooledByteBuffer(int var1);

    public PooledByteBuffer allocatePooledByteBuffer(byte[] var1);

    public PooledByteBuffer allocatePooledByteBuffer(Map var1) throws IOException;

    public Formatters getFormatters();

    public LocaleUtilities getLocaleUtilities();

    public UTTimer createTimer(String var1);

    public UTTimer createTimer(String var1, boolean var2);

    public UTTimer createTimer(String var1, int var2);

    public UTTimer createTimer(String var1, int var2, int var3);

    public void createThread(String var1, Runnable var2);

    public void createProcess(String var1) throws PluginException;

    public void createProcess(File var1, String[] var2, String[] var3) throws PluginException;

    public ResourceDownloaderFactory getResourceDownloaderFactory();

    public ResourceUploaderFactory getResourceUploaderFactory();

    public SESecurityManager getSecurityManager();

    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory();

    public RSSFeed getRSSFeed(URL var1, InputStream var2) throws SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(URL var1) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(URL var1, ResourceDownloader var2) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public InetAddress getPublicAddress();

    public InetAddress getPublicAddress(boolean var1);

    public String reverseDNSLookup(InetAddress var1);

    public long getCurrentSystemTime();

    public ByteArrayWrapper createWrapper(byte[] var1);

    public AggregatedDispatcher createAggregatedDispatcher(long var1, long var3);

    public AggregatedList createAggregatedList(AggregatedListAcceptor var1, long var2, long var4);

    public Map readResilientBEncodedFile(File var1, String var2, boolean var3);

    public void writeResilientBEncodedFile(File var1, String var2, Map var3, boolean var4);

    public void deleteResilientBEncodedFile(File var1, String var2, boolean var3);

    public int compareVersions(String var1, String var2);

    public String normaliseFileName(String var1);

    public DelayedTask createDelayedTask(Runnable var1);

    public void registerSearchProvider(SearchProvider var1) throws SearchException;

    public void unregisterSearchProvider(SearchProvider var1) throws SearchException;

    public SearchInitiator getSearchInitiator() throws SearchException;

    public SubscriptionManager getSubscriptionManager() throws SubscriptionException;

    public boolean supportsPowerStateControl(int var1);

    public void addPowerManagementListener(PowerManagementListener var1);

    public void removePowerManagementListener(PowerManagementListener var1);

    public List<LocationProvider> getLocationProviders();

    public void addLocationProvider(LocationProvider var1);

    public void removeLocationProvider(LocationProvider var1);

    public void addLocationProviderListener(LocationProviderListener var1);

    public void removeLocationProviderListener(LocationProviderListener var1);

    public void registerJSONRPCServer(JSONServer var1);

    public void unregisterJSONRPCServer(JSONServer var1);

    public void registerJSONRPCClient(JSONClient var1);

    public void unregisterJSONRPCClient(JSONClient var1);

    public List<DistributedDatabase> getDistributedDatabases(String[] var1);

    public List<DistributedDatabase> getDistributedDatabases(String[] var1, Map<String, Object> var2);

    public List<ScriptProvider> getScriptProviders();

    public void registerScriptProvider(ScriptProvider var1);

    public void unregisterScriptProvider(ScriptProvider var1);

    public void addScriptProviderListener(ScriptProvider.ScriptProviderListener var1);

    public void removeScriptProviderListener(ScriptProvider.ScriptProviderListener var1);

    public TagManager getTagManager();

    public Tag lookupTag(String var1);

    public static interface JSONClient {
        public void serverRegistered(JSONServer var1);

        public void serverUnregistered(JSONServer var1);
    }

    public static interface JSONServer {
        public String getName();

        public List<String> getSupportedMethods();

        public Map call(String var1, Map var2) throws PluginException;
    }
}

