/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.network;

import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.messaging.MessageStreamEncoder;
import com.biglybt.pif.network.OutgoingMessageQueueListener;

public interface OutgoingMessageQueue {
    public void setEncoder(MessageStreamEncoder var1);

    public void sendMessage(Message var1);

    public void registerListener(OutgoingMessageQueueListener var1);

    public void deregisterListener(OutgoingMessageQueueListener var1);

    public void notifyOfExternalSend(Message var1);

    default public int getPercentDoneOfCurrentMessage() {
        int[] progress = this.getCurrentMessageProgress();
        if (progress == null) {
            return -1;
        }
        int length = progress[0];
        int done = progress[1];
        if (length <= 0) {
            return -1;
        }
        if (done >= length) {
            return 100;
        }
        return done * 100 / length;
    }

    public int[] getCurrentMessageProgress();

    public int getDataQueuedBytes();

    public int getProtocolQueuedBytes();

    public boolean isBlocked();
}

