/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.network;

import com.biglybt.pif.messaging.Message;
import com.biglybt.pif.network.IncomingMessageQueueListener;
import java.io.IOException;

public interface IncomingMessageQueue {
    public void registerListener(IncomingMessageQueueListener var1);

    public void registerPriorityListener(IncomingMessageQueueListener var1);

    public void deregisterListener(IncomingMessageQueueListener var1);

    public void notifyOfExternalReceive(Message var1) throws IOException;

    default public int getPercentDoneOfCurrentMessage() {
        int[] progress = this.getCurrentMessageProgress();
        if (progress == null) {
            return -1;
        }
        int length = progress[0];
        int done = progress[1];
        if (length <= 0) {
            return -1;
        }
        if (done >= length) {
            return 100;
        }
        return done * 100 / length;
    }

    public int[] getCurrentMessageProgress();
}

