/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.pif.download.savelocation;

import com.biglybt.core.util.FileUtil;
import java.io.File;

public class SaveLocationChange {
    public File download_location = null;
    public String download_name = null;
    public File torrent_location = null;
    public String torrent_name = null;

    public final String toString() {
        StringBuilder res = new StringBuilder("SaveLocationChange: ");
        res.append("DL-LOC=");
        res.append(this.download_location);
        res.append(", DL-NAME=");
        res.append(this.download_name);
        res.append(", TOR-LOC=");
        res.append(this.torrent_location);
        res.append(", TOR-NAME=");
        res.append(this.torrent_name);
        return res.toString();
    }

    public String getString() {
        return this.toString();
    }

    public final File normaliseTorrentLocation(File old_torrent_location) {
        return this.normaliseTorrentLocation(old_torrent_location.getParentFile(), old_torrent_location.getName());
    }

    public final File normaliseTorrentLocation(File old_torrent_directory, String old_torrent_name) {
        return FileUtil.newFile(this.torrent_location != null ? this.torrent_location : old_torrent_directory, this.torrent_name != null ? this.torrent_name : old_torrent_name);
    }

    public final File normaliseDownloadLocation(File old_download_location) {
        return this.normaliseDownloadLocation(old_download_location.getParentFile(), old_download_location.getName());
    }

    public final File normaliseDownloadLocation(File old_download_directory, String old_download_name) {
        return FileUtil.newFile(this.download_location != null ? this.download_location : old_download_directory, this.download_name != null ? this.download_name : old_download_name);
    }

    public final boolean hasDownloadChange() {
        return this.download_location != null || this.download_name != null;
    }

    public final boolean hasTorrentChange() {
        return this.torrent_location != null || this.torrent_name != null;
    }

    public final boolean isDifferentDownloadLocation(File current_location) {
        if (!this.hasDownloadChange()) {
            return false;
        }
        return !FileUtil.areFilePathsIdentical(current_location, this.normaliseDownloadLocation(current_location));
    }

    public final boolean isDifferentTorrentLocation(File current_location) {
        if (!this.hasTorrentChange()) {
            return false;
        }
        return !FileUtil.areFilePathsIdentical(current_location, this.normaliseTorrentLocation(current_location));
    }
}

