/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.net.udp.uc;

import com.biglybt.core.dht.transport.udp.DHTTransportUDP;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.RandomUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public abstract class PRUDPPacket {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int DEFAULT_UDP_TIMEOUT = 30000;
    private static int next_id = RandomUtils.nextInt();
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacket");
    private InetSocketAddress address;
    private int type;
    private int transaction_id;
    private PRUDPPacket previous_packet;
    private int serialised_size;

    protected PRUDPPacket(int _type, int _transaction_id) {
        this.type = _type;
        this.transaction_id = _transaction_id;
    }

    protected PRUDPPacket(int _type) {
        this.type = _type;
        try {
            class_mon.enter();
            this.transaction_id = next_id++;
        }
        finally {
            class_mon.exit();
        }
    }

    public void setSerialisedSize(int len) {
        this.serialised_size = len;
    }

    public int getSerialisedSize() {
        return this.serialised_size;
    }

    public boolean hasContinuation() {
        return false;
    }

    public void setPreviousPacket(PRUDPPacket p) {
        this.previous_packet = p;
    }

    public PRUDPPacket getPreviousPacket() {
        return this.previous_packet;
    }

    public void setAddress(InetSocketAddress _address) {
        this.address = _address;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getAction() {
        return this.type;
    }

    public int getTransactionId() {
        return this.transaction_id;
    }

    public abstract void serialise(DataOutputStream var1) throws IOException;

    protected byte getMinimumProtocolVersion(int network) {
        if (network == 1) {
            return DHTTransportUDP.PROTOCOL_VERSION_MIN_AZ_CVS;
        }
        if (network == 0 || network == 3) {
            return DHTTransportUDP.PROTOCOL_VERSION_MIN_AZ;
        }
        return DHTTransportUDP.PROTOCOL_VERSION_MIN_BIGLYBT;
    }

    public String getString() {
        return "type=" + this.type + ",addr=" + this.address;
    }
}

