/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.launcher.classloading;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class PrimaryClassloader
extends URLClassLoader {
    private final ClassLoader packageLoader;
    private static final String packageName = PrimaryClassloader.class.getPackage().getName();

    public PrimaryClassloader(ClassLoader parent) {
        super(PrimaryClassloader.generateURLs(), parent.getParent());
        this.packageLoader = parent;
    }

    private static URL[] generateURLs() {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(File.pathSeparator);
        URL[] urls = new URL[paths.length + 1];
        try {
            int i = 0;
            while (i < paths.length) {
                urls[i] = new File(paths[i]).getCanonicalFile().toURI().toURL();
                ++i;
            }
            urls[urls.length - 1] = new File(".").getCanonicalFile().toURI().toURL();
        }
        catch (Exception e) {
            System.err.println("Invalid classpath detected\n");
            e.printStackTrace();
            System.exit(1);
        }
        return urls;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.startsWith(packageName)) {
            return super.loadClass(name, resolve);
        }
        return this.packageLoader.loadClass(name);
    }
}

