/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.launcher;

import java.lang.reflect.Method;

public class Launcher {
    private static final String OSName = System.getProperty("os.name");
    private static final boolean isOSX = OSName.toLowerCase().startsWith("mac os");
    private static volatile boolean done;

    public static void launch(final Class MainClass, final String[] args) {
        done = true;
        Thread.currentThread().setName("Launcher::bootstrap");
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Method main = MainClass.getDeclaredMethod("main", String[].class);
                    main.setAccessible(true);
                    main.invoke(null, new Object[]{args});
                }
                catch (Exception e) {
                    System.err.println("Launch failed");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        };
        if (isOSX) {
            runner.run();
        } else {
            new Thread(runner).start();
        }
    }

    public static boolean checkAndLaunch(Class MainClass, String[] args) {
        if (done) {
            return false;
        }
        Launcher.launch(MainClass, args);
        return true;
    }
}

