/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import java.io.IOException;
import java.io.InputStream;

public class UncloseableInputStream
extends InputStream {
    private final InputStream is;
    private boolean closed;

    public UncloseableInputStream(InputStream _is) {
        this.is = _is;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.available();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

