/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.Timer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;

public class SimpleTimer {
    public static final int TICK_MILLIS = 1000;
    protected static final Timer timer;
    private static volatile int tick_count;
    static final CopyOnWriteList<TimerTickReceiver> tick_receivers;

    static {
        tick_receivers = new CopyOnWriteList(true);
        timer = new Timer("Simple Timer", 32);
        timer.setIndestructable();
        timer.setWarnWhenFull();
        if (Constants.IS_CVS_VERSION) {
            timer.setSlowEventLimit(2500);
        }
        SimpleTimer.addPeriodicEvent("SimpleTimer:ticker", 1000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                tick_count = tick_count + 1;
                if (tick_receivers.size() > 0) {
                    long mono_now = SystemTime.getMonotonousTime();
                    for (TimerTickReceiver ttr : tick_receivers) {
                        try {
                            ttr.tick(mono_now, tick_count);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        });
    }

    public static TimerEvent addEvent(String name, long when, TimerEventPerformer performer) {
        TimerEvent res = timer.addEvent(name, when, performer);
        return res;
    }

    public static TimerEvent addEvent(String name, long when, boolean absolute, TimerEventPerformer performer) {
        TimerEvent res = timer.addEvent(name, when, absolute, performer);
        return res;
    }

    public static TimerEventPeriodic addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        TimerEventPeriodic res = timer.addPeriodicEvent(name, frequency, performer);
        return res;
    }

    public static TimerEventPeriodic addPeriodicEvent(String name, long frequency, boolean absolute, TimerEventPerformer performer) {
        TimerEventPeriodic res = timer.addPeriodicEvent(name, frequency, absolute, performer);
        return res;
    }

    public static void addTickReceiver(TimerTickReceiver receiver) {
        tick_receivers.add(receiver);
    }

    public static void removeTickReceiver(TimerTickReceiver receiver) {
        tick_receivers.remove(receiver);
    }

    public static int getTickCount() {
        return tick_count;
    }

    public static interface TimerTickReceiver {
        public void tick(long var1, int var3);
    }
}

