/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.Base32;
import java.security.SecureRandom;
import java.util.Random;

public class RandomUtils {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final String INSTANCE_ID;
    public static final SecureRandom SECURE_RANDOM;
    public static final int LISTEN_PORT_MIN = 10000;
    public static final int LISTEN_PORT_MAX = 65535;

    static {
        byte[] bytes = new byte[3];
        RANDOM.nextBytes(bytes);
        INSTANCE_ID = Base32.encode(bytes).toLowerCase();
        SECURE_RANDOM = new SecureRandom();
    }

    public static byte[] generateRandomBytes(int num_to_generate) {
        byte[] id = new byte[num_to_generate];
        RANDOM.nextBytes(id);
        return id;
    }

    public static String generateRandomAlphanumerics(int num_to_generate) {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder buff = new StringBuilder(num_to_generate);
        int i = 0;
        while (i < num_to_generate) {
            int pos = (int)(RANDOM.nextDouble() * (double)alphabet.length());
            buff.append(alphabet.charAt(pos));
            ++i;
        }
        return buff.toString();
    }

    public static int generateRandomNetworkListenPort() {
        return RandomUtils.generateRandomNetworkListenPort(10000, 65535);
    }

    public static int generateRandomNetworkListenPort(int min_port, int max_port) {
        if (min_port > max_port) {
            int temp = min_port;
            min_port = max_port;
            max_port = temp;
        }
        if (max_port > 65535) {
            max_port = 65535;
        }
        if (max_port < 1) {
            max_port = 1;
        }
        if (min_port < 1) {
            min_port = 1;
        }
        if (min_port > max_port) {
            min_port = max_port;
        }
        int existing_tcp = COConfigurationManager.getIntParameter("TCP.Listen.Port");
        int existing_udp = COConfigurationManager.getIntParameter("UDP.Listen.Port");
        int existing_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
        int port = min_port;
        int i = 0;
        while (i < 100) {
            int min = min_port;
            port = min + RANDOM.nextInt(max_port + 1 - min);
            if ((port < 45100 || port > 45110) && port != existing_tcp && port != existing_udp && port != existing_udp2) {
                return port;
            }
            ++i;
        }
        return port;
    }

    public static int generateRandomPlusMinus1() {
        return RANDOM.nextBoolean() ? -1 : 1;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static void nextBytes(byte[] bytes) {
        RANDOM.nextBytes(bytes);
    }

    public static void nextSecureBytes(byte[] bytes) {
        SECURE_RANDOM.nextBytes(bytes);
    }

    public static byte[] nextSecureHash() {
        byte[] hash = new byte[20];
        SECURE_RANDOM.nextBytes(hash);
        return hash;
    }

    public static byte[] nextHash() {
        byte[] hash = new byte[20];
        RANDOM.nextBytes(hash);
        return hash;
    }

    public static int nextInt(int n) {
        return RANDOM.nextInt(n);
    }

    public static byte nextByte() {
        return (byte)RANDOM.nextInt();
    }

    public static int nextInt() {
        return RANDOM.nextInt();
    }

    public static int nextAbsoluteInt() {
        return RANDOM.nextInt() << 1 >>> 1;
    }

    public static long nextLong() {
        return RANDOM.nextLong();
    }

    public static long nextLong(long n) {
        if (n > Integer.MAX_VALUE) {
            long res;
            long rand;
            while ((rand = RandomUtils.nextAbsoluteLong()) - (res = rand % n) + (n - 1L) < 0L) {
            }
            return res;
        }
        return RANDOM.nextInt((int)n);
    }

    public static long nextAbsoluteLong() {
        return RANDOM.nextLong() << 1 >>> 1;
    }

    public static long nextSecureAbsoluteLong() {
        long val;
        while ((val = Math.abs(SECURE_RANDOM.nextLong())) < 0L) {
        }
        return val;
    }

    public static int generateRandomIntUpto(int max) {
        return RandomUtils.nextInt(max);
    }

    public static int generateRandomIntBetween(int min, int max) {
        return min + RandomUtils.generateRandomIntUpto(max + 1 - min);
    }
}

