/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.IPToHostNameResolverListener;
import java.net.InetAddress;

public class IPToHostNameResolverRequest
extends AERunnable {
    protected final String ip;
    protected IPToHostNameResolverListener listener;

    protected IPToHostNameResolverRequest(String _ip, IPToHostNameResolverListener _listener) {
        this.ip = _ip;
        this.listener = _listener;
    }

    @Override
    public void runSupport() {
        IPToHostNameResolverListener l = this.listener;
        if (l != null) {
            if (AENetworkClassifier.categoriseAddress(this.ip) == "Public") {
                try {
                    InetAddress addr = InetAddress.getByName(this.ip);
                    l.IPResolutionComplete(addr.getHostName(), true);
                }
                catch (Throwable e) {
                    l.IPResolutionComplete(this.ip, false);
                }
            } else {
                l.IPResolutionComplete(this.ip, true);
            }
        }
    }

    public void cancel() {
        this.listener = null;
    }

    protected String getIP() {
        return this.ip;
    }

    protected IPToHostNameResolverListener getListener() {
        return this.listener;
    }
}

