/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Base32;
import com.biglybt.pif.utils.ByteArrayWrapper;
import java.util.Arrays;

public class HashWrapper
implements ByteArrayWrapper {
    private final byte[] hash;
    private int hash_code;

    public HashWrapper(byte[] _hash) {
        this(_hash, 0, _hash.length);
    }

    public HashWrapper(byte[] _hash, int offset, int length) {
        this.hash = new byte[length];
        System.arraycopy(_hash, offset, this.hash, 0, length);
        int i = 0;
        while (i < length) {
            this.hash_code = 31 * this.hash_code + this.hash[i];
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HashWrapper)) {
            return false;
        }
        byte[] otherHash = ((HashWrapper)o).getHash();
        return Arrays.equals(this.hash, otherHash);
    }

    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public byte[] getBytes() {
        return this.hash;
    }

    public int hashCode() {
        return this.hash_code;
    }

    @Override
    public String toBase32String() {
        return Base32.encode(this.hash);
    }
}

