/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Debug;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class DNSUtils {
    private static DNSUtilsIntf impl;

    static {
        String cla = System.getProperty("az.factory.dnsutils.impl", "com.biglybt.core.util.dns.DNSUtilsImpl");
        try {
            impl = (DNSUtilsIntf)Class.forName(cla).newInstance();
        }
        catch (Throwable e) {
            Debug.out("Failed to instantiate impl: " + cla, e);
        }
    }

    public static DNSUtilsIntf getSingleton() {
        return impl;
    }

    public static String getInterestingHostSuffix(String host) {
        int num_bits;
        if (host == null) {
            return null;
        }
        String[] bits = host.split("\\.");
        if (bits[(num_bits = bits.length) - 1].equals("dht")) {
            return null;
        }
        if (AENetworkClassifier.categoriseAddress(host) != "Public") {
            return host;
        }
        if (bits.length > 2) {
            boolean raw = true;
            char[] cArray = host.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '.' && c != ':' && !Character.isDigit(c)) {
                    raw = false;
                    break;
                }
                ++n2;
            }
            if (raw) {
                return null;
            }
            int hit = -1;
            int i = num_bits - 2;
            while (i >= 0) {
                String bit = bits[i];
                if (bit.length() > 3) {
                    hit = i;
                    break;
                }
                --i;
            }
            if (hit > 0) {
                host = "";
                i = hit;
                while (i < num_bits) {
                    host = String.valueOf(host) + (host == "" ? "" : ".") + bits[i];
                    ++i;
                }
            }
        }
        return host;
    }

    public static interface DNSDirContext {
        public String getString();
    }

    public static interface DNSUtilsIntf {
        public DNSDirContext getInitialDirContext() throws Exception;

        public DNSDirContext getDirContextForServer(String var1) throws Exception;

        public Inet4Address getIPV4ByName(String var1) throws UnknownHostException;

        public Inet6Address getIPV6ByName(String var1) throws UnknownHostException;

        public List<InetAddress> getAllByName(String var1) throws UnknownHostException;

        public List<InetAddress> getAllByName(DNSDirContext var1, String var2) throws UnknownHostException;

        public List<String> getTXTRecords(String var1);

        public String getTXTRecord(String var1) throws UnknownHostException;
    }
}

