/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class CopyOnWriteMap<K, V> {
    private volatile Map<K, V> map;
    private final boolean is_identify;
    private boolean visible = false;

    public CopyOnWriteMap() {
        this(false);
    }

    public CopyOnWriteMap(boolean identity_hash_map) {
        this.is_identify = identity_hash_map;
        this.map = this.is_identify ? new IdentityHashMap() : new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        V result;
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            if (this.visible) {
                AbstractMap new_map = this.is_identify ? new IdentityHashMap<K, V>(this.map) : new HashMap<K, V>(this.map);
                result = new_map.put(key, value);
                this.map = new_map;
                this.visible = false;
            } else {
                result = this.map.put(key, value);
            }
        }
        return result;
    }

    public void putAll(CopyOnWriteMap<K, V> all) {
        this.putAll(all.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<K, V> all) {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            if (this.visible) {
                AbstractMap new_map = this.is_identify ? new IdentityHashMap<K, V>(this.map) : new HashMap<K, V>(this.map);
                new_map.putAll(all);
                this.map = new_map;
                this.visible = false;
            } else {
                this.map.putAll(all);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        V result;
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            if (this.visible) {
                AbstractMap new_map = this.is_identify ? new IdentityHashMap<K, V>(this.map) : new HashMap<K, V>(this.map);
                result = new_map.remove(key);
                this.map = new_map;
                this.visible = false;
            } else {
                result = this.map.remove(key);
            }
        }
        return result;
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getReadOnlyMap() {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            this.visible = true;
            return this.map;
        }
    }
}

