/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.SystemProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Constants {
    public static final String PLUGINS_WEB_SITE = "https://plugins.biglybt.com/";
    public static final String URL_PLUGINS_TORRENT_BASE = "http://version.biglybt.com/biglybt-files/plugins/";
    public static final String URL_CLIENT_HOME = "https://www.biglybt.com/";
    public static final String URL_BUG_REPORTS = "https://bugs.biglybt.com/";
    public static final String URL_VOTE = "https://vote.biglybt.com/";
    public static final String URL_FORUMS = "https://forums.biglybt.com/";
    public static final String URL_WIKI = "https://wiki.biglybt.com/";
    public static final String URL_GETTING_STARTED = "https://biglybt.github.io/GettingStarted.html";
    public static final String URL_RPC = "https://rpc.biglybt.com/rpc.php";
    public static final String URL_RPC2 = "https://vrpc.vuze.com/vzrpc/rpc.php";
    @Deprecated
    public static final String URL_DEVICES_FAQ = "https://wiki.biglybt.com/w/FAQ_Devices";
    public static final String URL_DONATION = "https://www.biglybt.com/donation/donate.php";
    public static final String URL_WEBSEARCH = "https://www.google.com/search?q=%s%20torrent&newwindow=1";
    public static final String URL_SEARCH_ADDEDIT = "http://client.vuze.com/xsearch/addedit.php?azid=anonymous&azv=5.7.5.0&locale=en_US&os.name=Windows%207&vzemb=1";
    public static final String VERSION_SERVER_V4 = "version.biglybt.com";
    public static final String VERSION_SERVER_V6 = "version6.biglybt.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.biglybt.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.biglybt.com";
    public static final String DHT_SEED_ADDRESS_V6_TUNNEL = "dht6tunnel.biglybt.com";
    public static final String NAT_TEST_TCP_SERVER = "nettest.biglybt.com";
    public static final String NAT_TEST_TCP_SERVER_V6 = "nettest6.biglybt.com";
    public static final String NAT_TEST_UDP_SERVER = "nettestudp.biglybt.com";
    public static final String NAT_TEST_UDP_SERVER_V6 = "nettestudp6.biglybt.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.biglybt.com/";
    public static final String NAT_TEST_SERVER_V6_HTTP = "http://nettest.biglybt.com/";
    public static final String PAIRING_SERVER = "pair.biglybt.com";
    public static final String WEB_REMOTE_SERVER = "remote.biglybt.com";
    public static final String XMLNS_VUZE = "xmlns:vuze=\"http://www.vuze.com\"";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String[] APP_DOMAINS;
    public static final Charset UTF_8;
    public static final Charset ISO_8859_1;
    @Deprecated
    public static final String DEFAULT_ENCODING = "UTF8";
    @Deprecated
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static final Charset DEFAULT_ENCODING_CHARSET;
    public static final Charset BYTE_ENCODING_CHARSET;
    public static final int DEFAULT_INSTANCE_PORT = 6880;
    public static final int INSTANCE_PORT;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static final boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
    public static final String BIGLYBT_NAME = "BiglyBT";
    public static final String APP_NAME;
    public static final String DEFAULT_JAR_NAME = "BiglyBT";
    public static final String BIGLY_PROTOCOL_NAME = "BiglyBT";
    public static final String BIGLY_PEER_ID = "BI";
    public static final String BIGLYBT_VERSION = "3.4.0.0";
    public static final String SUBVERSION = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final String OSArch;
    public static final String OSVersion;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static final boolean isWindows8OrHigher;
    public static final boolean isWindows10OrHigher;
    public static final boolean isArm;
    public static final boolean is64Bit;
    public static final boolean isOS64Bit;
    public static final boolean isOSX_10_8_OrHigher;
    public static final boolean isAndroid;
    public static final String JAVA_VERSION;
    public static final int API_LEVEL;
    public static final boolean isJava7OrHigher;
    public static final boolean isJava8OrHigher;
    public static final boolean isJava9OrHigher;
    public static final boolean isJava10OrHigher;
    public static final boolean isJava11OrHigher;
    public static final boolean isJava12OrHigher;
    public static final boolean isJava18OrHigher;
    public static final String FILE_WILDCARD;
    public static final String AZUREUS_PROTOCOL_NAME_PRE_4813 = "Azureus";
    public static final String AZUREUS_PROTOCOL_NAME = "Vuze";
    public static final String AZUREUS_VERSION = "3.4.0.0";
    public static final String AZUREUS_NAME = "BiglyBT";

    static {
        boolean _18plus;
        boolean _12plus;
        boolean _11plus;
        boolean _10plus;
        boolean _9plus;
        boolean _8plus;
        boolean _is64Bit;
        int ip;
        APP_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com", "biglybt.com"};
        UTF_8 = StandardCharsets.UTF_8;
        ISO_8859_1 = StandardCharsets.ISO_8859_1;
        DEFAULT_ENCODING_CHARSET = UTF_8;
        BYTE_ENCODING_CHARSET = ISO_8859_1;
        String ip_str = System.getProperty(SystemProperties.SYSPROP_INSTANCE_PORT, String.valueOf(6880));
        try {
            ip = Integer.parseInt(ip_str);
        }
        catch (Throwable e) {
            ip = 6880;
        }
        INSTANCE_PORT = ip;
        LOCALE_ENGLISH = Locale.ENGLISH;
        try {
            String timezone = System.getProperty(SystemProperties.SYSPROP_APP_TIMEZONE, null);
            if (timezone != null) {
                TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        APP_NAME = System.getProperty(SystemProperties.SYSPROP_PRODUCT_NAME, "BiglyBT");
        VERSION_ID = "-BI3400-".getBytes();
        FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        IS_CVS_VERSION = Constants.isCVSVersion("3.4.0.0") && !FORCE_NON_CVS;
        OSName = System.getProperty("os.name", SUBVERSION);
        OSArch = System.getProperty("os.arch", SUBVERSION);
        OSVersion = System.getProperty("os.version", SUBVERSION);
        isOSX = OSName.toLowerCase().startsWith("mac os");
        isLinux = OSName.equalsIgnoreCase("Linux");
        isSolaris = OSName.equalsIgnoreCase("SunOS");
        isFreeBSD = OSName.equalsIgnoreCase("FreeBSD");
        isWindowsXP = OSName.equalsIgnoreCase("Windows XP");
        isWindows95 = OSName.equalsIgnoreCase("Windows 95");
        isWindows98 = OSName.equalsIgnoreCase("Windows 98");
        isWindows2000 = OSName.equalsIgnoreCase("Windows 2000");
        isWindowsME = OSName.equalsIgnoreCase("Windows ME");
        isWindows9598ME = isWindows95 || isWindows98 || isWindowsME;
        isSafeMode = false;
        isWindows = OSName.toLowerCase().startsWith("windows");
        isUnix = !isWindows && !isOSX;
        isArm = OSArch.startsWith("arm") || OSArch.startsWith("aarch");
        try {
            _is64Bit = OSArch.contains("64");
            if (!_is64Bit) {
                _is64Bit = System.getProperty("sun.arch.data.model").equals("64");
            }
        }
        catch (Throwable e) {
            _is64Bit = false;
        }
        boolean _isOS64Bit = is64Bit = _is64Bit;
        if (isWindows && !_isOS64Bit) {
            try {
                String pa = System.getenv("PROCESSOR_ARCHITECTURE");
                String wow_pa = System.getenv("PROCESSOR_ARCHITEW6432");
                _isOS64Bit = pa != null && pa.endsWith("64") || wow_pa != null && wow_pa.endsWith("64");
            }
            catch (Throwable pa) {
                // empty catch block
            }
        }
        isOS64Bit = _isOS64Bit;
        if (isWindows) {
            boolean vista_sp2_or_higher;
            block44: {
                Float ver = null;
                try {
                    ver = new Float(OSVersion);
                }
                catch (Throwable wow_pa) {
                    // empty catch block
                }
                vista_sp2_or_higher = false;
                if (ver == null) {
                    isWindowsVista = false;
                    isWindowsVistaOrHigher = false;
                    isWindows7OrHigher = false;
                    isWindows8OrHigher = false;
                    isWindows10OrHigher = false;
                } else {
                    float f_ver = ver.floatValue();
                    isWindowsVista = f_ver == 6.0f;
                    isWindowsVistaOrHigher = f_ver >= 6.0f;
                    isWindows7OrHigher = f_ver >= 6.1f;
                    isWindows8OrHigher = f_ver >= 6.2f;
                    boolean bl = isWindows10OrHigher = f_ver >= 10.0f;
                    if (isWindowsVista) {
                        BufferedReader lnr = null;
                        try {
                            try {
                                String line;
                                Process p = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                                lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                                    if (!line.matches(".*CSDVersion.*")) continue;
                                    vista_sp2_or_higher = line.matches(".*Service Pack [2-9]");
                                    break;
                                }
                            }
                            catch (Throwable p) {
                                if (lnr != null) {
                                    try {
                                        lnr.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            if (lnr != null) {
                                try {
                                    lnr.close();
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (lnr != null) {
                            try {
                                lnr.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            isWindowsVistaSP2OrHigher = vista_sp2_or_higher;
        } else {
            isWindowsVista = false;
            isWindowsVistaSP2OrHigher = false;
            isWindowsVistaOrHigher = false;
            isWindows7OrHigher = false;
            isWindows8OrHigher = false;
            isWindows10OrHigher = false;
        }
        if (isOSX) {
            int first_digit = 0;
            int second_digit = 0;
            try {
                String os_version = OSVersion;
                String[] bits = os_version.split("\\.");
                first_digit = Integer.parseInt(bits[0]);
                if (bits.length > 1) {
                    second_digit = Integer.parseInt(bits[1]);
                }
            }
            catch (Throwable os_version) {
                // empty catch block
            }
            isOSX_10_8_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 8;
        } else {
            isOSX_10_8_OrHigher = false;
        }
        isAndroid = System.getProperty("java.vm.name", SUBVERSION).equalsIgnoreCase("Dalvik") || System.getProperty("java.vendor", SUBVERSION).contains("Android");
        String java_version = isAndroid ? "1.8" : System.getProperty("java.version");
        int api_level = 0;
        if (isAndroid) {
            String sdk_int = System.getProperty("android.os.build.version.sdk_int", "0");
            try {
                api_level = Integer.parseInt(sdk_int);
            }
            catch (Throwable bits) {
                // empty catch block
            }
        }
        JAVA_VERSION = java_version;
        API_LEVEL = api_level;
        isJava7OrHigher = !isAndroid;
        try {
            int pos = JAVA_VERSION.indexOf(45);
            if (pos == -1) {
                pos = JAVA_VERSION.indexOf(43);
            }
            String version = pos == -1 ? JAVA_VERSION : JAVA_VERSION.substring(0, pos);
            String[] bits = version.split("\\.");
            int first = Integer.parseInt(bits[0]);
            int second = bits.length == 1 ? 0 : Integer.parseInt(bits[1]);
            _8plus = first > 1 || second >= 8;
            _9plus = first > 1 || second >= 9;
            _10plus = first >= 10;
            _11plus = first >= 11;
            _12plus = first >= 12;
            _18plus = first >= 18;
        }
        catch (Throwable e) {
            System.err.println("Unparsable Java version: " + JAVA_VERSION);
            e.printStackTrace();
            _8plus = false;
            _9plus = false;
            _10plus = false;
            _11plus = false;
            _12plus = false;
            _18plus = false;
        }
        isJava8OrHigher = _8plus;
        isJava9OrHigher = _9plus;
        isJava10OrHigher = _10plus;
        isJava11OrHigher = _11plus;
        isJava12OrHigher = _12plus;
        isJava18OrHigher = _18plus;
        FILE_WILDCARD = isWindows ? "*.*" : "*";
    }

    public static String getCurrentVersion() {
        return "3.4.0.0";
    }

    public static String getBaseVersion() {
        return Constants.getBaseVersion("3.4.0.0");
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String version) {
        return version.contains("_");
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild("3.4.0.0");
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static boolean isCurrentVersionLT(String version) {
        return Constants.compareVersions("3.4.0.0", version) < 0;
    }

    public static boolean isCurrentVersionGE(String version) {
        return Constants.compareVersions("3.4.0.0", version) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int compareVersions(String version_1, String version_2) {
        try {
            version_1 = version_1.replaceAll("_CVS", "_B100");
            version_2 = version_2.replaceAll("_CVS", "_B100");
            if (version_1.startsWith(".")) {
                version_1 = "0" + version_1;
            }
            if (version_2.startsWith(".")) {
                version_2 = "0" + version_2;
            }
            version_1 = version_1.replaceAll("[^0-9.]", ".");
            version_2 = version_2.replaceAll("[^0-9.]", ".");
            StringTokenizer tok1 = new StringTokenizer(version_1, ".");
            StringTokenizer tok2 = new StringTokenizer(version_2, ".");
            while (true) {
                int i1;
                if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                    int i2;
                    i1 = Integer.parseInt(tok1.nextToken());
                    if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                    return i1 - i2;
                }
                if (tok1.hasMoreTokens()) {
                    i1 = Integer.parseInt(tok1.nextToken());
                    if (i1 == 0) continue;
                    return 1;
                }
                if (!tok2.hasMoreTokens()) {
                    return 0;
                }
                int i2 = Integer.parseInt(tok2.nextToken());
                if (i2 != 0) break;
            }
            return -1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < version.length()) {
            char c = version.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                return false;
            }
            ++i;
        }
        return !version.startsWith(".") && !version.endsWith(".") && !version.contains("..");
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static boolean isAzureusDomain(String host) {
        return Constants.isAppDomain(host);
    }

    public static boolean isAppDomain(String host) {
        host = host.toLowerCase();
        int i = 0;
        while (i < APP_DOMAINS.length) {
            String domain = APP_DOMAINS[i];
            if (domain.equals(host)) {
                return true;
            }
            if (host.endsWith("." + domain)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

