/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.ConcurrentHasher;
import com.biglybt.core.util.ConcurrentHasherRequestListener;
import com.biglybt.core.util.SHA1Hasher;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class ConcurrentHasherRequest {
    private final int hash_version;
    private final ByteBuffer buffer;
    private final int piece_size;
    private final long v2_file_size;
    private List<List<byte[]>> v2_hash_tree;
    private ConcurrentHasherRequestListener listener;
    private final int size;
    private byte[] result;
    private boolean cancelled;
    private final boolean low_priority;
    private final AESemaphore sem = new AESemaphore("ConcHashRequest");

    protected ConcurrentHasherRequest(ConcurrentHasher _concurrent_hasher, ByteBuffer _buffer, int _hash_version, int _piece_size, long _v2_file_size, ConcurrentHasherRequestListener _listener, boolean _low_priorty) {
        this.hash_version = _hash_version;
        this.buffer = _buffer;
        this.piece_size = _piece_size;
        this.v2_file_size = _v2_file_size;
        this.listener = _listener;
        this.low_priority = _low_priorty;
        this.size = this.buffer.limit() - this.buffer.position();
    }

    public int getHashVersion() {
        return this.hash_version;
    }

    public byte[] getResult() {
        this.sem.reserve();
        return this.result;
    }

    public List<List<byte[]>> getHashTree() {
        return this.v2_hash_tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.cancelled) {
            ConcurrentHasherRequestListener listener_copy;
            this.cancelled = true;
            this.sem.releaseForever();
            ConcurrentHasherRequest concurrentHasherRequest = this;
            synchronized (concurrentHasherRequest) {
                listener_copy = this.listener;
                this.listener = null;
            }
            if (listener_copy != null) {
                listener_copy.complete(this);
            }
        }
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLowPriority() {
        return this.low_priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(SHA1Hasher hasher) {
        if (!this.cancelled) {
            this.result = hasher.calculateHash(this.buffer);
            this.sem.releaseForever();
            if (!this.cancelled) {
                ConcurrentHasherRequestListener listener_copy;
                ConcurrentHasherRequest concurrentHasherRequest = this;
                synchronized (concurrentHasherRequest) {
                    listener_copy = this.listener;
                    this.listener = null;
                }
                if (listener_copy != null) {
                    listener_copy.complete(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(MessageDigest hasher) {
        if (!this.cancelled) {
            long leaf_count;
            int block_size = 16384;
            int rem = this.buffer.remaining();
            int pos = this.buffer.position();
            ArrayList<byte[]> leaf_digests = new ArrayList<byte[]>(this.piece_size / block_size);
            while (rem > 0) {
                this.buffer.position(pos);
                int len = Math.min(rem, block_size);
                this.buffer.limit(pos + len);
                hasher.update(this.buffer);
                byte[] digest = hasher.digest();
                leaf_digests.add(digest);
                rem -= len;
                pos += len;
            }
            byte[] zero_buffer = new byte[hasher.getDigestLength()];
            if (this.v2_file_size < (long)this.piece_size) {
                long highestOneBit = Long.highestOneBit(this.v2_file_size);
                long leaf_width = this.v2_file_size == highestOneBit ? this.v2_file_size : highestOneBit << 1;
                leaf_count = leaf_width / (long)block_size;
                if (leaf_count == 0L) {
                    leaf_count = 1L;
                }
            } else {
                leaf_count = this.piece_size / block_size;
            }
            while ((long)leaf_digests.size() < leaf_count) {
                leaf_digests.add(zero_buffer);
            }
            ArrayList<byte[]> current_level = leaf_digests;
            this.v2_hash_tree = new ArrayList<List<byte[]>>(10);
            while (current_level.size() > 1) {
                this.v2_hash_tree.add(current_level);
                ArrayList<byte[]> next_level = new ArrayList<byte[]>(current_level.size() / 2);
                int i = 0;
                while (i < current_level.size()) {
                    hasher.update((byte[])current_level.get(i));
                    hasher.update((byte[])current_level.get(i + 1));
                    byte[] hash = hasher.digest();
                    next_level.add(hash);
                    i += 2;
                }
                current_level = next_level;
            }
            this.result = (byte[])current_level.get(0);
            this.sem.releaseForever();
            if (!this.cancelled) {
                ConcurrentHasherRequestListener listener_copy;
                ConcurrentHasherRequest concurrentHasherRequest = this;
                synchronized (concurrentHasherRequest) {
                    listener_copy = this.listener;
                    this.listener = null;
                }
                if (listener_copy != null) {
                    listener_copy.complete(this);
                }
            }
        }
    }
}

