/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.ConcurrentHasherRequest;
import com.biglybt.core.util.ConcurrentHasherRequestListener;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.core.util.ThreadPool;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;

public class ConcurrentHasher {
    protected static final ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected final List<ConcurrentHasherRequest> requests = new LinkedList<ConcurrentHasherRequest>();
    protected final List<SHA1Hasher> v1_hashers = new LinkedList<SHA1Hasher>();
    protected final List<MessageDigest> v2_hashers = new LinkedList<MessageDigest>();
    protected final AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected final AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected final AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing;

    static {
        COConfigurationManager.addAndFireParameterListener("diskmanager.hashchecking.strategy", new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getIntParameter("diskmanager.hashchecking.strategy") == 0;
            }
        });
    }

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        int i = 0;
        while (i < this.processor_num * 3) {
            this.scheduler_sem.release();
            ++i;
        }
        final ThreadPool pool = new ThreadPool("ConcurrentHasher", this.processor_num < 64 ? 64 : 128);
        new AEThread2("ConcurrentHasher:scheduler", true){

            @Override
            public void run() {
                while (true) {
                    SHA1Hasher v1_hasher;
                    MessageDigest v2_hasher;
                    ConcurrentHasherRequest req;
                    block8: {
                        block9: {
                            ConcurrentHasher.this.request_sem.reserve();
                            ConcurrentHasher.this.requests_mon.enter();
                            req = ConcurrentHasher.this.requests.remove(0);
                            if (req.getHashVersion() == 1) {
                                v2_hasher = null;
                                v1_hasher = ConcurrentHasher.this.v1_hashers.size() == 0 ? new SHA1Hasher() : ConcurrentHasher.this.v1_hashers.remove(0);
                                break block8;
                            }
                            v1_hasher = null;
                            if (ConcurrentHasher.this.v2_hashers.size() != 0) break block9;
                            try {
                                v2_hasher = MessageDigest.getInstance("SHA-256");
                                break block8;
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                req.cancel();
                                ConcurrentHasher.this.requests_mon.exit();
                            }
                        }
                        try {
                            v2_hasher = ConcurrentHasher.this.v2_hashers.remove(0);
                        }
                        finally {
                            ConcurrentHasher.this.requests_mon.exit();
                        }
                    }
                    pool.run(new AERunnable(){

                        @Override
                        public void runSupport() {
                            try {
                                if (v1_hasher != null) {
                                    req.run(v1_hasher);
                                } else {
                                    req.run(v2_hasher);
                                }
                            }
                            finally {
                                try {
                                    (this).ConcurrentHasher.this.requests_mon.enter();
                                    if (v1_hasher != null) {
                                        (this).ConcurrentHasher.this.v1_hashers.add(v1_hasher);
                                    } else {
                                        (this).ConcurrentHasher.this.v2_hashers.add(v2_hasher);
                                    }
                                }
                                finally {
                                    (this).ConcurrentHasher.this.requests_mon.exit();
                                }
                                if (friendly_hashing && req.isLowPriority()) {
                                    try {
                                        int size = req.getSize();
                                        int max = 250;
                                        int min = 50;
                                        size /= 1024;
                                        size /= 8;
                                        size = Math.min(size, 250);
                                        size = Math.max(size, 50);
                                        Thread.sleep(size);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                (this).ConcurrentHasher.this.scheduler_sem.release();
                            }
                        }
                    });
                }
            }
        }.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer, int hash_version, int piece_size, long v2_file_size) {
        return this.addRequest(buffer, hash_version, piece_size, v2_file_size, null, false);
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer, int hash_version, int piece_size, long v2_file_size, ConcurrentHasherRequestListener listener, boolean low_priorty) {
        ConcurrentHasherRequest req = new ConcurrentHasherRequest(this, buffer, hash_version, piece_size, v2_file_size, listener, low_priorty);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(req);
        }
        finally {
            this.requests_mon.exit();
        }
        this.request_sem.release();
        return req;
    }

    public static void main(String[] args) {
    }
}

