/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import java.io.File;
import java.io.IOException;

public class AETemporaryFileHandler {
    private static final boolean PORTABLE = System.getProperty(SystemProperties.SYSPROP_PORTABLE_ROOT, "").length() > 0;
    private static final String PREFIX = "AZU";
    private static final String SUFFIX = ".tmp";
    private static boolean started_up;
    private static File tmp_dir;

    public static synchronized void startup() {
        block12: {
            if (started_up) {
                return;
            }
            started_up = true;
            try {
                tmp_dir = FileUtil.getUserFile("tmp");
                if (tmp_dir.exists()) {
                    File[] files = tmp_dir.listFiles();
                    if (files != null) {
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            if (file.getName().startsWith(PREFIX) && file.getName().endsWith(SUFFIX)) {
                                if (file.isDirectory()) {
                                    FileUtil.recursiveDelete(file);
                                } else {
                                    file.delete();
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    tmp_dir.mkdir();
                }
            }
            catch (Throwable e) {
                try {
                    tmp_dir = File.createTempFile(PREFIX, SUFFIX).getParentFile();
                }
                catch (Throwable f) {
                    tmp_dir = new File("");
                }
                if (e instanceof NoClassDefFoundError) break block12;
                Debug.printStackTrace(e);
            }
        }
    }

    public static File getTempDirectory() {
        AETemporaryFileHandler.startup();
        return tmp_dir;
    }

    public static boolean isTempFile(File file) {
        String name;
        block6: {
            block5: {
                if (!file.exists()) {
                    return false;
                }
                try {
                    String s1 = file.getParentFile().getCanonicalPath();
                    String s2 = tmp_dir.getCanonicalPath();
                    if (s1.equals(s2)) break block5;
                    return false;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    return false;
                }
            }
            name = file.getName();
            if (name.startsWith(PREFIX)) break block6;
            return false;
        }
        return name.endsWith(SUFFIX);
    }

    public static File createTempFile() throws IOException {
        AETemporaryFileHandler.startup();
        return File.createTempFile(PREFIX, SUFFIX, tmp_dir);
    }

    public static File createTempFileInDir(File parent_dir) throws IOException {
        AETemporaryFileHandler.startup();
        return File.createTempFile(PREFIX, SUFFIX, parent_dir);
    }

    public static synchronized File createSemiTempFile(String preferred_name) throws IOException {
        preferred_name = FileUtil.convertOSSpecificChars(preferred_name, false);
        File result = AETemporaryFileHandler.createSemiTempFile();
        if (preferred_name.length() > 0) {
            File dir = result.getParentFile();
            int i = 0;
            while (i < 10) {
                File file = FileUtil.newFile(dir, preferred_name);
                if (!file.exists()) {
                    try {
                        if (file.createNewFile()) {
                            result.delete();
                            return file;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                preferred_name = "_" + preferred_name;
                ++i;
            }
        }
        return result;
    }

    public static File createSemiTempFile() throws IOException {
        if (PORTABLE) {
            try {
                File stmp_dir = FileUtil.getUserFile("tmp2");
                if (!stmp_dir.exists()) {
                    stmp_dir.mkdirs();
                }
                if (stmp_dir.canWrite()) {
                    return File.createTempFile(PREFIX, null, stmp_dir);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return File.createTempFile(PREFIX, null);
    }

    public static File createTempDir() throws IOException {
        AETemporaryFileHandler.startup();
        int i = 0;
        while (i < 16) {
            File f = File.createTempFile(PREFIX, SUFFIX, tmp_dir);
            f.delete();
            if (f.mkdirs()) {
                return f;
            }
            ++i;
        }
        throw new IOException("Failed to create temporary directory in " + tmp_dir);
    }
}

