/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import java.util.Iterator;

public class AERunStateHandler {
    public static final long RS_DELAYED_UI = 1L;
    public static final long RS_UDP_NET_ONLY = 2L;
    public static final long RS_DHT_SLEEPING = 4L;
    public static final long RS_ALL_ACTIVE = 0L;
    public static final long RS_ALL_LOW = -1L;
    public static final long[] RS_MODES = new long[]{1L, 2L, 4L};
    public static final String[] RS_MODE_NAMES = new String[]{"dui: Delay UI Initialisation", "uno: UDP Network Only", "ds:  DHT Sleeping"};
    private static final boolean start_low = COConfigurationManager.getBooleanParameter("Start In Low Resource Mode");
    private static long current_mode;
    private static final AsyncDispatcher dispatcher;
    private static final CopyOnWriteList<RunStateChangeListener> listeners;

    static {
        if (start_low) {
            if (COConfigurationManager.getBooleanParameter("LRMS UI")) {
                current_mode |= 1L;
            }
            if (COConfigurationManager.getBooleanParameter("LRMS UDP Peers")) {
                current_mode |= 2L;
            }
            if (COConfigurationManager.getBooleanParameter("LRMS DHT Sleep")) {
                current_mode |= 4L;
            }
        } else {
            current_mode = 0L;
        }
        dispatcher = new AsyncDispatcher(2500);
        listeners = new CopyOnWriteList();
    }

    public static boolean isDelayedUI() {
        return (current_mode & 1L) != 0L;
    }

    public static boolean isUDPNetworkOnly() {
        return (current_mode & 2L) != 0L;
    }

    public static boolean isDHTSleeping() {
        return (current_mode & 4L) != 0L;
    }

    public static void setDHTSleeping(boolean b) {
        AERunStateHandler.setState(4L, b);
    }

    private static void setState(long flag, boolean on) {
        long new_mode = current_mode;
        new_mode = on ? (new_mode |= flag) : (new_mode &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        AERunStateHandler.setResourceMode(new_mode);
    }

    public static long getResourceMode() {
        return current_mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResourceMode(final long new_mode) {
        AsyncDispatcher asyncDispatcher = dispatcher;
        synchronized (asyncDispatcher) {
            if (new_mode == current_mode) {
                return;
            }
            current_mode = new_mode;
            final Iterator<RunStateChangeListener> it = listeners.iterator();
            dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    while (it.hasNext()) {
                        try {
                            ((RunStateChangeListener)it.next()).runStateChanged(new_mode);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(final RunStateChangeListener l, boolean fire_now) {
        AsyncDispatcher asyncDispatcher = dispatcher;
        synchronized (asyncDispatcher) {
            listeners.add(l);
            if (fire_now) {
                dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            l.runStateChanged(current_mode);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(RunStateChangeListener l) {
        AsyncDispatcher asyncDispatcher = dispatcher;
        synchronized (asyncDispatcher) {
            listeners.remove(l);
        }
    }

    public static interface RunStateChangeListener {
        public void runStateChanged(long var1);
    }
}

