/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.util.Debug;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class AEMonitor {
    final ReentrantLock lock;

    public AEMonitor(String _name) {
        this.lock = new ReentrantLock();
    }

    public AEMonitor(String _name, boolean _fair) {
        this.lock = new ReentrantLock(_fair);
    }

    public void enter() {
        this.lock.lock();
    }

    public boolean enter(int max_millis) {
        try {
            return this.lock.tryLock(max_millis, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public void exit() {
        this.lock.unlock();
    }

    public boolean isHeld() {
        return this.lock.isHeldByCurrentThread();
    }

    public boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }
}

