/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.util;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.AEJavaManagement;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.logging.LoggerChannel;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.components.UIComponent;
import com.biglybt.pif.ui.model.BasicPluginViewModel;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AEDiagnostics {
    public static final boolean ALWAYS_PASS_HASH_CHECKS = false;
    public static final boolean USE_DUMMY_FILE_DATA = false;
    public static final boolean CHECK_DUMMY_FILE_DATA = false;
    public static final boolean DEBUG_MONITOR_SEM_USAGE = false;
    public static final boolean DEBUG_THREADS = true;
    public static final boolean TRACE_DIRECT_BYTE_BUFFERS = false;
    public static final boolean TRACE_DBB_POOL_USAGE = false;
    public static final boolean PRINT_DBB_POOL_USAGE = false;
    public static final boolean TRACE_TCP_TRANSPORT_STATS = false;
    public static final boolean TRACE_CONNECTION_DROPS = false;
    private static final int MAX_FILE_SIZE_DEFAULT;
    private static int[] MAX_FILE_SIZE_ACTUAL;
    private static final String CONFIG_KEY = "diagnostics.tidy_close";
    private static File debug_dir;
    private static File debug_save_dir;
    private static boolean started_up;
    private static volatile boolean startup_complete;
    private static boolean enable_pending_writes;
    private static final Map<String, AEDiagnosticsLogger> loggers;
    protected static boolean logging_enabled;
    protected static boolean loggers_enabled;
    protected static boolean loggers_disabled;
    private static final List<AEDiagnosticsEvidenceGenerator> evidence_generators;
    private static final Map<AEDiagnosticsEvidenceGenerator, Void> weak_evidence_generators;
    private static final AESemaphore dump_check_done_sem;
    private static final String[][] bad_dlls;

    static {
        MAX_FILE_SIZE_ACTUAL = new int[1];
        int maxFileSize = 262144;
        try {
            String logSize = System.getProperty("diag.logsize", null);
            if (logSize != null) {
                maxFileSize = logSize.toLowerCase().endsWith("m") ? Integer.parseInt(logSize.substring(0, logSize.length() - 1)) * 1024 * 1024 : Integer.parseInt(logSize);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AEDiagnostics.MAX_FILE_SIZE_ACTUAL[0] = MAX_FILE_SIZE_DEFAULT = maxFileSize;
        loggers = new HashMap<String, AEDiagnosticsLogger>();
        evidence_generators = new ArrayList<AEDiagnosticsEvidenceGenerator>();
        weak_evidence_generators = new WeakHashMap<AEDiagnosticsEvidenceGenerator, Void>();
        dump_check_done_sem = new AESemaphore("dumpcheckcomplete");
        bad_dlls = new String[][]{{"niphk", "y"}, {"nvappfilter", "y"}, {"netdog", "y"}, {"vlsp", "y"}, {"imon", "y"}, {"sarah", "y"}, {"MxAVLsp", "y"}, {"mclsp", "y"}, {"radhslib", "y"}, {"winsflt", "y"}, {"nl_lsp", "y"}, {"AxShlex", "y"}, {"iFW_Xfilter", "y"}, {"gapsp", "y"}, {"WSOCKHK", "n"}, {"InjHook12", "n"}, {"FPServiceProvider", "n"}, {"SBLSP.dll", "y"}, {"nvLsp.dll", "y"}};
    }

    public static synchronized void startup(boolean _enable_pending) {
        if (started_up) {
            return;
        }
        started_up = true;
        enable_pending_writes = _enable_pending;
        try {
            boolean transitoryStartup = System.getProperty("transitory.startup", "0").equals("1");
            if (transitoryStartup) {
                loggers_enabled = false;
                return;
            }
            try {
                debug_dir = FileUtil.getUserFile("logs");
                debug_save_dir = FileUtil.newFile(debug_dir, "save");
                COConfigurationManager.addAndFireParameterListeners(new String[]{"Logger.Enabled", "Logger.DebugFiles.Enabled", "Logger.DebugFiles.Enabled.Force", "Logger.DebugFiles.Disable", "Logger.DebugFiles.SizeKB"}, new ParameterListener(){

                    @Override
                    public void parameterChanged(String parameterName) {
                        int kb;
                        logging_enabled = COConfigurationManager.getBooleanParameter("Logger.Enabled");
                        loggers_enabled = logging_enabled && COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled");
                        loggers_disabled = COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Disable");
                        if (!loggers_enabled) {
                            boolean skipCVSCheck = System.getProperty("skip.loggers.enabled.cvscheck", "0").equals("1");
                            boolean bl = loggers_enabled = !skipCVSCheck && Constants.IS_CVS_VERSION || COConfigurationManager.getBooleanParameter("Logger.DebugFiles.Enabled.Force");
                        }
                        if (System.getProperty("diag.logsize", null) == null && (kb = COConfigurationManager.getIntParameter("Logger.DebugFiles.SizeKB", 0) * 1024) > 0) {
                            MAX_FILE_SIZE_ACTUAL[0] = kb;
                        }
                    }
                });
                boolean was_tidy = COConfigurationManager.getBooleanParameter(CONFIG_KEY);
                new AEThread2("asyncify", true){

                    @Override
                    public void run() {
                        SimpleTimer.addEvent("AEDiagnostics:logCleaner", SystemTime.getCurrentTime() + 60000L + (long)RandomUtils.nextInt(15000), new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                AEDiagnostics.cleanOldLogs();
                            }
                        });
                    }
                }.start();
                if (debug_dir.exists()) {
                    boolean save_logs = System.getProperty("az.logging.save.debug", "true").equals("true");
                    long now = SystemTime.getCurrentTime();
                    File[] files = debug_dir.listFiles();
                    if (files != null) {
                        boolean file_found = false;
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            if (!file.isDirectory() && !was_tidy) {
                                file_found = true;
                                if (save_logs) {
                                    if (!debug_save_dir.exists()) {
                                        debug_save_dir.mkdir();
                                    }
                                    FileUtil.copyFile(file, FileUtil.newFile(debug_save_dir, String.valueOf(now) + "_" + file.getName()));
                                }
                            }
                            ++i;
                        }
                        if (file_found) {
                            Logger.logTextResource(new LogAlert(false, 1, "diagnostics.log_found"), new String[]{debug_save_dir.toString()});
                        }
                    }
                } else {
                    debug_dir.mkdir();
                }
                AEJavaManagement.initialise();
            }
            catch (Throwable e) {
                if (!(e instanceof NoClassDefFoundError)) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            startup_complete = true;
        }
    }

    public static void dumpThreads() {
        AEJavaManagement.dumpThreads();
    }

    public static void dumpThreads(IndentWriter writer) {
        AEJavaManagement.dumpThreads(writer);
    }

    public static String getThreadInfo(Thread thread) {
        return AEJavaManagement.getThreadInfo(thread);
    }

    private static synchronized void cleanOldLogs() {
        try {
            long now = SystemTime.getCurrentTime();
            File[] files = debug_save_dir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    long last_modified;
                    File file = files[i];
                    if (!file.isDirectory() && now - (last_modified = file.lastModified()) > 864000000L) {
                        file.delete();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isStartupComplete() {
        return startup_complete;
    }

    public static void postStartup(Core core) {
        PluginInterface plugin_interface = core.getPluginManager().getDefaultPluginInterface();
        LoggerChannel log = plugin_interface.getLogger().getChannel("JVM Info");
        UIManager ui_manager = plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("log.jvm.info");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.attachLoggerChannel(log);
        model.getLogArea().addRefreshListener(new UIComponent.RefreshListener(){
            private String last_line = null;

            @Override
            public void refresh() {
                List<String> lines = AEJavaManagement.getMemoryHistory();
                int line_num = lines.size();
                if (line_num == 0) {
                    return;
                }
                int pos = lines.indexOf(this.last_line);
                if (pos == line_num - 1) {
                    return;
                }
                String content = "";
                for (String line : lines.subList(pos < 0 ? 0 : pos + 1, lines.size())) {
                    content = String.valueOf(content) + line + "\n";
                }
                this.last_line = lines.get(lines.size() - 1);
                model.getLogArea().appendText(content);
            }
        });
    }

    public static File getLogDir() {
        AEDiagnostics.startup(false);
        return debug_dir;
    }

    public static synchronized void flushPendingLogs() {
        for (AEDiagnosticsLogger logger : loggers.values()) {
            logger.writePending();
        }
        enable_pending_writes = false;
    }

    public static synchronized AEDiagnosticsLogger getLogger(String name) {
        AEDiagnosticsLogger logger = loggers.get(name);
        if (logger == null) {
            AEDiagnostics.startup(false);
            logger = new AEDiagnosticsLogger(debug_dir, name, MAX_FILE_SIZE_ACTUAL, !enable_pending_writes);
            loggers.put(name, logger);
        }
        return logger;
    }

    public static void logWithStack(String logger_name, String str) {
        AEDiagnostics.log(logger_name, String.valueOf(str) + ": " + Debug.getCompressedStackTrace());
    }

    public static void log(String logger_name, String str) {
        AEDiagnostics.getLogger(logger_name).log(str);
    }

    public static void markDirty() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, false);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isDirty() {
        return !COConfigurationManager.getBooleanParameter(CONFIG_KEY);
    }

    public static void markClean() {
        try {
            COConfigurationManager.setParameter(CONFIG_KEY, true);
            COConfigurationManager.save();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void checkDumpsAndNatives() {
        try {
            try {
                long last_done;
                PlatformManager p_man = PlatformManagerFactory.getPlatformManager();
                if (p_man.getPlatformType() == 1 && p_man.hasCapability(PlatformManagerCapabilities.TestNativeAvailability)) {
                    int i = 0;
                    while (i < bad_dlls.length) {
                        String dll = bad_dlls[i][0];
                        String load = bad_dlls[i][1];
                        if (!load.equalsIgnoreCase("n") && !COConfigurationManager.getBooleanParameter("platform.win32.dll_found." + dll, false)) {
                            try {
                                if (p_man.testNativeAvailability(String.valueOf(dll) + ".dll")) {
                                    COConfigurationManager.setParameter("platform.win32.dll_found." + dll, true);
                                    String detail = MessageText.getString("platform.win32.baddll." + dll);
                                    Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{String.valueOf(dll) + ".dll", detail});
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        ++i;
                    }
                }
                ArrayList<File> fdirs_to_check = new ArrayList<File>();
                fdirs_to_check.add(FileUtil.newFile(SystemProperties.getApplicationPath(), new String[0]));
                try {
                    File temp_file = File.createTempFile("AZU", "tmp");
                    fdirs_to_check.add(temp_file.getParentFile());
                    temp_file.delete();
                }
                catch (Throwable temp_file) {
                    // empty catch block
                }
                File most_recent_dump = null;
                long most_recent_time = 0L;
                for (File dir : fdirs_to_check) {
                    File[] files;
                    if (!dir.canRead() || (files = dir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith("hs_err_pid") && name.endsWith(".log");
                        }
                    })) == null) continue;
                    long now = SystemTime.getCurrentTime();
                    long one_week_ago = now - 604800000L;
                    int i = 0;
                    while (i < files.length) {
                        File f = files[i];
                        long last_mod = f.lastModified();
                        if (last_mod > most_recent_time && last_mod > one_week_ago) {
                            most_recent_dump = f;
                            most_recent_time = last_mod;
                        }
                        ++i;
                    }
                }
                if (most_recent_dump != null && (last_done = COConfigurationManager.getLongParameter("diagnostics.dump.lasttime", 0L)) < most_recent_time) {
                    COConfigurationManager.setParameter("diagnostics.dump.lasttime", most_recent_time);
                    AEDiagnostics.analyseDump(most_recent_dump);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                dump_check_done_sem.releaseForever();
            }
        }
        finally {
            dump_check_done_sem.releaseForever();
        }
    }

    protected static void analyseDump(File file) {
        System.out.println("Analysing " + file);
        try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader(FileUtil.newFileInputStream(file)));){
            String line;
            boolean float_excep = false;
            boolean swt_crash = false;
            boolean browser_crash = false;
            String[] bad_dlls_uc = new String[bad_dlls.length];
            int i = 0;
            while (i < bad_dlls.length) {
                String dll = bad_dlls[i][0];
                bad_dlls_uc[i] = (String.valueOf(dll) + ".dll").toUpperCase();
                ++i;
            }
            String alcohol_dll = "AxShlex";
            ArrayList<String> matches = new ArrayList<String>();
            while ((line = lnr.readLine()) != null) {
                if ((line = line.toUpperCase()).contains("EXCEPTION_FLT")) {
                    float_excep = true;
                    continue;
                }
                if (line.startsWith("# C") && line.contains("[SWT-WIN32")) {
                    swt_crash = true;
                } else if (line.contains("CURRENT THREAD") && line.contains("SWT THREAD")) {
                    swt_crash = true;
                } else if (line.startsWith("# C") && (line.contains("[IEFRAME") || line.contains("[JSCRIPT") || line.contains("[FLASH") || line.contains("[MSHTML"))) {
                    browser_crash = true;
                    swt_crash = true;
                } else if (line.startsWith("J ") && line.contains("SWT.BROWSER") || line.startsWith("C ") && line.contains("[IEFRAME") || line.startsWith("C ") && line.contains("[MSHTML") || line.startsWith("C ") && line.contains("[FLASH") || line.startsWith("C ") && line.contains("[JSCRIPT")) {
                    browser_crash = true;
                }
                int i2 = 0;
                while (i2 < bad_dlls_uc.length) {
                    String b_uc = bad_dlls_uc[i2];
                    if (line.contains(b_uc)) {
                        String dll = bad_dlls[i2][0];
                        if (dll.equals(alcohol_dll)) {
                            if (float_excep) {
                                matches.add(dll);
                            }
                        } else {
                            matches.add(dll);
                        }
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < matches.size()) {
                String dll = (String)matches.get(i3);
                String detail = MessageText.getString("platform.win32.baddll." + dll);
                Logger.logTextResource(new LogAlert(true, 1, "platform.win32.baddll.info"), new String[]{String.valueOf(dll) + ".dll", detail});
                ++i3;
            }
            if (swt_crash && browser_crash && Constants.isWindows && !COConfigurationManager.getBooleanParameter("browser.internal.disable", false)) {
                COConfigurationManager.setParameter("browser.internal.disable", true);
                COConfigurationManager.save();
                Logger.logTextResource(new LogAlert(true, 1, "browser.internal.auto.disabled"));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void waitForDumpChecks(long max_wait) {
        dump_check_done_sem.reserve(max_wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWeakEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List<AEDiagnosticsEvidenceGenerator> list = evidence_generators;
        synchronized (list) {
            weak_evidence_generators.put(gen, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List<AEDiagnosticsEvidenceGenerator> list = evidence_generators;
        synchronized (list) {
            evidence_generators.add(gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEvidenceGenerator(AEDiagnosticsEvidenceGenerator gen) {
        List<AEDiagnosticsEvidenceGenerator> list = evidence_generators;
        synchronized (list) {
            evidence_generators.remove(gen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEvidence(PrintWriter _writer) {
        IndentWriter writer = new IndentWriter(_writer);
        List<AEDiagnosticsEvidenceGenerator> list = evidence_generators;
        synchronized (list) {
            for (AEDiagnosticsEvidenceGenerator gen : evidence_generators) {
                try {
                    gen.generate(writer);
                }
                catch (Throwable e) {
                    e.printStackTrace(_writer);
                }
            }
            for (AEDiagnosticsEvidenceGenerator gen : weak_evidence_generators.keySet()) {
                try {
                    gen.generate(writer);
                }
                catch (Throwable e) {
                    e.printStackTrace(_writer);
                }
            }
        }
        writer.println("Memory");
        try {
            writer.indent();
            Runtime rt = Runtime.getRuntime();
            writer.println("max=" + rt.maxMemory() + ",total=" + rt.totalMemory() + ",free=" + rt.freeMemory());
        }
        finally {
            writer.exdent();
        }
    }
}

