/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.protocol;

import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HostNameToIPResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class PRHelpers {
    public static int addressToInt(String address) throws UnknownHostException {
        InetAddress i_address = HostNameToIPResolver.syncResolve(address);
        byte[] bytes = i_address.getAddress();
        if (Constants.IS_CVS_VERSION && bytes.length > 4) {
            Debug.out("hmm");
        }
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    public static byte[] addressToBytes(String address) throws UnknownHostException {
        InetAddress i_address = HostNameToIPResolver.syncResolve(address);
        return i_address.getAddress();
    }

    public static int addressToInt(InetAddress i_address) {
        byte[] bytes = i_address.getAddress();
        if (Constants.IS_CVS_VERSION && bytes.length > 4) {
            Debug.out("hmm");
        }
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    public static long addressToLong(InetAddress i_address) {
        return (long)PRHelpers.addressToInt(i_address) & 0xFFFFFFFFL;
    }

    public static String intToAddress(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        try {
            String res = InetAddress.getByAddress(bytes).getHostAddress();
            return res;
        }
        catch (UnknownHostException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static String bytesToAddress(byte[] bytes) {
        try {
            String res = InetAddress.getByAddress(bytes).getHostAddress();
            return res;
        }
        catch (UnknownHostException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static String DNSToIPAddress(String dns_name) throws UnknownHostException {
        return HostNameToIPResolver.syncResolve(dns_name).getHostAddress();
    }
}

