/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker.client.impl;

import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerException;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerFactory;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerFactoryListener;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerImpl;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerMuxer;
import com.biglybt.core.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TRTrackerAnnouncerFactoryImpl {
    protected static final List<TRTrackerAnnouncerFactoryListener> listeners = new ArrayList<TRTrackerAnnouncerFactoryListener>();
    protected static final List<TRTrackerAnnouncerImpl> clients = new ArrayList<TRTrackerAnnouncerImpl>();
    protected static final AEMonitor class_mon = new AEMonitor("TRTrackerClientFactory");

    public static TRTrackerAnnouncer create(TOTorrent torrent, TRTrackerAnnouncerFactory.DataProvider provider, boolean manual) throws TRTrackerAnnouncerException {
        TRTrackerAnnouncerMuxer client = new TRTrackerAnnouncerMuxer(torrent, provider, manual);
        if (!manual) {
            ArrayList<TRTrackerAnnouncerFactoryListener> listeners_copy;
            try {
                class_mon.enter();
                clients.add(client);
                listeners_copy = new ArrayList<TRTrackerAnnouncerFactoryListener>(listeners);
            }
            finally {
                class_mon.exit();
            }
            int i = 0;
            while (i < listeners_copy.size()) {
                try {
                    ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientCreated(client);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        return client;
    }

    public static void addListener(TRTrackerAnnouncerFactoryListener l) {
        ArrayList<TRTrackerAnnouncerImpl> clients_copy;
        try {
            class_mon.enter();
            listeners.add(l);
            clients_copy = new ArrayList<TRTrackerAnnouncerImpl>(clients);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < clients_copy.size()) {
            try {
                l.clientCreated((TRTrackerAnnouncer)clients_copy.get(i));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public static void removeListener(TRTrackerAnnouncerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void destroy(TRTrackerAnnouncer client) {
        if (!client.isManual()) {
            ArrayList<TRTrackerAnnouncerFactoryListener> listeners_copy;
            try {
                class_mon.enter();
                clients.remove(client);
                listeners_copy = new ArrayList<TRTrackerAnnouncerFactoryListener>(listeners);
            }
            finally {
                class_mon.exit();
            }
            int i = 0;
            while (i < listeners_copy.size()) {
                try {
                    ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientDestroyed(client);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    public static byte[] getAnonymousPeerId(String my_ip, int my_port) {
        byte[] anon_peer_id = new byte[20];
        anon_peer_id[0] = 91;
        anon_peer_id[1] = 93;
        byte[] ip_bytes = my_ip.getBytes(Constants.DEFAULT_ENCODING_CHARSET);
        int ip_len = ip_bytes.length;
        if (ip_len > 18) {
            ip_len = 18;
        }
        System.arraycopy(ip_bytes, 0, anon_peer_id, 2, ip_len);
        int port_copy = my_port;
        int j = 2 + ip_len;
        while (j < 20) {
            anon_peer_id[j] = (byte)(port_copy & 0xFF);
            port_copy >>= 8;
            ++j;
        }
        return anon_peer_id;
    }

    public static List<TRTrackerAnnouncerResponsePeer> getCachedPeers(Map map) {
        ArrayList<TRTrackerAnnouncerResponsePeer> result = new ArrayList<TRTrackerAnnouncerResponsePeer>();
        List peers = (List)map.get("tracker_peers");
        if (peers != null) {
            int i = 0;
            while (i < peers.size()) {
                Map peer = (Map)peers.get(i);
                byte[] src_bytes = (byte[])peer.get("src");
                String peer_source = src_bytes == null ? "Tracker" : new String(src_bytes);
                String peer_ip_address = new String((byte[])peer.get("ip"));
                int peer_tcp_port = ((Long)peer.get("port")).intValue();
                byte[] peer_peer_id = TRTrackerAnnouncerFactoryImpl.getAnonymousPeerId(peer_ip_address, peer_tcp_port);
                Long l_protocol = (Long)peer.get("prot");
                short protocol = l_protocol == null ? (short)1 : l_protocol.shortValue();
                Long l_udp_port = (Long)peer.get("udpport");
                int peer_udp_port = l_udp_port == null ? 0 : l_udp_port.intValue();
                Long l_http_port = (Long)peer.get("httpport");
                int peer_http_port = l_http_port == null ? 0 : l_http_port.intValue();
                Long l_az_ver = (Long)peer.get("azver");
                byte az_ver = l_az_ver == null ? (byte)1 : l_az_ver.byteValue();
                TRTrackerAnnouncerResponsePeerImpl entry = new TRTrackerAnnouncerResponsePeerImpl(peer_source, peer_peer_id, peer_ip_address, peer_tcp_port, peer_udp_port, peer_http_port, protocol, az_ver, 0);
                entry.setCached(true);
                result.add(entry);
                ++i;
            }
        }
        return result;
    }
}

