/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tracker;

import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.alltrackers.AllTrackersManagerImpl;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerRequest;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

public interface AllTrackersManager {
    public static AllTrackers getAllTrackers() {
        return AllTrackersManagerImpl.getSingleton();
    }

    public static interface AllTrackers {
        public String ingestURL(URL var1);

        public int getTrackerCount();

        public void registerTorrent(TOTorrent var1);

        public void unregisterTorrent(TOTorrent var1);

        public void registerTracker(TOTorrent var1, URL var2);

        public void registerTrackers(TOTorrent var1, List<List<URL>> var2);

        public void updateTracker(URL var1, TRTrackerAnnouncerResponse var2);

        public void updateTracker(String var1, TRTrackerAnnouncerRequest var2);

        public void updateTracker(URL var1, TRTrackerScraperResponse var2);

        public void addActiveRequest(TRTrackerAnnouncerRequest var1);

        public void removeActiveRequest(TRTrackerAnnouncerRequest var1);

        public boolean isStopping();

        public void addScrapeRequest();

        public void removeScrapeRequest();

        public int getActiveRequestCount();

        public float getAnnouncesPerSecond();

        public float getScrapesPerSecond();

        public AnnounceStats getAnnounceStats();

        public ScrapeStats getScrapeStats();

        public AllTrackersTracker getTracker(String var1);

        public AllTrackersTracker getTracker(URL var1);

        public boolean getLoggingEnabled(String var1);

        public void setLoggingEnabled(String var1, boolean var2);

        public File getLogFile(String var1);

        public long getOptionsMutationCount();

        public void registerAnnounceStatsProvider(AnnounceStatsProvider var1);

        public void registerScrapeStatsProvider(ScrapeStatsProvider var1);

        public void addListener(AllTrackersListener var1, boolean var2);

        public void removeListener(AllTrackersListener var1);
    }

    public static interface AllTrackersEvent {
        public static final int ET_TRACKER_ADDED = 0;
        public static final int ET_TRACKER_UPDATED = 1;
        public static final int ET_TRACKER_REMOVED = 2;

        public int getEventType();

        public List<AllTrackersTracker> getTrackers();
    }

    public static interface AllTrackersListener {
        public void trackerEventOccurred(AllTrackersEvent var1);
    }

    public static interface AllTrackersTracker {
        public static final String OPT_CRYPTO_PORT = "cp";
        public static final String OPT_LIGHT_SEEDING = "ls";
        public static final String OPT_SCRAPE_LEVEL = "sl";
        public static final String[] OPT_ALL = new String[]{"cp", "ls", "sl"};

        public String getTrackerName();

        public String getStatusString();

        public long getLastGoodTime();

        public long getLastFailTime();

        public long getFailingSinceTime();

        public long getConsecutiveFails();

        public void resetReportedStats();

        public long getTotalReportedUp();

        public long getTotalReportedDown();

        public Map<String, Object> getOptions();

        public void setOptions(Map<String, Object> var1);

        public String getShortKey();

        public long getAverageRequestDuration();

        public int getPrivatePercentage();

        public int getTorrentCount();

        public int getActiveRequestCount();

        public long getPeersReceived();

        public boolean isRemovable();

        public void remove();
    }

    public static interface AnnounceStats {
        public long getPublicLagMillis();

        public long getPrivateLagMillis();

        public int getPublicScheduledCount();

        public int getPrivateScheduledCount();

        public int getPublicPendingCount();

        public int getPrivatePendingCount();
    }

    public static interface AnnounceStatsProvider {
        public AnnounceStats getStats();
    }

    public static interface ScrapeStats {
        public long getLagMillis();
    }

    public static interface ScrapeStatsProvider {
        public ScrapeStats getStats();
    }
}

