/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.torrent.impl;

import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.impl.TOTorrentFileImpl;
import com.biglybt.core.torrent.impl.TOTorrentImpl;
import com.biglybt.core.util.ByteEncodedKeyHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.xml.simpleparser.SimpleXMLParserDocumentFactory;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocument;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import com.biglybt.pif.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TOTorrentXMLDeserialiser {
    public TOTorrent deserialise(File file) throws TOTorrentException {
        try {
            SimpleXMLParserDocument doc = SimpleXMLParserDocumentFactory.create(file);
            TOTorrent res = this.decodeRoot(doc);
            return res;
        }
        catch (SimpleXMLParserDocumentException e) {
            throw new TOTorrentException("XML Parse Fails: " + e.getMessage(), 6);
        }
    }

    protected TOTorrent decodeRoot(SimpleXMLParserDocument doc) throws TOTorrentException {
        String root_name = doc.getName();
        if (root_name.equalsIgnoreCase("TORRENT")) {
            TOTorrentImpl torrent = new TOTorrentImpl();
            try {
                SimpleXMLParserDocumentNode[] kids = doc.getChildren();
                URL announce_url = null;
                byte[] torrent_hash = null;
                byte[] torrent_hash_override = null;
                int i = 0;
                while (i < kids.length) {
                    SimpleXMLParserDocumentNode kid = kids[i];
                    String name = kid.getName();
                    if (name.equalsIgnoreCase("ANNOUNCE_URL")) {
                        try {
                            announce_url = new URL(kid.getValue());
                        }
                        catch (MalformedURLException e) {
                            throw new TOTorrentException("ANNOUNCE_URL malformed", 6);
                        }
                    }
                    if (name.equalsIgnoreCase("ANNOUNCE_LIST")) {
                        SimpleXMLParserDocumentNode[] set_nodes = kid.getChildren();
                        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                        TOTorrentAnnounceURLSet[] sets = new TOTorrentAnnounceURLSet[set_nodes.length];
                        int j = 0;
                        while (j < sets.length) {
                            SimpleXMLParserDocumentNode[] url_nodes = set_nodes[j].getChildren();
                            URL[] urls = new URL[url_nodes.length];
                            int k = 0;
                            while (k < urls.length) {
                                try {
                                    urls[k] = new URL(url_nodes[k].getValue());
                                }
                                catch (MalformedURLException e) {
                                    throw new TOTorrentException("ANNOUNCE_LIST malformed", 6);
                                }
                                ++k;
                            }
                            sets[j] = group.createAnnounceURLSet(urls);
                            ++j;
                        }
                        group.setAnnounceURLSets(sets);
                    } else if (name.equalsIgnoreCase("COMMENT")) {
                        torrent.setComment(this.readLocalisableString(kid));
                    } else if (name.equalsIgnoreCase("CREATED_BY")) {
                        torrent.setCreatedBy(this.readLocalisableString(kid));
                    } else if (name.equalsIgnoreCase("CREATION_DATE")) {
                        torrent.setCreationDate(this.readGenericLong(kid));
                    } else if (name.equalsIgnoreCase("TORRENT_HASH")) {
                        torrent_hash = this.readGenericBytes(kid);
                    } else if (name.equalsIgnoreCase("TORRENT_HASH_OVERRIDE")) {
                        torrent_hash_override = this.readGenericBytes(kid);
                    } else if (name.equalsIgnoreCase("INFO")) {
                        this.decodeInfo(kid, torrent);
                    } else {
                        mapEntry entry = this.readGenericMapEntry(kid);
                        torrent.addAdditionalProperty(entry.name, entry.value);
                    }
                    ++i;
                }
                if (announce_url == null) {
                    throw new TOTorrentException("ANNOUNCE_URL missing", 6);
                }
                torrent.setAnnounceURL(announce_url);
                if (torrent_hash_override != null) {
                    try {
                        torrent.setHashOverride(torrent_hash_override);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (torrent_hash != null && !Arrays.equals(torrent.getHash(), torrent_hash)) {
                    throw new TOTorrentException("Hash differs - declared TORRENT_HASH and computed hash differ. If this really is the intent (unlikely) then remove the TORRENT_HASH element", 6);
                }
                TOTorrentImpl tOTorrentImpl = torrent;
                return tOTorrentImpl;
            }
            finally {
                torrent.setConstructed();
            }
        }
        throw new TOTorrentException("Invalid root element", 6);
    }

    protected void decodeInfo(SimpleXMLParserDocumentNode doc, TOTorrentImpl torrent) throws TOTorrentException {
        int torrent_type;
        SimpleXMLParserDocumentNode[] kids = doc.getChildren();
        long torrent_length = 0L;
        SimpleXMLParserDocumentNode[] file_nodes = null;
        boolean has_v1 = false;
        boolean has_v2 = false;
        int i = 0;
        while (i < kids.length) {
            SimpleXMLParserDocumentNode kid = kids[i];
            String name = kid.getName();
            if (name.equalsIgnoreCase("PIECE_LENGTH")) {
                torrent.setPieceLength(this.readGenericLong(kid));
            } else if (name.equalsIgnoreCase("LENGTH")) {
                torrent.setSimpleTorrent(true);
                torrent_length = this.readGenericLong(kid);
            } else if (name.equalsIgnoreCase("NAME")) {
                torrent.setName(this.readLocalisableString(kid));
            } else if (name.equalsIgnoreCase("FILES")) {
                torrent.setSimpleTorrent(false);
                file_nodes = kid.getChildren();
            } else if (name.equalsIgnoreCase("PIECES")) {
                has_v1 = true;
                SimpleXMLParserDocumentNode[] piece_nodes = kid.getChildren();
                byte[][] pieces = new byte[piece_nodes.length][];
                int j = 0;
                while (j < pieces.length) {
                    pieces[j] = this.readGenericBytes(piece_nodes[j]);
                    ++j;
                }
                torrent.setPieces(pieces);
            } else {
                mapEntry entry = this.readGenericMapEntry(kid);
                if (entry.name.equals("file tree")) {
                    has_v2 = true;
                }
                torrent.addAdditionalInfoProperty(entry.name, entry.value);
            }
            ++i;
        }
        if (has_v1 && has_v2) {
            torrent_type = 2;
        } else if (has_v1) {
            torrent_type = 1;
        } else if (has_v2) {
            torrent_type = 3;
        } else {
            throw new TOTorrentException("Decode fails, missing v1 and v2 data", 6);
        }
        torrent.setTorrentType(torrent_type);
        if (torrent_type != 3) {
            if (torrent.isSimpleTorrent()) {
                torrent.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl(torrent, 0, 0L, torrent_length, new byte[][]{torrent.getName()})});
            } else {
                if (file_nodes == null) {
                    throw new TOTorrentException("FILES element missing", 6);
                }
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[file_nodes.length];
                long offset = 0L;
                int j = 0;
                while (j < files.length) {
                    SimpleXMLParserDocumentNode file_node = file_nodes[j];
                    SimpleXMLParserDocumentNode[] file_entries = file_node.getChildren();
                    long file_length = 0L;
                    boolean length_entry_found = false;
                    byte[][] path_comps = null;
                    Vector<mapEntry> additional_props = new Vector<mapEntry>();
                    int k = 0;
                    while (k < file_entries.length) {
                        SimpleXMLParserDocumentNode file_entry = file_entries[k];
                        String entry_name = file_entry.getName();
                        if (entry_name.equalsIgnoreCase("LENGTH")) {
                            file_length = this.readGenericLong(file_entry);
                            length_entry_found = true;
                        } else if (entry_name.equalsIgnoreCase("PATH")) {
                            SimpleXMLParserDocumentNode[] path_nodes = file_entry.getChildren();
                            path_comps = new byte[path_nodes.length][];
                            int n = 0;
                            while (n < path_nodes.length) {
                                path_comps[n] = this.readLocalisableString(path_nodes[n]);
                                ++n;
                            }
                        } else {
                            additional_props.addElement(this.readGenericMapEntry(file_entry));
                        }
                        ++k;
                    }
                    if (!length_entry_found || path_comps == null) {
                        throw new TOTorrentException("FILE element invalid (file length = " + file_length + ")", 6);
                    }
                    files[j] = new TOTorrentFileImpl(torrent, j, offset, file_length, path_comps);
                    offset += file_length;
                    k = 0;
                    while (k < additional_props.size()) {
                        mapEntry entry = (mapEntry)additional_props.elementAt(k);
                        files[j].setAdditionalProperty(entry.name, entry.value);
                        ++k;
                    }
                    ++j;
                }
                torrent.setFiles(files);
            }
        }
    }

    protected mapEntry readGenericMapEntry(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        if (!node.getName().equalsIgnoreCase("KEY")) {
            throw new TOTorrentException("Additional property invalid, must be KEY node", 6);
        }
        String name = node.getAttribute("name").getValue();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        if (kids.length != 1) {
            throw new TOTorrentException("Additional property invalid, KEY must have one child", 6);
        }
        String type = kids[0].getName();
        Object value = this.readGenericValue(kids[0]);
        return new mapEntry(name, value);
    }

    protected Object readGenericValue(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String name = node.getName();
        if (name.equalsIgnoreCase("BYTES")) {
            return this.readGenericBytes(node);
        }
        if (name.equalsIgnoreCase("LONG")) {
            return this.readGenericLong(node);
        }
        if (name.equalsIgnoreCase("LIST")) {
            return this.readGenericList(node);
        }
        if (name.equalsIgnoreCase("MAP")) {
            return this.readGenericMap(node);
        }
        throw new TOTorrentException("Additional property invalid, sub-key '" + name + "' not recognised", 6);
    }

    protected byte[] readGenericBytes(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        byte[] res = new byte[value.length() / 2];
        int i = 0;
        while (i < res.length) {
            res[i] = (byte)Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return res;
    }

    protected Long readGenericLong(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        try {
            return new Long(value);
        }
        catch (Throwable e) {
            throw new TOTorrentException("long value invalid for '" + node.getName() + "'", 6);
        }
    }

    protected Map readGenericMap(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        SimpleXMLParserDocumentAttribute bk = node.getAttribute("byte_keys");
        if (bk != null && bk.getValue().equalsIgnoreCase("true")) {
            ByteEncodedKeyHashMap res = new ByteEncodedKeyHashMap();
            SimpleXMLParserDocumentNode[] kids = node.getChildren();
            int i = 0;
            while (i < kids.length) {
                mapEntry entry = this.readGenericMapEntry(kids[i]);
                String key = new String(ByteFormatter.decodeString(entry.name), Constants.BYTE_ENCODING_CHARSET);
                res.put(key, entry.value);
                ++i;
            }
            return res;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        int i = 0;
        while (i < kids.length) {
            mapEntry entry = this.readGenericMapEntry(kids[i]);
            res.put(entry.name, entry.value);
            ++i;
        }
        return res;
    }

    protected byte[] readLocalisableString(SimpleXMLParserDocumentNode kid) throws TOTorrentException {
        SimpleXMLParserDocumentAttribute attr = kid.getAttribute("encoding");
        if (attr == null || attr.getValue().equalsIgnoreCase("bytes")) {
            return this.readGenericBytes(kid);
        }
        return kid.getValue().getBytes(Constants.DEFAULT_ENCODING_CHARSET);
    }

    protected List readGenericList(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        ArrayList<Object> res = new ArrayList<Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        int i = 0;
        while (i < kids.length) {
            res.add(this.readGenericValue(kids[i]));
            ++i;
        }
        return res;
    }

    protected static class mapEntry {
        final String name;
        final Object value;

        mapEntry(String _name, Object _value) {
            this.name = _name;
            this.value = _value;
        }
    }
}

