/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.activities.LocalActivityManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagFeatureNotifications;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagBase;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TrackersUtil;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TagWithState
extends TagBase {
    private static final String TP_KEY = "TagWithState:tp_key";
    private final CopyOnWriteSet<Taggable> objects = new CopyOnWriteSet(true);
    private final String TP_KEY_TAG_ADDED_TIME = "ta:" + this.getTagUID();
    private TagFeatureNotifications tag_notifications;
    private boolean removed;

    public TagWithState(TagTypeBase tt, int tag_id, String name) {
        super(tt, tag_id, name);
        if (tt.hasTagTypeFeature(256L)) {
            this.tag_notifications = (TagFeatureNotifications)((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected TagWithState(TagTypeBase tt, int tag_id, Map map) {
        super(tt, tag_id, MapUtils.getMapString(map, "n", ""));
        if (tt.hasTagTypeFeature(256L)) {
            this.tag_notifications = (TagFeatureNotifications)((Object)this);
        }
        if (map == null) return;
        List list = (List)map.get("o");
        List props = (List)map.get("p");
        if (list == null) return;
        int pos = 0;
        for (byte[] b : list) {
            block9: {
                try {
                    Long time_added;
                    String id = new String(b, "UTF-8");
                    Taggable taggable = tt.resolveTaggable(id);
                    if (taggable == null) break block9;
                    if (props != null && (time_added = (Long)((Map)props.get(pos)).get("a")) != null) {
                        String string = TP_KEY;
                        // MONITORENTER : "TagWithState:tp_key"
                        HashMap<String, Long> all_props = (HashMap<String, Long>)taggable.getTaggableTransientProperty(TP_KEY);
                        if (all_props == null) {
                            all_props = new HashMap<String, Long>();
                        }
                        all_props.put(this.TP_KEY_TAG_ADDED_TIME, time_added);
                        taggable.setTaggableTransientProperty(TP_KEY, all_props);
                        // MONITOREXIT : string
                    }
                    this.objects.add(taggable);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            ++pos;
        }
    }

    protected void exportDetails(VuzeFile vf, Map map, boolean do_contents) {
        String image_file;
        String[] bits;
        TagFeatureProperties tfp;
        TagFeatureProperties.TagProperty prop;
        this.exportDetails(map, do_contents);
        if (this.getTagType().hasTagTypeFeature(32L) && (prop = (tfp = (TagFeatureProperties)((Object)this)).getProperty("tracker_templates")) != null && (bits = prop.getStringList()) != null && bits.length > 0) {
            Map<String, List<List<String>>> templates = TrackersUtil.getInstance().getMultiTrackers();
            String[] stringArray = bits;
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] temp = bit.split(":");
                String t_name = temp[1];
                List<List<String>> template_trackers = templates.get(t_name);
                if (template_trackers != null) {
                    HashMap<String, Object> tt_map = new HashMap<String, Object>();
                    tt_map.put("name", t_name);
                    tt_map.put("template", template_trackers);
                    vf.addComponent(8192, tt_map);
                }
                ++n2;
            }
        }
        if ((image_file = this.getImageFile()) != null) {
            try {
                File file = FileUtil.newFile(image_file, new String[0]);
                byte[] bytes = FileUtil.readFileAsByteArray(file);
                if (bytes != null) {
                    map.put("_img_file", file.getName());
                    map.put("_img_bytes", bytes);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void exportDetails(Map map, boolean do_contents) {
        MapUtils.setMapString(map, "n", this.getTagNameRaw());
        if (do_contents) {
            Iterator<Taggable> it = this.objects.iterator();
            ArrayList<byte[]> l = new ArrayList<byte[]>(this.objects.size());
            ArrayList p = new ArrayList(this.objects.size());
            while (it.hasNext()) {
                try {
                    Long time_added;
                    Taggable taggable = it.next();
                    String id = taggable.getTaggableID();
                    if (id == null) continue;
                    l.add(id.getBytes("UTF-8"));
                    Map all_props = (Map)taggable.getTaggableTransientProperty(TP_KEY);
                    HashMap<String, Long> props = new HashMap<String, Long>();
                    if (all_props != null && (time_added = (Long)all_props.get(this.TP_KEY_TAG_ADDED_TIME)) != null) {
                        props.put("a", time_added);
                    }
                    p.add(props);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            map.put("o", l);
            map.put("p", p);
        }
    }

    @Override
    public void setTagName(String name) throws TagException {
        super.setTagName(name);
        this.getManager().tagChanged(this);
    }

    @Override
    public long getTaggableAddedTime(Taggable taggble) {
        Long added_time;
        Map all_props = (Map)taggble.getTaggableTransientProperty(TP_KEY);
        if (all_props != null && (added_time = (Long)all_props.get(this.TP_KEY_TAG_ADDED_TIME)) != null) {
            return added_time * 1000L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void addTaggable(Taggable t) {
        if (this.removed) {
            Debug.out("Tag has been removed");
            return;
        }
        boolean added = this.objects.add(t);
        if (added && this.getTagType().isTagTypePersistent()) {
            String string = TP_KEY;
            // MONITORENTER : "TagWithState:tp_key"
            HashMap<String, Long> all_props = (HashMap<String, Long>)t.getTaggableTransientProperty(TP_KEY);
            if (all_props == null) {
                all_props = new HashMap<String, Long>();
            }
            all_props.put(this.TP_KEY_TAG_ADDED_TIME, SystemTime.getCurrentTime() / 1000L);
            t.setTaggableTransientProperty(TP_KEY, all_props);
            // MONITOREXIT : string
        }
        super.addTaggable(t);
        if (!added) return;
        this.getManager().tagContentsChanged(this);
        if (this.tag_notifications == null) return;
        this.checkNotifications(t, true);
    }

    @Override
    public void removeTaggable(Taggable t) {
        boolean removed = this.objects.remove(t);
        super.removeTaggable(t);
        if (removed) {
            this.getManager().tagContentsChanged(this);
            if (this.tag_notifications != null) {
                this.checkNotifications(t, false);
            }
        }
    }

    protected void checkNotifications(Taggable taggable, boolean is_add) {
        int flags = this.getPostingNotifications();
        if (flags != 0) {
            boolean rem;
            boolean add = (flags & 1) != 0;
            boolean bl = rem = (flags & 2) != 0;
            if (add == is_add || rem == !is_add) {
                TaggableResolver resolver = taggable.getTaggableResolver();
                String name = resolver != null ? resolver.getDisplayName(taggable) : taggable.toString();
                name = MessageText.getString(is_add ? "tag.notification.added" : "tag.notification.removed", new String[]{name, this.getTagName(true)});
                HashMap<String, String> cb_data = new HashMap<String, String>();
                cb_data.put("allowReAdd", "true");
                cb_data.put("taguid", String.valueOf(this.getTagUID()));
                cb_data.put("id", String.valueOf(taggable.getTaggableID()));
                String icon_id = "image.sidebar.tag-green";
                int[] color = this.getColor();
                if (color != null && color.length == 3) {
                    long rgb = color[0] << 16 | color[1] << 8 | color[2];
                    String hex = Long.toHexString(rgb);
                    while (hex.length() < 6) {
                        hex = "0" + hex;
                    }
                    icon_id = String.valueOf(icon_id) + "#" + hex;
                }
                LocalActivityManager.addLocalActivity(String.valueOf(this.getTagUID()) + ":" + taggable.getTaggableID() + ":" + is_add, icon_id, name, new String[]{MessageText.getString("label.view")}, ActivityCallback.class, cb_data);
            }
        }
    }

    @Override
    public void removeTag() {
        super.removeTag();
        this.removed = true;
    }

    protected boolean isRemoved() {
        return this.removed;
    }

    @Override
    public int getTaggedCount() {
        return this.objects.size();
    }

    @Override
    public boolean hasTaggable(Taggable t) {
        return this.objects.contains(t);
    }

    @Override
    public Set<Taggable> getTagged() {
        return this.objects.getSet();
    }

    public static class ActivityCallback
    implements LocalActivityManager.LocalActivityCallback {
        @Override
        public void actionSelected(String action, Map<String, String> data) {
            String taguid = data.get("taguid");
            final String id = data.get("id");
            if (taguid != null && id != null) {
                try {
                    TaggableResolver resolver;
                    TagType tt;
                    Tag tag = TagManagerFactory.getTagManager().lookupTagByUID(Long.parseLong(taguid));
                    if (tag != null && (tt = tag.getTagType()) instanceof TagTypeWithState && (resolver = ((TagTypeWithState)tt).getResolver()) != null) {
                        if (!tag.isVisible()) {
                            tag.setVisible(true);
                        }
                        tag.requestAttention();
                        SimpleTimer.addEvent("async", SystemTime.getOffsetTime(500L), new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                resolver.requestAttention(id);
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }
}

