/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagDownloadWithState;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TagTypeDownloadManual
extends TagTypeWithState {
    private static final int[] color_default;
    private final AtomicInteger next_tag_id = new AtomicInteger(0);

    static {
        int[] nArray = new int[3];
        nArray[1] = 140;
        nArray[2] = 66;
        color_default = nArray;
    }

    protected TagTypeDownloadManual(TaggableResolver resolver) {
        super(3, resolver, 511, "tag.type.man");
        this.addTagType();
    }

    @Override
    public boolean isTagTypePersistent() {
        return true;
    }

    @Override
    public boolean isTagTypeAuto() {
        return false;
    }

    @Override
    public int[] getColorDefault() {
        return color_default;
    }

    @Override
    public Tag createTag(String name, boolean auto_add) throws TagException {
        TagDownloadWithState new_tag = new TagDownloadWithState((TagTypeBase)this, this.next_tag_id.incrementAndGet(), name, true, true, true, true, 139);
        new_tag.setSupportsTagTranscode(true);
        new_tag.setSupportsFileLocation(true);
        if (auto_add) {
            this.addTag(new_tag);
        }
        return new_tag;
    }

    @Override
    protected TagDownloadWithState createTag(int tag_id, Map<String, Object> details) {
        TagDownloadWithState new_tag = new TagDownloadWithState((TagTypeBase)this, tag_id, details, true, true, true, true, 139);
        new_tag.setSupportsTagTranscode(true);
        new_tag.setSupportsFileLocation(true);
        this.next_tag_id.set(Math.max(this.next_tag_id.get(), tag_id + 1));
        return new_tag;
    }

    protected TagDownloadWithState importTag(Map details, Map config) {
        byte[] image_bytes;
        int tag_id = this.next_tag_id.incrementAndGet();
        this.getTagManager().setConf(this.getTagType(), tag_id, config);
        TagDownloadWithState new_tag = new TagDownloadWithState((TagTypeBase)this, tag_id, details, true, true, true, true, 139);
        new_tag.setSupportsTagTranscode(true);
        new_tag.setSupportsFileLocation(true);
        String image_file = MapUtils.getMapString(details, "_img_file", null);
        if (image_file != null && (image_bytes = (byte[])details.get("_img_bytes")) != null) {
            try {
                int pos;
                File img_dir = FileUtil.newFile(SystemProperties.getUserPath(), "tagicons");
                if (!img_dir.exists()) {
                    img_dir.mkdirs();
                }
                String prefix = (pos = image_file.indexOf(46)) == -1 ? image_file : image_file.substring(0, pos);
                String suffix = pos == -1 ? "" : image_file.substring(pos);
                int i = 0;
                while (i < 32) {
                    File img_file = FileUtil.newFile(img_dir, String.valueOf(i == 0 ? prefix : String.valueOf(prefix) + "_" + i) + suffix);
                    if (!img_file.exists()) {
                        FileUtil.writeBytesAsFile(img_file.getAbsolutePath(), image_bytes);
                        if (img_file.exists()) {
                            new_tag.setImageFile(img_file.getAbsolutePath());
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return new_tag;
    }
}

