/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.Core;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeAdapter;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableLifecycleAdapter;
import com.biglybt.core.tag.impl.TagManagerImpl;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentListener;
import com.biglybt.core.util.TorrentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class TagPropertyTrackerHandler
implements TagFeatureProperties.TagPropertyListener,
TOTorrentListener {
    private final Core core;
    private final TagManagerImpl tag_manager;
    private Set<TagFeatureProperties.TagProperty> properties = new HashSet<TagFeatureProperties.TagProperty>();
    private final Map<String, List<Tag>> tracker_host_map = new HashMap<String, List<Tag>>();
    private final AtomicBoolean sync_required = new AtomicBoolean(false);

    protected TagPropertyTrackerHandler(Core _core, TagManagerImpl _tm) {
        this.core = _core;
        this.tag_manager = _tm;
        TOTorrentFactory.addTorrentListener(this);
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                TagType[] tts;
                TagType[] tagTypeArray = tts = new TagType[]{TagPropertyTrackerHandler.this.tag_manager.getTagType(3), TagPropertyTrackerHandler.this.tag_manager.getTagType(5)};
                int n = tts.length;
                int n2 = 0;
                while (n2 < n) {
                    TagType tt = tagTypeArray[n2];
                    tt.addTagTypeListener(new TagTypeAdapter(){

                        @Override
                        public void tagAdded(Tag tag) {
                            TagFeatureProperties.TagProperty[] props;
                            TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
                            TagFeatureProperties.TagProperty[] tagPropertyArray = props = tfp.getSupportedProperties();
                            int n = props.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TagFeatureProperties.TagProperty prop = tagPropertyArray[n2];
                                if (prop.getName(false).equals("trackers")) {
                                    TagPropertyTrackerHandler.this.hookTagProperty(prop);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }, true);
                    ++n2;
                }
            }

            @Override
            public void taggableCreated(Taggable taggable) {
                TagPropertyTrackerHandler.this.handleDownload((DownloadManager)taggable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hookTagProperty(TagFeatureProperties.TagProperty property) {
        Set<TagFeatureProperties.TagProperty> set = this.properties;
        synchronized (set) {
            this.properties.add(property);
        }
        property.addListener(this);
        this.handleProperty(property, true);
    }

    @Override
    public void propertyChanged(TagFeatureProperties.TagProperty property) {
        this.handleProperty(property, false);
    }

    @Override
    public void propertySync(TagFeatureProperties.TagProperty property) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProperty(TagFeatureProperties.TagProperty property, boolean start_of_day) {
        boolean hit;
        Set<String> hosts;
        String[] trackers = property.getStringList();
        HashSet<String> tag_hosts = new HashSet<String>();
        String[] stringArray = trackers;
        int n = trackers.length;
        int n2 = 0;
        while (n2 < n) {
            String tracker = stringArray[n2];
            tag_hosts.add(tracker.toLowerCase(Locale.US));
            ++n2;
        }
        Tag tag = property.getTag();
        Map<String, List<Tag>> map = this.tracker_host_map;
        synchronized (map) {
            List<Tag> tags;
            for (Map.Entry entry : this.tracker_host_map.entrySet()) {
                tags = (List<Tag>)entry.getValue();
                if (!tags.contains(tag) || tag_hosts.contains(entry.getKey())) continue;
                tags.remove(tag);
            }
            for (String string : tag_hosts) {
                tags = this.tracker_host_map.get(string);
                if (tags == null) {
                    tags = new ArrayList<Tag>();
                    this.tracker_host_map.put(string, tags);
                } else if (tags.contains(tag)) continue;
                tags.add(tag);
            }
        }
        if (start_of_day) {
            return;
        }
        Set<Taggable> tag_dls = tag.getTagged();
        for (Taggable taggable : tag_dls) {
            DownloadManager dm = (DownloadManager)taggable;
            hosts = this.getAugmentedHosts(dm);
            hit = false;
            for (String host : hosts) {
                if (!tag_hosts.contains(host)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            tag.removeTaggable(taggable);
        }
        List<DownloadManager> list = this.core.getGlobalManager().getDownloadManagers();
        for (DownloadManager dm : list) {
            if (tag.hasTaggable(dm)) continue;
            hosts = this.getAugmentedHosts(dm);
            hit = false;
            for (String host : hosts) {
                if (!tag_hosts.contains(host)) continue;
                hit = true;
                break;
            }
            if (!hit) continue;
            tag.addTaggable(dm);
        }
    }

    private Set<String> getAugmentedHosts(DownloadManager dm) {
        Set<String> hosts = TorrentUtils.getUniqueTrackerHosts(dm.getTorrent(), true);
        HashSet<String> result = new HashSet<String>();
        for (String host : hosts) {
            result.add(host);
            String[] bits = host.split("\\.");
            String suffix = "";
            int i = bits.length - 1;
            while (i > 0) {
                String bit = bits[i];
                suffix = suffix == "" ? bit : String.valueOf(bit) + "." + suffix;
                result.add(suffix);
                --i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Tag> getTagsForDownload(DownloadManager dm) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        Map<String, List<Tag>> map = this.tracker_host_map;
        synchronized (map) {
            if (this.tracker_host_map.size() > 0) {
                Set<String> hosts = this.getAugmentedHosts(dm);
                for (String host : hosts) {
                    List<Tag> tags = this.tracker_host_map.get(host);
                    if (tags == null) continue;
                    result.addAll(tags);
                }
            }
        }
        return result;
    }

    private void handleDownload(DownloadManager dm) {
        List<Tag> applicable_tags = this.getTagsForDownload(dm);
        for (Tag tag : applicable_tags) {
            if (tag.hasTaggable(dm)) continue;
            tag.addTaggable(dm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync() {
        if (this.sync_required.getAndSet(false)) {
            ArrayList<TagFeatureProperties.TagProperty> to_do;
            Set<TagFeatureProperties.TagProperty> set = this.properties;
            synchronized (set) {
                to_do = new ArrayList<TagFeatureProperties.TagProperty>(this.properties);
            }
            for (TagFeatureProperties.TagProperty tp2 : to_do) {
                if (tp2.getStringList().length <= 0) continue;
                this.handleProperty(tp2, false);
            }
        }
    }

    @Override
    public void torrentChanged(TOTorrent torrent, int change_type, Object data) {
        if (change_type == 1) {
            this.sync_required.set(true);
        }
    }
}

