/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.tag.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManagerFactory;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.tag.TagFeatureExecOnAssign;
import com.biglybt.core.tag.TagFeatureLimits;
import com.biglybt.core.tag.TagFeatureProperties;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerListener;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagTypeListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableLifecycleAdapter;
import com.biglybt.core.tag.impl.TagManagerImpl;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginAdapter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagPropertyConstraintHandler
implements TagTypeListener,
DownloadListener {
    private static final Object DM_LISTENERS_ADDED = new Object();
    private static final Object DM_FILE_NAMES = new Object();
    private static final Object DM_FILE_NAMES_SELECTED = new Object();
    private static final Object DM_FILE_EXTS = new Object();
    private static final Object DM_FILE_EXTS_SELECTED = new Object();
    private static final Object DM_FILE_PATHS = new Object();
    private static final Object DM_FILE_PATHS_SELECTED = new Object();
    private static final Object DM_NAME = new Object();
    private static final Object DM_SAVE_PATH = new Object();
    private static final Object DM_PEER_SETS = new Object();
    private static final Object DM_RATES = new Object();
    private static final String EVAL_CTX_COLOURS = "colours";
    private static final String EVAL_CTX_TAG_SORT = "tag_sort";
    private final Core core;
    private final TagManagerImpl tag_manager;
    private final ShareManager share_manager;
    private volatile boolean initialised;
    private boolean initial_assignment_complete;
    private boolean stopping;
    private String ta_rating_name;
    final Map<Tag, TagConstraint> constrained_tags = new ConcurrentHashMap<Tag, TagConstraint>();
    private boolean dm_listener_added;
    final Map<Tag, Map<DownloadManager, Long>> apply_history = new HashMap<Tag, Map<DownloadManager, Long>>();
    private final AsyncDispatcher dispatcher = new AsyncDispatcher("tag:constraints");
    private final FrequencyLimitedDispatcher freq_lim_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            TagPropertyConstraintHandler.this.checkFreqLimUpdates();
        }
    }, 5000);
    final IdentityHashMap<DownloadManager, Set<TagConstraint>> freq_lim_pending = new IdentityHashMap();
    private DownloadManagerListener dm_listener = new DownloadManagerAdapter(){
        private Object[] keys = new Object[]{TagPropertyConstraintHandler.access$1(), TagPropertyConstraintHandler.access$2(), TagPropertyConstraintHandler.access$3()};

        @Override
        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
            boolean changed = false;
            Object[] objectArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                if (download.getUserData(key) != null) {
                    changed = true;
                }
                download.setUserData(key, null);
                ++n2;
            }
            if (changed) {
                TagPropertyConstraintHandler.this.nameEtcChanged(download);
            }
        }
    };
    private DownloadManagerStateAttributeListener dms_listener = new DownloadManagerStateAttributeListener(){
        private Object[] keys = new Object[]{TagPropertyConstraintHandler.access$4(), TagPropertyConstraintHandler.access$5(), TagPropertyConstraintHandler.access$6(), TagPropertyConstraintHandler.access$3()};

        @Override
        public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
            boolean changed = false;
            Object[] objectArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                if (download.getUserData(key) != null) {
                    changed = true;
                }
                download.setUserData(key, null);
                ++n2;
            }
            if (changed) {
                TagPropertyConstraintHandler.this.nameEtcChanged(download);
            }
        }
    };
    private static IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private static volatile int apply_all_secs;
    private static volatile int target_share_ratio;
    private TimerEventPeriodic timer;
    private static Object process_lock;
    private static int processing_disabled_count;
    private static List<Object[]> processing_queue;
    private static Pattern comp_op_pattern;
    private static Pattern comp_ift_pattern;
    private static Map<String, String> comp_op_map;
    private static Map<String, Object[]> config_value_cache;
    private static Map<String, String[]> config_key_map;
    private static final String CONFIG_FLOAT = "float";

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tag Auto Full Reapply Period Secs", "Stop Ratio"}, n -> {
            apply_all_secs = COConfigurationManager.getIntParameter("Tag Auto Full Reapply Period Secs");
            if (apply_all_secs <= 0) {
                apply_all_secs = 0;
            } else if (apply_all_secs < 10) {
                apply_all_secs = 10;
            }
            target_share_ratio = (int)(1000.0f * COConfigurationManager.getFloatParameter("Stop Ratio"));
        });
        process_lock = new Object();
        processing_queue = new ArrayList<Object[]>();
        comp_op_pattern = Pattern.compile("(.+?)(==|!=|>=|>|<=|<|\\+|-|\\*|/|%)(.+)");
        comp_ift_pattern = Pattern.compile("(.+?)\\?(.+):(.+)");
        comp_op_map = new HashMap<String, String>();
        comp_op_map.put("==", "isEQ");
        comp_op_map.put("!=", "isNEQ");
        comp_op_map.put(">=", "isGE");
        comp_op_map.put("<=", "isLE");
        comp_op_map.put(">", "isGT");
        comp_op_map.put("<", "isLT");
        comp_op_map.put("+", "plus");
        comp_op_map.put("-", "minus");
        comp_op_map.put("*", "mult");
        comp_op_map.put("/", "div");
        comp_op_map.put("%", "rem");
        config_value_cache = new ConcurrentHashMap<String, Object[]>();
        config_key_map = new HashMap<String, String[]>();
        String[][] entries = new String[][]{{"queue.seeding.ignore.share.ratio", CONFIG_FLOAT, "Stop Ratio"}};
        ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                config_value_cache.clear();
            }
        };
        String[][] stringArrayArray = entries;
        int n2 = entries.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] entry = stringArrayArray[n3];
            config_key_map.put(entry[0], new String[]{entry[1], entry[2]});
            COConfigurationManager.addParameterListener(entry[2], listener);
            ++n3;
        }
    }

    protected TagPropertyConstraintHandler(Core _core, TagManagerImpl _tm) {
        ShareManager sm;
        this.core = _core;
        this.tag_manager = _tm;
        final PluginInterface default_pi = this.core.getPluginManager().getDefaultPluginInterface();
        try {
            sm = default_pi.getShareManager();
        }
        catch (Throwable e) {
            Debug.out(e);
            sm = null;
        }
        this.share_manager = sm;
        try {
            default_pi.addListener(new PluginAdapter(){

                @Override
                public void initializationComplete() {
                    TorrentManager tm;
                    TorrentAttribute ta_rating;
                    default_pi.removeListener(this);
                    PluginInterface rating_pi = TagPropertyConstraintHandler.this.core.getPluginManager().getPluginInterfaceByID("azrating");
                    if (rating_pi != null && (ta_rating = (tm = rating_pi.getTorrentManager()).getPluginAttribute("rating")) != null) {
                        TagPropertyConstraintHandler.this.ta_rating_name = ta_rating.getName();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void stopping(Core core) {
                TagPropertyConstraintHandler.this.stopping = true;
            }
        });
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                try {
                    TagType tt_manual_download = TagPropertyConstraintHandler.this.tag_manager.getTagType(3);
                    tt_manual_download.addTagTypeListener(TagPropertyConstraintHandler.this, true);
                }
                catch (Throwable throwable) {
                    CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void coreRunning(Core core) {
                            Map<Tag, TagConstraint> map = (this).TagPropertyConstraintHandler.this.constrained_tags;
                            synchronized (map) {
                                TagPropertyConstraintHandler.this.initialised = true;
                                TagPropertyConstraintHandler.this.checkRecompiles();
                                TagPropertyConstraintHandler.this.apply((List<DownloadManager>)core.getGlobalManager().getDownloadManagers(), true);
                            }
                        }
                    });
                    throw throwable;
                }
                CoreFactory.addCoreRunningListener(new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public void taggableCreated(Taggable taggable) {
                DownloadManager dm = (DownloadManager)taggable;
                long added = dm.getDownloadState().getLongParameter("stats.download.added.time");
                boolean is_new = SystemTime.getCurrentTime() - added < 300000L;
                TagPropertyConstraintHandler.this.apply(dm, null, false, is_new);
            }
        });
        this.tag_manager.addTagManagerListener(new TagManagerListener(){

            @Override
            public void tagTypeRemoved(TagManager manager, TagType tag_type) {
            }

            @Override
            public void tagTypeAdded(TagManager manager, TagType tag_type) {
                if (tag_type.getTagType() == 4) {
                    tag_type.addTagTypeListener(new TagTypeListener(){

                        @Override
                        public void tagEventOccurred(TagTypeListener.TagEvent event2) {
                            if (event2.getEventType() == 0) {
                                TagPropertyConstraintHandler.this.checkRecompiles();
                            }
                        }

                        @Override
                        public void tagTypeChanged(TagType tag_type) {
                        }
                    }, false);
                }
            }
        }, true);
    }

    private void checkRecompiles() {
        for (Tag tag : this.constrained_tags.keySet()) {
            if (tag.getTransientProperty("Constraint Error") == null) continue;
            TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
            TagFeatureProperties.TagProperty prop = tfp.getProperty("constraint");
            this.handleProperty(prop, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessingEnabled(boolean enabled) {
        Object object = process_lock;
        synchronized (object) {
            if (enabled) {
                if (--processing_disabled_count == 0) {
                    ArrayList<Object[]> to_do = new ArrayList<Object[]>(processing_queue);
                    processing_queue.clear();
                    for (Object[] entry : to_do) {
                        TagConstraint constraint = (TagConstraint)entry[0];
                        Object target = entry[1];
                        boolean is_new = (Boolean)entry[2];
                        try {
                            if (target instanceof DownloadManager) {
                                constraint.apply((DownloadManager)target, is_new);
                                continue;
                            }
                            constraint.apply((List)target);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            } else {
                ++processing_disabled_count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canProcess(TagConstraint constraint, DownloadManager dm, boolean is_new) {
        Object object = process_lock;
        synchronized (object) {
            block4: {
                if (processing_disabled_count != 0) break block4;
                return true;
            }
            processing_queue.add(new Object[]{constraint, dm, is_new});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canProcess(TagConstraint constraint, List<DownloadManager> dms) {
        Object object = process_lock;
        synchronized (object) {
            block4: {
                if (processing_disabled_count != 0) break block4;
                return true;
            }
            processing_queue.add(new Object[]{constraint, dms, false});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDMListeners(DownloadManager dm) {
        Object object = DM_LISTENERS_ADDED;
        synchronized (object) {
            if (dm.getUserData(DM_LISTENERS_ADDED) == null) {
                dm.addListener(this.dm_listener);
                DownloadManagerState dms = dm.getDownloadState();
                dms.addListener(this.dms_listener, "filelinks2", 1);
                dms.addListener(this.dms_listener, "canosavedir", 1);
                dms.addListener(this.dms_listener, "displayname", 1);
                dm.setUserData(DM_LISTENERS_ADDED, "");
            }
        }
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagEventOccurred(TagTypeListener.TagEvent event2) {
        TagConstraint tc;
        int type = event2.getEventType();
        Tag tag = event2.getTag();
        if (type == 0) {
            this.tagAdded(tag);
        } else if (type == 2) {
            this.tagRemoved(tag);
        } else if (type == 4 && (tc = this.constrained_tags.get(tag)) != null) {
            tc.checkStuff();
        }
    }

    public void tagAdded(Tag tag) {
        TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
        TagFeatureProperties.TagProperty prop = tfp.getProperty("constraint");
        if (prop != null) {
            prop.addListener(new TagFeatureProperties.TagPropertyListener(){

                @Override
                public void propertyChanged(TagFeatureProperties.TagProperty property) {
                    TagPropertyConstraintHandler.this.handleProperty(property, false);
                }

                @Override
                public void propertySync(TagFeatureProperties.TagProperty property) {
                }
            });
            this.handleProperty(prop, false);
        }
        tag.addTagListener(new TagListener(){

            @Override
            public void taggableSync(Tag tag) {
            }

            @Override
            public void taggableRemoved(Tag tag, Taggable tagged) {
                TagPropertyConstraintHandler.this.apply((DownloadManager)tagged, tag, true, false);
            }

            @Override
            public void taggableAdded(Tag tag, Taggable tagged) {
                TagPropertyConstraintHandler.this.apply((DownloadManager)tagged, tag, true, false);
            }
        }, false);
    }

    private void checkTimer() {
        if (this.constrained_tags.size() > 0) {
            if (this.timer == null) {
                int TICK_SECS = 5;
                int MIN_TICKS = 12;
                this.timer = SimpleTimer.addPeriodicEvent("tag:constraint:timer", 5000L, new TimerEventPerformer(){
                    int tick_count = 0;
                    boolean apply_done = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        ArrayList<TagConstraint> time_constraints;
                        ArrayList<TagConstraint> ps_constraints;
                        ++this.tick_count;
                        if (this.tick_count % 12 == 0) {
                            GlobalManager gm = TagPropertyConstraintHandler.this.core.getGlobalManager();
                            List<DownloadManager> all_dms = gm.getDownloadManagers();
                            for (DownloadManager dm : all_dms) {
                                long[] rates;
                                int state = dm.getState();
                                if (state != 50 && state != 60 || (rates = (long[])dm.getUserData(DM_RATES)) == null) continue;
                                DownloadManagerStats stats2 = dm.getStats();
                                long down = stats2.getTotalDataBytesReceived() + stats2.getTotalProtocolBytesReceived();
                                long up = stats2.getTotalDataBytesSent() + stats2.getTotalProtocolBytesSent();
                                if (rates[0] != -1L) {
                                    long down_diff = down - rates[0];
                                    long up_diff = up - rates[1];
                                    rates[2] = down_diff / 60L;
                                    rates[3] = up_diff / 60L;
                                }
                                rates[0] = down;
                                rates[1] = up;
                            }
                        }
                        HashSet<Tag> peer_sets = new HashSet<Tag>();
                        List ps_changed = Collections.emptyList();
                        Map<Tag, TagConstraint> state = TagPropertyConstraintHandler.this.constrained_tags;
                        synchronized (state) {
                            ps_constraints = new ArrayList<TagConstraint>(TagPropertyConstraintHandler.this.constrained_tags.size());
                            time_constraints = new ArrayList<TagConstraint>(TagPropertyConstraintHandler.this.constrained_tags.size());
                            for (TagConstraint tc : TagPropertyConstraintHandler.this.constrained_tags.values()) {
                                if (tc.getDependsOnLevel() == 2) {
                                    time_constraints.add(tc);
                                }
                                Set tags = tc.getDependsOnTags();
                                boolean added = false;
                                for (Tag tag : tags) {
                                    if (tag.getTagType().getTagType() != 4) continue;
                                    peer_sets.add(tag);
                                    added = true;
                                }
                                if (!added) continue;
                                ps_constraints.add(tc);
                            }
                        }
                        if (!peer_sets.isEmpty()) {
                            GlobalManager gm = TagPropertyConstraintHandler.this.core.getGlobalManager();
                            IdentityHashMap<DownloadManager, HashSet<Tag>> dm_map = new IdentityHashMap<DownloadManager, HashSet<Tag>>();
                            for (Tag ps : peer_sets) {
                                Set<Taggable> peers = ps.getTagged();
                                for (Taggable peer : peers) {
                                    PEPeer pe_peer = (PEPeer)peer;
                                    byte[] dl_hash = pe_peer.getManager().getHash();
                                    DownloadManager dm = gm.getDownloadManager(new HashWrapper(dl_hash));
                                    if (dm == null) continue;
                                    HashSet<Tag> s = (HashSet<Tag>)dm_map.get(dm);
                                    if (s == null) {
                                        s = new HashSet<Tag>();
                                        dm_map.put(dm, s);
                                    }
                                    s.add(ps);
                                }
                            }
                            List<DownloadManager> all_dms = gm.getDownloadManagers();
                            ps_changed = new ArrayList(all_dms.size());
                            for (DownloadManager dm : all_dms) {
                                Set existing;
                                Set current = (Set)dm_map.get(dm);
                                if (current == (existing = (Set)dm.getUserData(DM_PEER_SETS))) continue;
                                if (current == null) {
                                    dm.setUserData(DM_PEER_SETS, null);
                                    ps_changed.add(dm);
                                    continue;
                                }
                                if (existing == null) {
                                    dm.setUserData(DM_PEER_SETS, current);
                                    ps_changed.add(dm);
                                    continue;
                                }
                                if (existing.equals(current)) continue;
                                dm.setUserData(DM_PEER_SETS, current);
                                ps_changed.add(dm);
                            }
                        }
                        if (this.tick_count % 6 == 0) {
                            TagPropertyConstraintHandler.this.apply_history.clear();
                        }
                        boolean did_apply_all = false;
                        if (apply_all_secs == 0) {
                            if (!this.apply_done) {
                                did_apply_all = TagPropertyConstraintHandler.this.applyAll();
                            }
                        } else {
                            int apply_all_ticks = apply_all_secs / 5;
                            if (this.tick_count % apply_all_ticks == 0) {
                                did_apply_all = TagPropertyConstraintHandler.this.applyAll();
                            }
                        }
                        if (did_apply_all) {
                            this.apply_done = true;
                        } else {
                            if (!time_constraints.isEmpty()) {
                                GlobalManager gm = TagPropertyConstraintHandler.this.core.getGlobalManager();
                                TagPropertyConstraintHandler.this.apply((List<DownloadManager>)gm.getDownloadManagers(), time_constraints);
                            }
                            if (!ps_changed.isEmpty()) {
                                TagPropertyConstraintHandler.this.apply((List<DownloadManager>)ps_changed, ps_constraints);
                            }
                        }
                    }
                });
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void coreRunning(Core core) {
                        Map<Tag, TagConstraint> map = TagPropertyConstraintHandler.this.constrained_tags;
                        synchronized (map) {
                            if (TagPropertyConstraintHandler.this.timer != null) {
                                core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getGlobalDownloadEventNotifier().addListener(TagPropertyConstraintHandler.this);
                                TagPropertyConstraintHandler.this.dm_listener_added = true;
                            }
                        }
                    }
                });
            }
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            if (this.dm_listener_added) {
                this.core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getGlobalDownloadEventNotifier().removeListener(this);
            }
            this.apply_history.clear();
        }
    }

    private void checkFreqLimUpdates() {
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                IdentityHashMap<DownloadManager, Set<TagConstraint>> identityHashMap = TagPropertyConstraintHandler.this.freq_lim_pending;
                synchronized (identityHashMap) {
                    for (Map.Entry<DownloadManager, Set<TagConstraint>> entry : TagPropertyConstraintHandler.this.freq_lim_pending.entrySet()) {
                        for (TagConstraint con : entry.getValue()) {
                            con.apply(entry.getKey(), false);
                        }
                    }
                    TagPropertyConstraintHandler.this.freq_lim_pending.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nameEtcChanged(DownloadManager dm) {
        HashSet<TagConstraint> interesting = new HashSet<TagConstraint>();
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (!this.initialised) {
                return;
            }
            for (TagConstraint tc : this.constrained_tags.values()) {
                if (!tc.dependsOnNameEtc()) continue;
                interesting.add(tc);
            }
        }
        if (interesting.size() > 0) {
            map = this.freq_lim_pending;
            synchronized (map) {
                Set<TagConstraint> existing = this.freq_lim_pending.get(dm);
                if (existing == null) {
                    this.freq_lim_pending.put(dm, interesting);
                } else {
                    existing.addAll(interesting);
                }
            }
            this.freq_lim_dispatcher.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(Download download, int old_state, int new_state) {
        HashSet<TagConstraint> interesting = new HashSet<TagConstraint>();
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (!this.initialised) {
                return;
            }
            for (TagConstraint tc : this.constrained_tags.values()) {
                if (!tc.dependsOnDownloadState()) continue;
                interesting.add(tc);
            }
        }
        if (interesting.size() > 0) {
            DownloadManager dm = PluginCoreUtils.unwrap(download);
            IdentityHashMap<DownloadManager, Set<TagConstraint>> identityHashMap = this.freq_lim_pending;
            synchronized (identityHashMap) {
                Set<TagConstraint> existing = this.freq_lim_pending.get(dm);
                if (existing == null) {
                    this.freq_lim_pending.put(dm, interesting);
                } else {
                    existing.addAll(interesting);
                }
            }
            this.freq_lim_dispatcher.dispatch();
        }
    }

    @Override
    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    protected String getTagStatus(Tag tag) {
        TagConstraint tc = this.constrained_tags.get(tag);
        if (tc != null) {
            return tc.getStatus();
        }
        return null;
    }

    protected String[] explain(Tag tag, Taggable taggable) {
        TagConstraint tc = this.constrained_tags.get(tag);
        if (tc == null) {
            return new String[]{"no constraint"};
        }
        if (!(taggable instanceof DownloadManager)) {
            return new String[]{"invalid taggable"};
        }
        StringBuilder debug = new StringBuilder(1024);
        boolean result = tc.testConstraint((DownloadManager)taggable, debug);
        return new String[]{String.valueOf(result), tc.getString(), debug.toString()};
    }

    protected Set<Tag> getDependsOnTags(Tag tag) {
        TagConstraint tc = this.constrained_tags.get(tag);
        if (tc != null) {
            return tc.getDependsOnTags();
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tagRemoved(Tag tag) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.containsKey(tag)) {
                this.constrained_tags.remove(tag);
                this.checkTimer();
            }
        }
    }

    private boolean isStopping() {
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProperty(TagFeatureProperties.TagProperty property, boolean force) {
        Tag tag = property.getTag();
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            String options;
            String constraint;
            boolean enabled = property.isEnabled();
            String[] value = property.getStringList();
            if (value == null) {
                constraint = "";
                options = "";
            } else {
                constraint = value.length > 0 && value[0] != null ? value[0].trim() : "";
                String string = options = value.length > 1 && value[1] != null ? value[1].trim() : "";
            }
            if (constraint.length() == 0) {
                if (this.constrained_tags.containsKey(tag)) {
                    this.constrained_tags.remove(tag);
                    tag.setTransientProperty("Constraint Error", null);
                }
            } else {
                TagConstraint con = this.constrained_tags.get(tag);
                if (!force && con != null && con.getConstraint().equals(constraint) && con.getOptions().equals(options) && con.isEnabled() == enabled) {
                    return;
                }
                con = new TagConstraint(this, tag, constraint, options, enabled);
                this.constrained_tags.put(tag, con);
                if (this.initialised) {
                    this.apply(con);
                }
            }
            this.checkTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final DownloadManager dm, Tag related_tag, boolean auto, final boolean is_new) {
        if (dm.isDestroyed()) {
            return;
        }
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return;
            }
            if (auto && !this.initial_assignment_complete) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList<TagConstraint> cons;
                Map<Tag, TagConstraint> map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList<TagConstraint>(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (TagConstraint con : cons) {
                    con.apply(dm, is_new);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final List<DownloadManager> dms, final boolean initial_assignment) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList<TagConstraint> cons;
                Map<Tag, TagConstraint> map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList<TagConstraint>(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (TagConstraint tagConstraint : cons) {
                    tagConstraint.apply(dms);
                }
                if (initial_assignment) {
                    Map<Tag, TagConstraint> map2 = TagPropertyConstraintHandler.this.constrained_tags;
                    synchronized (map2) {
                        TagPropertyConstraintHandler.this.initial_assignment_complete = true;
                    }
                    for (TagConstraint tagConstraint : cons) {
                        tagConstraint.apply(dms);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final TagConstraint constraint) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (!this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                List<DownloadManager> dms = TagPropertyConstraintHandler.this.core.getGlobalManager().getDownloadManagers();
                constraint.apply(dms);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final List<DownloadManager> dms, final List<TagConstraint> cons) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (!this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                for (TagConstraint con : cons) {
                    con.apply(dms);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean applyAll() {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return false;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList<TagConstraint> cons;
                List<DownloadManager> dms = TagPropertyConstraintHandler.this.core.getGlobalManager().getDownloadManagers();
                Map<Tag, TagConstraint> map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList<TagConstraint>(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (TagConstraint con : cons) {
                    con.apply(dms);
                }
            }
        });
        return true;
    }

    public TagConstraint compileConstraint(String expr) {
        return new TagConstraint(this, null, expr, null, true);
    }

    static /* synthetic */ ShareManager access$12(TagPropertyConstraintHandler tagPropertyConstraintHandler) {
        return tagPropertyConstraintHandler.share_manager;
    }

    static /* synthetic */ IpFilter access$13() {
        return ip_filter;
    }

    private static class TagConstraint
    implements com.biglybt.core.tag.TagConstraint {
        private final TagPropertyConstraintHandler handler;
        private final Tag tag_maybe_null;
        private final String constraint;
        private final boolean enabled;
        private final boolean auto_add;
        private final boolean auto_remove;
        private final boolean new_only;
        private final ConstraintExpr expr;
        private boolean depends_on_download_state;
        private boolean depends_on_names_etc;
        private int depends_on_level = 0;
        private Set<Tag> dependent_on_tags;
        private boolean dependent_on_peer_sets;
        private Set<Tag> tag_weights;
        private int tag_weights_opt = 0;
        private boolean must_check_dependencies;
        private Average activity_average = Average.getInstance(1000, 60);
        private String error;
        static final Map<String, Integer> fn_map = new HashMap<String, Integer>();
        private static final int FT_HAS_TAG = 1;
        private static final int FT_IS_PRIVATE = 2;
        private static final int FT_GE = 3;
        private static final int FT_GT = 4;
        private static final int FT_LE = 5;
        private static final int FT_LT = 6;
        private static final int FT_EQ = 7;
        private static final int FT_NEQ = 8;
        private static final int FT_CONTAINS = 9;
        private static final int FT_MATCHES = 10;
        private static final int FT_HAS_NET = 11;
        private static final int FT_IS_COMPLETE = 12;
        private static final int FT_CAN_ARCHIVE = 13;
        private static final int FT_IS_FORCE_START = 14;
        private static final int FT_JAVASCRIPT = 15;
        private static final int FT_IS_CHECKING = 16;
        private static final int FT_IS_STOPPED = 17;
        private static final int FT_IS_PAUSED = 18;
        private static final int FT_IS_ERROR = 19;
        private static final int FT_IS_MAGNET = 20;
        private static final int FT_IS_LOW_NOISE = 21;
        private static final int FT_COUNT_TAG = 22;
        private static final int FT_HAS_TAG_GROUP = 23;
        private static final int FT_HOURS_TO_SECS = 24;
        private static final int FT_DAYS_TO_SECS = 25;
        private static final int FT_WEEKS_TO_SECS = 26;
        private static final int FT_GET_CONFIG = 27;
        private static final int FT_HAS_TAG_AGE = 28;
        private static final int FT_LOWERCASE = 29;
        private static final int FT_SET_COLOURS = 30;
        private static final int FT_IS_NEW = 31;
        private static final int FT_IS_SUPER_SEEDING = 32;
        private static final int FT_IS_SEQUENTIAL = 33;
        private static final int FT_TAG_POSITION = 34;
        private static final int FT_IS_SHARE = 35;
        private static final int FT_IS_UNALLOCATED = 36;
        private static final int FT_IS_QUEUED = 37;
        private static final int FT_IS_IP_FILTERED = 38;
        private static final int FT_COUNT_TRACKERS = 39;
        private static final int FT_IS_MOVING = 40;
        private static final int FT_SET_TAG_SORT = 41;
        private static final int FT_TIME_TO_ELAPSED = 42;
        private static final int FT_TO_MB = 43;
        private static final int FT_TO_MiB = 44;
        private static final int FT_TO_GB = 45;
        private static final int FT_TO_GiB = 46;
        private static final int FT_PLUS = 47;
        private static final int FT_MINUS = 48;
        private static final int FT_MULT = 49;
        private static final int FT_DIV = 50;
        private static final int FT_GET_TAG_WEIGHT = 51;
        private static final int FT_IF_THEN_ELSE = 52;
        private static final int FT_IS_SEEDING = 53;
        private static final int FT_IS_DOWNLOADING = 54;
        private static final int FT_IS_RUNNING = 55;
        private static final int FT_REM = 56;
        private static final int FT_MIN = 57;
        private static final int FT_MAX = 58;
        private static final int DEP_STATIC = 0;
        private static final int DEP_RUNNING = 1;
        private static final int DEP_TIME = 2;
        static final Map<String, int[]> keyword_map;
        private static final int KW_SHARE_RATIO = 0;
        private static final int KW_AGE = 1;
        private static final int KW_PERCENT = 2;
        private static final int KW_DOWNLOADING_FOR = 3;
        private static final int KW_SEEDING_FOR = 4;
        private static final int KW_SWARM_MERGE = 5;
        private static final int KW_LAST_ACTIVE = 6;
        private static final int KW_SEED_COUNT = 7;
        private static final int KW_PEER_COUNT = 8;
        private static final int KW_SEED_PEER_RATIO = 9;
        private static final int KW_RESUME_IN = 10;
        private static final int KW_MIN_OF_HOUR = 11;
        private static final int KW_HOUR_OF_DAY = 12;
        private static final int KW_DAY_OF_WEEK = 13;
        private static final int KW_TAG_AGE = 14;
        private static final int KW_COMPLETED_AGE = 15;
        private static final int KW_PEER_MAX_COMP = 16;
        private static final int KW_PEER_AVERAGE_COMP = 17;
        private static final int KW_LEECHER_MAX_COMP = 18;
        private static final int KW_SIZE = 19;
        private static final int KW_SIZE_MB = 20;
        private static final int KW_SIZE_GB = 21;
        private static final int KW_FILE_COUNT = 22;
        private static final int KW_AVAILABILITY = 23;
        private static final int KW_UP_IDLE = 24;
        private static final int KW_DOWN_IDLE = 25;
        private static final int KW_DOWNLOADED = 26;
        private static final int KW_UPLOADED = 27;
        private static final int KW_NAME = 28;
        private static final int KW_FILE_NAMES = 29;
        private static final int KW_SAVE_PATH = 30;
        private static final int KW_SAVE_FOLDER = 31;
        private static final int KW_MAX_UP = 32;
        private static final int KW_MAX_DOWN = 33;
        private static final int KW_FILE_NAMES_SELECTED = 34;
        private static final int KW_FILE_EXTS = 35;
        private static final int KW_FILE_EXTS_SELECTED = 36;
        private static final int KW_TORRENT_TYPE = 37;
        private static final int KW_FILE_PATHS = 38;
        private static final int KW_FILE_PATHS_SELECTED = 39;
        private static final int KW_TARGET_RATIO = 40;
        private static final int KW_TAG_NAMES = 41;
        private static final int KW_TRACKER_STATUS = 42;
        private static final int KW_FULL_COPY_SEEN = 43;
        private static final int KW_REMAINING = 44;
        private static final int KW_DOWN_SPEED = 45;
        private static final int KW_UP_SPEED = 46;
        private static final int KW_SESSION_AGE = 47;
        private static final int KW_PLUGIN_MY_RATING = 48;

        static {
            fn_map.put("hastag", 1);
            fn_map.put("isprivate", 2);
            fn_map.put("isge", 3);
            fn_map.put("isgt", 4);
            fn_map.put("isle", 5);
            fn_map.put("islt", 6);
            fn_map.put("iseq", 7);
            fn_map.put("isneq", 8);
            fn_map.put("contains", 9);
            fn_map.put("matches", 10);
            fn_map.put("hasnet", 11);
            fn_map.put("iscomplete", 12);
            fn_map.put("canarchive", 13);
            fn_map.put("isforcestart", 14);
            fn_map.put("javascript", 15);
            fn_map.put("ischecking", 16);
            fn_map.put("isstopped", 17);
            fn_map.put("ispaused", 18);
            fn_map.put("isseeding", 53);
            fn_map.put("isdownloading", 54);
            fn_map.put("isrunning", 55);
            fn_map.put("iserror", 19);
            fn_map.put("ismagnet", 20);
            fn_map.put("islownoise", 21);
            fn_map.put("counttag", 22);
            fn_map.put("hastaggroup", 23);
            fn_map.put("hourstoseconds", 24);
            fn_map.put("htos", 24);
            fn_map.put("h2s", 24);
            fn_map.put("daystoseconds", 25);
            fn_map.put("dtos", 25);
            fn_map.put("d2s", 25);
            fn_map.put("weekstoseconds", 26);
            fn_map.put("wtos", 26);
            fn_map.put("w2s", 26);
            fn_map.put("getconfig", 27);
            fn_map.put("hastagage", 28);
            fn_map.put("lowercase", 29);
            fn_map.put("setcolours", 30);
            fn_map.put("setcolors", 30);
            fn_map.put("isnew", 31);
            fn_map.put("issuperseeding", 32);
            fn_map.put("issequential", 33);
            fn_map.put("tagposition", 34);
            fn_map.put("isshare", 35);
            fn_map.put("isunallocated", 36);
            fn_map.put("isqueued", 37);
            fn_map.put("isipfiltered", 38);
            fn_map.put("counttrackers", 39);
            fn_map.put("ismoving", 40);
            fn_map.put("settagsort", 41);
            fn_map.put("timetoelapsed", 42);
            fn_map.put("tomb", 43);
            fn_map.put("tomib", 44);
            fn_map.put("togb", 45);
            fn_map.put("togib", 46);
            fn_map.put("plus", 47);
            fn_map.put("minus", 48);
            fn_map.put("mult", 49);
            fn_map.put("div", 50);
            fn_map.put("rem", 56);
            fn_map.put("min", 57);
            fn_map.put("max", 58);
            fn_map.put("gettagweight", 51);
            fn_map.put("ifthenelse", 52);
            keyword_map = new HashMap<String, int[]>();
            int[] nArray = new int[2];
            nArray[1] = 1;
            keyword_map.put("shareratio", nArray);
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            keyword_map.put("share_ratio", nArray2);
            keyword_map.put("age", new int[]{1, 2});
            keyword_map.put("percent", new int[]{2, 1});
            keyword_map.put("downloadingfor", new int[]{3, 1});
            keyword_map.put("downloading_for", new int[]{3, 1});
            keyword_map.put("seedingfor", new int[]{4, 1});
            keyword_map.put("seeding_for", new int[]{4, 1});
            keyword_map.put("swarmmergebytes", new int[]{5, 1});
            keyword_map.put("swarm_merge_bytes", new int[]{5, 1});
            keyword_map.put("lastactive", new int[]{6, 1});
            keyword_map.put("last_active", new int[]{6, 1});
            keyword_map.put("seedcount", new int[]{7, 2});
            keyword_map.put("seed_count", new int[]{7, 2});
            keyword_map.put("peercount", new int[]{8, 2});
            keyword_map.put("peer_count", new int[]{8, 2});
            keyword_map.put("seedpeerratio", new int[]{9, 2});
            keyword_map.put("seed_peer_ratio", new int[]{9, 2});
            keyword_map.put("resumein", new int[]{10, 2});
            keyword_map.put("resume_in", new int[]{10, 2});
            keyword_map.put("minofhour", new int[]{11, 2});
            keyword_map.put("min_of_hour", new int[]{11, 2});
            keyword_map.put("hourofday", new int[]{12, 2});
            keyword_map.put("hour_of_day", new int[]{12, 2});
            keyword_map.put("dayofweek", new int[]{13, 2});
            keyword_map.put("day_of_week", new int[]{13, 2});
            keyword_map.put("tagage", new int[]{14, 2});
            keyword_map.put("tag_age", new int[]{14, 2});
            keyword_map.put("completedage", new int[]{15, 2});
            keyword_map.put("completed_age", new int[]{15, 2});
            keyword_map.put("peermaxcompletion", new int[]{16, 1});
            keyword_map.put("peer_max_completion", new int[]{16, 1});
            keyword_map.put("leechmaxcompletion", new int[]{18, 1});
            keyword_map.put("leech_max_completion", new int[]{18, 1});
            keyword_map.put("leechermaxcompletion", new int[]{18, 1});
            keyword_map.put("leecher_max_completion", new int[]{18, 1});
            keyword_map.put("peeraveragecompletion", new int[]{17, 1});
            keyword_map.put("peer_average_completion", new int[]{17, 1});
            int[] nArray3 = new int[2];
            nArray3[0] = 19;
            keyword_map.put("size", nArray3);
            int[] nArray4 = new int[2];
            nArray4[0] = 20;
            keyword_map.put("sizemb", nArray4);
            int[] nArray5 = new int[2];
            nArray5[0] = 20;
            keyword_map.put("size_mb", nArray5);
            int[] nArray6 = new int[2];
            nArray6[0] = 21;
            keyword_map.put("sizegb", nArray6);
            int[] nArray7 = new int[2];
            nArray7[0] = 21;
            keyword_map.put("size_gb", nArray7);
            int[] nArray8 = new int[2];
            nArray8[0] = 22;
            keyword_map.put("filecount", nArray8);
            int[] nArray9 = new int[2];
            nArray9[0] = 22;
            keyword_map.put("file_count", nArray9);
            keyword_map.put("availability", new int[]{23, 1});
            keyword_map.put("upidle", new int[]{24, 1});
            keyword_map.put("up_idle", new int[]{24, 1});
            keyword_map.put("downidle", new int[]{25, 1});
            keyword_map.put("down_idle", new int[]{25, 1});
            keyword_map.put("downloaded", new int[]{26, 1});
            keyword_map.put("uploaded", new int[]{27, 1});
            int[] nArray10 = new int[2];
            nArray10[0] = 28;
            keyword_map.put("name", nArray10);
            int[] nArray11 = new int[2];
            nArray11[0] = 29;
            keyword_map.put("filenames", nArray11);
            int[] nArray12 = new int[2];
            nArray12[0] = 29;
            keyword_map.put("file_names", nArray12);
            int[] nArray13 = new int[2];
            nArray13[0] = 34;
            keyword_map.put("filenamesselected", nArray13);
            int[] nArray14 = new int[2];
            nArray14[0] = 34;
            keyword_map.put("file_names_selected", nArray14);
            int[] nArray15 = new int[2];
            nArray15[0] = 35;
            keyword_map.put("fileexts", nArray15);
            int[] nArray16 = new int[2];
            nArray16[0] = 35;
            keyword_map.put("file_exts", nArray16);
            int[] nArray17 = new int[2];
            nArray17[0] = 36;
            keyword_map.put("fileextsselected", nArray17);
            int[] nArray18 = new int[2];
            nArray18[0] = 36;
            keyword_map.put("file_exts_selected", nArray18);
            int[] nArray19 = new int[2];
            nArray19[0] = 30;
            keyword_map.put("savepath", nArray19);
            int[] nArray20 = new int[2];
            nArray20[0] = 30;
            keyword_map.put("save_path", nArray20);
            int[] nArray21 = new int[2];
            nArray21[0] = 31;
            keyword_map.put("savefolder", nArray21);
            int[] nArray22 = new int[2];
            nArray22[0] = 31;
            keyword_map.put("save_folder", nArray22);
            keyword_map.put("maxup", new int[]{32, 1});
            keyword_map.put("max_up", new int[]{32, 1});
            keyword_map.put("maxdown", new int[]{33, 1});
            keyword_map.put("max_down", new int[]{33, 1});
            int[] nArray23 = new int[2];
            nArray23[0] = 37;
            keyword_map.put("torrent_type", nArray23);
            int[] nArray24 = new int[2];
            nArray24[0] = 37;
            keyword_map.put("torrenttype", nArray24);
            int[] nArray25 = new int[2];
            nArray25[0] = 38;
            keyword_map.put("filepaths", nArray25);
            int[] nArray26 = new int[2];
            nArray26[0] = 38;
            keyword_map.put("file_paths", nArray26);
            int[] nArray27 = new int[2];
            nArray27[0] = 39;
            keyword_map.put("filepathsselected", nArray27);
            int[] nArray28 = new int[2];
            nArray28[0] = 39;
            keyword_map.put("file_paths_selected", nArray28);
            keyword_map.put("targetratio", new int[]{40, 2});
            keyword_map.put("target_ratio", new int[]{40, 2});
            int[] nArray29 = new int[2];
            nArray29[0] = 41;
            keyword_map.put("tagnames", nArray29);
            int[] nArray30 = new int[2];
            nArray30[0] = 41;
            keyword_map.put("tag_names", nArray30);
            int[] nArray31 = new int[2];
            nArray31[0] = 42;
            keyword_map.put("tracker_status", nArray31);
            int[] nArray32 = new int[2];
            nArray32[0] = 42;
            keyword_map.put("trackerstatus", nArray32);
            keyword_map.put("fullcopyseen", new int[]{43, 1});
            keyword_map.put("full_copy_seen", new int[]{43, 1});
            keyword_map.put("remaining", new int[]{44, 1});
            keyword_map.put("down_speed", new int[]{45, 1});
            keyword_map.put("downspeed", new int[]{45, 1});
            keyword_map.put("up_speed", new int[]{46, 1});
            keyword_map.put("upspeed", new int[]{46, 1});
            keyword_map.put("session_age", new int[]{47, 1});
            keyword_map.put("sessionage", new int[]{47, 1});
            keyword_map.put("my_rating", new int[]{48, 2});
            keyword_map.put("myrating", new int[]{48, 2});
        }

        private TagConstraint(TagPropertyConstraintHandler _handler, Tag _tag, String _constraint, String options, boolean _enabled) {
            this.handler = _handler;
            this.tag_maybe_null = _tag;
            this.constraint = _constraint;
            this.enabled = _enabled;
            if (options == null) {
                this.auto_add = true;
                this.auto_remove = true;
                this.new_only = false;
            } else if (options.contains("am=3;")) {
                this.auto_add = false;
                this.auto_remove = false;
                this.new_only = true;
            } else {
                this.auto_add = !options.contains("am=2;");
                this.auto_remove = !options.contains("am=1;");
                this.new_only = false;
            }
            this.checkStuff();
            ConstraintExpr compiled_expr = null;
            this.setError(null);
            try {
                try {
                    compiled_expr = this.compileStart(this.constraint, new HashMap<String, ConstraintExpr>());
                }
                catch (Throwable e) {
                    this.setError("Invalid constraint: " + Debug.getNestedExceptionMessage(e));
                    this.expr = compiled_expr;
                }
            }
            finally {
                this.expr = compiled_expr;
            }
        }

        private String getStatus() {
            String result = String.valueOf(this.activity_average.getAverage()) + "/" + TimeFormatter.getLongSuffix(0);
            if (Constants.IS_CVS_VERSION) {
                result = String.valueOf(result) + ", DS=" + this.depends_on_download_state + ", DL=" + this.depends_on_level;
            }
            return result;
        }

        private String getString() {
            return this.expr == null ? "Failed to compile constraint \"" + this.constraint + "\"" : this.expr.getString();
        }

        private int getDependsOnLevel() {
            return this.depends_on_level;
        }

        private Set<Tag> getDependsOnTags() {
            return this.dependent_on_tags == null ? Collections.emptySet() : this.dependent_on_tags;
        }

        private void checkStuff() {
            if (this.new_only) {
                this.must_check_dependencies = true;
            } else if (this.tag_maybe_null != null) {
                this.must_check_dependencies = ((TagFeatureExecOnAssign)((Object)this.tag_maybe_null)).isAnyActionEnabled() ? true : ((TagFeatureLimits)((Object)this.tag_maybe_null)).getMaximumTaggables() > 0;
            }
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private void setError(String str) {
            this.error = null;
            if (this.tag_maybe_null != null) {
                String existing;
                boolean already_error = false;
                if (str != null && !str.isEmpty() && (existing = (String)this.tag_maybe_null.getTransientProperty("Constraint Error")) != null && !existing.isEmpty()) {
                    already_error = true;
                }
                if (!already_error) {
                    this.tag_maybe_null.setTransientProperty("Constraint Error", str);
                    if (str != null && this.handler.initialised) {
                        Debug.out(str);
                    }
                }
            }
        }

        @Override
        public String getError() {
            return this.expr == null ? "Failed to compile" : this.error;
        }

        private boolean dependsOnDownloadState() {
            return this.depends_on_download_state;
        }

        private boolean dependsOnNameEtc() {
            return this.depends_on_names_etc;
        }

        private ConstraintExpr compileStart(String str, Map<String, ConstraintExpr> context2) {
            if ((str = str.trim()).equalsIgnoreCase("true")) {
                return new ConstraintExprTrue();
            }
            char[] chars = str.toCharArray();
            boolean in_quote = false;
            boolean prev_was_esc = false;
            int level = 0;
            int bracket_start = 0;
            StringBuilder result = new StringBuilder(str.length());
            int i = 0;
            while (i < chars.length) {
                boolean is_esc;
                char c = chars[i];
                boolean bl = is_esc = c == '\\';
                if (is_esc && prev_was_esc) {
                    prev_was_esc = false;
                } else {
                    if (GeneralUtils.isDoubleQuote(c) && !prev_was_esc) {
                        in_quote = !in_quote;
                    }
                    prev_was_esc = is_esc;
                    if (!in_quote) {
                        if (c == '(') {
                            if (++level == 1) {
                                bracket_start = i + 1;
                            }
                        } else if (c == ')') {
                            if (--level == 0) {
                                String bracket_text = new String(chars, bracket_start, i - bracket_start).trim();
                                if (result.length() > 0 && Character.isLetterOrDigit(result.charAt(result.length() - 1))) {
                                    String key = "{" + context2.size() + "}";
                                    context2.put(key, new ConstraintExprParams(bracket_text, context2));
                                    result.append("(").append(key).append(")");
                                } else {
                                    ConstraintExpr sub_expr = this.compileStart(bracket_text, context2);
                                    if (sub_expr == null) {
                                        throw new RuntimeException("Failed to compile '" + bracket_text + "'");
                                    }
                                    String key = "{" + context2.size() + "}";
                                    context2.put(key, sub_expr);
                                    result.append(key);
                                }
                            }
                        } else if (level == 0 && !Character.isWhitespace(c)) {
                            result.append(c);
                        }
                    } else if (level == 0) {
                        result.append(c);
                    }
                }
                ++i;
            }
            if (in_quote) {
                throw new RuntimeException("Unmatched '\"' in \"" + str + "\"");
            }
            if (level != 0) {
                throw new RuntimeException("Unmatched '(' in \"" + str + "\"");
            }
            return this.compileBasic(result.toString(), context2);
        }

        private ConstraintExpr compileBasic(String str, Map<String, ConstraintExpr> context2) {
            if (str.contains("||")) {
                String[] bits = str.split("\\|\\|");
                return new ConstraintExprOr(this.compile(bits, context2));
            }
            if (str.contains("&&")) {
                String[] bits = str.split("&&");
                return new ConstraintExprAnd(this.compile(bits, context2));
            }
            if (str.contains("^")) {
                String[] bits = str.split("\\^");
                return new ConstraintExprXor(this.compile(bits, context2));
            }
            Matcher m = comp_op_pattern.matcher(str);
            if (m.find()) {
                String lhs = m.group(1).trim();
                String op = m.group(2).trim();
                String rhs = m.group(3).trim();
                ConstraintExprParams params = new ConstraintExprParams(String.valueOf(lhs) + "," + rhs, context2);
                return new ConstraintExprFunction((String)comp_op_map.get(op), params);
            }
            m = comp_ift_pattern.matcher(str);
            if (m.find()) {
                String op1 = m.group(1).trim();
                String op2 = m.group(2).trim();
                String op3 = m.group(3).trim();
                ConstraintExprParams params = new ConstraintExprParams(String.valueOf(op1) + "," + op2 + "," + op3, context2);
                return new ConstraintExprFunction("ifThenElse", params);
            }
            if (str.startsWith("!")) {
                return new ConstraintExprNot(this.compileBasic(str.substring(1).trim(), context2));
            }
            if (str.startsWith("{")) {
                ConstraintExpr val = context2.get(str);
                if (val == null) {
                    throw new RuntimeException("Failed to compile '" + str + "'");
                }
                return val;
            }
            int pos = str.indexOf(40);
            if (pos > 0 && str.endsWith(")")) {
                String func = str.substring(0, pos);
                String key = str.substring(pos + 1, str.length() - 1).trim();
                ConstraintExprParams params = (ConstraintExprParams)context2.get(key);
                return new ConstraintExprFunction(func, params);
            }
            throw new RuntimeException("Unsupported construct: " + str);
        }

        private ConstraintExpr[] compile(String[] bits, Map<String, ConstraintExpr> context2) {
            ConstraintExpr[] res = new ConstraintExpr[bits.length];
            int i = 0;
            while (i < bits.length) {
                res[i] = this.compileBasic(bits[i].trim(), context2);
                ++i;
            }
            return res;
        }

        private String getConstraint() {
            return this.constraint;
        }

        private String getOptions() {
            if (this.auto_add) {
                if (this.auto_remove) {
                    return "am=0;";
                }
                return "am=1;";
            }
            if (this.auto_remove) {
                return "am=2;";
            }
            if (this.new_only) {
                return "am=3";
            }
            Debug.out("Hmm");
            return "am=0;";
        }

        private void apply(DownloadManager dm, boolean is_new) {
            if (this.ignoreDownload(dm)) {
                return;
            }
            if (this.expr == null) {
                return;
            }
            if (this.handler.isStopping()) {
                return;
            }
            if (!TagPropertyConstraintHandler.canProcess(this, dm, is_new)) {
                return;
            }
            Set<Taggable> existing = this.tag_maybe_null.getTagged();
            this.applySupport(existing, dm, is_new);
        }

        private void apply(List<DownloadManager> dms) {
            if (this.expr == null) {
                return;
            }
            if (this.handler.isStopping()) {
                return;
            }
            if (!TagPropertyConstraintHandler.canProcess(this, dms)) {
                return;
            }
            Set<Taggable> existing = this.tag_maybe_null.getTagged();
            for (DownloadManager dm : dms) {
                if (this.handler.isStopping()) {
                    return;
                }
                if (this.ignoreDownload(dm)) continue;
                this.applySupport(existing, dm, false);
            }
        }

        private void applySupport(Set<Taggable> existing, DownloadManager dm, boolean is_new) {
            this.applySupport2(existing, dm, this.must_check_dependencies, null, is_new);
        }

        private void applySupport2(Set<Taggable> existing, DownloadManager dm, boolean check_dependencies, Set<TagConstraint> checked, boolean is_new) {
            if (check_dependencies && checked != null && checked.contains(this)) {
                return;
            }
            boolean do_add = this.auto_add;
            if (this.new_only) {
                if (is_new) {
                    do_add = true;
                } else {
                    return;
                }
            }
            if (this.testConstraint(dm, null)) {
                if (do_add && !existing.contains(dm)) {
                    if (check_dependencies && this.dependent_on_tags != null) {
                        boolean recheck = false;
                        for (Tag t : this.dependent_on_tags) {
                            TagConstraint dep = this.handler.constrained_tags.get(t);
                            if (dep == null) continue;
                            if (checked == null) {
                                checked = new HashSet<TagConstraint>();
                            }
                            try {
                                checked.add(this);
                                dep.applySupport2(existing, dm, true, checked, is_new);
                            }
                            finally {
                                checked.remove(this);
                            }
                            recheck = true;
                        }
                        if (recheck) {
                            this.applySupport2(existing, dm, false, checked, is_new);
                            return;
                        }
                    }
                    if (this.handler.isStopping()) {
                        return;
                    }
                    if (this.canAddTaggable(dm)) {
                        this.tag_maybe_null.addTaggable(dm);
                    }
                }
            } else if (this.auto_remove && existing.contains(dm)) {
                if (this.handler.isStopping()) {
                    return;
                }
                if (this.tag_maybe_null.hasTaggable(dm)) {
                    this.tag_maybe_null.removeTaggable(dm);
                }
            }
        }

        private boolean ignoreDownload(DownloadManager dm) {
            return dm.isDestroyed();
        }

        private boolean canAddTaggable(DownloadManager dm) {
            Long time;
            long now = SystemTime.getMonotonousTime();
            Map<DownloadManager, Long> recent_dms = this.handler.apply_history.get(this.tag_maybe_null);
            if (recent_dms != null && (time = recent_dms.get(dm)) != null && now - time < 1000L) {
                System.out.println("Not applying constraint as too recently actioned: " + dm.getDisplayName() + "/" + this.tag_maybe_null.getTagName(true));
                return false;
            }
            if (recent_dms == null) {
                recent_dms = new IdentityHashMap<DownloadManager, Long>();
                this.handler.apply_history.put(this.tag_maybe_null, recent_dms);
            }
            recent_dms.put(dm, now);
            return true;
        }

        @Override
        public boolean testConstraint(DownloadManager dm) {
            return this.testConstraint(dm, null);
        }

        private boolean testConstraint(DownloadManager dm, StringBuilder debug) {
            if (this.enabled) {
                this.activity_average.addValue(1L);
                List<Tag> dm_tags = this.handler.tag_manager.getTagsForTaggable(dm);
                if (this.expr == null) {
                    if (debug != null) {
                        debug.append("false");
                    }
                    return false;
                }
                HashMap<String, Object> context2 = new HashMap<String, Object>();
                Object o_result = this.expr.eval(context2, dm, dm_tags, debug);
                if (o_result instanceof Number) {
                    o_result = ((Number)o_result).intValue() != 0;
                }
                if (o_result instanceof Boolean) {
                    boolean result = (Boolean)o_result;
                    if (result && this.tag_maybe_null != null) {
                        long[] colours = (long[])context2.get(TagPropertyConstraintHandler.EVAL_CTX_COLOURS);
                        this.tag_maybe_null.setColors(colours);
                        Object[] tag_sort = (Object[])context2.get(TagPropertyConstraintHandler.EVAL_CTX_TAG_SORT);
                        if (tag_sort != null) {
                            long current = ((Number)tag_sort[0]).longValue();
                            long uid = this.tag_maybe_null.getTagUID();
                            String options = tag_sort.length > 1 ? (String)tag_sort[1] : null;
                            HashMap<Long, Object[]> map = (HashMap<Long, Object[]>)dm.getDownloadState().getTransientAttribute("t_tagsort");
                            boolean changed = false;
                            if (map == null) {
                                map = new HashMap<Long, Object[]>();
                                map.put(uid, new Object[]{this.tag_maybe_null, current, options});
                                changed = true;
                            } else {
                                Object[] existing = (Object[])map.get(uid);
                                if (existing != null) {
                                    existing[1] = current;
                                    existing[2] = options;
                                } else {
                                    map = new HashMap(map);
                                    map.put(uid, new Object[]{this.tag_maybe_null, current, options});
                                    changed = true;
                                }
                            }
                            if (changed) {
                                dm.getDownloadState().setTransientAttribute("t_tagsort", map);
                            }
                        }
                    }
                    return result;
                }
                this.setError("Constraint must evaluate to a boolean");
                return false;
            }
            if (debug != null) {
                debug.append("Constraint is not enabled");
            }
            return false;
        }

        static /* synthetic */ boolean access$12(TagConstraint tagConstraint) {
            return tagConstraint.dependent_on_peer_sets;
        }

        static /* synthetic */ int access$13(TagConstraint tagConstraint) {
            return tagConstraint.tag_weights_opt;
        }

        private static interface ConstraintExpr {
            public Object eval(Map<String, Object> var1, DownloadManager var2, List<Tag> var3, StringBuilder var4);

            public String getString();
        }

        private static class ConstraintExprAnd
        implements ConstraintExpr {
            private final ConstraintExpr[] exprs;

            private ConstraintExprAnd(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append("(");
                }
                boolean res = false;
                try {
                    int num = 1;
                    ConstraintExpr[] constraintExprArray = this.exprs;
                    int n = this.exprs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean b;
                        ConstraintExpr expr = constraintExprArray[n2];
                        if (debug != null && num > 1) {
                            debug.append("&&");
                        }
                        if (!(b = ((Boolean)expr.eval(context2, dm, tags, debug)).booleanValue())) {
                            res = false;
                            Boolean bl = false;
                            return bl;
                        }
                        ++num;
                        ++n2;
                    }
                    res = true;
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    if (debug != null) {
                        debug.append(")");
                        debug.append("->");
                        debug.append(res);
                    }
                }
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "&&") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }

        private class ConstraintExprFunction
        implements ConstraintExpr {
            private final String func_name;
            private final ConstraintExprParams params_expr;
            private final Object[] params;
            private final int fn_type;
            private Map<String, Object[]> matches_cache = new HashMap<String, Object[]>();

            private ConstraintExprFunction(String _func_name, ConstraintExprParams _params) {
                this.func_name = _func_name;
                this.params_expr = _params;
                this.params = _params.getValues();
                Integer _fn_type = fn_map.get(this.func_name.toLowerCase(Locale.US));
                if (_fn_type == null) {
                    throw new RuntimeException("Unsupported function '" + this.func_name + "'");
                }
                this.fn_type = _fn_type;
                int num_params = this.params.length;
                boolean params_ok = false;
                block1 : switch (this.fn_type) {
                    case 1: 
                    case 22: 
                    case 28: 
                    case 34: {
                        boolean bl = params_ok = num_params >= 1 && this.getStringLiteral(this.params, 0);
                        if (params_ok) {
                            if (this.fn_type == 34) {
                                if (num_params > 1) {
                                    params_ok = num_params == 2 && this.getNumericLiteral(this.params, 1);
                                }
                            } else {
                                boolean bl2 = params_ok = num_params == 1;
                            }
                        }
                        if (!params_ok) break;
                        String tag_name = (String)this.params[0];
                        if (TagConstraint.this.handler.tag_manager == null) break;
                        List<Tag> tags = TagConstraint.this.handler.tag_manager.getTagsByName(tag_name, true);
                        if (tags.isEmpty()) {
                            throw new RuntimeException("Tag '" + tag_name + "' not found");
                        }
                        for (Tag t : tags) {
                            TagType tt = t.getTagType();
                            if (!tt.hasTagTypeFeature(32L) && tt.getTagType() != 4) continue;
                            if (TagConstraint.this.dependent_on_tags == null) {
                                TagConstraint.this.dependent_on_tags = new HashSet();
                            }
                            if (tt.getTagType() == 4) {
                                TagConstraint.this.dependent_on_peer_sets = true;
                            }
                            TagConstraint.this.dependent_on_tags.add(t);
                        }
                        break;
                    }
                    case 51: {
                        String options;
                        String tags_str;
                        params_ok = num_params <= 2;
                        int i = 0;
                        while (i < num_params && params_ok) {
                            params_ok = this.getStringLiteral(this.params, i);
                            ++i;
                        }
                        if (!params_ok || num_params <= 0) break;
                        if (num_params == 1) {
                            tags_str = "";
                            options = (String)this.params[0];
                        } else {
                            tags_str = (String)this.params[0];
                            options = (String)this.params[1];
                        }
                        if (TagConstraint.this.handler.tag_manager != null && !tags_str.isEmpty()) {
                            String[] tag_names;
                            String[] stringArray = tag_names = tags_str.split(",");
                            int n = tag_names.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String tag_name = stringArray[n2];
                                if (!(tag_name = tag_name.trim()).isEmpty()) {
                                    List<Tag> tags = TagConstraint.this.handler.tag_manager.getTagsByName(tag_name, true);
                                    if (tags.isEmpty()) {
                                        throw new RuntimeException("Tag '" + tag_name + "' not found");
                                    }
                                    if (TagConstraint.this.tag_weights == null) {
                                        TagConstraint.this.tag_weights = new HashSet();
                                    }
                                    TagConstraint.this.tag_weights.addAll(tags);
                                }
                                ++n2;
                            }
                        }
                        if ((options = options.trim()).isEmpty()) break;
                        String[] bits = options.split("=");
                        if (bits.length != 2 || !bits[0].toLowerCase(Locale.US).equals("type")) {
                            throw new RuntimeException("options '" + options + "' invalid");
                        }
                        String rhs = bits[1].toLowerCase(Locale.US);
                        if (rhs.equals("max")) {
                            TagConstraint.this.tag_weights_opt = 0;
                            break;
                        }
                        if (rhs.equals("min")) {
                            TagConstraint.this.tag_weights_opt = 1;
                            break;
                        }
                        if (rhs.equals("cumulative")) {
                            TagConstraint.this.tag_weights_opt = 2;
                            break;
                        }
                        throw new RuntimeException("options '" + options + "' invalid");
                    }
                    case 11: {
                        boolean bl = params_ok = num_params == 1 && this.getStringLiteral(this.params, 0);
                        if (!params_ok) break;
                        this.params[0] = AENetworkClassifier.internalise((String)this.params[0]);
                        params_ok = this.params[0] != null;
                        break;
                    }
                    case 2: 
                    case 13: 
                    case 20: 
                    case 21: 
                    case 31: 
                    case 33: 
                    case 35: 
                    case 38: {
                        params_ok = num_params == 0;
                        break;
                    }
                    case 12: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 32: 
                    case 36: 
                    case 37: 
                    case 40: 
                    case 53: 
                    case 54: 
                    case 55: {
                        TagConstraint.this.depends_on_download_state = true;
                        params_ok = num_params == 0;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 56: 
                    case 57: 
                    case 58: {
                        params_ok = num_params == 2;
                        break;
                    }
                    case 9: {
                        params_ok = num_params == 2 || num_params == 3 && this.getNumericLiteral(this.params, 2);
                        break;
                    }
                    case 29: {
                        params_ok = num_params == 1;
                        break;
                    }
                    case 10: {
                        boolean bl = params_ok = (num_params == 2 || num_params == 3) && this.getStringLiteral(this.params, 1);
                        if (params_ok && num_params == 3) {
                            params_ok = this.getNumericLiteral(this.params, 2);
                        }
                        if (!params_ok) break;
                        try {
                            Number flags;
                            boolean case_insensitive = true;
                            if (num_params == 3 && (flags = (Number)this.params[2]).intValue() == 0) {
                                case_insensitive = false;
                            }
                            if (case_insensitive) {
                                Pattern.compile((String)this.params[1], 66);
                                break;
                            }
                            Pattern.compile((String)this.params[1]);
                        }
                        catch (Throwable e) {
                            TagConstraint.this.setError("Invalid constraint pattern: " + this.params[1] + ": " + e.getMessage());
                        }
                        break;
                    }
                    case 15: {
                        params_ok = num_params == 1 && this.getStringLiteral(this.params, 0);
                        TagConstraint.this.depends_on_download_state = true;
                        break;
                    }
                    case 23: {
                        params_ok = num_params == 1 && this.getStringLiteral(this.params, 0);
                        break;
                    }
                    case 24: 
                    case 25: 
                    case 26: {
                        params_ok = num_params == 1 && this.getNumericLiteral(this.params, 0);
                        break;
                    }
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        params_ok = num_params == 1;
                        break;
                    }
                    case 27: {
                        boolean bl = params_ok = num_params == 1 && this.getStringLiteral(this.params, 0);
                        if (!params_ok) break;
                        String key = (String)this.params[0];
                        key = key.toLowerCase(Locale.US);
                        this.params[0] = key;
                        if (config_key_map.containsKey(key)) break;
                        throw new RuntimeException("Unsupported configuration parameter: " + key);
                    }
                    case 30: {
                        boolean bl = params_ok = num_params >= 1 && num_params <= 3;
                        if (!params_ok) break;
                        int i = 0;
                        while (i < num_params) {
                            params_ok = this.getNumericLiteral(this.params, i);
                            if (!params_ok) break block1;
                            ++i;
                        }
                        break;
                    }
                    case 41: {
                        params_ok = num_params >= 1 && num_params <= 2;
                        String option = null;
                        if (params_ok) {
                            if (num_params == 1 && this.getStringLiteral(this.params, 0)) {
                                option = (String)this.params[0];
                            }
                            if (num_params == 2 && (params_ok = this.getStringLiteral(this.params, 1))) {
                                option = (String)this.params[1];
                            }
                        }
                        if (!params_ok || option == null || option.equals("r") || option.equals("reverse") || option.equals("random")) break;
                        throw new RuntimeException("option '" + option + "' invalid");
                    }
                    case 39: {
                        params_ok = num_params == 0;
                        break;
                    }
                    case 52: {
                        params_ok = num_params == 3;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported function '" + this.fn_type + "'");
                    }
                }
                if (!params_ok) {
                    throw new RuntimeException("Invalid parameters for function '" + this.func_name + "': " + this.params_expr.getString());
                }
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append("[" + this.func_name + "(");
                }
                Object res = this.evalSupport(context2, dm, tags, debug);
                if (debug != null) {
                    debug.append(")->" + res + "]");
                }
                return res;
            }

            /*
             * Unable to fully structure code
             */
            public Object evalSupport(Map<String, Object> context, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                num_params = this.params.length;
                switch (this.fn_type) {
                    case 1: {
                        tag_name = this.getStringParam(this.params, 0, debug);
                        for (Tag t : tags) {
                            if (!t.getTagName(true).equals(tag_name)) continue;
                            return true;
                        }
                        if (TagConstraint.access$12(TagConstraint.this) && (ps_tags = (Set)dm.getUserData(TagPropertyConstraintHandler.access$11())) != null) {
                            for (Tag t : ps_tags) {
                                if (!t.getTagName(true).equals(tag_name)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    case 28: {
                        tag_name = this.getStringParam(this.params, 0, debug);
                        target = null;
                        if (TagConstraint.access$4(TagConstraint.this) != null) {
                            for (Tag t : TagConstraint.access$4(TagConstraint.this)) {
                                if (!t.getTagName(true).equals(tag_name)) continue;
                                target = t;
                                break;
                            }
                        }
                        if (target == null) {
                            TagConstraint.access$11(TagConstraint.this, "Tag '" + tag_name + "' not found");
                            return 0;
                        }
                        if (!target.hasTaggable(dm)) {
                            return -1;
                        }
                        tag_added = target.getTaggableAddedTime(dm);
                        if (tag_added <= 0L) {
                            return 0;
                        }
                        age = (SystemTime.getCurrentTime() - tag_added) / 1000L;
                        if (age < 0L) {
                            age = 0L;
                        }
                        return age;
                    }
                    case 23: {
                        group_name = this.getStringParam(this.params, 0, debug);
                        for (Tag t : tags) {
                            group = t.getGroup();
                            if (group == null || !group.equals(group_name)) continue;
                            return true;
                        }
                        return false;
                    }
                    case 22: {
                        tag_name = this.getStringParam(this.params, 0, debug);
                        target = null;
                        if (TagConstraint.access$4(TagConstraint.this) != null) {
                            for (Tag t : TagConstraint.access$4(TagConstraint.this)) {
                                if (!t.getTagName(true).equals(tag_name)) continue;
                                target = t;
                                break;
                            }
                        }
                        if (target == null) {
                            TagConstraint.access$11(TagConstraint.this, "Tag '" + tag_name + "' not found");
                            return 0;
                        }
                        return target.getTaggedCount();
                    }
                    case 34: {
                        tag_name = this.getStringParam(this.params, 0, debug);
                        target = null;
                        if (TagConstraint.access$4(TagConstraint.this) != null) {
                            for (Tag t : TagConstraint.access$4(TagConstraint.this)) {
                                if (!t.getTagName(true).equals(tag_name)) continue;
                                target = t;
                                break;
                            }
                        }
                        if (target == null) {
                            TagConstraint.access$11(TagConstraint.this, "Tag '" + tag_name + "' not found");
                            return -1;
                        }
                        sort = this.params.length == 1 ? 1 : this.getNumericParam(this.params, 1, debug).intValue();
                        dms = target.getTagged();
                        if (!dms.contains(dm)) {
                            return -1;
                        }
                        if (sort == 1) {
                            my_position = dm.getPosition();
                            tag_position = 0;
                            found = false;
                            for (Taggable t : dms) {
                                this_dm = (DownloadManager)t;
                                if (t == dm) {
                                    found = true;
                                    continue;
                                }
                                this_pos = this_dm.getPosition();
                                if (this_pos >= my_position) continue;
                                ++tag_position;
                            }
                            if (found) {
                                return tag_position;
                            }
                            return -1;
                        }
                        my_time = target.getTaggableAddedTime(dm);
                        if (my_time == -1L) {
                            return -1;
                        }
                        my_time += (long)dm.getPosition();
                        tag_position = 0;
                        found = false;
                        for (Taggable t : dms) {
                            if (t == dm) {
                                found = true;
                                continue;
                            }
                            this_time = target.getTaggableAddedTime(t);
                            if (this_time == -1L || (this_time += (long)(this_dm = (DownloadManager)t).getPosition()) >= my_time) continue;
                            ++tag_position;
                        }
                        if (found) {
                            return tag_position;
                        }
                        return -1;
                    }
                    case 51: {
                        result = 0;
                        for (Tag tag : tags) {
                            if (TagConstraint.access$7(TagConstraint.this) != null && !TagConstraint.access$7(TagConstraint.this).contains(tag) || (w = (tag_dl = (TagDownload)tag).getWeight()) <= 0) continue;
                            if (TagConstraint.access$13(TagConstraint.this) == 0) {
                                result = Math.max(result, w);
                                continue;
                            }
                            if (TagConstraint.access$13(TagConstraint.this) == 1) {
                                result = Math.min(result, w);
                                continue;
                            }
                            result += w;
                        }
                        return result;
                    }
                    case 11: {
                        net_name = this.getStringParam(this.params, 0, debug);
                        if (net_name != null && (nets = dm.getDownloadState().getNetworks()) != null) {
                            tag_position = nets;
                            w = nets.length;
                            tag_dl = 0;
                            while (tag_dl < w) {
                                net = tag_position[tag_dl];
                                if (net == net_name) {
                                    return true;
                                }
                                ++tag_dl;
                            }
                        }
                        return false;
                    }
                    case 2: {
                        t = dm.getTorrent();
                        if (t != null && t.getPrivate()) {
                            return true;
                        }
                        return false;
                    }
                    case 35: {
                        sm = TagPropertyConstraintHandler.access$12(TagConstraint.access$3(TagConstraint.this));
                        if (sm == null) {
                            return false;
                        }
                        try {
                            if (sm.lookupShare(dm.getTorrent().getHash()) != null) {
                                return true;
                            }
                            return false;
                        }
                        catch (Throwable e) {
                            return false;
                        }
                    }
                    case 14: {
                        return dm.isForceStart();
                    }
                    case 16: {
                        state = dm.getState();
                        if (state == 30) {
                            return true;
                        }
                        if (state == 60 && (disk_manager = dm.getDiskManager()) != null) {
                            if (disk_manager.getCompleteRecheckStatus() != -1) {
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 40: {
                        if (dm.getMoveProgress() == null && !FileUtil.hasTask(dm)) {
                            return false;
                        }
                        return true;
                    }
                    case 32: {
                        pm = dm.getPeerManager();
                        if (pm != null) {
                            return pm.isSuperSeedMode();
                        }
                        return false;
                    }
                    case 12: {
                        return dm.isDownloadComplete(false);
                    }
                    case 17: {
                        state = dm.getState();
                        if (state == 70 && !dm.isPaused()) {
                            return true;
                        }
                        return false;
                    }
                    case 53: {
                        state = dm.getState();
                        if (state == 60) {
                            return true;
                        }
                        return false;
                    }
                    case 54: {
                        state = dm.getState();
                        if (state == 50) {
                            return true;
                        }
                        return false;
                    }
                    case 55: {
                        state = dm.getState();
                        if (state != 70 && state != 100 && state != 75) {
                            return true;
                        }
                        return false;
                    }
                    case 19: {
                        state = dm.getState();
                        if (state == 100) {
                            return true;
                        }
                        return false;
                    }
                    case 20: {
                        return dm.getDownloadState().getFlag(512L);
                    }
                    case 21: {
                        return dm.getDownloadState().getFlag(16L);
                    }
                    case 31: {
                        if (dm.getAssumedComplete() && !PlatformTorrentUtils.getHasBeenOpened(dm)) {
                            return true;
                        }
                        return false;
                    }
                    case 36: {
                        return dm.isDataAlreadyAllocated() == false;
                    }
                    case 18: {
                        return dm.isPaused();
                    }
                    case 37: {
                        state = dm.getState();
                        if (state == 75) {
                            return true;
                        }
                        return false;
                    }
                    case 13: {
                        dl = PluginCoreUtils.wrap(dm);
                        if (dl != null && dl.canStubbify()) {
                            return true;
                        }
                        return false;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n1 = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        n2 = this.getNumeric(context, dm, tags, this.params, 1, debug);
                        switch (this.fn_type) {
                            case 3: {
                                if (n1.doubleValue() >= n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                            case 4: {
                                if (n1.doubleValue() > n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                            case 5: {
                                if (n1.doubleValue() <= n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                            case 6: {
                                if (n1.doubleValue() < n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                            case 7: {
                                if (n1.doubleValue() == n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                            case 8: {
                                if (n1.doubleValue() != n2.doubleValue()) {
                                    return true;
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                    case 9: {
                        s1s = this.getStrings(context, dm, tags, this.params, 0, debug);
                        s2 = this.getString(context, dm, tags, this.params, 1, debug);
                        case_insensitive = false;
                        if (num_params == 3 && this.getNumericLiteral(this.params, 2) && (flags = this.getNumericParam(this.params, 2, debug)).intValue() == 1) {
                            case_insensitive = true;
                        }
                        if (s2.contains("|")) {
                            pat_str = "";
                            bits = s2.split("\\|");
                            hasSpace = s2.contains(" ");
                            if (hasSpace) {
                                s2 = "";
                            }
                            this_dm = bits;
                            t = bits.length;
                            found = 0;
                            while (found < t) {
                                bit = this_dm[found];
                                if (!(bit = bit.trim()).isEmpty()) {
                                    if (hasSpace) {
                                        s2 = String.valueOf(s2) + (s2.isEmpty() != false ? "" : "|") + bit;
                                    }
                                    pat_str = String.valueOf(pat_str) + (pat_str.isEmpty() != false ? "" : "|") + Pattern.quote(bit);
                                }
                                ++found;
                            }
                            if (hasSpace) {
                                this.params[1] = "\"" + s2 + "\"";
                            }
                            pattern = RegExUtil.getCachedPattern("tag:constraint:" + TagConstraint.access$14(TagConstraint.this).getTagUID(), pat_str, case_insensitive != false ? 0 : 66);
                            key = dm.getInternalName();
                            if (!key.isEmpty() && (cache = this.matches_cache.get(key)) != null && cache[1] == pattern && (s1s == (old_s1s = (String[])cache[0]) || Arrays.equals(old_s1s, s1s))) {
                                return (Boolean)cache[2];
                            }
                            result = false;
                            var18_137 = s1s;
                            var17_138 = s1s.length;
                            var16_135 = 0;
                            while (var16_135 < var17_138) {
                                s1 = var18_137[var16_135];
                                if (pattern.matcher(s1).find()) {
                                    result = true;
                                    break;
                                }
                                ++var16_135;
                            }
                            this.matches_cache.put(key, new Object[]{s1s, pattern, result});
                            return result;
                        }
                        if (case_insensitive) {
                            s2 = s2.toLowerCase(Locale.US);
                            var12_116 = s1s;
                            hasSpace = s1s.length;
                            bits = 0;
                            while (bits < hasSpace) {
                                s1 = var12_116[bits];
                                if (s1.toLowerCase(Locale.US).contains(s2)) {
                                    return true;
                                }
                                ++bits;
                            }
                        } else {
                            var12_117 = s1s;
                            hasSpace = s1s.length;
                            bits = 0;
                            while (bits < hasSpace) {
                                s1 = var12_117[bits];
                                if (s1.contains(s2)) {
                                    return true;
                                }
                                ++bits;
                            }
                        }
                        return false;
                    }
                    case 29: {
                        s = this.getString(context, dm, tags, this.params, 0, debug);
                        return s.toLowerCase(Locale.US);
                    }
                    case 10: {
                        s1s = this.getStrings(context, dm, tags, this.params, 0, debug);
                        if (this.params[1] == null) {
                            return false;
                        }
                        if (this.params[1] instanceof Pattern) {
                            pattern = (Pattern)this.params[1];
                        } else {
                            case_insensitive = true;
                            if (num_params == 3 && (flags = (Number)this.params[2]).intValue() == 0) {
                                case_insensitive = false;
                            }
                            try {
                                pattern = case_insensitive != false ? Pattern.compile((String)this.params[1], 66) : Pattern.compile((String)this.params[1]);
                                this.params[1] = pattern;
                            }
                            catch (Throwable e) {
                                TagConstraint.access$11(TagConstraint.this, "Invalid constraint pattern: " + this.params[1] + ": " + e.getMessage());
                                this.params[1] = null;
                                return false;
                            }
                        }
                        if (debug != null) {
                            debug.append(",\"" + pattern + "\"");
                        }
                        if (!(key = dm.getInternalName()).isEmpty() && (cache = this.matches_cache.get(key)) != null && cache[1] == pattern && (s1s == (old_s1s = (String[])cache[0]) || Arrays.equals(old_s1s, s1s))) {
                            return (Boolean)cache[2];
                        }
                        result = false;
                        var13_129 = s1s;
                        var12_118 = s1s.length;
                        hasSpace = 0;
                        while (hasSpace < var12_118) {
                            s1 = var13_129[hasSpace];
                            if (pattern.matcher(s1).find()) {
                                result = true;
                                break;
                            }
                            ++hasSpace;
                        }
                        this.matches_cache.put(key, new Object[]{s1s, pattern, result});
                        return result;
                    }
                    case 15: {
                        result = TagPropertyConstraintHandler.access$9(TagConstraint.access$3(TagConstraint.this)).evalScript(TagConstraint.access$14(TagConstraint.this), "javascript( " + (String)this.params[0] + ")", Arrays.asList(new DownloadManager[]{dm}), "inTag");
                        if (result instanceof Boolean) {
                            return (Boolean)result;
                        }
                        if (result instanceof Throwable) {
                            TagConstraint.access$11(TagConstraint.this, Debug.getNestedExceptionMessage((Throwable)result));
                        }
                        return false;
                    }
                    case 24: {
                        n1 = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        return (long)(n1.doubleValue() * 60.0 * 60.0);
                    }
                    case 25: {
                        n1 = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        return (long)(n1.doubleValue() * 24.0 * 60.0 * 60.0);
                    }
                    case 26: {
                        n1 = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        return (long)(n1.doubleValue() * 7.0 * 24.0 * 60.0 * 60.0);
                    }
                    case 42: {
                        time = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                        if (time > 0L) {
                            secs = (SystemTime.getCurrentTime() - time) / 1000L;
                            if (Math.abs(secs) < 5L) {
                                secs = 0L;
                            }
                            return secs;
                        }
                        return time;
                    }
                    case 43: {
                        bytes = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                        multiplier = 1000L;
                        return bytes / (multiplier * multiplier);
                    }
                    case 44: {
                        bytes = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                        multiplier = 1024L;
                        return bytes / (multiplier * multiplier);
                    }
                    case 45: {
                        bytes = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                        multiplier = 1000L;
                        return bytes / (multiplier * multiplier * multiplier);
                    }
                    case 46: {
                        bytes = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                        multiplier = 1024L;
                        return bytes / (multiplier * multiplier * multiplier);
                    }
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 56: 
                    case 57: 
                    case 58: {
                        n1 = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        n2 = this.getNumeric(context, dm, tags, this.params, 1, debug);
                        if (!(n1 instanceof Double) && !(n1 instanceof Float) && !(n2 instanceof Double) && !(n2 instanceof Float)) ** GOTO lbl406
                        p1 = n1.doubleValue();
                        p2 = n2.doubleValue();
                        switch (this.fn_type) {
                            case 47: {
                                return p1 + p2;
                            }
                            case 48: {
                                return p1 - p2;
                            }
                            case 49: {
                                return p1 * p2;
                            }
                            case 50: {
                                return p1 / p2;
                            }
                            case 56: {
                                return p1 % p2;
                            }
                            case 57: {
                                return Math.min(p1, p2);
                            }
                            case 58: {
                                return Math.max(p1, p2);
                            }
                        }
                        ** GOTO lbl423
lbl406:
                        // 1 sources

                        p1 = n1.longValue();
                        p2 = n2.longValue();
                        switch (this.fn_type) {
                            case 47: {
                                return p1 + p2;
                            }
                            case 48: {
                                return p1 - p2;
                            }
                            case 49: {
                                return p1 * p2;
                            }
                            case 50: {
                                return p1 / p2;
                            }
                            case 56: {
                                return p1 % p2;
                            }
                            case 57: {
                                return Math.min(p1, p2);
                            }
                            case 58: {
                                return Math.max(p1, p2);
                            }
                        }
                    }
lbl423:
                    // 3 sources

                    case 27: {
                        key = this.getStringParam(this.params, 0, debug);
                        now = SystemTime.getMonotonousTime();
                        existing = (Object[])TagPropertyConstraintHandler.access$7().get(key);
                        if (existing != null && now - (Long)existing[0] < 60000L) {
                            return existing[1];
                        }
                        entry = (String[])TagPropertyConstraintHandler.access$10().get(key);
                        if (entry[0] == "float") {
                            result = Float.valueOf(COConfigurationManager.getFloatParameter(entry[1]));
                            TagPropertyConstraintHandler.access$7().put(key, new Object[]{now, result});
                            return result;
                        }
                        TagConstraint.access$11(TagConstraint.this, "Error getting config value for '" + key + "'");
                        return 0;
                    }
                    case 30: {
                        p = new long[num_params];
                        i = 0;
                        while (i < num_params) {
                            p[i] = this.getNumeric(context, dm, tags, this.params, i, debug).longValue();
                            ++i;
                        }
                        context.put("colours", p);
                        return true;
                    }
                    case 41: {
                        if (num_params == 1 && this.params[0] instanceof String && ((String)this.params[0]).equals("random")) {
                            p = new Object[]{TagConstraint.access$14(TagConstraint.this) == null ? 0 : RandomUtils.nextInt(Math.max(1, TagConstraint.access$14(TagConstraint.this).getTaggedCount())), (String)this.params[0]};
                        } else {
                            p = new Object[num_params];
                            p[0] = this.getNumeric(context, dm, tags, this.params, 0, debug).longValue();
                            if (p.length > 1) {
                                p[1] = (String)this.params[1];
                            }
                        }
                        context.put("tag_sort", p);
                        return true;
                    }
                    case 33: {
                        return dm.getDownloadState().getFlag(8192L);
                    }
                    case 38: {
                        if (TagPropertyConstraintHandler.access$13().isEnabled() && !dm.getDownloadState().getFlag(256L)) {
                            return true;
                        }
                        return false;
                    }
                    case 39: {
                        torrent = dm.getTorrent();
                        total = 0;
                        if (torrent != null) {
                            sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
                            if (sets.length == 0) {
                                url = torrent.getAnnounceURL();
                                if (!TorrentUtils.isDecentralised(url)) {
                                    ++total;
                                }
                            } else {
                                var12_119 = sets;
                                var11_112 = sets.length;
                                var10_104 = 0;
                                while (var10_104 < var11_112) {
                                    set = var12_119[var10_104];
                                    total += set.getAnnounceURLs().length;
                                    ++var10_104;
                                }
                            }
                        }
                        return total;
                    }
                    case 52: {
                        cond = this.getNumeric(context, dm, tags, this.params, 0, debug);
                        if (cond.intValue() != 0) {
                            return this.getWhatever(context, dm, tags, this.params, 1, debug);
                        }
                        return this.getWhatever(context, dm, tags, this.params, 2, debug);
                    }
                }
                return false;
            }

            private String getStringParam(Object[] params, int index, StringBuilder debug) {
                String result = (String)params[index];
                if (debug != null) {
                    if (index > 0) {
                        debug.append(",");
                    }
                    debug.append("\"" + result + "\"");
                }
                return result;
            }

            private Number getNumericParam(Object[] params, int index, StringBuilder debug) {
                Number result = (Number)params[index];
                if (debug != null) {
                    if (index > 0) {
                        debug.append(",");
                    }
                    debug.append(result);
                }
                return result;
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Object getWhatever(Map<String, Object> context, DownloadManager dm, List<Tag> tags, Object[] args, int index, StringBuilder debug) {
                block11: {
                    if (debug != null && index > 0) {
                        debug.append(",");
                    }
                    arg = args[index];
                    if (arg instanceof Number) {
                        return arg;
                    }
                    if (!(arg instanceof String)) ** GOTO lbl33
                    s_arg = (String)arg;
                    if (!GeneralUtils.startsWithDoubleQuote(s_arg) || !GeneralUtils.endsWithDoubleQuote(s_arg)) break block11;
                    return s_arg.substring(1, s_arg.length() - 1).replace("\\\"", "\"");
                    {
                        catch (Throwable e) {
                            TagConstraint.access$11(TagConstraint.this, Debug.getNestedExceptionMessage(e));
                            return "\"\"";
                        }
                    }
                }
                try {
                    if (s_arg.startsWith("0x")) {
                        args[index] = Long.parseLong(s_arg.substring(2), 16);
                        return args[index];
                    }
                    if (s_arg.startsWith("#")) {
                        args[index] = Long.parseLong(s_arg.substring(1), 16);
                        return args[index];
                    }
                    args[index] = Double.parseDouble(s_arg);
                    return args[index];
                }
                catch (Throwable var9_11) {
                    result = this.getKeywordValue(dm, tags, s_arg);
                    if (result != null) {
                        return result;
                    }
                    result = this.getNumericSupport(dm, tags, args, index);
                    if (result == null) throw new Exception("Invalid constraint string: " + s_arg);
                    return result;
lbl33:
                    // 1 sources

                    if (arg instanceof ConstraintExpr == false) throw new Exception("Invalid constraint string: " + arg);
                    if (debug != null) {
                        debug.append("[");
                    }
                    res = ((ConstraintExpr)arg).eval(context, dm, tags, debug);
                    if (debug == null) return res;
                    debug.append("->" + res + "]");
                    return res;
                }
            }

            private boolean getStringLiteral(Object[] args, int index) {
                String arg;
                Object _arg = args[index];
                if (_arg instanceof String && GeneralUtils.startsWithDoubleQuote(arg = (String)_arg) && GeneralUtils.endsWithDoubleQuote(arg)) {
                    args[index] = arg.substring(1, arg.length() - 1).replace("\\\"", "\"");
                    return true;
                }
                return false;
            }

            private boolean getNumericLiteral(Object[] args, int index) {
                Object arg = args[index];
                if (arg instanceof Number) {
                    return true;
                }
                if (arg instanceof String) {
                    String s_arg;
                    block7: {
                        block6: {
                            s_arg = (String)arg;
                            if (!s_arg.startsWith("0x")) break block6;
                            args[index] = Long.parseLong(s_arg.substring(2), 16);
                            return true;
                        }
                        if (!s_arg.startsWith("#")) break block7;
                        args[index] = Long.parseLong(s_arg.substring(1), 16);
                        return true;
                    }
                    try {
                        args[index] = Double.parseDouble(s_arg);
                        return true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return false;
            }

            private String getString(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, Object[] args, int index, StringBuilder debug) {
                String[] res = this.getStrings(context2, dm, tags, args, index, debug);
                return res[0];
            }

            private String[] getStrings(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, Object[] args, int index, StringBuilder debug) {
                if (debug != null && index > 0) {
                    debug.append(",");
                }
                try {
                    Object arg = args[index];
                    if (arg instanceof String) {
                        String[] result;
                        String str = (String)arg;
                        if (GeneralUtils.startsWithDoubleQuote(str) && GeneralUtils.endsWithDoubleQuote(str)) {
                            String[] result2 = new String[]{str.substring(1, str.length() - 1).replace("\\\"", "\"")};
                            if (debug != null) {
                                debug.append("\"" + result2[0] + "\"");
                            }
                            return result2;
                        }
                        Object o_result = this.getKeywordValue(dm, tags, str);
                        if (o_result == null) {
                            throw new Exception("Invalid constraint string: " + str);
                        }
                        if (o_result instanceof String) {
                            result = new String[]{(String)o_result};
                        } else if (o_result instanceof String[]) {
                            result = (String[])o_result;
                        } else {
                            throw new Exception("Invalid constraint keyword, string(s) expected: " + str);
                        }
                        if (debug != null) {
                            debug.append("[");
                            debug.append(str);
                            debug.append("->\"");
                            debug.append(result[0]);
                            if (result.length > 1) {
                                debug.append(",...");
                            }
                            debug.append("\"]");
                        }
                        return result;
                    }
                    if (arg instanceof ConstraintExpr) {
                        if (debug != null) {
                            debug.append("[");
                        }
                        String res = (String)((ConstraintExpr)arg).eval(context2, dm, tags, debug);
                        if (debug != null) {
                            debug.append("->" + res + "]");
                        }
                        return new String[]{res};
                    }
                    throw new Exception("Invalid constraint string: " + arg);
                }
                catch (Throwable e) {
                    TagConstraint.this.setError(Debug.getNestedExceptionMessage(e));
                    String result = "\"\"";
                    args[index] = result;
                    return new String[]{result};
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private Object getKeywordValue(DownloadManager dm, List<Tag> tags, String str) {
                int[] kw_details = keyword_map.get(str.toLowerCase(Locale.US));
                if (kw_details == null) {
                    return null;
                }
                int kw = kw_details[0];
                switch (kw) {
                    case 0: {
                        int sr = dm.getStats().getShareRatio();
                        if (sr != -1) return new Float((float)sr / 1000.0f);
                        return Integer.MAX_VALUE;
                    }
                    case 40: {
                        int tr = dm.getDownloadState().getIntParameter("sr.max");
                        if (tr > 0) return new Float((float)tr / 1000.0f);
                        tr = target_share_ratio;
                        return new Float((float)tr / 1000.0f);
                    }
                    case 2: {
                        int percent = dm.getStats().getPercentDoneExcludingDND();
                        return new Float((float)percent / 10.0f);
                    }
                    case 1: {
                        long added = dm.getDownloadState().getLongParameter("stats.download.added.time");
                        if (added > 0L) return (SystemTime.getCurrentTime() - added) / 1000L;
                        return 0;
                    }
                    case 15: {
                        long comp2 = dm.getDownloadState().getLongParameter("stats.download.completed.time");
                        if (comp2 > 0L) return (SystemTime.getCurrentTime() - comp2) / 1000L;
                        return 0;
                    }
                    case 16: {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null) return new Float((float)pm.getMaxCompletionInThousandNotation(false) / 10.0f);
                        return 0;
                    }
                    case 18: {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null) return new Float((float)pm.getMaxCompletionInThousandNotation(true) / 10.0f);
                        return 0;
                    }
                    case 17: {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null) return new Float((float)pm.getAverageCompletionInThousandNotation() / 10.0f);
                        return 0;
                    }
                    case 3: {
                        return dm.getStats().getSecondsDownloading();
                    }
                    case 4: {
                        return dm.getStats().getSecondsOnlySeeding();
                    }
                    case 6: {
                        DownloadManagerState dms = dm.getDownloadState();
                        long timestamp = dms.getLongAttribute("last.act.tag");
                        if (timestamp > 0L) return (SystemTime.getCurrentTime() - timestamp) / 1000L;
                        return Long.MAX_VALUE;
                    }
                    case 10: {
                        long resume_millis = dm.getAutoResumeTime();
                        long now = SystemTime.getCurrentTime();
                        if (resume_millis <= 0L) return 0;
                        if (resume_millis > now) return (resume_millis - now) / 1000L;
                        return 0;
                    }
                    case 11: {
                        long now = SystemTime.getCurrentTime();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(new Date(now));
                        return cal.get(12);
                    }
                    case 12: {
                        long now = SystemTime.getCurrentTime();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(new Date(now));
                        return cal.get(11);
                    }
                    case 13: {
                        long now = SystemTime.getCurrentTime();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(new Date(now));
                        return cal.get(7);
                    }
                    case 5: {
                        return dm.getDownloadState().getLongAttribute("mergedata");
                    }
                    case 7: {
                        Download dl;
                        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                        int seeds = dm.getNbSeeds();
                        if (response != null && response.isValid()) {
                            seeds = Math.max(seeds, response.getSeeds());
                        }
                        if ((dl = PluginCoreUtils.wrap(dm)) == null) return Math.max(0, seeds);
                        seeds = Math.max(seeds, dl.getAggregatedScrapeResult().getSeedCount());
                        return Math.max(0, seeds);
                    }
                    case 8: {
                        Download dl;
                        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                        int peers = dm.getNbPeers();
                        if (response != null && response.isValid()) {
                            peers = Math.max(peers, response.getPeers());
                        }
                        if ((dl = PluginCoreUtils.wrap(dm)) == null) return Math.max(0, peers);
                        peers = Math.max(peers, dl.getAggregatedScrapeResult().getNonSeedCount());
                        return Math.max(0, peers);
                    }
                    case 9: {
                        float ratio;
                        Download dl;
                        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                        int seeds = dm.getNbSeeds();
                        int peers = dm.getNbPeers();
                        if (response != null && response.isValid()) {
                            seeds = Math.max(seeds, response.getSeeds());
                            peers = Math.max(peers, response.getPeers());
                        }
                        if ((dl = PluginCoreUtils.wrap(dm)) != null) {
                            DownloadScrapeResult sr = dl.getAggregatedScrapeResult();
                            seeds = Math.max(seeds, sr.getSeedCount());
                            peers = Math.max(peers, sr.getNonSeedCount());
                        }
                        if (peers < 0 || seeds < 0) {
                            ratio = 0.0f;
                            return Float.valueOf(ratio);
                        } else if (peers == 0) {
                            if (seeds != 0) return Integer.MAX_VALUE;
                            ratio = 0.0f;
                            return Float.valueOf(ratio);
                        } else {
                            ratio = (float)seeds / (float)peers;
                        }
                        return Float.valueOf(ratio);
                    }
                    case 14: {
                        long tag_added = TagConstraint.this.tag_maybe_null.getTaggableAddedTime(dm);
                        if (tag_added <= 0L) {
                            return 0;
                        }
                        long age = (SystemTime.getCurrentTime() - tag_added) / 1000L;
                        if (age >= 0L) return age;
                        age = 0L;
                        return age;
                    }
                    case 19: {
                        return dm.getSize();
                    }
                    case 20: {
                        return dm.getSize() / 0x100000L;
                    }
                    case 21: {
                        return dm.getSize() / 0x40000000L;
                    }
                    case 22: {
                        return dm.getNumFileInfos();
                    }
                    case 23: {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) {
                            return Float.valueOf(-1.0f);
                        }
                        float avail = pm.getMinAvailability();
                        return new Float(avail);
                    }
                    case 24: {
                        long secs = dm.getStats().getTimeSinceLastDataSentInSeconds();
                        if (secs >= 0L) return secs;
                        return Long.MAX_VALUE;
                    }
                    case 25: {
                        long secs = dm.getStats().getTimeSinceLastDataReceivedInSeconds();
                        if (secs >= 0L) return secs;
                        return Long.MAX_VALUE;
                    }
                    case 26: {
                        return dm.getStats().getTotalGoodDataBytesReceived();
                    }
                    case 44: {
                        return dm.getStats().getRemainingExcludingDND();
                    }
                    case 27: {
                        return dm.getStats().getTotalDataBytesSent();
                    }
                    case 32: {
                        return dm.getStats().getUploadRateLimitBytesPerSecond();
                    }
                    case 33: {
                        return dm.getStats().getDownloadRateLimitBytesPerSecond();
                    }
                    case 37: {
                        TOTorrent t = dm.getTorrent();
                        return t == null ? 0 : t.getTorrentType();
                    }
                    case 43: {
                        long value = dm.getStats().getAvailWentBadTime();
                        if (value < 0L) {
                            value = Long.MIN_VALUE;
                            return value;
                        } else {
                            if (value != 0L) return value;
                            value = SystemTime.getCurrentTime();
                        }
                        return value;
                    }
                    case 45: 
                    case 46: {
                        long[] rates = (long[])dm.getUserData(DM_RATES);
                        if (rates == null) {
                            long[] lArray = new long[4];
                            lArray[0] = -1L;
                            lArray[1] = -1L;
                            rates = lArray;
                            dm.setUserData(DM_RATES, rates);
                            return 0;
                        }
                        if (rates[0] != -1L) return rates[kw == 45 ? 2 : 3];
                        return 0;
                    }
                    case 47: {
                        long value = dm.getStats().getTimeStarted();
                        if (value > 0L) return (SystemTime.getCurrentTime() - value) / 1000L;
                        return 0;
                    }
                    case 28: {
                        dm.setUserData(DM_NAME, "");
                        TagConstraint.this.depends_on_names_etc = true;
                        return dm.getDisplayName();
                    }
                    case 29: {
                        String[] result = (String[])dm.getUserData(DM_FILE_NAMES);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        result = new String[files.length];
                        int i = 0;
                        while (i < files.length) {
                            result[i] = files[i].getFile(false).getName();
                            ++i;
                        }
                        dm.setUserData(DM_FILE_NAMES, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        return result;
                    }
                    case 35: {
                        String[] result = (String[])dm.getUserData(DM_FILE_EXTS);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        HashSet<String> exts = new HashSet<String>();
                        int i = 0;
                        while (i < files.length) {
                            String ext = files[i].getExtension();
                            if (ext != null && !ext.isEmpty() && !exts.contains(ext)) {
                                exts.add(ext.toLowerCase(Locale.US));
                            }
                            ++i;
                        }
                        result = exts.toArray(new String[0]);
                        dm.setUserData(DM_FILE_EXTS, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        return result;
                    }
                    case 38: {
                        String[] result = (String[])dm.getUserData(DM_FILE_PATHS);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        result = new String[files.length];
                        int i = 0;
                        while (i < files.length) {
                            result[i] = files[i].getFile(true).getAbsolutePath();
                            ++i;
                        }
                        dm.setUserData(DM_FILE_PATHS, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        TagConstraint.this.handler.checkDMListeners(dm);
                        return result;
                    }
                    case 36: {
                        String[] result = (String[])dm.getUserData(DM_FILE_EXTS_SELECTED);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        HashSet<String> exts = new HashSet<String>();
                        int i = 0;
                        while (i < files.length) {
                            String ext;
                            if (!(files[i].isSkipped() || (ext = files[i].getExtension()) == null || ext.isEmpty() || exts.contains(ext))) {
                                exts.add(ext.toLowerCase(Locale.US));
                            }
                            ++i;
                        }
                        result = exts.toArray(new String[0]);
                        dm.setUserData(DM_FILE_EXTS_SELECTED, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        TagConstraint.this.handler.checkDMListeners(dm);
                        return result;
                    }
                    case 34: {
                        String[] result = (String[])dm.getUserData(DM_FILE_NAMES_SELECTED);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        ArrayList<String> names = new ArrayList<String>(files.length);
                        int i = 0;
                        while (i < files.length) {
                            if (!files[i].isSkipped()) {
                                names.add(files[i].getFile(false).getName());
                            }
                            ++i;
                        }
                        result = names.toArray(new String[0]);
                        dm.setUserData(DM_FILE_NAMES_SELECTED, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        TagConstraint.this.handler.checkDMListeners(dm);
                        return result;
                    }
                    case 41: {
                        String[] result = new String[tags.size()];
                        int i = 0;
                        while (i < tags.size()) {
                            Tag tag = tags.get(i);
                            result[i] = tag == TagConstraint.this.tag_maybe_null ? "" : tag.getTagName(true);
                            ++i;
                        }
                        return result;
                    }
                    case 42: {
                        return dm.getTrackerStatus();
                    }
                    case 39: {
                        String[] result = (String[])dm.getUserData(DM_FILE_PATHS_SELECTED);
                        if (result != null) return result;
                        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                        ArrayList<String> names = new ArrayList<String>(files.length);
                        int i = 0;
                        while (i < files.length) {
                            if (!files[i].isSkipped()) {
                                names.add(files[i].getFile(true).getAbsolutePath());
                            }
                            ++i;
                        }
                        result = names.toArray(new String[0]);
                        dm.setUserData(DM_FILE_PATHS_SELECTED, result);
                        TagConstraint.this.depends_on_names_etc = true;
                        TagConstraint.this.handler.checkDMListeners(dm);
                        return result;
                    }
                    case 30: {
                        TagConstraint.this.depends_on_names_etc = true;
                        dm.setUserData(DM_SAVE_PATH, "");
                        return dm.getAbsoluteSaveLocation().getAbsolutePath();
                    }
                    case 31: {
                        TagConstraint.this.depends_on_names_etc = true;
                        dm.setUserData(DM_SAVE_PATH, "");
                        File save_loc = dm.getAbsoluteSaveLocation().getAbsoluteFile();
                        File save_folder = save_loc.getParentFile();
                        if (!FileUtil.isDirectoryWithTimeout(save_folder)) return save_loc.getAbsolutePath();
                        return save_folder.getAbsolutePath();
                    }
                    case 48: {
                        if (TagConstraint.this.handler.ta_rating_name == null) {
                            return 0;
                        }
                        String rating_str = dm.getDownloadState().getAttribute(TagConstraint.this.handler.ta_rating_name);
                        if (rating_str == null) return 0;
                        return Integer.parseInt(rating_str);
                    }
                }
                return null;
            }

            private Number getNumeric(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, Object[] args, int index, StringBuilder debug) {
                Object arg;
                if (debug != null && index > 0) {
                    debug.append(",");
                }
                if ((arg = args[index]) instanceof Number) {
                    Number res = (Number)arg;
                    if (debug != null) {
                        debug.append("[" + res + "]");
                    }
                    return res;
                }
                if (arg instanceof ConstraintExpr) {
                    if (debug != null) {
                        debug.append("[");
                    }
                    Object res = ((ConstraintExpr)arg).eval(context2, dm, tags, debug);
                    if (debug != null) {
                        debug.append("->" + res + "]");
                    }
                    if (res instanceof Number) {
                        return (Number)res;
                    }
                    if (res instanceof Boolean) {
                        return (Boolean)res != false ? 1 : 0;
                    }
                    if (res instanceof String) {
                        return Long.parseLong((String)res);
                    }
                    throw new RuntimeException("Unsupported numeric type: " + res);
                }
                if (debug != null) {
                    debug.append("[" + arg + "->");
                }
                Number res = this.getNumericSupport(dm, tags, args, index);
                if (debug != null) {
                    debug.append(res + "]");
                }
                return res;
            }

            private Number getNumericSupport(DownloadManager dm, List<Tag> tags, Object[] args, int index) {
                Object arg = args[index];
                String str = (String)arg;
                Number result = 0;
                try {
                    if (str.equals("\u221e")) {
                        result = Integer.MAX_VALUE;
                        Integer n = result;
                        return n;
                    }
                    if (Character.isDigit(str.charAt(0)) || str.length() > 1 && str.startsWith("-") && Character.isDigit(str.charAt(1))) {
                        String unit = "";
                        int i = 1;
                        while (i < str.length()) {
                            char c = str.charAt(i);
                            if (c != '.' && !Character.isDigit(c)) {
                                unit = str.substring(i).trim();
                                str = str.substring(0, i);
                                break;
                            }
                            ++i;
                        }
                        result = str.contains(".") ? (Number)Double.parseDouble(str) : (Number)Long.parseLong(str);
                        if (!unit.isEmpty()) {
                            long multiplier = GeneralUtils.getUnitMultiplier(unit, false);
                            if (multiplier <= 0L) {
                                TagConstraint.this.setError("Invalid unit '" + unit + "'");
                            } else if (multiplier > 1L) {
                                result = result instanceof Long ? (Number)(result.longValue() * multiplier) : (Number)(result.doubleValue() * (double)multiplier);
                            }
                        }
                        Number number = result;
                        return number;
                    }
                    result = null;
                    Object o_result = this.getKeywordValue(dm, tags, str);
                    if (o_result instanceof Number) {
                        Number number = (Number)o_result;
                        return number;
                    }
                    if (o_result == null) {
                        TagConstraint.this.setError("Invalid constraint keyword: " + str);
                    } else {
                        TagConstraint.this.setError("Invalid constraint keyword, numeric expected: " + str);
                    }
                    Number number = result;
                    return number;
                }
                catch (Throwable e) {
                    TagConstraint.this.setError("Invalid constraint numeric: " + str);
                    Integer n = result;
                    return n;
                }
                finally {
                    if (result != null) {
                        args[index] = result;
                    }
                }
            }

            @Override
            public String getString() {
                return String.valueOf(this.func_name) + "(" + this.params_expr.getString() + ")";
            }
        }

        private static class ConstraintExprNot
        implements ConstraintExpr {
            private final ConstraintExpr expr;

            private ConstraintExprNot(ConstraintExpr e) {
                this.expr = e;
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append("!(");
                }
                Boolean result = (Boolean)this.expr.eval(context2, dm, tags, debug) == false;
                if (debug != null) {
                    debug.append(")");
                    debug.append("->");
                    debug.append(result);
                }
                return result;
            }

            @Override
            public String getString() {
                return "!(" + this.expr.getString() + ")";
            }
        }

        private static class ConstraintExprOr
        implements ConstraintExpr {
            private final ConstraintExpr[] exprs;

            private ConstraintExprOr(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append("(");
                }
                boolean res = false;
                try {
                    int num = 1;
                    ConstraintExpr[] constraintExprArray = this.exprs;
                    int n = this.exprs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Boolean b;
                        ConstraintExpr expr = constraintExprArray[n2];
                        if (debug != null && num > 1) {
                            debug.append("||");
                        }
                        if ((b = (Boolean)expr.eval(context2, dm, tags, debug)).booleanValue()) {
                            res = true;
                            Boolean bl = true;
                            return bl;
                        }
                        ++num;
                        ++n2;
                    }
                    res = false;
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (debug != null) {
                        debug.append(")");
                        debug.append("->");
                        debug.append(res);
                    }
                }
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "||") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }

        private class ConstraintExprParams
        implements ConstraintExpr {
            private final String value;
            private final Map<String, ConstraintExpr> context;

            private ConstraintExprParams(String _value, Map<String, ConstraintExpr> _context) {
                this.value = _value.trim();
                this.context = _context;
                try {
                    Object[] args;
                    Object[] objectArray = args = this.getValues();
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int[] kw_details;
                        Object obj = objectArray[n2];
                        if (obj instanceof String && (kw_details = keyword_map.get((String)obj)) != null) {
                            TagConstraint.this.depends_on_level = Math.max(TagConstraint.this.depends_on_level, kw_details[1]);
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                return false;
            }

            public Object[] getValues() {
                if (this.value.length() == 0) {
                    return new String[0];
                }
                if (!this.value.contains(",")) {
                    if (!GeneralUtils.startsWithDoubleQuote(this.value)) {
                        if (this.value.startsWith("{")) {
                            Object temp = this.dereference(this.value);
                            if (temp instanceof Object[]) {
                                return (Object[])temp;
                            }
                            return new Object[]{temp};
                        }
                        if (this.value.contains("(") || comp_op_pattern.matcher(this.value).find()) {
                            return new Object[]{TagConstraint.this.compileStart(this.value, this.context)};
                        }
                    }
                    return new Object[]{this.value};
                }
                char[] chars = this.value.toCharArray();
                boolean in_quote = false;
                int bracket_level = 0;
                ArrayList<Object> params = new ArrayList<Object>(16);
                StringBuilder current_param = new StringBuilder(this.value.length());
                int i = 0;
                while (i < chars.length) {
                    char c = chars[i];
                    if (GeneralUtils.isDoubleQuote(c) && (i == 0 || chars[i - 1] != '\\')) {
                        boolean bl = in_quote = !in_quote;
                    }
                    if (c == ',' && !in_quote) {
                        if (bracket_level == 0) {
                            params.add(current_param.toString());
                            current_param.setLength(0);
                        } else {
                            current_param.append(c);
                        }
                    } else {
                        if (!in_quote) {
                            if (c == '(') {
                                ++bracket_level;
                            } else if (c == ')') {
                                --bracket_level;
                            }
                        }
                        if (in_quote || !Character.isWhitespace(c)) {
                            current_param.append(c);
                        }
                    }
                    ++i;
                }
                params.add(current_param.toString());
                i = 0;
                while (i < params.size()) {
                    String p = (String)params.get(i);
                    if (!GeneralUtils.startsWithDoubleQuote(p)) {
                        if (p.startsWith("{")) {
                            params.set(i, this.dereference(p));
                        } else if (p.contains("(") || comp_op_pattern.matcher(p).find()) {
                            params.set(i, TagConstraint.this.compileStart(p, this.context));
                        }
                    }
                    ++i;
                }
                return params.toArray(new Object[params.size()]);
            }

            private Object dereference(String key) {
                ConstraintExpr expr = this.context.get(key);
                if (expr == null) {
                    throw new RuntimeException("Reference " + key + " not found");
                }
                if (expr instanceof ConstraintExprParams) {
                    ConstraintExprParams params = (ConstraintExprParams)expr;
                    return params.getValues();
                }
                return expr;
            }

            @Override
            public String getString() {
                Object[] params = this.getValues();
                String str = "";
                Object[] objectArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    str = String.valueOf(str) + (str.isEmpty() ? "" : ",") + (obj instanceof ConstraintExpr ? ((ConstraintExpr)obj).getString() : obj);
                    ++n2;
                }
                return str;
            }
        }

        private static class ConstraintExprTrue
        implements ConstraintExpr {
            private ConstraintExprTrue() {
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append(this.getString());
                }
                return true;
            }

            @Override
            public String getString() {
                return "true";
            }
        }

        private static class ConstraintExprXor
        implements ConstraintExpr {
            private final ConstraintExpr[] exprs;

            private ConstraintExprXor(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
                if (this.exprs.length < 2) {
                    throw new RuntimeException("Two or more arguments required for ^");
                }
            }

            @Override
            public Object eval(Map<String, Object> context2, DownloadManager dm, List<Tag> tags, StringBuilder debug) {
                if (debug != null) {
                    debug.append("(");
                }
                boolean res = false;
                try {
                    res = (Boolean)this.exprs[0].eval(context2, dm, tags, debug);
                    if (debug != null) {
                        debug.append(res);
                    }
                    int i = 1;
                    while (i < this.exprs.length) {
                        if (debug != null) {
                            debug.append("^");
                        }
                        boolean b = (Boolean)this.exprs[i].eval(context2, dm, tags, debug);
                        res ^= b;
                        ++i;
                    }
                    Boolean bl = res;
                    return bl;
                }
                finally {
                    if (debug != null) {
                        debug.append(")");
                        debug.append("->");
                        debug.append(res);
                    }
                }
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "^") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }
    }
}

